/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.AuthUtils;
import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.jwt.Signer;
import com.vmware.xenon.services.common.authn.BasicAuthenticationUtils;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;

public class AuthorizationFilter
implements OperationProcessingChain.Filter {
    private ConcurrentHashMap<String, Operation.AuthorizationContext> authorizationContextCache;
    private ConcurrentHashMap<String, Set<String>> userLinkToTokenMap;

    @Override
    public void init() {
        this.authorizationContextCache = new ConcurrentHashMap();
        this.userLinkToTokenMap = new ConcurrentHashMap();
    }

    @Override
    public void close() {
        this.authorizationContextCache.clear();
        this.userLinkToTokenMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheAuthorizationContext(ServiceHost h, String token, Operation.AuthorizationContext ctx) {
        AuthorizationFilter authorizationFilter = this;
        synchronized (authorizationFilter) {
            this.authorizationContextCache.put(token, ctx);
            this.addUserToken(this.userLinkToTokenMap, ctx.getClaims().getSubject(), token);
        }
        h.getManagementService().adjustStat("authorizationCacheInsertCount", 1.0);
        h.getManagementService().adjustStat("authorizationCacheSize", (double)this.authorizationContextCache.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAuthorizationContext(ServiceHost h, String userLink) {
        AuthorizationFilter authorizationFilter = this;
        synchronized (authorizationFilter) {
            Set<String> tokenSet = this.userLinkToTokenMap.remove(userLink);
            if (tokenSet != null) {
                for (String token : tokenSet) {
                    this.authorizationContextCache.remove(token);
                }
            }
        }
        h.getManagementService().adjustStat("authorizationCacheSize", (double)this.authorizationContextCache.size());
    }

    public Operation.AuthorizationContext getAuthorizationContext(String token) {
        return this.authorizationContextCache.get(token);
    }

    public Operation.AuthorizationContext createAuthorizationContext(Signer tokenSigner, String userLink) {
        String token;
        Claims.Builder cb = new Claims.Builder();
        cb.setIssuer("xn");
        cb.setSubject(userLink);
        cb.setExpirationTime(Instant.MAX.getEpochSecond());
        Claims claims = (Claims)cb.getResult();
        try {
            token = tokenSigner.sign(claims);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        Operation.AuthorizationContext.Builder ab = Operation.AuthorizationContext.Builder.create();
        ab.setClaims(claims);
        ab.setToken(token);
        ab.setPropagateToClient(false);
        return ab.getResult();
    }

    @Override
    public OperationProcessingChain.FilterReturnCode processRequest(Operation op, OperationProcessingChain.OperationProcessingContext context) {
        if (!context.getHost().isAuthorizationEnabled() || context.getHost().getAuthorizationService() == null) {
            return OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING;
        }
        context.setSuspendConsumer(o -> {
            if (op.getAuthorizationContext() != null) {
                this.checkAndPopulateAuthzContext(op, context);
            } else {
                BiConsumer<Operation, Throwable> externalAuthFailureCallback = (resultOp, ex) -> {
                    ServiceErrorResponse err = resultOp.getBody(ServiceErrorResponse.class);
                    context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, (Throwable)ex);
                    op.transferResponseHeadersFrom((Operation)resultOp);
                    op.fail(resultOp.getStatusCode(), new RuntimeException(err.message), resultOp.getBodyRaw());
                };
                ServiceHost host = context.getHost();
                this.populateAuthorizationContext(op, host, authorizationContext -> this.checkAndPopulateAuthzContext(op, context), externalAuthFailureCallback);
            }
        });
        return OperationProcessingChain.FilterReturnCode.SUSPEND_PROCESSING;
    }

    private void checkAndPopulateAuthzContext(Operation op, OperationProcessingChain.OperationProcessingContext context) {
        Service authzService = context.getHost().getAuthorizationService();
        if (Utils.isContentTypeKryoBinary(op.getContentType()) && !op.getAuthorizationContext().isSystemUser()) {
            String msg = String.format("%s requests are only authorized for System Users", op.getContentType());
            IllegalAccessException ex = new IllegalAccessException(msg);
            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.FAILED_STOP_PROCESSING, ex);
            ServiceErrorResponse response = new ServiceErrorResponse();
            response.message = msg;
            response.statusCode = 401;
            op.fail(401, ex, response);
            return;
        }
        long dispatchTime = System.nanoTime();
        op.nestCompletion(o -> {
            if (authzService.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                long dispatchDuration = System.nanoTime() - dispatchTime;
                AuthUtils.setAuthDurationStat(authzService, "authorizationDurationMicros", TimeUnit.NANOSECONDS.toMicros(dispatchDuration));
            }
            context.resumeProcessingRequest(op, OperationProcessingChain.FilterReturnCode.CONTINUE_PROCESSING, null);
        });
        context.getHost().queueOrScheduleRequest(authzService, op);
    }

    public void populateAuthorizationContext(Operation op, ServiceHost host, Consumer<Operation.AuthorizationContext> authorizationContextHandler, BiConsumer<Operation, Throwable> externalAuthFailureCallback) {
        this.getAuthorizationContext(op, host, authorizationContext -> {
            Operation.AuthorizationContext cachedGuestCtx;
            if (authorizationContext == null && (cachedGuestCtx = host.getAuthorizationContext(null, (authorizationContext = host.getGuestAuthorizationContext()).getToken())) != null) {
                authorizationContext = cachedGuestCtx;
            }
            op.setAuthorizationContext((Operation.AuthorizationContext)authorizationContext);
            authorizationContextHandler.accept((Operation.AuthorizationContext)authorizationContext);
        }, externalAuthFailureCallback);
    }

    private void getAuthorizationContext(Operation op, ServiceHost host, Consumer<Operation.AuthorizationContext> authorizationContextHandler, BiConsumer<Operation, Throwable> externalAuthFailureCallback) {
        String token = BasicAuthenticationUtils.getAuthToken(op);
        if (token == null) {
            authorizationContextHandler.accept(null);
            return;
        }
        Operation.AuthorizationContext ctx = host.getAuthorizationContext(null, token);
        if (ctx != null) {
            if ((ctx = this.checkAndGetAuthorizationContext(ctx, ctx.getClaims(), token, op, host)) == null) {
                this.verifyToken(op, host, authorizationContextHandler, externalAuthFailureCallback);
                return;
            }
            authorizationContextHandler.accept(ctx);
            return;
        }
        this.verifyToken(op, host, authorizationContextHandler, externalAuthFailureCallback);
    }

    private Operation.AuthorizationContext checkAndGetAuthorizationContext(Operation.AuthorizationContext ctx, Claims claims, String token, Operation op, ServiceHost host) {
        if (claims == null) {
            host.log(Level.INFO, "Request to %s has no claims found with token: %s", op.getUri().getPath(), token);
            return null;
        }
        Long expirationTime = claims.getExpirationTime();
        if (expirationTime != null && TimeUnit.SECONDS.toMicros(expirationTime) <= Utils.getSystemNowMicrosUtc()) {
            host.log(Level.FINE, "Token expired for %s", claims.getSubject());
            host.clearAuthorizationContext(null, claims.getSubject());
            return null;
        }
        if (ctx != null) {
            return ctx;
        }
        Operation.AuthorizationContext.Builder b = Operation.AuthorizationContext.Builder.create();
        b.setClaims(claims);
        b.setToken(token);
        ctx = b.getResult();
        host.cacheAuthorizationContext(null, token, ctx);
        return ctx;
    }

    private void verifyToken(Operation parentOp, ServiceHost host, Consumer<Operation.AuthorizationContext> authorizationContextHandler, BiConsumer<Operation, Throwable> externalAuthFailureCallback) {
        URI tokenVerificationUri = host.getAuthenticationServiceUri();
        if (tokenVerificationUri == null) {
            host.log(Level.WARNING, "Error verifying token, authentication service not initialized", new Object[0]);
            authorizationContextHandler.accept(null);
            return;
        }
        boolean shouldRetry = true;
        if (host.getBasicAuthenticationServiceUri().equals(host.getAuthenticationServiceUri())) {
            shouldRetry = false;
        }
        Consumer<Operation> verificationSuccessCallback = resultOp -> {
            Operation.AuthorizationContext ctx = resultOp.getBody(Operation.AuthorizationContext.class);
            Operation getUserOp = Operation.createGet(AuthUtils.buildUserUriFromClaims(host, ctx.getClaims())).setReferer(parentOp.getUri()).setCompletion((getOp, getEx) -> {
                if (getEx != null) {
                    host.log(Level.WARNING, "Error obtaining subject: %s", getEx);
                    authorizationContextHandler.accept(null);
                    return;
                }
                Operation.AuthorizationContext authCtx = this.checkAndGetAuthorizationContext(null, ctx.getClaims(), ctx.getToken(), parentOp, host);
                parentOp.transferResponseHeadersFrom((Operation)resultOp);
                Map<String, String> cookies = resultOp.getCookies();
                if (cookies != null) {
                    Map<String, String> parentOpCookies = parentOp.getCookies();
                    if (parentOpCookies == null) {
                        parentOp.setCookies(cookies);
                    } else {
                        parentOpCookies.putAll(cookies);
                    }
                }
                authorizationContextHandler.accept(authCtx);
            });
            getUserOp.setAuthorizationContext(host.getSystemAuthorizationContext());
            host.sendRequest(getUserOp);
        };
        boolean performRetry = shouldRetry;
        BiConsumer<Operation, Throwable> verificationFailureCallback = (resultOp, ex) -> {
            host.log(Level.WARNING, "Error verifying token: %s", ex);
            if (!performRetry) {
                authorizationContextHandler.accept(null);
                return;
            }
            ServiceErrorResponse err = resultOp.getBody(ServiceErrorResponse.class);
            if (err.getErrorCode() == -2147483632) {
                host.log(Level.FINE, () -> "Skipping basic auth.");
                externalAuthFailureCallback.accept((Operation)resultOp, (Throwable)ex);
                return;
            }
            host.log(Level.INFO, "Retrying token verification with basic auth.", new Object[0]);
            this.verifyTokenInternal(parentOp, host, tokenVerificationUri, verificationSuccessCallback, (opp, eex) -> {
                host.log(Level.WARNING, "Error verifying token: %s", ex);
                authorizationContextHandler.accept(null);
            });
        };
        this.verifyTokenInternal(parentOp, host, tokenVerificationUri, verificationSuccessCallback, verificationFailureCallback);
    }

    private void verifyTokenInternal(Operation parentOp, ServiceHost host, URI tokenVerificationUri, Consumer<Operation> verificationSuccessCallback, BiConsumer<Operation, Throwable> verificationFailureCallback) {
        Operation verifyOp = Operation.createPost(tokenVerificationUri).setReferer(parentOp.getUri()).transferRequestHeadersFrom(parentOp).setCookies(parentOp.getCookies()).addPragmaDirective("xn-verify-token").setCompletion((resultOp, ex) -> {
            if (ex != null) {
                verificationFailureCallback.accept(resultOp, ex);
            } else {
                verificationSuccessCallback.accept(resultOp);
            }
        });
        verifyOp.setAuthorizationContext(host.getSystemAuthorizationContext());
        host.sendRequest(verifyOp);
    }

    private void addUserToken(Map<String, Set<String>> userLinktoTokenMap, String userServiceLink, String token) {
        Set<String> tokenSet = userLinktoTokenMap.get(userServiceLink);
        if (tokenSet == null) {
            tokenSet = new HashSet<String>();
        }
        tokenSet.add(token);
        userLinktoTokenMap.put(userServiceLink, tokenSet);
    }
}

