/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStatUtils;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.UriUtils;
import java.net.URI;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;

public final class AuthUtils {
    private static final ConcurrentMap<String, Function<Claims, String>> URI_BUILDERS = new ConcurrentSkipListMap<String, Function<Claims, String>>();

    private AuthUtils() {
    }

    public static URI buildAuthProviderHostUri(ServiceHost host, String serviceLink) {
        URI uri = host.getStateNoCloning().authProviderHostURI;
        URI baseUri = uri != null ? uri : host.getUri();
        return UriUtils.extendUri(baseUri, serviceLink);
    }

    public static void registerUserLinkBuilder(String authnServiceLink, Function<Claims, String> userLinkBuilder) {
        URI_BUILDERS.putIfAbsent(authnServiceLink, userLinkBuilder);
    }

    public static URI buildUserUriFromClaims(ServiceHost host, Claims claims) {
        String authnServiceLink = host.getAuthenticationService().getSelfLink();
        String userLink = claims.getSubject();
        Function func = (Function)URI_BUILDERS.get(authnServiceLink);
        if (func != null) {
            userLink = (String)func.apply(claims);
        }
        return AuthUtils.buildAuthProviderHostUri(host, userLink);
    }

    public static void setAuthDurationStat(Service service, String prefix, double value) {
        ServiceStats.ServiceStat st = ServiceStatUtils.getOrCreateDailyTimeSeriesHistogramStat(service, prefix, ServiceStatUtils.AGGREGATION_TYPE_AVG_MAX);
        service.setStat(st, value);
        st = ServiceStatUtils.getOrCreateHourlyTimeSeriesHistogramStat(service, prefix, ServiceStatUtils.AGGREGATION_TYPE_AVG_MAX);
        service.setStat(st, value);
    }
}

