/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.util.EnumSet;
import java.util.Map;

public class QueryPageForwardingService
extends StatelessService {
    public static final String SELF_LINK = ServiceUriPaths.CORE_QUERY_PAGE_FORWARDING;
    private NodeSelectorService selector;
    private static EnumSet<NodeSelectorService.SelectAndForwardRequest.ForwardingOption> unicastOption = EnumSet.of(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.UNICAST);

    public QueryPageForwardingService(NodeSelectorService selector) {
        this.toggleOption(Service.ServiceOption.CORE, true);
        this.selector = selector;
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op) {
        Map<String, String> params = UriUtils.parseUriQueryParams(op.getUri());
        String peer = params.get("peer");
        if (peer == null) {
            if (params.isEmpty() && op.getAction() == Service.Action.DELETE) {
                super.handleRequest(op);
                return;
            }
            op.fail(new IllegalArgumentException("peer uri parameter is required"));
            return;
        }
        String path = params.get("path");
        if (path == null) {
            op.fail(new IllegalArgumentException("path uri parameter is required"));
            return;
        }
        if (path.contains("/") || path.contains("..")) {
            op.fail(new IllegalArgumentException("path uri parameter is invalid"));
            return;
        }
        if (path.equals("forwarding")) {
            op.fail(new IllegalArgumentException("path uri parameter cannot be self"));
            return;
        }
        NodeSelectorService.SelectAndForwardRequest body = new NodeSelectorService.SelectAndForwardRequest();
        body.key = peer;
        body.targetPath = UriUtils.buildUriPath(ServiceUriPaths.CORE_QUERY_PAGE, path);
        body.targetQuery = null;
        body.options = unicastOption;
        this.selector.selectAndForward(op, body);
    }
}

