/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.serialization.KryoSerializers;
import com.vmware.xenon.services.common.QueryTask;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

class LuceneIndexDocumentHelper {
    public static final String GROUP_BY_PROPERTY_NAME_SUFFIX = "_groupBySuffix";
    public static final String SORT_PROPERTY_NAME_SUFFIX = "_sort";
    private static final String FIELD_NAME_INDEXING_PREFIX = "xenon.indexing";
    public static final String FIELD_NAME_INDEXING_ID = "xenon.indexing.id";
    public static final String FIELD_NAME_INDEXING_METADATA_VALUE_CURRENT = "xenon.indexing.metadata.current";
    private static final String DISABLE_SORT_FIELD_NAMING_PROPERTY_NAME = "xenon.LuceneIndexDocumentHelper.DISABLE_SORT_FIELD_NAMING";
    private static boolean DISABLE_SORT_FIELD_NAMING = Boolean.getBoolean("xenon.LuceneIndexDocumentHelper.DISABLE_SORT_FIELD_NAMING");
    private Document doc = new Document();
    private final LongFieldContext versionField = new LongFieldContext(){

        @Override
        public void initialize() {
            this.storedField = new StoredField("documentVersion", 0L);
            this.longPoint = new LongPoint("documentVersion", new long[]{0L});
            this.numericDocField = new NumericDocValuesField("documentVersion", 0L);
        }
    };
    private final LongFieldContext updateTimeField = new LongFieldContext(){

        @Override
        public void initialize() {
            this.storedField = new StoredField("documentUpdateTimeMicros", 0L);
            this.longPoint = new LongPoint("documentUpdateTimeMicros", new long[]{0L});
            this.numericDocField = new NumericDocValuesField("documentUpdateTimeMicros", 0L);
        }
    };
    private final LongFieldContext expirationTimeField = new LongFieldContext(){

        @Override
        public void initialize() {
            this.storedField = new StoredField("documentExpirationTimeMicros", 0L);
            this.longPoint = new LongPoint("documentExpirationTimeMicros", new long[]{0L});
            this.numericDocField = new NumericDocValuesField("documentExpirationTimeMicros", 0L);
        }
    };
    private final LongFieldContext currentField = new LongFieldContext(){

        @Override
        public void initialize() {
            this.numericDocField = new NumericDocValuesField(LuceneIndexDocumentHelper.FIELD_NAME_INDEXING_METADATA_VALUE_CURRENT, 0L);
        }
    };
    private final StringFieldContext selfLinkField = new StringFieldContext(){

        @Override
        public void initialize() {
            this.stringField = new StringField("documentSelfLink", "", Field.Store.YES);
            this.sortedField = new SortedDocValuesField(LuceneIndexDocumentHelper.createSortFieldPropertyName("documentSelfLink"), new BytesRef((CharSequence)" "));
        }
    };
    private final StringFieldContext kindField = new StringFieldContext(){

        @Override
        public void initialize() {
            this.stringField = new StringField("documentKind", "", Field.Store.NO);
        }
    };
    private final StringFieldContext authPrincipalLinkField = new StringFieldContext(){

        @Override
        public void initialize() {
            this.stringField = new StringField("documentAuthPrincipalLink", "", Field.Store.NO);
        }
    };
    private final StringFieldContext txIdField = new StringFieldContext(){

        @Override
        public void initialize() {
            this.stringField = new StringField("documentTransactionId", "", Field.Store.NO);
        }
    };
    private final StringFieldContext updateActionField = new StringFieldContext(){

        @Override
        public void initialize() {
            this.stringField = new StringField("documentUpdateAction", "", Field.Store.YES);
        }
    };
    private final StringFieldContext indexingIdField = new StringFieldContext(){

        @Override
        public void initialize() {
            this.stringField = new StringField(LuceneIndexDocumentHelper.FIELD_NAME_INDEXING_ID, "", Field.Store.YES);
        }
    };
    private final Map<String, StoredField> storedFields = new HashMap<String, StoredField>();
    private final Map<String, StringField> stringFields = new HashMap<String, StringField>();
    private final Map<String, StringField> storedStringFields = new HashMap<String, StringField>();
    private final Map<String, SortedDocValuesField> sortedStringFields = new HashMap<String, SortedDocValuesField>();
    private final Map<String, LongPoint> longPointFields = new HashMap<String, LongPoint>();
    private final Map<String, DoublePoint> doublePointFields = new HashMap<String, DoublePoint>();
    private Map<String, NumericDocValuesField> numericFields = new HashMap<String, NumericDocValuesField>();

    public Document getDoc() {
        return this.doc;
    }

    public LuceneIndexDocumentHelper() {
        this.selfLinkField.initialize();
        this.kindField.initialize();
        this.authPrincipalLinkField.initialize();
        this.expirationTimeField.initialize();
        this.txIdField.initialize();
        this.updateActionField.initialize();
        this.updateTimeField.initialize();
        this.versionField.initialize();
        this.currentField.initialize();
        this.indexingIdField.initialize();
    }

    void addSelfLinkField(String selfLink) {
        StringFieldContext ctx = this.selfLinkField;
        ctx.stringField.setStringValue(selfLink);
        ctx.sortedField.setBytesValue(new BytesRef((CharSequence)selfLink));
        this.doc.add((IndexableField)ctx.stringField);
        this.doc.add((IndexableField)ctx.sortedField);
    }

    void addKindField(String kind) {
        this.kindField.stringField.setStringValue(kind);
        this.doc.add((IndexableField)this.kindField.stringField);
    }

    void addUpdateActionField(String action) {
        this.updateActionField.stringField.setStringValue(action);
        this.doc.add((IndexableField)this.updateActionField.stringField);
    }

    void addTxIdField(String txId) {
        this.txIdField.stringField.setStringValue(txId);
        this.doc.add((IndexableField)this.txIdField.stringField);
    }

    void addAuthPrincipalLinkField(String authLink) {
        this.authPrincipalLinkField.stringField.setStringValue(authLink);
        this.doc.add((IndexableField)this.authPrincipalLinkField.stringField);
    }

    void addVersionField(long version) {
        this.updateLongFieldContext(version, this.versionField);
    }

    void addUpdateTimeField(long updateTimeMicros) {
        this.updateLongFieldContext(updateTimeMicros, this.updateTimeField);
    }

    void addExpirationTimeField(long exp) {
        this.updateLongFieldContext(exp, this.expirationTimeField);
    }

    void addCurrentField() {
        this.currentField.numericDocField.setLongValue(1L);
        this.doc.add((IndexableField)this.currentField.numericDocField);
    }

    void addIndexingIdField(String selfLink, Long epoch, long version) {
        StringBuilder sb = new StringBuilder(selfLink);
        if (epoch != null) {
            sb.append(":").append(epoch);
        }
        String indexingId = sb.append(":").append(version).toString();
        this.indexingIdField.stringField.setStringValue(indexingId);
        this.doc.add((IndexableField)this.indexingIdField.stringField);
    }

    private void updateLongFieldContext(long value, LongFieldContext ctx) {
        ctx.storedField.setLongValue(value);
        this.doc.add((IndexableField)ctx.storedField);
        ctx.longPoint.setLongValue(value);
        this.doc.add((IndexableField)ctx.longPoint);
        ctx.numericDocField.setLongValue(value);
        this.doc.add((IndexableField)ctx.numericDocField);
    }

    void addNumericField(String propertyName, long propertyValue, boolean isStored, boolean isCollectionItem, boolean sorted) {
        if (isStored) {
            StoredField field = isCollectionItem ? new StoredField(propertyName, propertyValue) : this.getAndSetStoredField(propertyName, propertyValue);
            this.doc.add((IndexableField)field);
        }
        if (isCollectionItem) {
            this.doc.add((IndexableField)new LongPoint(propertyName, new long[]{propertyValue}));
        } else {
            LongPoint lpField = this.longPointFields.computeIfAbsent(propertyName, k -> new LongPoint(propertyName, new long[]{propertyValue}));
            lpField.setLongValue(propertyValue);
            this.doc.add((IndexableField)lpField);
        }
        NumericDocValuesField ndField = this.getAndSetNumericField(propertyName, propertyValue, isCollectionItem);
        this.doc.add((IndexableField)ndField);
        if (sorted) {
            Field sdField = this.getAndSetSortedStoredField(propertyName + GROUP_BY_PROPERTY_NAME_SUFFIX, Long.toString(propertyValue));
            this.doc.add((IndexableField)sdField);
        }
    }

    private void addNumericField(String propertyName, double propertyValue, boolean stored, boolean isCollectionItem, boolean sorted) {
        long longPropertyValue = NumericUtils.doubleToSortableLong((double)propertyValue);
        if (stored) {
            StoredField field = isCollectionItem ? new StoredField(propertyName, propertyValue) : this.getAndSetStoredField(propertyName, propertyValue);
            this.doc.add((IndexableField)field);
        }
        if (isCollectionItem) {
            this.doc.add((IndexableField)new DoublePoint(propertyName, new double[]{propertyValue}));
        } else {
            DoublePoint dpField = this.doublePointFields.computeIfAbsent(propertyName, k -> new DoublePoint(propertyName, new double[]{propertyValue}));
            dpField.setDoubleValue(propertyValue);
            this.doc.add((IndexableField)dpField);
        }
        NumericDocValuesField ndField = this.getAndSetNumericField(propertyName, longPropertyValue, isCollectionItem);
        this.doc.add((IndexableField)ndField);
        if (sorted) {
            Field sdField = this.getAndSetSortedStoredField(propertyName + GROUP_BY_PROPERTY_NAME_SUFFIX, Double.toString(propertyValue));
            this.doc.add((IndexableField)sdField);
        }
    }

    public void addBinaryStateFieldToDocument(ServiceDocument s, byte[] serializedDocument, ServiceDocumentDescription desc) {
        try {
            int count = 0;
            if (serializedDocument == null) {
                Output o = KryoSerializers.serializeDocumentForIndexing(s, desc.serializedStateSizeLimit);
                count = o.position();
                serializedDocument = o.getBuffer();
            } else {
                count = serializedDocument.length;
            }
            StoredField bodyField = new StoredField("binarySerializedState", serializedDocument, 0, count);
            this.doc.add((IndexableField)bodyField);
        }
        catch (KryoException ke) {
            throw new IllegalArgumentException("Failure serializing state of service " + s.documentSelfLink + ", possibly due to size limit. Service author should override getDocumentTemplate() and adjust ServiceDocumentDescription.serializedStateSizeLimit. Cause: " + ke.toString());
        }
    }

    public void addIndexableFieldsToDocument(Object podo, ServiceDocumentDescription sd) {
        for (Map.Entry<String, ServiceDocumentDescription.PropertyDescription> e : sd.propertyDescriptions.entrySet()) {
            String name = e.getKey();
            ServiceDocumentDescription.PropertyDescription pd = e.getValue();
            if (pd.usageOptions != null && pd.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.INFRASTRUCTURE)) continue;
            Object v = ReflectionUtils.getPropertyValue(pd, podo);
            this.addIndexableFieldToDocument(v, pd, name, false, true);
        }
    }

    private void addIndexableFieldToDocument(Object podo, ServiceDocumentDescription.PropertyDescription pd, String fieldName, boolean isCollectionItem, boolean allowSortedField) {
        Object luceneField = null;
        Field luceneDocValuesField = null;
        Field.Store fsv = Field.Store.NO;
        boolean isSortedField = false;
        boolean expandField = false;
        Object v = podo;
        if (v == null) {
            return;
        }
        EnumSet<ServiceDocumentDescription.PropertyIndexingOption> opts = pd.indexingOptions;
        if (opts != null) {
            if (opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.STORE_ONLY)) {
                return;
            }
            if (opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
                isSortedField = true;
            }
            if (opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.EXPAND)) {
                expandField = true;
            }
        }
        if (pd.usageOptions != null) {
            if (pd.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.LINK)) {
                fsv = Field.Store.YES;
            }
            if (pd.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.LINKS)) {
                expandField = true;
            }
        }
        boolean isStored = fsv == Field.Store.YES;
        String stringValue = null;
        if (v instanceof String) {
            stringValue = v.toString();
            if (opts == null) {
                luceneField = this.getAndSetStringField(fieldName, stringValue, fsv, isCollectionItem);
            } else {
                if (opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.CASE_INSENSITIVE)) {
                    stringValue = stringValue.toLowerCase();
                }
                luceneField = opts.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.TEXT) ? new TextField(fieldName, stringValue, fsv) : this.getAndSetStringField(fieldName, stringValue, fsv, isCollectionItem);
            }
        } else if (v instanceof URI) {
            stringValue = QueryTask.QuerySpecification.toMatchValue((URI)v);
            luceneField = this.getAndSetStringField(fieldName, stringValue, fsv, isCollectionItem);
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.ENUM)) {
            stringValue = QueryTask.QuerySpecification.toMatchValue((Enum)v);
            luceneField = this.getAndSetStringField(fieldName, stringValue, fsv, isCollectionItem);
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.LONG)) {
            long value = ((Number)v).longValue();
            this.addNumericField(fieldName, value, isStored, isCollectionItem, isSortedField);
            isSortedField = false;
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.DATE)) {
            long micros = 0L;
            if (v instanceof Date) {
                micros = ((Date)v).getTime() * 1000L;
            } else if (v instanceof ZonedDateTime) {
                Instant inst = ((ZonedDateTime)v).toInstant();
                micros = this.instantToMicros(inst);
            } else if (v instanceof Instant) {
                Instant inst = (Instant)v;
                micros = this.instantToMicros(inst);
            } else if (v instanceof LocalDateTime) {
                Instant inst = ((LocalDateTime)v).atZone(ZoneId.systemDefault()).toInstant();
                micros = this.instantToMicros(inst);
            }
            this.addNumericField(fieldName, micros, isStored, isCollectionItem, false);
            isSortedField = false;
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.DOUBLE)) {
            double value = ((Number)v).doubleValue();
            this.addNumericField(fieldName, value, isStored, isCollectionItem, isSortedField);
            isSortedField = false;
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.BOOLEAN)) {
            stringValue = QueryTask.QuerySpecification.toMatchValue((Boolean)v);
            luceneField = this.getAndSetStringField(fieldName, stringValue, fsv, isCollectionItem);
        } else if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.BYTES)) {
            isSortedField = false;
        } else {
            if (pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.PODO)) {
                if (!(v instanceof TaskState) && !expandField) {
                    return;
                }
                this.addObjectIndexableFieldToDocument(v, pd, fieldName);
                return;
            }
            if (expandField && pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.MAP)) {
                this.addMapIndexableFieldToDocument(v, pd, fieldName);
                return;
            }
            if (expandField && pd.typeName.equals((Object)ServiceDocumentDescription.TypeName.COLLECTION)) {
                this.addCollectionIndexableFieldToDocument(v, pd, fieldName);
                return;
            }
            stringValue = v.toString();
            luceneField = this.getAndSetStringField(fieldName, stringValue, fsv, isCollectionItem);
        }
        if (isSortedField && allowSortedField) {
            luceneDocValuesField = this.getAndSetSortedStoredField(LuceneIndexDocumentHelper.createSortFieldPropertyName(fieldName), stringValue);
        }
        if (luceneField != null) {
            this.doc.add((IndexableField)luceneField);
        }
        if (luceneDocValuesField != null) {
            this.doc.add((IndexableField)luceneDocValuesField);
        }
    }

    private long instantToMicros(Instant inst) {
        long micros = inst.getEpochSecond() * 1000L * 1000L;
        return micros += (long)(inst.getNano() / 1000);
    }

    private void addObjectIndexableFieldToDocument(Object v, ServiceDocumentDescription.PropertyDescription pd, String fieldNamePrefix) {
        for (Map.Entry<String, ServiceDocumentDescription.PropertyDescription> e : pd.fieldDescriptions.entrySet()) {
            ServiceDocumentDescription.PropertyDescription fieldDescription = e.getValue();
            Object fieldValue = ReflectionUtils.getPropertyValue(fieldDescription, v);
            if (v == null) continue;
            if (pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
                fieldDescription.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
            }
            String fieldName = QueryTask.QuerySpecification.buildCompositeFieldName(fieldNamePrefix, e.getKey());
            this.addIndexableFieldToDocument(fieldValue, fieldDescription, fieldName, false, true);
        }
    }

    private void addMapIndexableFieldToDocument(Object v, ServiceDocumentDescription.PropertyDescription pd, String fieldNamePrefix) {
        String errorMsg = "Field not supported. Map keys must be of type String.";
        Map m = (Map)v;
        if (pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
            pd.elementDescription.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
        }
        for (Map.Entry o : m.entrySet()) {
            Map.Entry entry = o;
            Object mapKey = entry.getKey();
            if (!(mapKey instanceof String)) {
                throw new IllegalArgumentException("Field not supported. Map keys must be of type String.");
            }
            this.addIndexableFieldToDocument(entry.getValue(), pd.elementDescription, QueryTask.QuerySpecification.buildCompositeFieldName(fieldNamePrefix, (String)mapKey), false, true);
            if (!pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.FIXED_ITEM_NAME)) continue;
            this.addIndexableFieldToDocument(entry.getKey(), new ServiceDocumentDescription.PropertyDescription(), fieldNamePrefix, true, true);
            this.addIndexableFieldToDocument(entry.getValue(), pd.elementDescription, fieldNamePrefix, true, false);
        }
    }

    private void addCollectionIndexableFieldToDocument(Object v, ServiceDocumentDescription.PropertyDescription pd, String fieldNamePrefix) {
        fieldNamePrefix = QueryTask.QuerySpecification.buildCollectionItemName(fieldNamePrefix);
        List<Object> c = v instanceof Collection ? (List<Object>)v : Arrays.asList((Object[])v);
        if (pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.SORT)) {
            pd.elementDescription.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
        }
        for (Object e : c) {
            if (e == null) continue;
            this.addIndexableFieldToDocument(e, pd.elementDescription, fieldNamePrefix, true, true);
        }
    }

    private Field getAndSetSortedStoredField(String name, String value) {
        Field f = (Field)this.sortedStringFields.computeIfAbsent(name, k -> new SortedDocValuesField(name, new BytesRef((CharSequence)value)));
        f.setBytesValue(new BytesRef((CharSequence)value));
        return f;
    }

    private Field getAndSetStringField(String name, String value, Field.Store fsv, boolean isCollectionItem) {
        if (isCollectionItem) {
            return new StringField(name, value, fsv);
        }
        if (fsv == Field.Store.YES) {
            return this.getAndSetStoredField(name, value);
        }
        return this.getAndSetStringField(name, value);
    }

    private Field getAndSetStringField(String name, String value) {
        Field f = (Field)this.stringFields.computeIfAbsent(name, k -> new StringField(name, value, Field.Store.NO));
        f.setStringValue(value);
        return f;
    }

    private Field getAndSetStoredField(String name, String value) {
        Field f = (Field)this.storedStringFields.computeIfAbsent(name, k -> new StringField(name, value, Field.Store.YES));
        f.setStringValue(value);
        return f;
    }

    private Field getAndSetStoredField(String name, Long value) {
        Field f = (Field)this.storedFields.computeIfAbsent(name, k -> new StoredField(name, value.longValue()));
        f.setLongValue(value.longValue());
        return f;
    }

    private Field getAndSetStoredField(String name, Double value) {
        Field f = (Field)this.storedFields.computeIfAbsent(name, k -> new StoredField(name, value.doubleValue()));
        f.setDoubleValue(value.doubleValue());
        return f;
    }

    private NumericDocValuesField getAndSetNumericField(String propertyName, long propertyValue, boolean isCollectionItem) {
        if (isCollectionItem) {
            return new NumericDocValuesField(propertyName, propertyValue);
        }
        NumericDocValuesField ndField = this.numericFields.computeIfAbsent(propertyName, k -> new NumericDocValuesField(propertyName, propertyValue));
        ndField.setLongValue(propertyValue);
        return ndField;
    }

    static String createSortFieldPropertyName(String propertyName) {
        return DISABLE_SORT_FIELD_NAMING ? propertyName : propertyName + SORT_PROPERTY_NAME_SUFFIX;
    }

    static abstract class StringFieldContext {
        public StringField stringField;
        public SortedDocValuesField sortedField;

        StringFieldContext() {
        }

        public abstract void initialize();
    }

    static abstract class LongFieldContext {
        public StoredField storedField;
        public LongPoint longPoint;
        public NumericDocValuesField numericDocField;

        LongFieldContext() {
        }

        public abstract void initialize();
    }
}

