/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.services.common.AuthorizationContextServiceHelper;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class AuthorizationContextService
extends StatelessService {
    public static final String SELF_LINK = ServiceUriPaths.CORE_AUTHZ_VERIFICATION;
    private final AuthorizationContextServiceHelper.AuthServiceContext context;
    private final Set<String> cacheClearRequests = Collections.synchronizedSet(new HashSet());
    private final Map<String, Collection<Operation>> pendingOperationsBySubject = new HashMap<String, Collection<Operation>>();

    public AuthorizationContextService() {
        this.toggleOption(Service.ServiceOption.CORE, true);
        this.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        this.context = new AuthorizationContextServiceHelper.AuthServiceContext(this, null, requestBody -> {
            Map<String, Collection<Operation>> map = this.pendingOperationsBySubject;
            synchronized (map) {
                if (this.pendingOperationsBySubject.containsKey(requestBody.subjectLink)) {
                    this.cacheClearRequests.add(requestBody.subjectLink);
                }
            }
        });
    }

    @Override
    public boolean queueRequest(Operation op) {
        return AuthorizationContextServiceHelper.queueRequest(op, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(Operation op) {
        if (op.getAction() == Service.Action.DELETE && op.getUri().getPath().equals(this.getSelfLink())) {
            super.handleRequest(op);
            return;
        }
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx == null) {
            op.fail(new IllegalArgumentException("no authorization context"));
            return;
        }
        Claims claims = ctx.getClaims();
        if (claims == null) {
            op.fail(new IllegalArgumentException("no claims"));
            return;
        }
        String subject = claims.getSubject();
        Map<String, Collection<Operation>> map = this.pendingOperationsBySubject;
        synchronized (map) {
            Collection<Operation> pendingOperations = this.pendingOperationsBySubject.get(subject);
            if (pendingOperations != null) {
                pendingOperations.add(op);
                return;
            }
            pendingOperations = new LinkedList<Operation>();
            pendingOperations.add(op);
            this.pendingOperationsBySubject.put(subject, pendingOperations);
        }
        this.handlePopulateAuthContextCompletion(op);
        AuthorizationContextServiceHelper.populateAuthContext(op, this.context);
    }

    private void handlePopulateAuthContextCompletion(Operation op) {
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        Claims claims = ctx.getClaims();
        String subject = claims.getSubject();
        op.nestCompletion((nestOp, nestEx) -> {
            if (nestEx != null) {
                this.failThrowable(subject, nestEx, this.context);
                return;
            }
            if (this.cacheClearRequests.remove(claims.getSubject())) {
                this.handlePopulateAuthContextCompletion(op);
                AuthorizationContextServiceHelper.populateAuthContext(op, this.context);
                return;
            }
            Operation.AuthorizationContext populatedAuthContext = nestOp.getAuthorizationContext();
            this.getHost().cacheAuthorizationContext(this, populatedAuthContext);
            this.completePendingOperations(subject, populatedAuthContext, this.context);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Operation> getPendingOperations(String subject, AuthorizationContextServiceHelper.AuthServiceContext context) {
        Collection<Operation> operations;
        Map<String, Collection<Operation>> map = this.pendingOperationsBySubject;
        synchronized (map) {
            operations = this.pendingOperationsBySubject.remove(subject);
        }
        if (operations == null) {
            return Collections.emptyList();
        }
        return operations;
    }

    private void completePendingOperations(String subject, Operation.AuthorizationContext ctx, AuthorizationContextServiceHelper.AuthServiceContext context) {
        for (Operation op : this.getPendingOperations(subject, context)) {
            this.setAuthorizationContext(op, ctx);
            op.complete();
        }
    }

    private void failThrowable(String subject, Throwable e, AuthorizationContextServiceHelper.AuthServiceContext context) {
        if (e instanceof ServiceHost.ServiceNotFoundException) {
            this.failNotFound(subject, context);
            return;
        }
        for (Operation op : this.getPendingOperations(subject, context)) {
            op.fail(e);
        }
    }

    private void failNotFound(String subject, AuthorizationContextServiceHelper.AuthServiceContext context) {
        for (Operation op : this.getPendingOperations(subject, context)) {
            op.fail(404);
        }
    }
}

