/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServerSentEvent;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import com.vmware.xenon.common.http.netty.NettyHttpEventStreamHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.net.ProtocolException;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NettyHttpServerResponseHandler
extends SimpleChannelInboundHandler<HttpObject> {
    public static final Logger LOGGER = Logger.getLogger(NettyHttpServerResponseHandler.class.getName());
    private NettyChannelPool pool;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public NettyHttpServerResponseHandler(NettyChannelPool pool) {
        this.pool = pool;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            Operation request = this.findOperation(ctx, (HttpObject)response, true);
            if (request == null) {
                this.logger.warning("No request in channel " + ctx.channel().id().asLongText());
                return;
            }
            request.setStatusCode(response.status().code());
            this.parseResponseHeaders(request, (HttpResponse)response);
            this.completeRequest(ctx, request, response.content());
        } else if (msg instanceof NettyHttpEventStreamHandler.EventStreamHeadersMessage) {
            NettyHttpEventStreamHandler.EventStreamHeadersMessage sseHeaders = (NettyHttpEventStreamHandler.EventStreamHeadersMessage)msg;
            Operation request = this.findOperation(ctx, msg, false);
            request.setStatusCode(sseHeaders.originalResponse.status().code());
            this.parseResponseHeaders(request, sseHeaders.originalResponse);
            request.sendHeaders();
        } else if (msg instanceof NettyHttpEventStreamHandler.EventStreamMessage) {
            NettyHttpEventStreamHandler.EventStreamMessage sseMessage = (NettyHttpEventStreamHandler.EventStreamMessage)msg;
            ServerSentEvent event = sseMessage.event;
            if (event != null && "x-xenon-error".equals(event.event)) {
                Operation request = this.findOperation(ctx, msg, true);
                this.handleEventStreamError(request, event);
            } else {
                Operation request = this.findOperation(ctx, msg, false);
                request.sendServerSentEvent(event);
            }
        }
    }

    private Operation findOperation(ChannelHandlerContext ctx, HttpObject msg, boolean remove) {
        Operation request;
        if (ctx.channel().hasAttr(NettyChannelContext.HTTP2_KEY) && msg instanceof HttpResponse) {
            Integer streamId = ((HttpResponse)msg).headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            if (streamId == null) {
                this.logger.warning("HTTP/2 message has no stream ID: ignoring.");
                return null;
            }
            NettyChannelContext channelContext = (NettyChannelContext)ctx.channel().attr(NettyChannelContext.CHANNEL_CONTEXT_KEY).get();
            if (channelContext == null) {
                this.logger.warning("HTTP/2 channel is missing associated channel context: ignoring response on stream " + streamId);
                return null;
            }
            request = channelContext.getOperationForStream(streamId);
            if (request == null) {
                this.logger.warning("Can't find operation for stream " + streamId);
                return null;
            }
            channelContext.removeOperationForStream(streamId);
        } else {
            request = remove ? (Operation)ctx.channel().attr(NettyChannelContext.OPERATION_KEY).getAndSet(null) : (Operation)ctx.channel().attr(NettyChannelContext.OPERATION_KEY).get();
            if (request == null) {
                this.logger.warning("Can't find operation for channel " + ctx.channel().id().asLongText());
                return null;
            }
        }
        return request;
    }

    private void parseResponseHeaders(Operation request, HttpResponse nettyResponse) {
        HttpHeaders headers = nettyResponse.headers();
        if (headers.isEmpty()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            NettyHttpServerResponseHandler.logResponseFraming(request, nettyResponse);
        }
        request.setKeepAlive(HttpUtil.isKeepAlive((HttpMessage)nettyResponse));
        headers.remove((CharSequence)HttpHeaderNames.CONNECTION);
        if (HttpUtil.isContentLengthSet((HttpMessage)nettyResponse)) {
            request.setContentLength(HttpUtil.getContentLength((HttpMessage)nettyResponse));
            headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
        String contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        headers.remove((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null) {
            request.setContentType(contentType);
        }
        if (request.isConnectionSharing()) {
            headers.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text());
            headers.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        }
        if (headers.isEmpty()) {
            return;
        }
        for (Map.Entry h : headers) {
            String key = (String)h.getKey();
            String value = (String)h.getValue();
            if ("x-http2-stream-id".equals(key)) continue;
            request.addResponseHeader(key, value);
        }
    }

    private void completeRequest(ChannelHandlerContext ctx, Operation request, ByteBuf content) {
        this.decodeResponseBody(request, content);
        this.pool.returnOrClose((NettyChannelContext)request.getSocketContext(), !request.isKeepAlive());
    }

    private void decodeResponseBody(Operation request, ByteBuf content) {
        if (!content.isReadable()) {
            if (this.checkResponseForError(request)) {
                return;
            }
            request.setContentLength(0L).complete();
            return;
        }
        try {
            Utils.decodeBody(request, content.nioBuffer(), false);
            if (this.checkResponseForError(request)) {
                return;
            }
            this.completeRequest(request);
        }
        catch (Exception e) {
            request.fail(e);
            return;
        }
    }

    private void completeRequest(Operation request) {
        if (this.checkResponseForError(request)) {
            return;
        }
        request.complete();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Operation request = (Operation)ctx.channel().attr(NettyChannelContext.OPERATION_KEY).getAndSet(null);
        if (request == null) {
            this.logger.info("Channel exception but no HTTP/1.1 request to fail:" + cause.getMessage());
            return;
        }
        request.setStatusCode(400);
        request.setBody(ServiceErrorResponse.create(cause, request.getStatusCode(), EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)));
        request.fail(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            Operation request;
            if (!ctx.channel().hasAttr(NettyChannelContext.HTTP2_KEY) && (request = (Operation)ctx.channel().attr(NettyChannelContext.OPERATION_KEY).getAndSet(null)) != null && "text/event-stream".equals(request.getContentType())) {
                request.complete();
                this.pool.returnOrClose((NettyChannelContext)request.getSocketContext(), !request.isKeepAlive());
            }
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    private boolean checkResponseForError(Operation op) {
        if (op.getStatusCode() < 400) {
            return false;
        }
        String errorMsg = String.format("Service %s returned error %d for %s. id %d", new Object[]{op.getUri(), op.getStatusCode(), op.getAction(), op.getId()});
        if (!op.hasBody()) {
            ServiceErrorResponse rsp = ServiceErrorResponse.create(new ProtocolException(errorMsg), op.getStatusCode());
            op.setBodyNoCloning(rsp);
        } else if ("application/json".equals(op.getContentType())) {
            try {
                Object originalBody = op.getBodyRaw();
                ServiceErrorResponse rsp = op.getErrorResponseBody();
                if (rsp != null) {
                    errorMsg = errorMsg + " message " + rsp.message;
                }
                op.setBodyNoCloning(originalBody);
            }
            catch (Exception e) {
                this.logger.warning("Error response body not JSON: " + e.getMessage());
                ServiceErrorResponse rsp = ServiceErrorResponse.create(e, op.getStatusCode());
                op.setBodyNoCloning(rsp);
            }
        }
        op.fail(new ProtocolException(errorMsg));
        return true;
    }

    private void handleEventStreamError(Operation op, ServerSentEvent event) {
        String errorMsg = String.format("Service %s returned error for %s. id %d", new Object[]{op.getUri(), op.getAction(), op.getId()});
        ServiceErrorResponse rsp = Utils.fromJson(event.data, ServiceErrorResponse.class);
        errorMsg = errorMsg + " message " + rsp.message;
        op.setBodyNoCloning(rsp);
        op.fail(new ProtocolException(errorMsg));
    }

    public static void logResponseFraming(Operation op, HttpResponse response) {
        if (response.headers().isEmpty()) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(op.getAction().toString()).append(" ").append(op.getUri().toString()).append("\n");
        response.headers().forEach(e -> s.append(e.toString()).append("\n"));
        LOGGER.info(s.toString());
    }
}

