/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.Utils;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;

public class ServiceStats
extends ServiceDocument {
    public static final String KIND = Utils.buildKind(ServiceStats.class);
    public static final String STAT_NAME_SUFFIX_PER_DAY = "PerDay";
    public static final String STAT_NAME_SUFFIX_PER_HOUR = "PerHour";
    public String kind = KIND;
    public Map<String, ServiceStat> entries = new HashMap<String, ServiceStat>();

    public static class ServiceStat {
        public static final String KIND = Utils.buildKind(ServiceStat.class);
        public static final String FIELD_NAME_NAME = "name";
        public static final String FIELD_NAME_VERSION = "version";
        public static final String FIELD_NAME_LAST_UPDATE_TIME_MICROS_UTC = "lastUpdateMicrosUtc";
        public static final String FIELD_NAME_LATEST_VALUE = "latestValue";
        public static final String FIELD_NAME_UNIT = "unit";
        public String name;
        public double latestValue;
        public double accumulatedValue;
        public long version;
        public long lastUpdateMicrosUtc;
        public String kind = KIND;
        public String unit;
        public Long sourceTimeMicrosUtc;
        public URI serviceReference;
        public ServiceStatLogHistogram logHistogram;
        public TimeSeriesStats timeSeriesStats;
    }

    public static class TimeSeriesStats {
        public SortedMap<Long, TimeBin> bins;
        public int numBins;
        public long binDurationMillis;
        public EnumSet<AggregationType> aggregationType;

        public TimeSeriesStats() {
        }

        public TimeSeriesStats(int numBins, long binDurationMillis, EnumSet<AggregationType> aggregationType) {
            this.numBins = numBins;
            this.binDurationMillis = binDurationMillis;
            this.bins = new ConcurrentSkipListMap<Long, TimeBin>();
            this.aggregationType = aggregationType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long timestampMicros, double value, double delta) {
            TimeSeriesStats timeSeriesStats = this;
            synchronized (timeSeriesStats) {
                long binId = this.normalizeTimestamp(timestampMicros, this.binDurationMillis);
                TimeBin dataBin = null;
                if (this.bins.containsKey(binId)) {
                    dataBin = (TimeBin)this.bins.get(binId);
                } else {
                    if (this.bins.size() == this.numBins) {
                        if (this.bins.firstKey() > timestampMicros) {
                            return;
                        }
                        this.bins.remove(this.bins.firstKey());
                    }
                    dataBin = new TimeBin();
                    this.bins.put(binId, dataBin);
                }
                if (this.aggregationType.contains((Object)AggregationType.AVG)) {
                    if (dataBin.avg == null) {
                        dataBin.avg = value;
                        dataBin.count = 1.0;
                    } else {
                        dataBin.avg = (dataBin.avg * dataBin.count + value) / (dataBin.count + 1.0);
                        dataBin.count += 1.0;
                    }
                }
                if (this.aggregationType.contains((Object)AggregationType.SUM)) {
                    if (dataBin.sum == null) {
                        dataBin.sum = delta;
                    } else {
                        TimeBin timeBin = dataBin;
                        timeBin.sum = timeBin.sum + delta;
                    }
                }
                if (this.aggregationType.contains((Object)AggregationType.MAX)) {
                    if (dataBin.max == null) {
                        dataBin.max = value;
                    } else if (dataBin.max < value) {
                        dataBin.max = value;
                    }
                }
                if (this.aggregationType.contains((Object)AggregationType.MIN)) {
                    if (dataBin.min == null) {
                        dataBin.min = value;
                    } else if (dataBin.min > value) {
                        dataBin.min = value;
                    }
                }
                if (this.aggregationType.contains((Object)AggregationType.LATEST)) {
                    dataBin.latest = value;
                }
            }
        }

        private long normalizeTimestamp(long timestampMicros, long binDurationMillis) {
            long timeMillis = TimeUnit.MICROSECONDS.toMillis(timestampMicros);
            timeMillis -= timeMillis % binDurationMillis;
            return timeMillis;
        }

        public static enum AggregationType {
            AVG,
            MIN,
            MAX,
            SUM,
            LATEST;

        }

        public static class TimeBin {
            public Double avg;
            public Double min;
            public Double max;
            public Double sum;
            public Double latest;
            public double count;
        }
    }

    public static class ServiceStatLogHistogram {
        public long[] bins = new long[15];
    }
}

