/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceStats;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class ServiceStatUtils {
    static final String GET_DURATION = (Object)((Object)Service.Action.GET) + "operationDuration";
    static final String POST_DURATION = (Object)((Object)Service.Action.POST) + "operationDuration";
    static final String PATCH_DURATION = (Object)((Object)Service.Action.PATCH) + "operationDuration";
    static final String PUT_DURATION = (Object)((Object)Service.Action.PUT) + "operationDuration";
    static final String DELETE_DURATION = (Object)((Object)Service.Action.DELETE) + "operationDuration";
    static final String OPTIONS_DURATION = (Object)((Object)Service.Action.OPTIONS) + "operationDuration";
    static final String GET_REQUEST_COUNT = (Object)((Object)Service.Action.GET) + "requestCount";
    static final String POST_REQUEST_COUNT = (Object)((Object)Service.Action.POST) + "requestCount";
    static final String PATCH_REQUEST_COUNT = (Object)((Object)Service.Action.PATCH) + "requestCount";
    static final String PUT_REQUEST_COUNT = (Object)((Object)Service.Action.PUT) + "requestCount";
    static final String DELETE_REQUEST_COUNT = (Object)((Object)Service.Action.DELETE) + "requestCount";
    static final String OPTIONS_REQUEST_COUNT = (Object)((Object)Service.Action.OPTIONS) + "requestCount";
    static final String GET_QLATENCY = (Object)((Object)Service.Action.GET) + "operationQueueingLatencyMicros";
    static final String POST_QLATENCY = (Object)((Object)Service.Action.POST) + "operationQueueingLatencyMicros";
    static final String PATCH_QLATENCY = (Object)((Object)Service.Action.PATCH) + "operationQueueingLatencyMicros";
    static final String PUT_QLATENCY = (Object)((Object)Service.Action.PUT) + "operationQueueingLatencyMicros";
    static final String DELETE_QLATENCY = (Object)((Object)Service.Action.DELETE) + "operationQueueingLatencyMicros";
    static final String OPTIONS_QLATENCY = (Object)((Object)Service.Action.OPTIONS) + "operationQueueingLatencyMicros";
    static final String GET_HANDLER_LATENCY = (Object)((Object)Service.Action.GET) + "operationHandlerProcessingLatencyMicros";
    static final String POST_HANDLER_LATENCY = (Object)((Object)Service.Action.POST) + "operationHandlerProcessingLatencyMicros";
    static final String PATCH_HANDLER_LATENCY = (Object)((Object)Service.Action.PATCH) + "operationHandlerProcessingLatencyMicros";
    static final String PUT_HANDLER_LATENCY = (Object)((Object)Service.Action.PUT) + "operationHandlerProcessingLatencyMicros";
    static final String DELETE_HANDLER_LATENCY = (Object)((Object)Service.Action.DELETE) + "operationHandlerProcessingLatencyMicros";
    static final String OPTIONS_HANDLER_LATENCY = (Object)((Object)Service.Action.OPTIONS) + "operationHandlerProcessingLatencyMicros";
    static final EnumSet<ServiceStats.TimeSeriesStats.AggregationType> AGGREGATION_TYPE_AVG_MAX = EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.AVG, ServiceStats.TimeSeriesStats.AggregationType.MAX);

    private ServiceStatUtils() {
    }

    public static ServiceStats.ServiceStat getOrCreateHistogramStat(Service service, String name) {
        return ServiceStatUtils.getOrCreateStat(service, name, true, null);
    }

    public static ServiceStats.TimeSeriesStats createHourlyTimeSeriesStat(EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        return new ServiceStats.TimeSeriesStats((int)TimeUnit.HOURS.toMinutes(1L), TimeUnit.MINUTES.toMillis(1L), aggregationTypes);
    }

    public static ServiceStats.TimeSeriesStats createDailyTimeSeriesStat(EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        return new ServiceStats.TimeSeriesStats((int)TimeUnit.DAYS.toHours(1L), TimeUnit.HOURS.toMillis(1L), aggregationTypes);
    }

    public static ServiceStats.ServiceStat getOrCreateHourlyTimeSeriesStat(Service service, String prefix, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        String statName = prefix + "PerHour";
        return ServiceStatUtils.getOrCreateStat(service, statName, false, () -> ServiceStatUtils.createHourlyTimeSeriesStat(aggregationTypes));
    }

    public static ServiceStats.ServiceStat getOrCreateDailyTimeSeriesStat(Service service, String prefix, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        String statName = prefix + "PerDay";
        return ServiceStatUtils.getOrCreateStat(service, statName, false, () -> ServiceStatUtils.createDailyTimeSeriesStat(aggregationTypes));
    }

    public static ServiceStats.ServiceStat getOrCreateHourlyTimeSeriesHistogramStat(Service service, String prefix, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        String statName = prefix + "PerHour";
        return ServiceStatUtils.getOrCreateStat(service, statName, true, () -> ServiceStatUtils.createHourlyTimeSeriesStat(aggregationTypes));
    }

    public static ServiceStats.ServiceStat getOrCreateDailyTimeSeriesHistogramStat(Service service, String prefix, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        String statName = prefix + "PerDay";
        return ServiceStatUtils.getOrCreateStat(service, statName, true, () -> ServiceStatUtils.createDailyTimeSeriesStat(aggregationTypes));
    }

    public static ServiceStats.ServiceStat getOrCreateTimeSeriesStat(Service service, String name, Supplier<ServiceStats.TimeSeriesStats> timeSeriesStatsSupplier) {
        return ServiceStatUtils.getOrCreateStat(service, name, false, timeSeriesStatsSupplier);
    }

    static String getPerActionDurationName(Service.Action a) {
        switch (a) {
            case GET: {
                return GET_DURATION;
            }
            case POST: {
                return POST_DURATION;
            }
            case PATCH: {
                return PATCH_DURATION;
            }
            case PUT: {
                return PUT_DURATION;
            }
            case DELETE: {
                return DELETE_DURATION;
            }
            case OPTIONS: {
                return OPTIONS_DURATION;
            }
        }
        throw new IllegalArgumentException("Unknown action " + (Object)((Object)a));
    }

    static String getPerActionRequestCountName(Service.Action a) {
        switch (a) {
            case GET: {
                return GET_REQUEST_COUNT;
            }
            case POST: {
                return POST_REQUEST_COUNT;
            }
            case PATCH: {
                return PATCH_REQUEST_COUNT;
            }
            case PUT: {
                return PUT_REQUEST_COUNT;
            }
            case DELETE: {
                return DELETE_REQUEST_COUNT;
            }
            case OPTIONS: {
                return OPTIONS_REQUEST_COUNT;
            }
        }
        throw new IllegalArgumentException("Unknown action " + (Object)((Object)a));
    }

    static String getPerActionQueueLatencyName(Service.Action a) {
        switch (a) {
            case GET: {
                return GET_QLATENCY;
            }
            case POST: {
                return POST_QLATENCY;
            }
            case PATCH: {
                return PATCH_QLATENCY;
            }
            case PUT: {
                return PUT_QLATENCY;
            }
            case DELETE: {
                return DELETE_QLATENCY;
            }
            case OPTIONS: {
                return OPTIONS_QLATENCY;
            }
        }
        throw new IllegalArgumentException("Unknown action " + (Object)((Object)a));
    }

    static String getPerActionServiceHandlerLatencyName(Service.Action a) {
        switch (a) {
            case GET: {
                return GET_HANDLER_LATENCY;
            }
            case POST: {
                return POST_HANDLER_LATENCY;
            }
            case PATCH: {
                return PATCH_HANDLER_LATENCY;
            }
            case PUT: {
                return PUT_HANDLER_LATENCY;
            }
            case DELETE: {
                return DELETE_HANDLER_LATENCY;
            }
            case OPTIONS: {
                return OPTIONS_HANDLER_LATENCY;
            }
        }
        throw new IllegalArgumentException("Unknown action " + (Object)((Object)a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceStats.ServiceStat getOrCreateStat(Service service, String name, boolean createHistogram, Supplier<ServiceStats.TimeSeriesStats> timeSeriesStatsSupplier) {
        ServiceStats.ServiceStat stat;
        if (!service.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return null;
        }
        ServiceStats.ServiceStat serviceStat = stat = service.getStat(name);
        synchronized (serviceStat) {
            if (stat.logHistogram == null && createHistogram) {
                stat.logHistogram = new ServiceStats.ServiceStatLogHistogram();
            }
            if (stat.timeSeriesStats == null && timeSeriesStatsSupplier != null) {
                stat.timeSeriesStats = timeSeriesStatsSupplier.get();
            }
        }
        return stat;
    }
}

