/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.RequestRouter;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class ServiceDocumentDescriptionHelper {
    private static final Logger logger = Logger.getLogger(ServiceDocumentDescriptionHelper.class.getName());
    private static final Map<Class<?>, Map<String, String>> documentationDescriptionCache = new WeakHashMap();
    private static final Map<String, Boolean> actionDefaultTypeMap = new LinkedHashMap<String, Boolean>();

    private ServiceDocumentDescriptionHelper() {
    }

    public static RequestRouter findAndDocumentRequestRouter(Service s) {
        RequestRouter requestRouter = RequestRouter.findRequestRouter(s.getOperationProcessingChain());
        if (requestRouter == null) {
            requestRouter = new RequestRouter();
        }
        for (Map.Entry<String, Boolean> entry : actionDefaultTypeMap.entrySet()) {
            try {
                String action = entry.getKey();
                String methodName = "handle" + action;
                String actionName = action.toUpperCase(Locale.ENGLISH);
                Method method = s.getClass().getMethod(methodName, Operation.class);
                RequestRouter.Route.RouteDocumentation[] docs = (RequestRouter.Route.RouteDocumentation[])method.getAnnotationsByType(RequestRouter.Route.RouteDocumentation.class);
                if (docs.length == 0) {
                    RequestRouter.Route route = new RequestRouter.Route();
                    route.path = "";
                    route.action = Service.Action.valueOf(actionName);
                    route.matcher = new RequestRouter.RequestDefaultMatcher();
                    requestRouter.register(route);
                    continue;
                }
                for (RequestRouter.Route.RouteDocumentation doc : docs) {
                    RequestRouter.Parameter p;
                    RequestRouter.Route.SupportLevel supportLevel;
                    if (RequestRouter.Route.SupportLevel.NOT_SUPPORTED == doc.supportLevel()) continue;
                    RequestRouter.Route route = new RequestRouter.Route();
                    route.path = doc.path();
                    Boolean entryValue = entry.getValue();
                    if (entryValue != null && !s.getStateType().equals(ServiceDocument.class)) {
                        route.responseType = s.getStateType();
                        if (entryValue.equals(Boolean.TRUE)) {
                            route.requestType = s.getStateType();
                            if (doc.requestBodyType() != Object.class) {
                                route.requestType = doc.requestBodyType();
                            }
                        }
                    }
                    if (entryValue != null && entryValue.equals(Boolean.TRUE) && route.requestType == null && doc.requestBodyType() != Object.class) {
                        route.requestType = doc.requestBodyType();
                    }
                    if (RequestRouter.Route.SupportLevel.DEPRECATED.compareTo(supportLevel = doc.supportLevel()) < 0 && method.getAnnotation(Deprecated.class) != null) {
                        supportLevel = RequestRouter.Route.SupportLevel.DEPRECATED;
                    }
                    route.supportLevel = supportLevel;
                    route.description = ServiceDocumentDescriptionHelper.lookupDocumentationDescription(s.getClass(), doc.description());
                    route.parameters = new ArrayList<RequestRouter.Parameter>();
                    for (RequestRouter.Route.RouteDocumentation.QueryParam queryParam : doc.queryParams()) {
                        p = new RequestRouter.Parameter(queryParam.name(), ServiceDocumentDescriptionHelper.lookupDocumentationDescription(s.getClass(), queryParam.description()), queryParam.type(), queryParam.required(), queryParam.example().isEmpty() ? null : queryParam.example(), RequestRouter.ParamDef.QUERY);
                        route.parameters.add(p);
                    }
                    for (Annotation annotation : doc.pathParams()) {
                        p = new RequestRouter.Parameter(annotation.name(), ServiceDocumentDescriptionHelper.lookupDocumentationDescription(s.getClass(), annotation.description()), annotation.type(), annotation.required(), annotation.example().isEmpty() ? null : annotation.example(), RequestRouter.ParamDef.PATH);
                        route.parameters.add(p);
                    }
                    for (Annotation annotation : doc.responses()) {
                        p = new RequestRouter.Parameter(Integer.toString(annotation.statusCode()), ServiceDocumentDescriptionHelper.lookupDocumentationDescription(s.getClass(), annotation.description()), annotation.response().getName(), false, null, RequestRouter.ParamDef.RESPONSE);
                        route.parameters.add(p);
                    }
                    for (String string : doc.consumes()) {
                        p = new RequestRouter.Parameter(string, null, null, false, null, RequestRouter.ParamDef.CONSUMES);
                        route.parameters.add(p);
                    }
                    for (String string : doc.produces()) {
                        p = new RequestRouter.Parameter(string, null, null, false, null, RequestRouter.ParamDef.PRODUCES);
                        route.parameters.add(p);
                    }
                    route.action = Service.Action.valueOf(actionName);
                    route.matcher = new RequestRouter.RequestDefaultMatcher();
                    requestRouter.register(route);
                }
            }
            catch (NoSuchMethodException | SecurityException ex) {
                logger.log(Level.WARNING, "Failure looking up handler method for %s: %s", new Object[]{entry.getKey(), Utils.toString(ex)});
            }
        }
        return requestRouter;
    }

    public static String lookupDocumentationDescription(Class<?> clazz, String description) {
        Map<String, String> cache;
        if (description == null) {
            return null;
        }
        if (!documentationDescriptionCache.containsKey(clazz)) {
            String resourceName = "/" + clazz.getName().replaceAll("\\.", "/") + ".html";
            InputStream is = clazz.getResourceAsStream(resourceName);
            if (is == null) {
                documentationDescriptionCache.put(clazz, null);
                return description;
            }
            HashMap<String, String> cache2 = new HashMap<String, String>();
            String key = null;
            StringBuilder body = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                String line;
                int lineNo = 1;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("<h1>")) {
                        int index = line.indexOf("</h1>");
                        if (index < 0) {
                            logger.log(Level.WARNING, "Unexpected format in document description file: %s at line %d", new Object[]{resourceName, lineNo});
                        } else {
                            if (key != null) {
                                cache2.put(key, body.toString().trim());
                            }
                            key = line.substring(4, index).trim();
                            body = new StringBuilder();
                        }
                    } else {
                        body.append(line).append(" ");
                    }
                    ++lineNo;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ServiceHost.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (body.length() > 0) {
                cache2.put(key, body.toString());
            }
            documentationDescriptionCache.put(clazz, cache2);
        }
        if ((cache = documentationDescriptionCache.get(clazz)) == null) {
            return description;
        }
        String mappedDesc = cache.get(description);
        if (mappedDesc == null) {
            return description;
        }
        return mappedDesc;
    }

    static {
        actionDefaultTypeMap.put("Get", false);
        actionDefaultTypeMap.put("Post", true);
        actionDefaultTypeMap.put("Put", true);
        actionDefaultTypeMap.put("Patch", true);
        actionDefaultTypeMap.put("Delete", null);
    }
}

