/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.Service;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class RequestRouter
implements Predicate<Operation> {
    private Map<Service.Action, List<Route>> routes = new LinkedHashMap<Service.Action, List<Route>>();

    public void register(Route route) {
        Service.Action action = route.action;
        List<Route> actionRoutes = this.routes.get((Object)action);
        if (actionRoutes == null) {
            actionRoutes = new ArrayList<Route>();
            this.routes.put(action, actionRoutes);
        }
        actionRoutes.add(route);
    }

    public void register(Service.Action action, Predicate<Operation> matcher, Consumer<Operation> handler, String description) {
        List<Route> actionRoutes = this.routes.get((Object)action);
        if (actionRoutes == null) {
            actionRoutes = new ArrayList<Route>();
        }
        actionRoutes.add(new Route(action, matcher, handler, description));
        this.routes.put(action, actionRoutes);
    }

    @Override
    public boolean test(Operation op) {
        List<Route> actionRoutes = this.routes.get((Object)op.getAction());
        if (actionRoutes != null) {
            for (Route route : actionRoutes) {
                if (!route.matcher.test(op)) continue;
                route.handler.accept(op);
                return false;
            }
        }
        return true;
    }

    public Map<Service.Action, List<Route>> getRoutes() {
        return this.routes;
    }

    public static RequestRouter findRequestRouter(OperationProcessingChain opProcessingChain) {
        if (opProcessingChain == null) {
            return null;
        }
        List<Predicate<Operation>> filters = opProcessingChain.getFilters();
        if (filters.isEmpty()) {
            return null;
        }
        Predicate<Operation> lastElement = filters.get(filters.size() - 1);
        if (lastElement instanceof RequestRouter) {
            return (RequestRouter)lastElement;
        }
        return null;
    }

    public static class RequestBodyMatcher<T>
    implements Predicate<Operation> {
        private final Class<T> typeParameterClass;
        private final Object fieldValue;
        private final Field field;

        public RequestBodyMatcher(Class<T> typeParameterClass, String fieldName, Object fieldValue) {
            this.typeParameterClass = typeParameterClass;
            this.field = ReflectionUtils.getField(typeParameterClass, fieldName);
            this.fieldValue = fieldValue;
        }

        @Override
        public boolean test(Operation op) {
            if (this.field == null) {
                return false;
            }
            try {
                T body = op.getBody(this.typeParameterClass);
                return body != null && Objects.equals(this.field.get(body), this.fieldValue);
            }
            catch (IllegalAccessException ex) {
                return false;
            }
        }

        public String toString() {
            return String.format("%s#%s=%s", this.typeParameterClass.getName(), this.field != null ? this.field.getName() : "<<bad field>>", this.fieldValue);
        }
    }

    public static class RequestUriMatcher
    implements Predicate<Operation> {
        private Pattern pattern;

        public RequestUriMatcher(String regexp) {
            this.pattern = Pattern.compile(regexp);
        }

        @Override
        public boolean test(Operation op) {
            return op.getUri() != null && op.getUri().getQuery() != null && this.pattern.matcher(op.getUri().getQuery()).matches();
        }

        public String toString() {
            return String.format("?%s", this.pattern.pattern());
        }
    }

    public static class RequestDefaultMatcher
    implements Predicate<Operation> {
        @Override
        public boolean test(Operation op) {
            return true;
        }

        public String toString() {
            return "#";
        }
    }

    public static class Route {
        public Service.Action action;
        public String path;
        public Predicate<Operation> matcher;
        public Consumer<Operation> handler;
        public String description;
        public Class<?> requestType;
        public Class<?> responseType;
        public List<Parameter> parameters;
        public SupportLevel supportLevel;

        public Route(Service.Action action, Predicate<Operation> matcher, Consumer<Operation> handler, String description) {
            this.action = action;
            this.matcher = matcher;
            this.handler = handler;
            this.description = description;
        }

        public Route() {
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        @Repeatable(value=RouteDocumentations.class)
        public static @interface RouteDocumentation {
            public SupportLevel supportLevel() default SupportLevel.PUBLIC;

            public String description() default "";

            public String path() default "";

            public ApiResponse[] responses() default {};

            public QueryParam[] queryParams() default {};

            public PathParam[] pathParams() default {};

            public String[] consumes() default {};

            public String[] produces() default {};

            public Class<?> requestBodyType() default Object.class;

            @Target(value={ElementType.METHOD})
            @Retention(value=RetentionPolicy.RUNTIME)
            public static @interface PathParam {
                public String name();

                public String description() default "";

                public String example() default "";

                public String type() default "string";

                public boolean required() default true;
            }

            @Target(value={ElementType.METHOD})
            @Retention(value=RetentionPolicy.RUNTIME)
            public static @interface QueryParam {
                public String name();

                public String description() default "";

                public String example() default "";

                public String type() default "string";

                public boolean required() default false;
            }

            @Target(value={ElementType.METHOD})
            @Retention(value=RetentionPolicy.RUNTIME)
            public static @interface ApiResponse {
                public int statusCode();

                public String description();

                public Class<?> response() default Void.class;
            }
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD})
        public static @interface RouteDocumentations {
            public RouteDocumentation[] value();
        }

        public static enum SupportLevel {
            NOT_SUPPORTED,
            INTERNAL,
            DEPRECATED,
            PUBLIC;

        }
    }

    public static enum ParamDef {
        QUERY("query"),
        BODY("body"),
        CONSUMES("consumes"),
        PRODUCES("produces"),
        RESPONSE("response"),
        PATH("path");

        String value;

        private ParamDef(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Parameter {
        public String name;
        public String description;
        public String type;
        public boolean required;
        public String value;
        public ParamDef paramDef;

        public Parameter(String name, String description, String type, boolean required, String value, ParamDef paramDef) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.required = required;
            this.value = value;
            this.paramDef = paramDef;
        }
    }
}

