/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.FileContentService;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public abstract class UiFileContentService
extends StatelessService {
    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleStart(Operation startPost) {
        try {
            Path baseResourcePath = Utils.getServiceUiResourcePath(this);
            Path baseUriPath = Paths.get(this.getSelfLink(), new String[0]);
            String prefix = baseResourcePath.toString().replace('\\', '/');
            HashMap<Path, String> pathToURIPath = new HashMap<Path, String>();
            if (this.getHost().getState().resourceSandboxFileReference != null) {
                this.getHost().discoverFileResources(this, pathToURIPath, baseUriPath, prefix);
            }
            if (pathToURIPath.isEmpty()) {
                this.getHost().discoverJarResources(baseResourcePath, this, pathToURIPath, baseUriPath, prefix);
            }
            if (pathToURIPath.isEmpty()) {
                this.log(Level.WARNING, "No custom UI resources found for %s", this.getClass().getName());
            }
            for (Map.Entry e : pathToURIPath.entrySet()) {
                String value = (String)e.getValue();
                Operation post = Operation.createPost(UriUtils.buildUri(this.getHost(), value));
                FileContentService fcs = new FileContentService(((Path)e.getKey()).toFile());
                this.getHost().startService(post, fcs);
            }
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Error enumerating UI resources for %s: %s", this.getSelfLink(), Utils.toString(e));
        }
        super.handleStart(startPost);
    }

    @Override
    public void handleGet(Operation get) {
        URI uri;
        String requestUri;
        String selfLink = this.getSelfLink();
        if (selfLink.equals(requestUri = (uri = get.getUri()).getPath()) && !"/".equals(requestUri)) {
            get.setStatusCode(302);
            get.addResponseHeader("location", selfLink + "/");
            get.complete();
            return;
        }
        String uiResourcePath = selfLink + "/" + "index.html";
        Operation operation = get.clone();
        operation.setUri(UriUtils.buildUri(this.getHost(), uiResourcePath, uri.getQuery())).setCompletion((o, e) -> {
            get.setBody(o.getBodyRaw()).setStatusCode(o.getStatusCode()).setContentType(o.getContentType());
            if (e != null) {
                get.fail(e);
            } else {
                get.complete();
            }
        });
        this.getHost().sendRequest(operation);
    }
}

