/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.OperationIndexService;
import java.net.URI;
import java.util.logging.Level;

public class ServiceHostManagementService
extends StatefulService {
    public static final String SELF_LINK = UriUtils.buildUriPath("/core/management");
    public static final String STAT_NAME_AVAILABLE_MEMORY_BYTES_PREFIX = "availableMemoryBytes";
    public static final String STAT_NAME_AVAILABLE_MEMORY_BYTES_PER_DAY = "availableMemoryBytesPerDay";
    public static final String STAT_NAME_AVAILABLE_MEMORY_BYTES_PER_HOUR = "availableMemoryBytesPerHour";
    public static final String STAT_NAME_AVAILABLE_DISK_BYTES_PREFIX = "availableDiskByte";
    public static final String STAT_NAME_AVAILABLE_DISK_BYTES_PER_DAY = "availableDiskBytePerDay";
    public static final String STAT_NAME_AVAILABLE_DISK_BYTES_PER_HOUR = "availableDiskBytePerHour";
    public static final String STAT_NAME_CPU_USAGE_PCT_PREFIX = "cpuUsagePercent";
    public static final String STAT_NAME_CPU_USAGE_PCT_PER_DAY = "cpuUsagePercentPerDay";
    public static final String STAT_NAME_CPU_USAGE_PCT_PER_HOUR = "cpuUsagePercentPerHour";
    public static final String STAT_NAME_THREAD_COUNT = "threadCount";
    public static final String STAT_NAME_JVM_THREAD_COUNT_PREFIX = "jvmThreadCount";
    public static final String STAT_NAME_JVM_THREAD_COUNT_PER_DAY = "jvmThreadCountPerDay";
    public static final String STAT_NAME_JVM_THREAD_COUNT_PER_HOUR = "jvmThreadCountPerHour";
    public static final String STAT_NAME_HTTP11_CONNECTION_COUNT_PREFIX = "http11ConnectionCount";
    public static final String STAT_NAME_HTTP11_CONNECTION_COUNT_PER_DAY = "http11ConnectionCountPerDay";
    public static final String STAT_NAME_HTTP11_CONNECTION_COUNT_PER_HOUR = "http11ConnectionCountPerHour";
    public static final String STAT_NAME_HTTP2_CONNECTION_COUNT_PREFIX = "http2ConnectionCount";
    public static final String STAT_NAME_HTTP2_CONNECTION_COUNT_PER_DAY = "http2ConnectionCountPerDay";
    public static final String STAT_NAME_HTTP2_CONNECTION_COUNT_PER_HOUR = "http2ConnectionCountPerHour";
    public static final String STAT_NAME_HTTP11_PENDING_OP_COUNT = "http11PendingOperationCount";
    public static final String STAT_NAME_HTTP2_PENDING_OP_COUNT = "http2PendingOperationCount";
    public static final String STAT_NAME_SERVICE_COUNT = "serviceCount";
    public static final String STAT_NAME_SERVICE_PAUSE_COUNT = "servicePauseCount";
    public static final String STAT_NAME_SERVICE_RESUME_COUNT = "serviceResumeCount";
    public static final String STAT_NAME_SERVICE_CACHE_CLEAR_COUNT = "serviceCacheClearCount";
    public static final String STAT_NAME_ODL_CACHE_CLEAR_COUNT = "onDemandLoadCacheClearCount";
    public static final String STAT_NAME_ODL_STOP_COUNT = "onDemandLoadStopCount";
    public static final String STAT_NAME_ODL_STOP_CONFLICT_COUNT = "onDemandLoadStopConflictCount";
    public static final String STAT_NAME_PAUSE_RESUME_CONFLICT_COUNT = "pauseResumeConflictCount";
    public static final String STAT_NAME_RATE_LIMITED_OP_COUNT = "rateLimitedOperationCount";
    public static final String STAT_NAME_PENDING_SERVICE_DELETION_COUNT = "pendingServiceDeletionCount";

    public ServiceHostManagementService() {
        super(ServiceHost.ServiceHostState.class);
        super.toggleOption(Service.ServiceOption.CORE, true);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
    }

    @Override
    public void handleGet(Operation get) {
        this.getHost().updateSystemInfo(false);
        ServiceHost.ServiceHostState s = this.getHost().getState();
        s.documentSelfLink = this.getSelfLink();
        s.documentKind = Utils.buildKind(ServiceHost.ServiceHostState.class);
        s.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        get.setBody(s).complete();
    }

    @Override
    public void handlePatch(Operation patch) {
        try {
            if (!patch.hasBody()) {
                throw new IllegalArgumentException("empty body");
            }
            patch.setStatusCode(304);
            ConfigureOperationTracingRequest tr = patch.getBody(ConfigureOperationTracingRequest.class);
            if (tr.kind.equals(ConfigureOperationTracingRequest.KIND)) {
                this.handleOperationTracingRequest(tr, patch);
                return;
            }
            BackupRequest br = patch.getBody(BackupRequest.class);
            if (br.kind.equals(BackupRequest.KIND)) {
                this.handleBackupRequest(br, patch);
                return;
            }
            RestoreRequest rr = patch.getBody(RestoreRequest.class);
            if (rr.kind.equals(RestoreRequest.KIND)) {
                this.handleRestoreRequest(rr, patch);
                return;
            }
            SynchronizeWithPeersRequest sr = patch.getBody(SynchronizeWithPeersRequest.class);
            if (sr.kind.equals(SynchronizeWithPeersRequest.KIND)) {
                this.handleSynchronizeWithPeersRequest(sr, patch);
                return;
            }
            throw new IllegalArgumentException("unknown request");
        }
        catch (Exception e) {
            patch.fail(e);
            return;
        }
    }

    @Override
    public void handleDelete(Operation delete) {
        this.logInfo("Received shutdown request from %s", delete.getReferer());
        boolean isProcessOwner = this.getHost().isProcessOwner();
        delete.setStatusCode(202);
        delete.complete();
        this.getHost().stop();
        if (isProcessOwner) {
            System.exit(0);
        } else {
            this.logInfo("This host is NOT the process owner. Skipping System.exit()", new Object[0]);
        }
    }

    private void handleSynchronizeWithPeersRequest(SynchronizeWithPeersRequest rr, Operation patch) {
        if (rr.nodeSelectorPath == null) {
            patch.fail(new IllegalArgumentException("nodeSelectorPath is required"));
            return;
        }
        if (this.getHost().getServiceStage(rr.nodeSelectorPath) == null) {
            patch.fail(new IllegalArgumentException(rr.nodeSelectorPath + " is not started on this host"));
            return;
        }
        this.getHost().scheduleNodeGroupChangeMaintenance(rr.nodeSelectorPath);
        patch.complete();
    }

    private void handleOperationTracingRequest(ConfigureOperationTracingRequest req, Operation op) throws Exception {
        URI operationTracingServiceUri = UriUtils.buildUri(this.getHost(), "/core/operation-index");
        Operation.CompletionHandler serviceCompletion = (o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            boolean start = req.enable == OperationTracingEnable.START;
            this.logInfo("%s %s", start ? "Started" : "Stopped", operationTracingServiceUri.toString());
            Level level = start ? Level.ALL : Level.OFF;
            try {
                if (req.level != null) {
                    level = Level.parse(req.level);
                }
            }
            catch (Exception ex) {
                this.logSevere(ex);
            }
            this.getHost().setOperationTracingLevel(level);
            op.complete();
        };
        if (req.enable == OperationTracingEnable.START) {
            OperationIndexService operationService = new OperationIndexService();
            this.getHost().startService(Operation.createPost(operationTracingServiceUri).setCompletion(serviceCompletion), operationService);
        } else {
            this.sendRequest(Operation.createDelete(operationTracingServiceUri).setCompletion(serviceCompletion));
        }
    }

    private void handleBackupRequest(BackupRequest req, Operation op) {
        String scheme;
        if (req.destination != null && ("http".equals(scheme = req.destination.getScheme()) || "https".equals(scheme))) {
            req.backupType = BackupType.STREAM;
        }
        Operation patch = Operation.createPatch(this, req.backupServiceLink).transferRequestHeadersFrom(op).transferRefererFrom(op).setExpiration(op.getExpirationMicrosUtc()).setBody(req).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.transferResponseHeadersFrom(o);
            op.setBodyNoCloning(o.getBodyRaw());
            op.complete();
        });
        this.sendRequest(patch);
    }

    private void handleRestoreRequest(RestoreRequest req, Operation op) {
        Operation patch = Operation.createPatch(this, req.backupServiceLink).transferRequestHeadersFrom(op).transferRefererFrom(op).setExpiration(op.getExpirationMicrosUtc()).setBody(req).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.transferResponseHeadersFrom(o);
            op.setBodyNoCloning(o.getBodyRaw());
            op.complete();
        });
        this.sendRequest(patch);
    }

    public static class RestoreRequest {
        public static final String KIND = Utils.buildKind(RestoreRequest.class);
        public String bearer;
        public URI destination;
        public String kind;
        public Long timeSnapshotBoundaryMicros;
        public String backupServiceLink = "/core/document-index-backup";
    }

    public static class BackupRequest {
        public static final String KIND = Utils.buildKind(BackupRequest.class);
        public String bearer;
        public URI destination;
        public BackupType backupType = BackupType.ZIP;
        public String kind;
        public String backupServiceLink = "/core/document-index-backup";
    }

    public static enum BackupType {
        ZIP,
        DIRECTORY,
        STREAM;

    }

    public static class ConfigureOperationTracingRequest {
        public static final String KIND = Utils.buildKind(ConfigureOperationTracingRequest.class);
        public OperationTracingEnable enable = OperationTracingEnable.START;
        public String level;
        public String kind;
    }

    public static class SynchronizeWithPeersRequest {
        public static final String KIND = Utils.buildKind(SynchronizeWithPeersRequest.class);
        public String nodeSelectorPath;
        public String kind;

        public static SynchronizeWithPeersRequest create(String path) {
            SynchronizeWithPeersRequest r = new SynchronizeWithPeersRequest();
            r.kind = KIND;
            r.nodeSelectorPath = path;
            return r;
        }
    }

    public static enum OperationTracingEnable {
        START,
        STOP;

    }
}

