/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;

final class DocumentStoredFieldVisitor
extends StoredFieldVisitor {
    private Set<String> fieldsToAdd;
    public String documentUpdateAction;
    public String documentSelfLink;
    public String documentIndexingId;
    public long documentVersion;
    public long documentUpdateTimeMicros;
    public Long documentExpirationTimeMicros;
    public byte[] binarySerializedState;
    public String jsonSerializedState;
    private Map<String, String> links;
    private int loadedFields;

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        if ("binarySerializedState".equals(fieldInfo.name)) {
            this.binarySerializedState = value;
        }
        ++this.loadedFields;
    }

    public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
        String stringValue = new String(value, StandardCharsets.UTF_8);
        switch (fieldInfo.name) {
            case "documentSelfLink": {
                this.documentSelfLink = stringValue;
                break;
            }
            case "documentUpdateAction": {
                this.documentUpdateAction = stringValue;
                break;
            }
            case "jsonSerializedState": {
                this.jsonSerializedState = stringValue;
                break;
            }
            case "xenon.indexing.id": {
                this.documentIndexingId = stringValue;
                break;
            }
            default: {
                if (this.links == null) {
                    this.links = new HashMap<String, String>();
                }
                this.links.put(fieldInfo.name, stringValue);
            }
        }
        ++this.loadedFields;
    }

    public void intField(FieldInfo fieldInfo, int value) {
    }

    public void longField(FieldInfo fieldInfo, long value) {
        switch (fieldInfo.name) {
            case "documentUpdateTimeMicros": {
                this.documentUpdateTimeMicros = value;
                break;
            }
            case "documentExpirationTimeMicros": {
                this.documentExpirationTimeMicros = value;
                break;
            }
            case "documentVersion": {
                this.documentVersion = value;
                break;
            }
        }
        ++this.loadedFields;
    }

    public void floatField(FieldInfo fieldInfo, float value) {
    }

    public void doubleField(FieldInfo fieldInfo, double value) {
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (this.loadedFields >= this.fieldsToAdd.size()) {
            return StoredFieldVisitor.Status.STOP;
        }
        return this.fieldsToAdd.contains(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
    }

    public void reset(String field) {
        this.fieldsToAdd = Collections.singleton(field);
        this.loadedFields = 0;
    }

    public void reset(Set<String> fields) {
        this.fieldsToAdd = fields;
        this.loadedFields = 0;
        this.documentUpdateAction = null;
        this.documentUpdateTimeMicros = 0L;
        this.documentExpirationTimeMicros = null;
        this.documentSelfLink = null;
        this.documentIndexingId = null;
        this.documentVersion = 0L;
        this.binarySerializedState = null;
        this.jsonSerializedState = null;
        if (this.links != null) {
            this.links.clear();
        }
    }

    public String getLink(String linkName) {
        if (this.links == null) {
            return null;
        }
        return this.links.get(linkName);
    }
}

