/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.AuthUtils;
import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.QueryFilterUtils;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.AuthorizationCacheClearRequest;
import com.vmware.xenon.services.common.QueryFilter;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ResourceGroupService;
import com.vmware.xenon.services.common.RoleService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.SystemUserService;
import com.vmware.xenon.services.common.UserGroupService;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class AuthorizationContextServiceHelper {
    private AuthorizationContextServiceHelper() {
    }

    public static boolean queueRequest(Operation op, AuthServiceContext context) {
        if (op.getAction() == Service.Action.DELETE && op.getUri().getPath().equals(context.authContextService.getSelfLink())) {
            return false;
        }
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx == null) {
            op.fail(new IllegalArgumentException("no authorization context"));
            return true;
        }
        Claims claims = ctx.getClaims();
        if (claims == null) {
            op.fail(new IllegalArgumentException("no claims"));
            return true;
        }
        String subject = claims.getSubject();
        if (subject == null) {
            op.fail(new IllegalArgumentException("no subject"));
            return true;
        }
        if (op.hasPragmaDirective("xn-clear-auth-cache")) {
            return AuthorizationContextServiceHelper.handleCacheClearRequest(op, subject, context);
        }
        if (subject.equals(SystemUserService.SELF_LINK)) {
            op.complete();
            return true;
        }
        if (ctx.getResourceQueryFilter(op.getAction()) != null) {
            op.complete();
            return true;
        }
        return false;
    }

    private static boolean handleCacheClearRequest(Operation op, String subject, AuthServiceContext context) {
        AuthorizationCacheClearRequest requestBody = op.getBody(AuthorizationCacheClearRequest.class);
        if (!AuthorizationCacheClearRequest.KIND.equals(requestBody.kind)) {
            op.fail(new IllegalArgumentException("invalid request body type"));
            return true;
        }
        if (requestBody.subjectLink == null) {
            op.fail(new IllegalArgumentException("no subjectLink"));
            return true;
        }
        if (!subject.equals(SystemUserService.SELF_LINK)) {
            op.fail(403);
            return true;
        }
        if (context.cacheClearRequestHandler != null) {
            context.cacheClearRequestHandler.accept(requestBody);
        }
        context.authContextService.getHost().clearAuthorizationContext(context.authContextService, requestBody.subjectLink);
        op.complete();
        return true;
    }

    public static void populateAuthContext(Operation op, AuthServiceContext context) {
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx == null) {
            op.fail(new IllegalArgumentException("no authorization context"));
            return;
        }
        Claims claims = ctx.getClaims();
        if (claims == null) {
            op.fail(new IllegalArgumentException("no claims"));
            return;
        }
        URI getSubjectUri = AuthUtils.buildUserUriFromClaims(context.authContextService.getHost(), claims);
        Operation get = Operation.createGet(getSubjectUri).setConnectionSharing(true).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ServiceDocument userState = AuthorizationContextServiceHelper.extractServiceState(o, context.authContextService.getHost());
            if (userState == null) {
                AuthorizationContextServiceHelper.populateAuthorizationContext(op, ctx, claims, null, context);
                return;
            }
            AuthorizationContextServiceHelper.loadUserGroups(op, ctx, claims, userState, context);
        });
        context.authContextService.setAuthorizationContext(get, context.authContextService.getSystemAuthorizationContext());
        context.authContextService.sendRequest(get);
    }

    private static ServiceDocument extractServiceState(Operation getOp, ServiceHost serviceHost) {
        ServiceDocument userState = QueryFilterUtils.getServiceState(getOp, serviceHost);
        if (userState == null) {
            Object rawBody = getOp.getBodyRaw();
            Class<?> serviceTypeClass = null;
            if (rawBody instanceof String) {
                String kind = Utils.getJsonMapValue(rawBody, "documentKind", String.class);
                serviceTypeClass = Utils.getTypeFromKind(kind);
            } else {
                serviceTypeClass = rawBody.getClass();
            }
            if (serviceTypeClass != null) {
                userState = (ServiceDocument)Utils.fromJson(rawBody, serviceTypeClass);
            }
        }
        return userState;
    }

    private static boolean loadUserGroupsFromUserState(Operation op, Operation.AuthorizationContext ctx, Claims claims, ServiceDocument userServiceDocument, AuthServiceContext context) {
        Object fieldValue;
        Field groupLinksField = ReflectionUtils.getFieldIfExists(userServiceDocument.getClass(), "userGroupLinks");
        if (groupLinksField == null) {
            return false;
        }
        try {
            fieldValue = groupLinksField.get(userServiceDocument);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            return false;
        }
        if (!(fieldValue instanceof Collection)) {
            return false;
        }
        Collection<String> userGroupLinks = (Collection<String>)fieldValue;
        if (userGroupLinks.isEmpty()) {
            return false;
        }
        OperationJoin.JoinedCompletionHandler handler = (ops, failures) -> {
            Collection userGroupOps = null;
            if (failures != null && !failures.isEmpty()) {
                userGroupOps = new HashSet(ops.values());
                for (Operation groupOp : ops.values()) {
                    if (groupOp.getStatusCode() == 200) continue;
                    if (groupOp.getStatusCode() == 404) {
                        userGroupOps.remove(groupOp);
                        continue;
                    }
                    op.fail((Throwable)failures.values().iterator().next());
                    return;
                }
            } else {
                userGroupOps = ops.values();
            }
            if (userGroupOps.isEmpty()) {
                AuthorizationContextServiceHelper.populateAuthorizationContext(op, ctx, claims, null, context);
                return;
            }
            try {
                HashSet<UserGroupService.UserGroupState> userGroupStates = new HashSet<UserGroupService.UserGroupState>();
                for (Operation userGroupOp : userGroupOps) {
                    UserGroupService.UserGroupState userGroupState = userGroupOp.getBody(UserGroupService.UserGroupState.class);
                    userGroupStates.add(userGroupState);
                }
                AuthorizationContextServiceHelper.loadRoles(op, ctx, claims, userGroupStates, context);
            }
            catch (Exception e) {
                op.fail(e);
                return;
            }
        };
        Collection<String> filteredUserGroupLinks = null;
        if (context.userGroupsFilter != null) {
            filteredUserGroupLinks = context.userGroupsFilter.apply(op, userGroupLinks);
            if (filteredUserGroupLinks == null || filteredUserGroupLinks.isEmpty()) {
                AuthorizationContextServiceHelper.populateAuthorizationContext(op, ctx, claims, null, context);
                return true;
            }
        } else {
            filteredUserGroupLinks = userGroupLinks;
        }
        HashSet<Operation> gets = new HashSet<Operation>();
        for (String userGroupLink : filteredUserGroupLinks) {
            Operation get = Operation.createGet(AuthUtils.buildAuthProviderHostUri(context.authContextService.getHost(), userGroupLink)).setReferer(context.authContextService.getUri());
            context.authContextService.setAuthorizationContext(get, context.authContextService.getSystemAuthorizationContext());
            gets.add(get);
        }
        OperationJoin join = OperationJoin.create(gets);
        join.setCompletion(handler);
        join.sendWith(context.authContextService.getHost());
        return true;
    }

    private static void loadUserGroups(Operation op, Operation.AuthorizationContext ctx, Claims claims, ServiceDocument userServiceDocument, AuthServiceContext context) {
        if (AuthorizationContextServiceHelper.loadUserGroupsFromUserState(op, ctx, claims, userServiceDocument, context)) {
            return;
        }
        URI getUserGroupsUri = AuthUtils.buildAuthProviderHostUri(context.authContextService.getHost(), ServiceUriPaths.CORE_AUTHZ_USER_GROUPS);
        getUserGroupsUri = UriUtils.buildExpandLinksQueryUri(getUserGroupsUri);
        Operation get = Operation.createGet(getUserGroupsUri).setConnectionSharing(true).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ServiceDocumentQueryResult result = o.getBody(ServiceDocumentQueryResult.class);
            ArrayList<UserGroupService.UserGroupState> userGroupStates = new ArrayList<UserGroupService.UserGroupState>();
            for (Object object : result.documents.values()) {
                UserGroupService.UserGroupState userGroupState = Utils.fromJson(object, UserGroupService.UserGroupState.class);
                try {
                    ServiceDocumentDescription sdd;
                    QueryFilter f = QueryFilter.create(userGroupState.query);
                    if (!QueryFilterUtils.evaluate(f, userServiceDocument, sdd = AuthorizationContextServiceHelper.getServiceDesc(userServiceDocument, context))) continue;
                    userGroupStates.add(userGroupState);
                }
                catch (QueryFilter.QueryFilterException qfe) {
                    op.fail(qfe);
                    return;
                }
            }
            if (userGroupStates.isEmpty()) {
                AuthorizationContextServiceHelper.populateAuthorizationContext(op, ctx, claims, null, context);
                return;
            }
            if (context.userGroupsFilter != null) {
                ArrayList<String> userGroupLinks = new ArrayList<String>();
                for (UserGroupService.UserGroupState groupState : userGroupStates) {
                    userGroupLinks.add(groupState.documentSelfLink);
                }
                Collection<String> collection = context.userGroupsFilter.apply(op, userGroupLinks);
                if (collection == null || collection.isEmpty()) {
                    AuthorizationContextServiceHelper.populateAuthorizationContext(op, ctx, claims, null, context);
                    return;
                }
                ArrayList<UserGroupService.UserGroupState> filteredUserGroupStates = new ArrayList<UserGroupService.UserGroupState>();
                if (collection != null) {
                    for (String filterUserGroupLink : collection) {
                        filteredUserGroupStates.add(Utils.fromJson(result.documents.get(filterUserGroupLink), UserGroupService.UserGroupState.class));
                    }
                }
                userGroupStates = filteredUserGroupStates;
            }
            AuthorizationContextServiceHelper.loadRoles(op, ctx, claims, userGroupStates, context);
        });
        context.authContextService.setAuthorizationContext(get, context.authContextService.getSystemAuthorizationContext());
        context.authContextService.sendRequest(get);
    }

    private static ServiceDocumentDescription getServiceDesc(ServiceDocument userServiceDocument, AuthServiceContext context) {
        String parentLink = UriUtils.getParentPath(userServiceDocument.documentSelfLink);
        if (parentLink == null) {
            return null;
        }
        ServiceDocumentDescription sdd = context.factoryDescriptionMap.computeIfAbsent(parentLink, val -> ServiceDocumentDescription.Builder.create().buildDescription(userServiceDocument.getClass()));
        return sdd;
    }

    private static void loadRoles(Operation op, Operation.AuthorizationContext ctx, Claims claims, Collection<UserGroupService.UserGroupState> userGroupStates, AuthServiceContext context) {
        HashMap<String, UserGroupService.UserGroupState> userGroupStateMap = new HashMap<String, UserGroupService.UserGroupState>();
        for (UserGroupService.UserGroupState userGroupState : userGroupStates) {
            userGroupStateMap.put(userGroupState.documentSelfLink, userGroupState);
        }
        QueryTask.Query kindClause = new QueryTask.Query();
        kindClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        kindClause.setTermPropertyName("documentKind");
        kindClause.setTermMatchType(QueryTask.QueryTerm.MatchType.TERM);
        kindClause.setTermMatchValue(RoleService.RoleState.KIND);
        QueryTask.Query selfLinkClause = new QueryTask.Query();
        selfLinkClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        if (userGroupStates.size() == 1) {
            selfLinkClause.setTermPropertyName("userGroupLink");
            selfLinkClause.setTermMatchType(QueryTask.QueryTerm.MatchType.TERM);
            selfLinkClause.setTermMatchValue(userGroupStates.iterator().next().documentSelfLink);
        } else {
            for (UserGroupService.UserGroupState userGroupState : userGroupStates) {
                QueryTask.Query clause = new QueryTask.Query();
                clause.occurance = QueryTask.Query.Occurance.SHOULD_OCCUR;
                clause.setTermPropertyName("userGroupLink");
                clause.setTermMatchType(QueryTask.QueryTerm.MatchType.TERM);
                clause.setTermMatchValue(userGroupState.documentSelfLink);
                selfLinkClause.addBooleanClause(clause);
            }
        }
        QueryTask.Query query = new QueryTask.Query();
        query.addBooleanClause(kindClause);
        query.addBooleanClause(selfLinkClause);
        QueryTask queryTask = new QueryTask();
        queryTask.querySpec = new QueryTask.QuerySpecification();
        queryTask.querySpec.query = query;
        queryTask.querySpec.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        queryTask.setDirect(true);
        URI postQueryUri = AuthUtils.buildAuthProviderHostUri(context.authContextService.getHost(), ServiceUriPaths.CORE_LOCAL_QUERY_TASKS);
        Operation post = Operation.createPost(postQueryUri).setBody(queryTask).setConnectionSharing(true).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            QueryTask queryTaskResult = o.getBody(QueryTask.class);
            ServiceDocumentQueryResult result = queryTaskResult.results;
            if (result.documents == null || result.documents.isEmpty()) {
                AuthorizationContextServiceHelper.populateAuthorizationContext(op, ctx, claims, null, context);
                return;
            }
            LinkedList<Role> roles = new LinkedList<Role>();
            for (Object doc : result.documents.values()) {
                RoleService.RoleState roleState = Utils.fromJson(doc, RoleService.RoleState.class);
                Role role = new Role();
                role.setRoleState(roleState);
                role.setUserGroupState((UserGroupService.UserGroupState)userGroupStateMap.get(roleState.userGroupLink));
                roles.add(role);
            }
            AuthorizationContextServiceHelper.loadResourceGroups(op, ctx, claims, roles, context);
        });
        context.authContextService.setAuthorizationContext(post, context.authContextService.getSystemAuthorizationContext());
        context.authContextService.sendRequest(post);
    }

    private static void loadResourceGroups(Operation op, Operation.AuthorizationContext ctx, Claims claims, Collection<Role> roles, AuthServiceContext context) {
        HashMap<Object, LinkedList<Role>> rolesByResourceGroup = new HashMap<Object, LinkedList<Role>>();
        for (Role role : roles) {
            String resourceGroupLink = role.roleState.resourceGroupLink;
            LinkedList<Role> byResourceGroup = (LinkedList<Role>)rolesByResourceGroup.get(resourceGroupLink);
            if (byResourceGroup == null) {
                byResourceGroup = new LinkedList<Role>();
                rolesByResourceGroup.put(resourceGroupLink, byResourceGroup);
            }
            byResourceGroup.add(role);
        }
        OperationJoin.JoinedCompletionHandler handler = (ops, failures) -> {
            Collection resourceGroupOps = null;
            if (failures != null && !failures.isEmpty()) {
                resourceGroupOps = new HashSet(ops.values());
                for (Operation getOp : ops.values()) {
                    if (getOp.getStatusCode() == 200) continue;
                    if (getOp.getStatusCode() == 404) {
                        resourceGroupOps.remove(getOp);
                        continue;
                    }
                    op.fail((Throwable)failures.values().iterator().next());
                    return;
                }
            } else {
                resourceGroupOps = ops.values();
            }
            try {
                for (Operation resourceOp : resourceGroupOps) {
                    ResourceGroupService.ResourceGroupState resourceGroupState = resourceOp.getBody(ResourceGroupService.ResourceGroupState.class);
                    Collection rolesForResourceGroup = (Collection)rolesByResourceGroup.get(resourceGroupState.documentSelfLink);
                    if (rolesForResourceGroup == null) continue;
                    for (Role role : rolesForResourceGroup) {
                        role.setResourceGroupState(resourceGroupState);
                    }
                }
                AuthorizationContextServiceHelper.populateAuthorizationContext(op, ctx, claims, roles, context);
            }
            catch (Exception e) {
                op.fail(e);
                return;
            }
        };
        LinkedList<Operation> gets = new LinkedList<Operation>();
        for (String resourceGroupLink : rolesByResourceGroup.keySet()) {
            Operation get = Operation.createGet(AuthUtils.buildAuthProviderHostUri(context.authContextService.getHost(), resourceGroupLink)).setReferer(context.authContextService.getUri());
            context.authContextService.setAuthorizationContext(get, context.authContextService.getSystemAuthorizationContext());
            gets.add(get);
        }
        OperationJoin join = OperationJoin.create(gets);
        join.setCompletion(handler);
        join.sendWith(context.authContextService.getHost());
    }

    private static void populateAuthorizationContext(Operation op, Operation.AuthorizationContext ctx, Claims claims, Collection<Role> roles, AuthServiceContext context) {
        if (roles == null) {
            roles = Collections.emptyList();
        }
        try {
            Operation.AuthorizationContext.Builder builder = Operation.AuthorizationContext.Builder.create();
            builder.setClaims(ctx.getClaims());
            builder.setToken(ctx.getToken());
            if (!roles.isEmpty()) {
                HashMap<Service.Action, LinkedList<Role>> roleListByAction = new HashMap<Service.Action, LinkedList<Role>>(Service.Action.values().length);
                for (Role role : roles) {
                    for (Service.Action action : role.roleState.verbs) {
                        LinkedList<Role> roleList = (LinkedList<Role>)roleListByAction.get((Object)action);
                        if (roleList == null) {
                            roleList = new LinkedList<Role>();
                            roleListByAction.put(action, roleList);
                        }
                        roleList.add(role);
                    }
                }
                HashMap<Service.Action, QueryFilter> queryFilterByAction = new HashMap<Service.Action, QueryFilter>(Service.Action.values().length);
                HashMap<Service.Action, QueryTask.Query> queryByAction = new HashMap<Service.Action, QueryTask.Query>(Service.Action.values().length);
                for (Map.Entry entry : roleListByAction.entrySet()) {
                    QueryTask.Query q = new QueryTask.Query();
                    q.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
                    for (Role role : (Collection)entry.getValue()) {
                        if (role.resourceGroupState == null) continue;
                        QueryTask.Query resourceGroupQuery = role.resourceGroupState.query;
                        resourceGroupQuery.occurance = role.roleState.policy == RoleService.Policy.ALLOW ? QueryTask.Query.Occurance.SHOULD_OCCUR : QueryTask.Query.Occurance.MUST_NOT_OCCUR;
                        q.addBooleanClause(resourceGroupQuery);
                    }
                    if (q.booleanClauses == null) continue;
                    try {
                        queryFilterByAction.put((Service.Action)((Object)entry.getKey()), QueryFilter.create(q));
                        queryByAction.put((Service.Action)((Object)entry.getKey()), q);
                    }
                    catch (QueryFilter.QueryFilterException qfe) {
                        op.fail(qfe);
                        return;
                    }
                }
                builder.setResourceQueryMap(queryByAction);
                builder.setResourceQueryFilterMap(queryFilterByAction);
            }
            Operation.AuthorizationContext newContext = builder.getResult();
            context.authContextService.setAuthorizationContext(op, newContext);
            op.complete();
        }
        catch (Exception e) {
            op.fail(e);
        }
    }

    private static class Role {
        protected RoleService.RoleState roleState;
        protected UserGroupService.UserGroupState userGroupState;
        protected ResourceGroupService.ResourceGroupState resourceGroupState;

        private Role() {
        }

        public void setRoleState(RoleService.RoleState roleState) {
            this.roleState = roleState;
        }

        public void setUserGroupState(UserGroupService.UserGroupState userGroupState) {
            this.userGroupState = userGroupState;
        }

        public void setResourceGroupState(ResourceGroupService.ResourceGroupState resourceGroupState) {
            this.resourceGroupState = resourceGroupState;
        }
    }

    public static class AuthServiceContext {
        public final ConcurrentHashMap<String, ServiceDocumentDescription> factoryDescriptionMap = new ConcurrentHashMap();
        public final Service authContextService;
        public final BiFunction<Operation, Collection<String>, Collection<String>> userGroupsFilter;
        public final Consumer<AuthorizationCacheClearRequest> cacheClearRequestHandler;

        public AuthServiceContext(Service authContextService, BiFunction<Operation, Collection<String>, Collection<String>> userGroupsFilter, Consumer<AuthorizationCacheClearRequest> cacheClearRequestHandler) {
            this.authContextService = authContextService;
            this.userGroupsFilter = userGroupsFilter;
            this.cacheClearRequestHandler = cacheClearRequestHandler;
        }
    }
}

