/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonWriter;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.serialization.ByteArrayToBase64TypeAdapter;
import com.vmware.xenon.common.serialization.HashingJsonWriter;
import com.vmware.xenon.common.serialization.InstantConverter;
import com.vmware.xenon.common.serialization.ObjectMapTypeConverter;
import com.vmware.xenon.common.serialization.RequestRouteConverter;
import com.vmware.xenon.common.serialization.SortedKeysMapViewAdapterFactory;
import com.vmware.xenon.common.serialization.UtcDateTypeAdapter;
import com.vmware.xenon.common.serialization.ZonedDateTimeConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.function.Consumer;

public class JsonMapper {
    public static final String PROPERTY_JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS = "xenon.json.suppressGsonSerializationErrors";
    private static boolean JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS = false;
    private static final int MAX_SERIALIZATION_ATTEMPTS = 100;
    private static final String JSON_INDENT = "  ";
    private final Gson compact;
    private Gson hashing;
    private final Gson compactSensitive;
    private boolean jsonSuppressGsonSerializationErrors = JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS;

    public JsonMapper() {
        this(JsonMapper.createDefaultGson(true, false), JsonMapper.createDefaultGson(true, true));
    }

    public JsonMapper(Consumer<GsonBuilder> gsonConfigCallback) {
        this(JsonMapper.createCustomGson(true, false, gsonConfigCallback), JsonMapper.createCustomGson(true, true, gsonConfigCallback));
        this.hashing = this.createHashingGson(gsonConfigCallback);
    }

    public JsonMapper(Gson compact, Gson compactSensitive) {
        this.compact = compact;
        this.compactSensitive = compactSensitive;
        this.hashing = this.createHashingGson(null);
    }

    private Gson createHashingGson(Consumer<GsonBuilder> gsonConfigCallback) {
        GsonBuilder bldr = new GsonBuilder();
        JsonMapper.registerCommonGsonTypeAdapters(bldr);
        bldr.disableHtmlEscaping();
        bldr.registerTypeAdapterFactory((TypeAdapterFactory)new SortedKeysMapViewAdapterFactory());
        if (gsonConfigCallback != null) {
            gsonConfigCallback.accept(bldr);
        }
        return bldr.create();
    }

    @Deprecated
    public JsonMapper(Gson compact, Gson pretty, Gson compactSensitive, Gson prettySensitive) {
        this(compact, compactSensitive);
    }

    public String toJson(Object body) {
        int i = 1;
        while (true) {
            try {
                return this.compact.toJson(body);
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    public void toJson(Object body, Appendable appendable) {
        int i = 1;
        while (true) {
            try {
                this.compact.toJson(body, appendable);
                return;
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    public JsonElement toJsonElement(Object body) {
        if (body == null) {
            return null;
        }
        int i = 1;
        while (true) {
            try {
                JsonTreeWriter writer = new JsonTreeWriter();
                this.compact.toJson(body, body.getClass(), (JsonWriter)writer);
                return writer.get();
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    public String toJsonHtml(Object body) {
        if (body == null) {
            return this.compact.toJson(null);
        }
        int i = 1;
        while (true) {
            try {
                StringBuilder appendable = new StringBuilder();
                this.toJsonHtml(body, appendable);
                return appendable.toString();
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    public void toJson(boolean hideSensitiveFields, boolean useHtmlFormatting, Object body, Appendable appendable) {
        int i = 1;
        while (true) {
            try {
                if (hideSensitiveFields) {
                    if (useHtmlFormatting) {
                        this.compactSensitive.toJson(body, body.getClass(), this.makePrettyJsonWriter(appendable));
                        return;
                    }
                    this.compactSensitive.toJson(body, appendable);
                    return;
                }
                if (useHtmlFormatting) {
                    this.compact.toJson(body, body.getClass(), this.makePrettyJsonWriter(appendable));
                    return;
                }
                this.compact.toJson(body, appendable);
                return;
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    private void handleIllegalStateException(IllegalStateException e, int i) {
        if (e.getMessage() == null) {
            Utils.logWarning("Failure serializing body because of GSON race (attempt %d)", i);
            if (i >= 100) {
                throw e;
            }
            try {
                Thread.sleep(0L, 1000 * i);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        throw e;
    }

    public <T> T fromJson(Object json, Class<T> clazz) {
        if (clazz.isInstance(json)) {
            return clazz.cast(json);
        }
        return this.fromJson(json, (Type)clazz);
    }

    public <T> T fromJson(Object json, Type type) {
        try {
            if (json instanceof JsonElement) {
                return (T)this.compact.fromJson((JsonElement)json, type);
            }
            return (T)this.compact.fromJson(json.toString(), type);
        }
        catch (RuntimeException e) {
            if (this.jsonSuppressGsonSerializationErrors) {
                throw new JsonSyntaxException("JSON body could not be parsed");
            }
            throw e;
        }
    }

    public void setJsonSuppressGsonSerializationErrors(boolean suppressErrors) {
        this.jsonSuppressGsonSerializationErrors = suppressErrors;
    }

    private static Gson createDefaultGson(boolean isCompact, boolean isSensitive) {
        return JsonMapper.createDefaultGsonBuilder(isCompact, isSensitive).create();
    }

    private static Gson createCustomGson(boolean isCompact, boolean isSensitive, Consumer<GsonBuilder> gsonConfigCallback) {
        GsonBuilder bldr = JsonMapper.createDefaultGsonBuilder(isCompact, isSensitive);
        gsonConfigCallback.accept(bldr);
        return bldr.create();
    }

    public static GsonBuilder createDefaultGsonBuilder(boolean isCompact, boolean isSensitive) {
        GsonBuilder bldr = new GsonBuilder();
        JsonMapper.registerCommonGsonTypeAdapters(bldr);
        if (!isCompact) {
            bldr.setPrettyPrinting();
        }
        bldr.disableHtmlEscaping();
        if (isSensitive) {
            bldr.addSerializationExclusionStrategy((ExclusionStrategy)new SensitiveAnnotationExclusionStrategy());
        }
        return bldr;
    }

    private static void registerCommonGsonTypeAdapters(GsonBuilder bldr) {
        bldr.registerTypeAdapter(ObjectMapTypeConverter.TYPE, (Object)ObjectMapTypeConverter.INSTANCE);
        bldr.registerTypeAdapter(InstantConverter.TYPE, (Object)InstantConverter.INSTANCE);
        bldr.registerTypeAdapter(ZonedDateTimeConverter.TYPE, (Object)ZonedDateTimeConverter.INSTANCE);
        bldr.registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter());
        bldr.registerTypeAdapter(RequestRouteConverter.TYPE, (Object)RequestRouteConverter.INSTANCE);
        bldr.registerTypeHierarchyAdapter(Date.class, (Object)UtcDateTypeAdapter.INSTANCE);
    }

    public void toJsonHtml(Object body, Appendable appendable) {
        if (body == null) {
            this.compact.toJson(null, appendable);
            return;
        }
        int i = 1;
        while (true) {
            try {
                JsonWriter jsonWriter = this.makePrettyJsonWriter(appendable);
                this.compact.toJson(body, body.getClass(), jsonWriter);
                return;
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    private JsonWriter makePrettyJsonWriter(Appendable appendable) {
        JsonWriter jsonWriter = new JsonWriter(Streams.writerForAppendable((Appendable)appendable));
        jsonWriter.setIndent(JSON_INDENT);
        return jsonWriter;
    }

    public long hashJson(Object body, long seed) {
        if (body == null) {
            return seed;
        }
        int i = 1;
        while (true) {
            try {
                HashingJsonWriter w = new HashingJsonWriter(seed);
                this.hashing.toJson(body, body.getClass(), (JsonWriter)w);
                return w.getHash();
            }
            catch (IllegalStateException e) {
                this.handleIllegalStateException(e, i);
                ++i;
                continue;
            }
            break;
        }
    }

    static {
        String v = System.getProperty(PROPERTY_JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS);
        if (v != null) {
            JSON_SUPPRESS_GSON_SERIALIZATION_ERRORS = Boolean.valueOf(v);
        }
    }

    private static class SensitiveAnnotationExclusionStrategy
    implements ExclusionStrategy {
        private SensitiveAnnotationExclusionStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            Collection annotations = fieldAttributes.getAnnotations();
            for (Annotation a : annotations) {
                if (ServiceDocument.UsageOptions.class.equals(a.annotationType())) {
                    ServiceDocument.UsageOptions usageOptions = (ServiceDocument.UsageOptions)a;
                    for (ServiceDocument.UsageOption usageOption : usageOptions.value()) {
                        if (!usageOption.option().equals((Object)ServiceDocumentDescription.PropertyUsageOption.SENSITIVE)) continue;
                        return true;
                    }
                    continue;
                }
                if (ServiceDocument.UsageOption.class.equals(a.annotationType())) {
                    ServiceDocument.UsageOption usageOption = (ServiceDocument.UsageOption)a;
                    if (!usageOption.option().equals((Object)ServiceDocumentDescription.PropertyUsageOption.SENSITIVE)) continue;
                    return true;
                }
                if (!ServiceDocument.PropertyOptions.class.equals(a.annotationType())) continue;
                ServiceDocument.PropertyOptions propertyOptions = (ServiceDocument.PropertyOptions)a;
                for (ServiceDocumentDescription.PropertyUsageOption propertyUsageOption : propertyOptions.usage()) {
                    if (!propertyUsageOption.equals((Object)ServiceDocumentDescription.PropertyUsageOption.SENSITIVE)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }
}

