/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyHttpClientRequestHandler;
import com.vmware.xenon.common.http.netty.NettyHttpListener;
import com.vmware.xenon.common.http.netty.NettyLoggingUtil;
import com.vmware.xenon.common.http.netty.NettyWebSocketRequestHandler;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import java.util.logging.Level;

public class NettyHttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String AGGREGATOR_HANDLER = "aggregator";
    public static final String ALPN_HANDLER = "alpn-handler";
    public static final String HTTP_REQUEST_HANDLER = "http-request-handler";
    public static final String WEBSOCKET_HANDLER = "websocket-request-handler";
    public static final String HTTP1_CODEC = "http1-codec";
    public static final String HTTP2_HANDLER = "http2-handler";
    public static final String HTTP2_UPGRADE_HANDLER = "http2-upgrade-handler";
    public static final String SSL_HANDLER = "ssl";
    private final SslContext sslContext;
    private ServiceHost host;
    private NettyHttpListener listener;
    private int responsePayloadSizeLimit;
    private boolean secureAuthCookie;
    private static final boolean debugLogging = false;

    public NettyHttpServerInitializer(NettyHttpListener listener, ServiceHost host, SslContext sslContext, int responsePayloadSizeLimit, boolean secureAuthCookie) {
        this.sslContext = sslContext;
        this.host = host;
        this.listener = listener;
        this.responsePayloadSizeLimit = responsePayloadSizeLimit;
        this.secureAuthCookie = secureAuthCookie;
        NettyLoggingUtil.setupNettyLogging();
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        ch.config().setAllocator((ByteBufAllocator)NettyChannelContext.ALLOCATOR);
        ch.config().setSendBufferSize(65536);
        ch.config().setReceiveBufferSize(65536);
        SslHandler sslHandler = null;
        if (this.sslContext != null) {
            sslHandler = this.sslContext.newHandler(ch.alloc());
            ServiceHost.ServiceHostState.SslClientAuthMode mode = this.host.getState().sslClientAuthMode;
            if (mode != null) {
                switch (mode) {
                    case NEED: {
                        sslHandler.engine().setNeedClientAuth(true);
                        break;
                    }
                    case WANT: {
                        sslHandler.engine().setWantClientAuth(true);
                        break;
                    }
                }
            }
            p.addLast(SSL_HANDLER, (ChannelHandler)sslHandler);
            if (NettyChannelContext.isALPNEnabled()) {
                p.addLast(ALPN_HANDLER, (ChannelHandler)new Http2NegotiationHandler(this, sslHandler));
                return;
            }
        }
        this.initializeHttpPipeline(p, sslHandler);
    }

    private void initializeHttp2Pipeline(ChannelPipeline pipeline, SslHandler sslHandler) {
        pipeline.addLast(HTTP2_HANDLER, (ChannelHandler)this.makeHttp2ConnectionHandler());
        this.initializeCommon(pipeline, sslHandler);
    }

    private void initializeHttpPipeline(ChannelPipeline p, SslHandler sslHandler) {
        HttpServerCodec http1_codec = new HttpServerCodec(4096, 65536, 65536, false);
        p.addLast(HTTP1_CODEC, (ChannelHandler)http1_codec);
        if (this.sslContext == null) {
            final HttpToHttp2ConnectionHandler connectionHandler = this.makeHttp2ConnectionHandler();
            HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

                public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                    if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                        return new Http2ServerUpgradeCodec((Http2ConnectionHandler)connectionHandler);
                    }
                    return null;
                }
            };
            HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)http1_codec, upgradeCodecFactory);
            p.addLast(HTTP2_UPGRADE_HANDLER, (ChannelHandler)upgradeHandler);
        }
        p.addLast(AGGREGATOR_HANDLER, (ChannelHandler)new HttpObjectAggregator(this.responsePayloadSizeLimit));
        this.initializeCommon(p, sslHandler);
    }

    private void initializeCommon(ChannelPipeline p, SslHandler sslHandler) {
        p.addLast(WEBSOCKET_HANDLER, (ChannelHandler)new NettyWebSocketRequestHandler(this.host, "/core/ws-endpoint", "/ws-service"));
        p.addLast(HTTP_REQUEST_HANDLER, (ChannelHandler)new NettyHttpClientRequestHandler(this.host, this.listener, sslHandler, this.responsePayloadSizeLimit, this.secureAuthCookie));
    }

    private HttpToHttp2ConnectionHandler makeHttp2ConnectionHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        InboundHttp2ToHttpAdapter inboundAdapter = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(this.responsePayloadSizeLimit).propagateSettings(false).build();
        DelegatingDecompressorFrameListener frameListener = new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)inboundAdapter);
        Http2Settings settings = new Http2Settings();
        settings.initialWindowSize(65536);
        HttpToHttp2ConnectionHandlerBuilder builder = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)frameListener).initialSettings(settings).connection((Http2Connection)connection);
        HttpToHttp2ConnectionHandler connectionHandler = builder.build();
        return connectionHandler;
    }

    private static class Http2NegotiationHandler
    extends ApplicationProtocolNegotiationHandler {
        private NettyHttpServerInitializer initializer;
        private SslHandler sslHandler;

        Http2NegotiationHandler(NettyHttpServerInitializer initializer, SslHandler sslHandler) {
            super("http/1.1");
            this.initializer = initializer;
            this.sslHandler = sslHandler;
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
            try {
                if ("h2".equals(protocol)) {
                    this.initializer.initializeHttp2Pipeline(ctx.pipeline(), this.sslHandler);
                    return;
                }
                if ("http/1.1".equals(protocol)) {
                    this.initializer.initializeHttpPipeline(ctx.pipeline(), this.sslHandler);
                    return;
                }
                throw new IllegalStateException("Unexpected protocol: " + protocol);
            }
            catch (Exception ex) {
                this.log(Level.WARNING, "Pipeline initialization failed: %s", Utils.toString(ex));
                ctx.close();
                return;
            }
        }

        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.log(Level.WARNING, "TLS handshake failed: %s", Utils.toString(cause));
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.log(Level.WARNING, "ALPN protocol negotiation failed: %s", Utils.toString(cause));
            ctx.close();
        }

        private void log(Level level, String fmt, Object ... args) {
            Utils.log(Http2NegotiationHandler.class, Http2NegotiationHandler.class.getSimpleName(), level, fmt, args);
        }
    }
}

