/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceRuntimeContext;
import com.vmware.xenon.common.ServiceStatUtils;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.SystemHostInfo;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.UtilityService;
import com.vmware.xenon.common.Utils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

class ServiceResourceTracker {
    private final Map<String, Service> attachedServices;
    private final ConcurrentSkipListSet<String> serviceFactoriesWithPauseResume = new ConcurrentSkipListSet();
    private final ConcurrentMap<String, ServiceDocument> cachedServiceStates = new ConcurrentHashMap<String, ServiceDocument>();
    private final ConcurrentMap<String, Long> persistedServiceLastAccessTimes = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<CachedServiceStateKey, ServiceDocument> cachedTransactionalServiceStates = new ConcurrentHashMap<CachedServiceStateKey, ServiceDocument>();
    private final ServiceHost host;
    private boolean isServiceStateCaching = true;
    private long startTimeMicros;
    private ThreadMXBean threadBean;
    private Service mgmtService;

    public static ServiceResourceTracker create(ServiceHost host, Map<String, Service> services, Map<String, Service> pendingPauseServices) {
        ServiceResourceTracker srt = new ServiceResourceTracker(host, services, pendingPauseServices);
        return srt;
    }

    public ServiceResourceTracker(ServiceHost host, Map<String, Service> services, Map<String, Service> pendingPauseServices) {
        this.attachedServices = services;
        this.host = host;
    }

    private void checkAndInitializeStats() {
        if (this.startTimeMicros > 0L) {
            return;
        }
        this.startTimeMicros = Utils.getNowMicrosUtc();
        if (this.host.getManagementService() == null) {
            this.host.log(Level.WARNING, "Management service not found, stats will not be available", new Object[0]);
            return;
        }
        long inUseMem = this.host.getState().systemInfo.totalMemoryByteCount - this.host.getState().systemInfo.freeMemoryByteCount;
        long freeMem = this.host.getState().systemInfo.maxMemoryByteCount - inUseMem;
        long freeDisk = this.host.getState().systemInfo.freeDiskByteCount;
        this.createTimeSeriesStat("availableMemoryBytes", freeMem);
        this.createTimeSeriesStat("availableDiskByte", freeDisk);
        this.createTimeSeriesStat("cpuUsagePercent", 0.0);
        this.createTimeSeriesStat("http11ConnectionCount", 0.0);
        this.createTimeSeriesStat("http2ConnectionCount", 0.0);
        this.getManagementService().setStat("threadCount", (double)Utils.DEFAULT_THREAD_COUNT);
    }

    void createTimeSeriesStat(String name, double v) {
        Service service = this.getManagementService();
        EnumSet<ServiceStats.TimeSeriesStats.AggregationType> types = EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.AVG);
        ServiceStats.ServiceStat dayStat = ServiceStatUtils.getOrCreateDailyTimeSeriesStat(service, name, types);
        ServiceStats.ServiceStat hourStat = ServiceStatUtils.getOrCreateHourlyTimeSeriesHistogramStat(service, name, types);
        service.setStat(dayStat, v);
        service.setStat(hourStat, v);
    }

    private void updateStats(long now) {
        ServiceClient.ConnectionPoolMetrics http2TagInfo;
        long[] threadIds;
        this.host.updateMemoryAndDiskInfo();
        ServiceHost.ServiceHostState hostState = this.host.getStateNoCloning();
        SystemHostInfo shi = hostState.systemInfo;
        Service mgmtService = this.getManagementService();
        if (mgmtService == null) {
            return;
        }
        this.checkAndInitializeStats();
        mgmtService.setStat("serviceCount", (double)hostState.serviceCount);
        long freeMemory = shi.maxMemoryByteCount - (shi.totalMemoryByteCount - shi.freeMemoryByteCount);
        mgmtService.setStat("availableMemoryBytesPerHour", (double)freeMemory);
        mgmtService.setStat("availableMemoryBytesPerDay", (double)freeMemory);
        mgmtService.setStat("availableDiskBytePerHour", (double)shi.freeDiskByteCount);
        mgmtService.setStat("availableDiskBytePerDay", (double)shi.freeDiskByteCount);
        if (this.threadBean == null) {
            this.threadBean = ManagementFactory.getThreadMXBean();
        }
        if (!this.threadBean.isCurrentThreadCpuTimeSupported()) {
            return;
        }
        long totalTime = 0L;
        for (long threadId : threadIds = this.threadBean.getAllThreadIds()) {
            totalTime += this.threadBean.getThreadCpuTime(threadId);
        }
        double runningTime = now - this.startTimeMicros;
        if (runningTime <= 0.0) {
            return;
        }
        this.createTimeSeriesStat("jvmThreadCount", threadIds.length);
        totalTime = TimeUnit.NANOSECONDS.toMicros(totalTime);
        double pctUse = (double)totalTime / runningTime;
        mgmtService.setStat("cpuUsagePercentPerHour", pctUse);
        mgmtService.setStat("cpuUsagePercentPerDay", pctUse);
        ServiceClient.ConnectionPoolMetrics http11TagInfo = this.host.getClient().getConnectionPoolMetrics("xn-cnx-tag-default");
        if (http11TagInfo != null) {
            mgmtService.setStat("http11PendingOperationCount", (double)http11TagInfo.pendingRequestCount);
            mgmtService.setStat("http11ConnectionCountPerHour", (double)http11TagInfo.inUseConnectionCount);
            mgmtService.setStat("http11ConnectionCountPerDay", (double)http11TagInfo.inUseConnectionCount);
        }
        if ((http2TagInfo = this.host.getClient().getConnectionPoolMetrics("xn-cnx-tag-http2-default")) != null) {
            mgmtService.setStat("http2PendingOperationCount", (double)http2TagInfo.pendingRequestCount);
            mgmtService.setStat("http2ConnectionCountPerHour", (double)http2TagInfo.inUseConnectionCount);
            mgmtService.setStat("http2ConnectionCountPerDay", (double)http2TagInfo.inUseConnectionCount);
        }
    }

    private Service getManagementService() {
        if (this.mgmtService == null) {
            this.mgmtService = this.host.getManagementService();
        }
        return this.mgmtService;
    }

    public void setServiceStateCaching(boolean enable) {
        this.isServiceStateCaching = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCachedServiceState(Service s, ServiceDocument st, Operation op) {
        if (ServiceHost.isServiceIndexed(s) && !this.isTransactional(op)) {
            this.persistedServiceLastAccessTimes.put(s.getSelfLink(), Utils.getNowMicrosUtc());
        }
        if (ServiceHost.isServiceIndexed(s) && !this.isServiceStateCaching) {
            return;
        }
        if (!this.isTransactional(op)) {
            String string = s.getSelfLink();
            synchronized (string) {
                ServiceDocument cachedState = this.cachedServiceStates.put(s.getSelfLink(), st);
                if (cachedState != null && cachedState.documentVersion > st.documentVersion) {
                    this.cachedServiceStates.put(s.getSelfLink(), cachedState);
                }
            }
            return;
        }
        CachedServiceStateKey key = new CachedServiceStateKey(s.getSelfLink(), op.getTransactionId());
        String string = key.toString();
        synchronized (string) {
            ServiceDocument cachedState = this.cachedTransactionalServiceStates.put(key, st);
            if (cachedState != null && cachedState.documentVersion > st.documentVersion) {
                this.cachedTransactionalServiceStates.put(key, cachedState);
            }
        }
    }

    public ServiceDocument getCachedServiceState(Service s, Operation op) {
        String servicePath = s.getSelfLink();
        ServiceDocument state = null;
        if (this.isTransactional(op)) {
            CachedServiceStateKey key = new CachedServiceStateKey(servicePath, op.getTransactionId());
            state = (ServiceDocument)this.cachedTransactionalServiceStates.get(key);
        } else if (ServiceHost.isServiceIndexed(s)) {
            this.persistedServiceLastAccessTimes.put(servicePath, this.host.getStateNoCloning().lastMaintenanceTimeUtcMicros);
        }
        if (state == null) {
            state = (ServiceDocument)this.cachedServiceStates.get(servicePath);
        }
        if (state == null) {
            return null;
        }
        if (state.documentExpirationTimeMicros > 0L && state.documentExpirationTimeMicros < state.documentUpdateTimeMicros) {
            this.stopService(s, true, op);
            return null;
        }
        return state;
    }

    private void stopService(Service s, boolean isExpired, Operation op) {
        if (s == null) {
            return;
        }
        if (isExpired && s.hasOption(Service.ServiceOption.PERSISTENCE)) {
            return;
        }
        Operation deleteExp = Operation.createDelete(this.host, s.getSelfLink()).disableFailureLogging(true).addPragmaDirective("xn-no-index-update").addPragmaDirective("xn-no-fwd").setReferer(this.host.getUri());
        this.host.sendRequest(deleteExp);
    }

    public void clearCachedServiceState(Service s, String servicePath, Operation op) {
        this.clearCachedServiceState(s, servicePath, op, false);
    }

    private void clearCachedServiceState(Service s, String servicePath, Operation op, boolean keepLastAccessTime) {
        if (s != null && servicePath == null) {
            servicePath = s.getSelfLink();
        }
        if (!this.isTransactional(op)) {
            if (!keepLastAccessTime) {
                this.persistedServiceLastAccessTimes.remove(servicePath);
            }
            ServiceDocument doc = (ServiceDocument)this.cachedServiceStates.remove(servicePath);
            if (s == null) {
                s = this.host.findService(servicePath, true);
            }
            if (s == null) {
                return;
            }
            if (doc != null) {
                this.updateCacheClearStats(s);
            }
            return;
        }
        this.clearTransactionalCachedServiceState(servicePath, op.getTransactionId());
    }

    public void clearTransactionalCachedServiceState(String servicePath, String transactionId) {
        CachedServiceStateKey key = new CachedServiceStateKey(servicePath, transactionId);
        ServiceDocument doc = (ServiceDocument)this.cachedTransactionalServiceStates.remove(key);
        Service s = this.host.findService(servicePath, true);
        if (s == null) {
            return;
        }
        if (doc != null) {
            this.updateCacheClearStats(s);
        }
    }

    private void updateCacheClearStats(Service s) {
        s.adjustStat("stateCacheClearCount", 1.0);
        this.host.getManagementService().adjustStat("serviceCacheClearCount", 1.0);
        if (s.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            this.host.getManagementService().adjustStat("onDemandLoadCacheClearCount", 1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMaintenance(long now, long deadlineMicros) {
        this.updateStats(now);
        ServiceHost.ServiceHostState hostState = this.host.getStateNoCloning();
        int pauseServiceCount = 0;
        long memoryLimitHighMB = this.host.getServiceMemoryLimitMB("", ServiceHost.ServiceHostState.MemoryLimitType.HIGH_WATERMARK);
        long memoryInUseMB = hostState.serviceCount * 4096L;
        boolean shouldPause = memoryLimitHighMB <= (memoryInUseMB /= 0x100000L);
        for (Service service : this.attachedServices.values()) {
            String factoryPath;
            boolean cacheCleared;
            if (service.hasOption(Service.ServiceOption.FACTORY)) continue;
            ServiceDocument s = (ServiceDocument)this.cachedServiceStates.get(service.getSelfLink());
            Long lastAccessTime = (Long)this.persistedServiceLastAccessTimes.get(service.getSelfLink());
            boolean bl = cacheCleared = s == null;
            if (s != null) {
                if (!ServiceHost.isServiceIndexed(service)) {
                    if (s.documentExpirationTimeMicros <= 0L || s.documentExpirationTimeMicros >= now) continue;
                    this.stopService(service, true, null);
                    continue;
                }
                if (service.hasOption(Service.ServiceOption.TRANSACTION_PENDING)) continue;
                if (lastAccessTime == null) {
                    lastAccessTime = s.documentUpdateTimeMicros;
                }
                long cacheClearDelayMicros = hostState.serviceCacheClearDelayMicros;
                if (ServiceHost.isServiceImmutable(service)) {
                    cacheClearDelayMicros = 0L;
                }
                if (cacheClearDelayMicros + lastAccessTime < now) {
                    this.clearCachedServiceState(service, null, null, true);
                    cacheCleared = true;
                }
            }
            if (lastAccessTime == null && ServiceHost.isServiceIndexed(service) && service.hasOption(Service.ServiceOption.DOCUMENT_OWNER) || lastAccessTime != null && hostState.lastMaintenanceTimeUtcMicros - lastAccessTime < service.getMaintenanceIntervalMicros() * 2L || service.hasOption(Service.ServiceOption.PERIODIC_MAINTENANCE) || !service.hasOption(Service.ServiceOption.FACTORY_ITEM) || !service.hasOption(Service.ServiceOption.ON_DEMAND_LOAD) || this.host.isServiceStarting(service, service.getSelfLink())) continue;
            if (this.host.hasPendingServiceAvailableCompletions(service.getSelfLink())) {
                this.host.log(Level.INFO, "Pending available completions, skipping pause/stop on %s", service.getSelfLink());
                continue;
            }
            boolean hasSoftState = this.hasServiceSoftState(service);
            if (cacheCleared && !hasSoftState) {
                this.stopService(service, false, null);
                continue;
            }
            if (!shouldPause && !cacheCleared) continue;
            if (!cacheCleared) {
                this.clearCachedServiceState(service, null, null);
                if (!hasSoftState) {
                    this.stopService(service, false, null);
                    continue;
                }
            }
            if ((factoryPath = UriUtils.getParentPath(service.getSelfLink())) != null) {
                this.serviceFactoriesWithPauseResume.add(factoryPath);
            }
            ++pauseServiceCount;
            this.pauseService(service);
            if (deadlineMicros >= Utils.getSystemNowMicrosUtc()) continue;
            break;
        }
        if (hostState.serviceCount < 0L) {
            ServiceHost.ServiceHostState serviceHostState = hostState;
            synchronized (serviceHostState) {
                hostState.serviceCount = this.attachedServices.size();
            }
        }
        if (pauseServiceCount == 0) {
            return;
        }
        this.host.log(Level.FINE, "Attempt pause on %d services, attached: %d, cached: %d, persistedServiceLastAccessTimes: %d", pauseServiceCount, hostState.serviceCount, this.cachedServiceStates.size(), this.persistedServiceLastAccessTimes.size());
    }

    private void pauseService(Service s) {
        if (this.host.isStopping()) {
            return;
        }
        ServiceHost.ServiceHostState hostState = this.host.getStateNoCloning();
        if (s.getProcessingStage() != Service.ProcessingStage.AVAILABLE) {
            return;
        }
        String path = s.getSelfLink();
        Operation.CompletionHandler indexCompletion = (o, e) -> {
            if (e != null) {
                this.resumeService(path, s);
                this.abortPause(s, path, e);
                return;
            }
            ServiceHost.ServiceHostState serviceHostState = hostState;
            synchronized (serviceHostState) {
                if (null != this.attachedServices.remove(path)) {
                    --hostState.serviceCount;
                }
            }
            this.persistedServiceLastAccessTimes.remove(path);
            this.host.getManagementService().adjustStat("servicePauseCount", 1.0);
        };
        try {
            ServiceRuntimeContext src = s.setProcessingStage(Service.ProcessingStage.PAUSED);
            Operation indexPut = Operation.createPut(this.host, "/core/service-context-index").setReferer(this.host.getUri()).setBodyNoCloning(src).setCompletion(indexCompletion);
            this.host.sendRequest(indexPut);
        }
        catch (Exception e2) {
            this.abortPause(s, path, e2);
        }
    }

    void abortPause(Service s, String path, Throwable e) {
        Operation op;
        if (this.host.isStopping()) {
            return;
        }
        if (e != null && !(e instanceof CancellationException)) {
            this.host.log(Level.WARNING, "Failure pausing service %s: %s", path, e.toString());
        }
        if ((op = s.dequeueRequest()) != null) {
            this.host.handleRequest(null, op);
        }
        this.host.processPendingServiceAvailableOperations(s, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean checkAndResumeService(Operation inboundOp) {
        String key = inboundOp.getUri().getPath();
        if (ServiceHost.isHelperServicePath(key)) {
            key = UriUtils.getParentPath(key);
        }
        String factoryPath = UriUtils.getParentPath(key);
        StatelessService factoryService = null;
        if (factoryPath != null) {
            Service parentService = this.host.findService(factoryPath);
            if (!(parentService instanceof FactoryService)) {
                Operation.failServiceNotFound(inboundOp, -2147483642, "URI path appears invalid, parent is not a factory service");
                return true;
            }
            factoryService = (FactoryService)parentService;
        }
        if (factoryService != null) {
            if (!this.serviceFactoriesWithPauseResume.contains(factoryPath)) {
                if (!factoryService.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) return false;
                inboundOp.addPragmaDirective("xn-check-index");
            } else if (this.host.getServiceStage(key) == Service.ProcessingStage.PAUSED) {
                this.host.log(Level.WARNING, "ODL service %s is paused, attempting resume", key);
                inboundOp.removePragmaDirective("xn-check-index");
            }
        }
        String path = key;
        if (factoryService == null) {
            Operation.failServiceNotFound(inboundOp);
            return true;
        }
        if (this.host.isStopping() && inboundOp.hasPragmaDirective("xn-no-index-update") && inboundOp.getAction() == Service.Action.DELETE) {
            inboundOp.complete();
            return true;
        }
        if (inboundOp.hasPragmaDirective("xn-check-index")) {
            if (inboundOp.getExpirationMicrosUtc() < Utils.getSystemNowMicrosUtc()) {
                this.host.log(Level.WARNING, "Request to %s has expired", path);
                return false;
            }
            if (this.host.isStopping()) {
                return false;
            }
            this.host.log(Level.FINE, "(%d) ODL check for %s", inboundOp.getId(), path);
            return this.checkAndOnDemandStartService(inboundOp, factoryService);
        }
        inboundOp.addPragmaDirective("xn-check-index");
        OperationContext inputContext = OperationContext.getOperationContext();
        Operation resumePut = Operation.createPut(this.host, "/core/service-context-index");
        resumePut.setBodyNoCloning(ServiceRuntimeContext.create(key));
        resumePut.setCompletion((o, e) -> {
            OperationContext.setFrom(inputContext);
            if (e != null) {
                this.host.log(Level.WARNING, "Failure checking if service paused: " + Utils.toString(e), new Object[0]);
                this.host.handleRequest(null, inboundOp);
                return;
            }
            if (!o.hasBody()) {
                this.host.handleRequest(null, inboundOp);
                return;
            }
            this.host.handleRequest(null, inboundOp);
        });
        resumePut.setAuthorizationContext(this.host.getSystemAuthorizationContext());
        this.host.sendRequest(resumePut.setReferer(this.host.getUri()));
        return true;
    }

    boolean checkAndOnDemandStartService(Operation inboundOp, Service parentService) {
        if (!parentService.hasOption(Service.ServiceOption.FACTORY)) {
            Operation.failServiceNotFound(inboundOp);
            return true;
        }
        if (!parentService.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            return false;
        }
        FactoryService factoryService = (FactoryService)parentService;
        String servicePath = inboundOp.getUri().getPath();
        if (ServiceHost.isHelperServicePath(servicePath)) {
            servicePath = UriUtils.getParentPath(servicePath);
        }
        String finalServicePath = servicePath;
        boolean doProbe = inboundOp.hasPragmaDirective("xn-queue");
        if (!factoryService.hasOption(Service.ServiceOption.REPLICATION) && inboundOp.getAction() == Service.Action.DELETE) {
            doProbe = true;
        }
        if (!doProbe) {
            this.startServiceOnDemand(inboundOp, parentService, factoryService, finalServicePath);
            return true;
        }
        Operation getOp = Operation.createGet(inboundOp.getUri()).addPragmaDirective("xn-check-index").transferRefererFrom(inboundOp).setCompletion((o, e) -> {
            if (e != null) {
                inboundOp.fail(e);
                return;
            }
            if (!o.hasBody()) {
                this.host.checkPragmaAndRegisterForAvailability(finalServicePath, inboundOp);
                return;
            }
            this.startServiceOnDemand(inboundOp, parentService, factoryService, finalServicePath);
        });
        Service indexService = this.host.getDocumentIndexService();
        if (indexService == null) {
            inboundOp.fail(new CancellationException());
            return true;
        }
        indexService.handleRequest(getOp);
        return true;
    }

    void startServiceOnDemand(Operation inboundOp, Service parentService, FactoryService factoryService, String finalServicePath) {
        Service childService;
        Operation onDemandPost = Operation.createPost(this.host, finalServicePath);
        Operation.CompletionHandler c = (o, e) -> {
            if (e != null) {
                if (e instanceof CancellationException) {
                    this.host.log(Level.WARNING, "Stop of idle service %s detected, retrying", inboundOp.getUri().getPath());
                    this.host.scheduleCore(() -> this.checkAndOnDemandStartService(inboundOp, parentService), 1L, TimeUnit.SECONDS);
                    return;
                }
                Service.Action a = inboundOp.getAction();
                ServiceErrorResponse response = o.getErrorResponseBody();
                if (response != null) {
                    if (response.statusCode == 409) {
                        if (!ServiceHost.isServiceCreate(inboundOp) && response.errorCode == -2147483645) {
                            this.host.handleRequest(null, inboundOp);
                            return;
                        }
                        if (response.errorCode == -2147483646) {
                            if (a == Service.Action.DELETE) {
                                inboundOp.complete();
                            } else if (a == Service.Action.POST) {
                                this.host.failRequestServiceAlreadyStarted(finalServicePath, null, inboundOp);
                            } else {
                                Operation.failServiceNotFound(inboundOp, -2147483646);
                            }
                            return;
                        }
                    }
                    if (inboundOp.getAction() == Service.Action.DELETE && response.statusCode == 404) {
                        inboundOp.complete();
                        return;
                    }
                    if (response.statusCode == 404) {
                        this.host.log(Level.WARNING, "Failed to start service %s with 404 status code.", finalServicePath);
                        this.host.checkPragmaAndRegisterForAvailability(finalServicePath, inboundOp);
                        return;
                    }
                }
                this.host.log(Level.SEVERE, "Failed to start service %s with statusCode %d", finalServicePath, o.getStatusCode());
                inboundOp.setBodyNoCloning(o.getBodyRaw()).setStatusCode(o.getStatusCode());
                inboundOp.fail(e);
                return;
            }
            this.host.handleRequest(null, inboundOp);
        };
        onDemandPost.addPragmaDirective("xn-check-index").addPragmaDirective("xn-check-version").transferRefererFrom(inboundOp).setExpiration(inboundOp.getExpirationMicrosUtc()).setReplicationDisabled(true).setCompletion(c);
        try {
            childService = factoryService.createServiceInstance();
            childService.toggleOption(Service.ServiceOption.FACTORY_ITEM, true);
        }
        catch (Throwable e1) {
            inboundOp.fail(e1);
            return;
        }
        if (inboundOp.getAction() == Service.Action.DELETE) {
            onDemandPost.disableFailureLogging(true);
            inboundOp.disableFailureLogging(true);
        }
        this.host.startService(onDemandPost, childService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeService(String path, Service resumedService) {
        ServiceHost.ServiceHostState hostState;
        if (this.host.isStopping()) {
            return;
        }
        resumedService.setHost(this.host);
        ServiceHost.ServiceHostState serviceHostState = hostState = this.host.getStateNoCloning();
        synchronized (serviceHostState) {
            if (!this.attachedServices.containsKey(path)) {
                this.attachedServices.put(path, resumedService);
                ++hostState.serviceCount;
            }
        }
        resumedService.setProcessingStage(Service.ProcessingStage.AVAILABLE);
        if (ServiceHost.isServiceIndexed(resumedService)) {
            this.persistedServiceLastAccessTimes.put(resumedService.getSelfLink(), Utils.getNowMicrosUtc());
        }
        this.host.getManagementService().adjustStat("serviceResumeCount", 1.0);
    }

    void retryPauseOrOnDemandLoadConflict(Operation op, boolean isOdlConflict) {
        op.removePragmaDirective("xn-check-index");
        String statName = isOdlConflict ? "onDemandLoadStopConflictCount" : "pauseResumeConflictCount";
        this.host.getManagementService().adjustStat(statName, 1.0);
        this.host.log(Level.WARNING, "Pause(%s)/ODL(%s) conflict: retrying %s (%d %s) on %s", new Object[]{!isOdlConflict, isOdlConflict, op.getAction(), op.getId(), op.getContextId(), op.getUri().getPath()});
        long interval = Math.max(TimeUnit.SECONDS.toMicros(1L), this.host.getMaintenanceIntervalMicros());
        this.host.scheduleCore(() -> this.host.handleRequest(null, op), interval, TimeUnit.MICROSECONDS);
    }

    public void close() {
        this.cachedServiceStates.clear();
        this.persistedServiceLastAccessTimes.clear();
    }

    private boolean isTransactional(Operation op) {
        return op != null && op.getTransactionId() != null && this.host.getTransactionServiceUri() != null;
    }

    private boolean hasServiceSoftState(Service service) {
        if (!service.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            return false;
        }
        UtilityService subUtilityService = (UtilityService)service.getUtilityService("/subscriptions");
        UtilityService statsUtilityService = (UtilityService)service.getUtilityService("/stats");
        boolean hasSoftState = false;
        if (subUtilityService != null && subUtilityService.hasSubscribers()) {
            hasSoftState = true;
        }
        if (statsUtilityService != null && statsUtilityService.hasStats()) {
            hasSoftState = true;
        }
        return hasSoftState;
    }

    private static final class CachedServiceStateKey {
        private String servicePath;
        private String transactionId;

        CachedServiceStateKey(String servicePath, String transactionId) {
            this.servicePath = servicePath;
            this.transactionId = transactionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedServiceStateKey that = (CachedServiceStateKey)o;
            if (this.servicePath != null ? !this.servicePath.equals(that.servicePath) : that.servicePath != null) {
                return false;
            }
            return this.transactionId != null ? this.transactionId.equals(that.transactionId) : that.transactionId == null;
        }

        public int hashCode() {
            int result = this.servicePath != null ? this.servicePath.hashCode() : 0;
            result = 31 * result + (this.transactionId != null ? this.transactionId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return String.format("CachedServiceStateKey{servicePath: %s, transactionId: %s}", this.servicePath, this.transactionId);
        }
    }
}

