/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListMap;

public class RoundRobinOperationQueue {
    public static final int INITIAL_CAPACITY = 256;
    private final NavigableMap<String, Queue<Operation>> queues = new ConcurrentSkipListMap<String, Queue<Operation>>();
    private String activeKey = "";

    public static RoundRobinOperationQueue create() {
        return new RoundRobinOperationQueue();
    }

    private RoundRobinOperationQueue() {
    }

    public synchronized boolean offer(String key, Operation op) {
        if (key == null || op == null) {
            throw new IllegalArgumentException("key and operation are required");
        }
        Queue q = this.queues.computeIfAbsent(key, k -> new ArrayDeque(256));
        if (!q.offer(op)) {
            op.setStatusCode(503);
            op.fail(new CancellationException("queue limit exceeded"));
            return false;
        }
        return true;
    }

    public synchronized Operation poll() {
        while (!this.queues.isEmpty()) {
            Map.Entry<String, Queue<Operation>> nextActive = this.queues.higherEntry(this.activeKey);
            if (nextActive == null) {
                nextActive = this.queues.firstEntry();
            }
            this.activeKey = nextActive.getKey();
            Operation op = nextActive.getValue().poll();
            if (op != null) {
                return op;
            }
            this.queues.remove(nextActive.getKey());
        }
        return null;
    }

    public boolean isEmpty() {
        return this.queues.isEmpty();
    }
}

