/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeGroupUtils;
import java.util.EnumSet;

public class NodeSelectorState
extends ServiceDocument {
    public static final EnumSet<Status> UNAVAILABLE = EnumSet.of(Status.UNAVAILABLE);
    public static final EnumSet<Status> PAUSED = EnumSet.of(Status.PAUSED, Status.AVAILABLE);
    public static final EnumSet<Status> AVAILABLE = EnumSet.of(Status.AVAILABLE);
    public static final EnumSet<Status> PAUSED_UNAVAILABLE = EnumSet.of(Status.PAUSED, Status.UNAVAILABLE);
    public String nodeGroupLink;
    public Long replicationFactor;
    public int membershipQuorum;
    public long membershipUpdateTimeMicros;
    public Status status;

    public static Status calculateStatus(ServiceHost host, NodeGroupService.NodeGroupState groupState) {
        boolean isAvailable = NodeGroupUtils.isNodeGroupAvailable(host, groupState);
        return isAvailable ? Status.AVAILABLE : Status.UNAVAILABLE;
    }

    public static void updateStatus(ServiceHost host, NodeGroupService.NodeGroupState groupState, NodeSelectorState ns) {
        ns.status = NodeSelectorState.calculateStatus(host, groupState);
    }

    public static boolean isAvailable(NodeSelectorState ns) {
        return AVAILABLE.contains((Object)ns.status);
    }

    public static boolean isAvailable(ServiceHost host, NodeGroupService.NodeGroupState groupState) {
        return AVAILABLE.contains((Object)NodeSelectorState.calculateStatus(host, groupState));
    }

    public static enum Status {
        UNAVAILABLE,
        PAUSED,
        AVAILABLE;

    }
}

