/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceRuntimeContext;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.serialization.KryoSerializers;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

public class ServiceContextIndexService
extends StatefulService {
    private static final String SERIALIZED_CONTEXT_FILE_EXTENSION = ".kryo";
    public static final String STAT_NAME_FILE_DELETE_COUNT = "fileDeleteCount";
    public static final String SELF_LINK = "/core/service-context-index";
    public static final String FILE_PATH = "service-context-index";
    private File indexDirectory;

    public ServiceContextIndexService() {
        super(ServiceDocument.class);
        super.setOperationQueueLimit(100000);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        super.toggleOption(Service.ServiceOption.CONCURRENT_GET_HANDLING, false);
    }

    @Override
    public void handleStart(Operation post) {
        this.indexDirectory = new File(new File(this.getHost().getStorageSandbox()), FILE_PATH);
        if (!this.createIndexDirectory(post)) {
            return;
        }
        post.complete();
    }

    private boolean createIndexDirectory(Operation post) {
        if (this.indexDirectory.exists()) {
            return true;
        }
        if (this.indexDirectory.mkdir()) {
            return true;
        }
        this.logWarning("Failure creating index directory %s, failing start", this.indexDirectory);
        post.fail(new IOException("could not create " + this.indexDirectory));
        return false;
    }

    @Override
    public void handlePut(Operation put) {
        ServiceRuntimeContext s = (ServiceRuntimeContext)put.getBodyRaw();
        if (s.serializedService != null) {
            this.handleSerializePut(put, s);
        } else {
            this.handleDeserializePut(put, s.selfLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSerializePut(Operation put, ServiceRuntimeContext s) {
        ByteBuffer bb = KryoSerializers.serializeObject(s, 65536);
        File serviceContextFile = this.getFileFromLink(s.selfLink);
        OutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(serviceContextFile));
            output.write(bb.array(), bb.position(), bb.limit());
        }
        catch (Exception e) {
            put.fail(e);
            return;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        put.setBody(null).complete();
    }

    private void handleDeserializePut(Operation put, String link) {
        File serviceContextFile = this.getFileFromLink(link);
        try {
            Path path = serviceContextFile.toPath();
            byte[] data = Files.readAllBytes(path);
            if (data == null || data.length == 0) {
                put.setBody(null).complete();
                return;
            }
            Files.deleteIfExists(path);
            this.adjustStat(STAT_NAME_FILE_DELETE_COUNT, 1.0);
            ServiceRuntimeContext src = (ServiceRuntimeContext)KryoSerializers.deserializeObject(data, 0, data.length);
            Service resumedService = (Service)KryoSerializers.deserializeObject(src.serializedService);
            this.getHost().resumeService(link, resumedService);
            put.setBodyNoCloning(src).complete();
        }
        catch (Exception ex) {
            if (ex instanceof NoSuchFileException) {
                put.setBody(null).complete();
                return;
            }
            put.fail(ex);
        }
    }

    private File getFileFromLink(String link) {
        String name = UriUtils.convertPathCharsFromLink(link) + SERIALIZED_CONTEXT_FILE_EXTENSION;
        return new File(this.indexDirectory, name);
    }
}

