/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.ODataQueryVisitor;
import com.vmware.xenon.common.ODataToken;
import com.vmware.xenon.common.ODataTokenList;
import com.vmware.xenon.common.ODataTokenizer;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;

public class RootNamespaceService
extends StatelessService {
    public static final String SELF_LINK = "/";

    @Override
    public void handleGet(Operation get) {
        String filter;
        EnumSet<Service.ServiceOption> includeOptions = EnumSet.of(Service.ServiceOption.FACTORY);
        EnumSet excludeOptions = null;
        boolean matchAllOptions = false;
        URI uri = get.getUri();
        if (uri.getQuery() != null) {
            String matchQueryParam;
            String[] excludes;
            Map<String, String> queryParams = UriUtils.parseUriQueryParams(uri);
            String[] includes = RootNamespaceService.getValueList(queryParams, "includes");
            if (includes != null) {
                HashSet<Service.ServiceOption> includeOptionsSet = new HashSet<Service.ServiceOption>();
                for (String option : includes) {
                    if (option.equals("ALL")) {
                        includeOptionsSet.addAll(Arrays.asList(Service.ServiceOption.values()));
                        continue;
                    }
                    includeOptionsSet.add(Service.ServiceOption.valueOf(option));
                }
                includeOptions = EnumSet.copyOf(includeOptionsSet);
            }
            if ((excludes = RootNamespaceService.getValueList(queryParams, "excludes")) != null) {
                HashSet<Service.ServiceOption> excludeOptionsSet = new HashSet<Service.ServiceOption>();
                for (String option : excludes) {
                    excludeOptionsSet.add(Service.ServiceOption.valueOf(option));
                }
                excludeOptions = EnumSet.copyOf(excludeOptionsSet);
            }
            if ((matchQueryParam = queryParams.get("matchAllOptions")) != null) {
                matchAllOptions = Boolean.valueOf(matchQueryParam);
            }
        }
        if ((filter = UriUtils.getODataFilterParamValue(get.getUri())) != null) {
            ODataTokenizer tokenizer = new ODataTokenizer(filter);
            ODataTokenList list = tokenizer.tokenize();
            while (list.hasNext()) {
                ODataToken tok = list.next();
                if (!tok.getUriLiteral().equals("options") || !list.hasNext() || !list.next().getUriLiteral().equals(ODataQueryVisitor.BinaryVerb.EQ.operator)) continue;
                if (!list.hasNext()) break;
                String value = list.next().getUriLiteral();
                if (value.startsWith("'") && value.endsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                }
                includeOptions.add(Service.ServiceOption.valueOf(value));
                break;
            }
        }
        get.nestCompletion((o, e) -> {
            if (e == null) {
                Collections.sort(o.getBody(ServiceDocumentQueryResult.class).documentLinks);
            }
            get.complete();
        });
        this.getHost().queryServiceUris(includeOptions, matchAllOptions, get, excludeOptions);
    }

    private static String[] getValueList(Map<String, String> queryParams, String queryParam) {
        String value = queryParams.get(queryParam);
        if (value == null) {
            return null;
        }
        return value.split("[, ]");
    }
}

