/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.QueryTaskService;
import com.vmware.xenon.services.common.ServiceUriPaths;

public class QueryTaskFactoryService
extends FactoryService {
    public static final String SELF_LINK = ServiceUriPaths.CORE_QUERY_TASKS;

    public QueryTaskFactoryService() {
        super(QueryTask.class);
        super.setPeerNodeSelectorPath("/core/node-selectors/default-1x");
    }

    @Override
    public void handlePost(Operation post) {
        if (!post.hasBody()) {
            post.fail(new IllegalArgumentException("body is required"));
            return;
        }
        QueryTask initState = post.getBody(QueryTask.class);
        if (initState.taskInfo.isDirect) {
            post.setReplicationDisabled(true);
        }
        if (initState.documentSourceLink == null) {
            post.complete();
            return;
        }
        if (!this.getHost().checkServiceAvailable(initState.documentSourceLink)) {
            post.fail(new IllegalStateException("Source query task is not available:" + initState.documentSourceLink));
            return;
        }
        this.sendRequest(Operation.createGet(this, initState.documentSourceLink).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Failure retrieving state from %s: %s", initState.documentSourceLink, Utils.toString(e));
                post.fail(e);
                return;
            }
            QueryTask mergedInitState = o.getBody(QueryTask.class);
            mergedInitState.taskInfo.failure = null;
            mergedInitState.taskInfo.stage = TaskState.TaskStage.CREATED;
            mergedInitState.results = null;
            mergedInitState.documentSelfLink = initState.documentSelfLink;
            mergedInitState.documentOwner = initState.documentOwner;
            mergedInitState.documentSourceLink = initState.documentSourceLink;
            mergedInitState.documentDescription = null;
            if (initState.taskInfo != null && initState.taskInfo.isDirect != mergedInitState.taskInfo.isDirect) {
                mergedInitState.taskInfo.isDirect = initState.taskInfo.isDirect;
            }
            post.setBody(mergedInitState).complete();
        }));
    }

    @Override
    public Service createServiceInstance() throws Throwable {
        return new QueryTaskService();
    }
}

