/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupBroadcastResponse;
import com.vmware.xenon.services.common.NodeGroupBroadcastResult;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class NodeGroupUtils {
    public static final String PROPERTY_NAME_OPERATION_TIMEOUT_SECONDS = "xenon.NodeGroupUtils.operationTimeoutSeconds";
    private static final long OPERATION_TIMEOUT_SECONDS = Long.getLong("xenon.NodeGroupUtils.operationTimeoutSeconds", TimeUnit.MICROSECONDS.toSeconds(ServiceHost.ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS / 3L));

    private NodeGroupUtils() {
    }

    public static void checkServiceAvailability(Operation.CompletionHandler ch, Service s) {
        NodeGroupUtils.checkServiceAvailability(ch, s.getHost(), s.getSelfLink(), s.getPeerNodeSelectorPath());
    }

    public static void checkServiceAvailability(Operation.CompletionHandler ch, ServiceHost host, String link, String selectorPath) {
        if (link == null) {
            throw new IllegalArgumentException("link is required");
        }
        URI service = UriUtils.buildUri(host, link);
        NodeGroupUtils.checkServiceAvailability(ch, host, service, selectorPath);
    }

    public static void checkServiceAvailability(Operation.CompletionHandler ch, ServiceHost host, URI service, String selectorPath) {
        URI statsUri = UriUtils.buildStatsUri(service);
        if (selectorPath == null) {
            throw new IllegalArgumentException("selectorPath is required");
        }
        long timeoutMicros = Math.min(host.getOperationTimeoutMicros(), TimeUnit.SECONDS.toMicros(OPERATION_TIMEOUT_SECONDS));
        Operation get = Operation.createGet(statsUri).setCompletion((o, e) -> {
            if (e != null) {
                host.log(Level.WARNING, "%s to %s failed: %s", new Object[]{o.getAction(), o.getUri(), e.toString()});
                ch.handle(null, e);
                return;
            }
            ServiceStats s = o.getBody(ServiceStats.class);
            ServiceStats.ServiceStat availableStat = s.entries.get("isAvailable");
            if (availableStat == null || availableStat.latestValue == 0.0) {
                ch.handle(o, new IllegalStateException("not available"));
                return;
            }
            ch.handle(o, null);
        });
        get.setReferer(host.getPublicUri()).setExpiration(Utils.fromNowMicrosUtc(timeoutMicros));
        URI nodeSelector = UriUtils.buildUri(service, selectorPath);
        NodeSelectorService.SelectAndForwardRequest req = new NodeSelectorService.SelectAndForwardRequest();
        req.key = service.getPath();
        Operation selectPost = Operation.createPost(nodeSelector).setReferer(host.getPublicUri()).setExpiration(get.getExpirationMicrosUtc()).setBodyNoCloning(req);
        selectPost.setCompletion((o, e) -> {
            if (e != null) {
                host.log(Level.WARNING, "SelectOwner for %s to %s failed: %s", req.key, nodeSelector, e.toString());
                ch.handle(get, e);
                return;
            }
            NodeSelectorService.SelectOwnerResponse selectRsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            URI serviceOnOwner = UriUtils.buildUri(selectRsp.ownerNodeGroupReference, statsUri.getPath());
            get.setUri(serviceOnOwner).sendWith(host);
        }).sendWith(host);
    }

    public static void checkConvergenceFromAnyHost(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        NodeGroupUtils.checkConvergenceAcrossPeers(host, ngs, parentOp);
    }

    public static void checkConvergence(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        NodeState self = ngs.nodes.get(host.getId());
        if (self == null) {
            parentOp.fail(new IllegalStateException("Self node is required"));
            return;
        }
        if (self.membershipQuorum == 1 && ngs.nodes.size() == 1) {
            parentOp.complete();
            return;
        }
        NodeGroupUtils.checkConvergenceAcrossPeers(host, ngs, parentOp);
    }

    private static void checkConvergenceAcrossPeers(ServiceHost host, NodeGroupService.NodeGroupState ngs, Operation parentOp) {
        OperationJoin.JoinedCompletionHandler joinedCompletion = (ops, failures) -> {
            if (failures != null) {
                StringBuilder errorRsp = new StringBuilder();
                try {
                    for (Operation op : ops.values()) {
                        if (op.getStatusCode() < 400) continue;
                        String error = op.getStatusCode() + "";
                        if (op.hasBody()) {
                            ServiceErrorResponse rsp = op.getErrorResponseBody();
                            String msg = rsp != null ? rsp.message : "";
                            error = msg + ":" + op.getStatusCode();
                        }
                        errorRsp.append("node ").append(op.getUri()).append(" failed with:").append(error).append("\n");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                parentOp.fail(new IllegalStateException("Failures: " + errorRsp.toString()));
                return;
            }
            HashMap<URI, Long> membershipUpdateTimes = new HashMap<URI, Long>();
            HashSet<Long> uniqueTimes = new HashSet<Long>();
            for (Operation peerOp : ops.values()) {
                if (!peerOp.hasBody()) {
                    membershipUpdateTimes.put(peerOp.getUri(), -1L);
                    uniqueTimes.add(-1L);
                    continue;
                }
                NodeGroupService.NodeGroupState rsp = peerOp.getBody(NodeGroupService.NodeGroupState.class);
                membershipUpdateTimes.put(peerOp.getUri(), rsp.membershipUpdateTimeMicros);
                uniqueTimes.add(rsp.membershipUpdateTimeMicros);
            }
            if (uniqueTimes.size() > 1) {
                String error = String.format("Membership times not converged: %s", membershipUpdateTimes);
                parentOp.fail(new IllegalStateException(error));
                return;
            }
            parentOp.complete();
        };
        ArrayList<Operation> ops2 = new ArrayList<Operation>();
        for (NodeState ns : ngs.nodes.values()) {
            if (NodeState.isUnAvailable(ns)) continue;
            long expirationMicros = Math.min(Utils.fromNowMicrosUtc(ngs.config.peerRequestTimeoutMicros), parentOp.getExpirationMicrosUtc());
            Operation peerOp = Operation.createGet(ns.groupReference).transferRefererFrom(parentOp).setExpiration(expirationMicros);
            if (host.getId().equals(ns.id)) {
                peerOp.setUri(UriUtils.buildUri(host.getUri(), ns.groupReference.getPath()));
            }
            ops2.add(peerOp);
        }
        if (ops2.isEmpty()) {
            parentOp.fail(new IllegalStateException("no available nodes"));
            return;
        }
        OperationJoin.create(ops2).setCompletion(joinedCompletion).sendWith(host);
    }

    public static void checkConvergence(ServiceHost host, URI nodegroupReference, Operation parentOp) {
        Operation.createGet(nodegroupReference).transferRefererFrom(parentOp).setCompletion((o, t) -> {
            if (t != null) {
                parentOp.fail(t);
                return;
            }
            NodeGroupService.NodeGroupState ngs = o.getBody(NodeGroupService.NodeGroupState.class);
            NodeGroupUtils.checkConvergenceAcrossPeers(host, ngs, parentOp);
        }).sendWith(host);
    }

    public static boolean isMembershipSettled(ServiceHost host, long maintIntervalMicros, NodeGroupService.NodeGroupState localState) {
        NodeState selfNode = localState.nodes.get(host.getId());
        if (selfNode == null) {
            return false;
        }
        if (localState.nodes.size() == 1 && selfNode.membershipQuorum == 1) {
            return true;
        }
        long threshold = localState.localMembershipUpdateTimeMicros + localState.config.stableGroupMaintenanceIntervalCount * maintIntervalMicros;
        return Utils.getSystemNowMicrosUtc() - threshold >= 0L;
    }

    public static boolean hasMembershipQuorum(ServiceHost host, NodeGroupService.NodeGroupState ngs) {
        NodeState selfNode = ngs.nodes.get(host.getId());
        if (selfNode == null) {
            return false;
        }
        int availableNodeCount = 0;
        if (ngs.nodes.size() == 1) {
            availableNodeCount = 1;
        } else {
            for (NodeState ns : ngs.nodes.values()) {
                if (!NodeState.isAvailable(ns, selfNode.id, false)) continue;
                ++availableNodeCount;
            }
        }
        return availableNodeCount >= selfNode.membershipQuorum;
    }

    public static boolean isNodeGroupAvailable(ServiceHost host, NodeGroupService.NodeGroupState localState) {
        return NodeGroupUtils.isMembershipSettled(host, host.getMaintenanceIntervalMicros(), localState) && NodeGroupUtils.hasMembershipQuorum(host, localState);
    }

    public static void registerForReplicatedServiceAvailability(ServiceHost host, Operation op, String servicePath, String nodeSelectorPath) {
        Operation.CompletionHandler ch = (o, e) -> {
            if (e != null) {
                if (op.getExpirationMicrosUtc() < Utils.getSystemNowMicrosUtc()) {
                    String msg = "Failed to check replicated service availability";
                    op.fail(new TimeoutException(msg));
                    return;
                }
                host.scheduleCore(() -> NodeGroupUtils.registerForReplicatedServiceAvailability(host, op, servicePath, nodeSelectorPath), host.getMaintenanceIntervalMicros(), TimeUnit.MICROSECONDS);
                return;
            }
            op.complete();
        };
        host.checkReplicatedServiceAvailable(ch, servicePath, nodeSelectorPath);
    }

    public static NodeGroupBroadcastResult toBroadcastResult(NodeGroupBroadcastResponse response) {
        URI nodeGroupUri;
        String hostId;
        URI hostUri;
        URI requestUri;
        NodeGroupBroadcastResult.PeerNodeResult singleResult;
        NodeGroupBroadcastResult result = new NodeGroupBroadcastResult();
        result.totalNodeCount = response.nodeCount;
        result.availableNodeCount = response.availableNodeCount;
        result.unavailableNodeCount = response.nodeCount - response.availableNodeCount;
        result.membershipQuorum = response.membershipQuorum;
        Map<URI, String> hostIdByUrl = response.selectedNodes.entrySet().stream().collect(Collectors.toMap(entry -> {
            URI uri = (URI)entry.getValue();
            return URI.create(uri.toString().replace(uri.getPath(), ""));
        }, Map.Entry::getKey));
        for (Map.Entry<URI, String> entry2 : response.jsonResponses.entrySet()) {
            singleResult = new NodeGroupBroadcastResult.PeerNodeResult();
            requestUri = entry2.getKey();
            String json = entry2.getValue();
            hostUri = URI.create(requestUri.toString().replace(requestUri.getPath(), ""));
            hostId = hostIdByUrl.get(hostUri);
            nodeGroupUri = response.selectedNodes.get(hostId);
            singleResult.requestUri = requestUri;
            singleResult.hostId = hostId;
            singleResult.nodeGroupUri = nodeGroupUri;
            singleResult.json = json;
            singleResult.errorResponse = null;
            result.allResponses.add(singleResult);
            result.successResponses.add(singleResult);
        }
        for (Map.Entry<URI, Object> entry3 : response.failures.entrySet()) {
            singleResult = new NodeGroupBroadcastResult.PeerNodeResult();
            requestUri = entry3.getKey();
            ServiceErrorResponse errorResponse = (ServiceErrorResponse)entry3.getValue();
            hostUri = URI.create(requestUri.toString().replace(requestUri.getPath(), ""));
            hostId = hostIdByUrl.get(hostUri);
            nodeGroupUri = response.selectedNodes.get(hostId);
            singleResult.requestUri = requestUri;
            singleResult.hostId = hostId;
            singleResult.nodeGroupUri = nodeGroupUri;
            singleResult.json = null;
            singleResult.errorResponse = errorResponse;
            result.allResponses.add(singleResult);
            result.failureResponses.add(singleResult);
            result.failureErrorResponses.add(errorResponse);
        }
        return result;
    }
}

