/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.DeferredResult;
import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.ServiceStatUtils;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeGroupUtils;
import com.vmware.xenon.services.common.NodeState;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MigrationTaskService
extends StatefulService {
    public static final String STAT_NAME_PROCESSED_DOCUMENTS = "processedServiceCount";
    public static final String STAT_NAME_ESTIMATED_TOTAL_SERVICE_COUNT = "estimatedTotalServiceCount";
    public static final String STAT_NAME_FETCHED_DOCUMENT_COUNT = "fetchedDocumentCount";
    public static final String STAT_NAME_OWNER_MISMATCH_COUNT = "ownerMismatchDocumentCount";
    public static final String STAT_NAME_BEFORE_TRANSFORM_COUNT = "beforeTransformDocumentCount";
    public static final String STAT_NAME_AFTER_TRANSFORM_COUNT = "afterTransformDocumentCount";
    public static final String STAT_NAME_COUNT_QUERY_TIME_DURATION_MICRO = "countQueryTimeDurationMicros";
    public static final String STAT_NAME_RETRIEVAL_OPERATIONS_DURATION_MICRO = "retrievalOperationsDurationMicros";
    public static final String STAT_NAME_RETRIEVAL_QUERY_TIME_DURATION_MICRO_FORMAT = "retrievalQueryTimeDurationMicros-%s";
    public static final String FACTORY_LINK = "/management/migration-tasks";
    private static final Integer DEFAULT_PAGE_SIZE = 10000;
    private static final Long DEFAULT_MAINTENANCE_INTERVAL_MILLIS = TimeUnit.MINUTES.toMicros(1L);
    private static final Integer DEFAULT_MAXIMUM_CONVERGENCE_CHECKS = 10;
    private static final Object DUMMY_OBJECT = new Object();

    public static Service createFactory() {
        FactoryService fs = FactoryService.create(MigrationTaskService.class, State.class, new Service.ServiceOption[0]);
        fs.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
        fs.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        return fs;
    }

    public MigrationTaskService() {
        super(State.class);
        super.toggleOption(Service.ServiceOption.CORE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
    }

    @Override
    public void handleStart(Operation startPost) {
        State initState = (State)this.getBody(startPost);
        this.logInfo("Starting migration with initState: %s", initState);
        initState = this.initialize(initState);
        if (TaskState.isFinished(initState.taskInfo)) {
            startPost.complete();
            return;
        }
        if (!this.verifyState(initState, startPost)) {
            return;
        }
        startPost.complete();
        State patchState = new State();
        if (initState.taskInfo == null) {
            patchState.taskInfo = TaskState.create();
        }
        if (initState.continuousMigration.booleanValue()) {
            this.setMaintenanceIntervalMicros(initState.maintenanceIntervalMicros);
        }
        if (initState.taskInfo.stage == TaskState.TaskStage.CANCELLED) {
            this.logInfo("In stage %s, will restart on next maintenance interval", new Object[]{initState.taskInfo.stage});
            return;
        }
        Operation.createPatch(this.getUri()).setBody(patchState).sendWith(this);
    }

    private State initialize(State initState) {
        if (initState.querySpec == null) {
            initState.querySpec = new QueryTask.QuerySpecification();
        }
        if (initState.querySpec.resultLimit == null) {
            initState.querySpec.resultLimit = DEFAULT_PAGE_SIZE;
        }
        initState.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        if (initState.querySpec.query == null || initState.querySpec.query.booleanClauses == null || initState.querySpec.query.booleanClauses.isEmpty()) {
            initState.querySpec.query = this.buildFieldClause(initState);
        } else {
            initState.querySpec.query.addBooleanClause(this.buildFieldClause(initState));
        }
        if (initState.taskInfo == null) {
            initState.taskInfo = new TaskState();
        }
        if (initState.taskInfo.stage == null) {
            initState.taskInfo.stage = TaskState.TaskStage.CREATED;
        }
        if (initState.maintenanceIntervalMicros == null) {
            initState.maintenanceIntervalMicros = DEFAULT_MAINTENANCE_INTERVAL_MILLIS;
        }
        if (initState.maximumConvergenceChecks == null) {
            initState.maximumConvergenceChecks = DEFAULT_MAXIMUM_CONVERGENCE_CHECKS;
        }
        if (initState.migrationOptions == null) {
            initState.migrationOptions = EnumSet.noneOf(MigrationOption.class);
        }
        if (initState.continuousMigration == null) {
            initState.continuousMigration = Boolean.FALSE;
        }
        if (initState.continuousMigration.booleanValue()) {
            initState.migrationOptions.add(MigrationOption.CONTINUOUS);
        }
        return initState;
    }

    private QueryTask.Query buildFieldClause(State initState) {
        QueryTask.Query query = QueryTask.Query.Builder.create().addFieldClause("documentSelfLink", this.addSlash(initState.sourceFactoryLink), QueryTask.QueryTerm.MatchType.PREFIX).build();
        return query;
    }

    private boolean verifyState(State state, Operation operation) {
        ArrayList<String> errMsgs = new ArrayList<String>();
        if (state.sourceFactoryLink == null) {
            errMsgs.add("sourceFactory cannot be null.");
        }
        if (state.sourceNodeGroupReference == null && state.sourceReferences.isEmpty()) {
            errMsgs.add("sourceNode or sourceUri need to be specified.");
        }
        if (state.sourceNodeGroupReference != null && !state.sourceReferences.isEmpty()) {
            errMsgs.add("cannot specify both sourceNode and sourceReferences.");
        }
        if (state.destinationFactoryLink == null) {
            errMsgs.add("destinationFactory cannot be null.");
        }
        if (state.destinationNodeGroupReference == null && state.destinationReferences.isEmpty()) {
            errMsgs.add("destinationNode or destinationReferences need to be specified.");
        }
        if (state.destinationNodeGroupReference != null && !state.destinationReferences.isEmpty()) {
            errMsgs.add("cannot specify both destinationNode and destinationReferences.");
        }
        if (!errMsgs.isEmpty()) {
            operation.fail(new IllegalArgumentException(String.join((CharSequence)" ", errMsgs)));
        }
        return errMsgs.isEmpty();
    }

    @Override
    public void handlePatch(Operation patchOperation) {
        State patchState = (State)this.getBody(patchOperation);
        State currentState = (State)this.getState(patchOperation);
        this.applyPatch(patchState, currentState);
        if (!this.verifyState(currentState, patchOperation) && !this.verifyPatchedState(currentState, patchOperation)) {
            return;
        }
        patchOperation.complete();
        this.logInfo("After PATCH, the latest state is: %s", currentState);
        if (TaskState.isFinished(currentState.taskInfo) || TaskState.isFailed(currentState.taskInfo) || TaskState.isCancelled(currentState.taskInfo)) {
            return;
        }
        if ((patchState.maintenanceIntervalMicros != null || patchState.continuousMigration != null) && currentState.continuousMigration.booleanValue()) {
            this.setMaintenanceIntervalMicros(currentState.maintenanceIntervalMicros);
        }
        this.resolveNodeGroupReferences(currentState);
    }

    private URI extractBaseUri(NodeState state) {
        URI uri = state.groupReference;
        return UriUtils.buildUri(uri.getScheme(), uri.getHost(), uri.getPort(), null, null);
    }

    @Override
    public void handleMaintenance(Operation maintenanceOperation) {
        maintenanceOperation.complete();
        ServiceMaintenanceRequest serviceMaintenanceRequest = maintenanceOperation.getBody(ServiceMaintenanceRequest.class);
        if (!serviceMaintenanceRequest.reasons.contains((Object)ServiceMaintenanceRequest.MaintenanceReason.PERIODIC_SCHEDULE)) {
            return;
        }
        Operation.CompletionHandler c = (o, t) -> {
            if (t != null) {
                this.logWarning("Error retrieving document %s, %s", this.getUri(), t);
                return;
            }
            State state = o.getBody(State.class);
            if (!state.continuousMigration.booleanValue()) {
                return;
            }
            if (state.taskInfo.stage == TaskState.TaskStage.STARTED || state.taskInfo.stage == TaskState.TaskStage.CREATED) {
                return;
            }
            State patch = new State();
            this.logInfo("Continuous migration enabled, restarting", new Object[0]);
            if (state.taskInfo.stage == TaskState.TaskStage.FINISHED) {
                patch.querySpec = state.querySpec;
                QueryTask.Query q = this.findUpdateTimeMicrosRangeClause(patch.querySpec.query);
                if (q != null) {
                    q.setNumericRange(QueryTask.NumericRange.createGreaterThanOrEqualRange(state.latestSourceUpdateTimeMicros));
                } else {
                    QueryTask.Query timeClause = QueryTask.Query.Builder.create().addRangeClause("documentUpdateTimeMicros", QueryTask.NumericRange.createGreaterThanOrEqualRange(state.latestSourceUpdateTimeMicros)).build();
                    patch.querySpec.query.addBooleanClause(timeClause);
                }
            }
            patch.taskInfo = TaskState.createAsStarted();
            Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
        };
        Operation.createGet(this.getUri()).setCompletion(c).sendWith(this);
    }

    private QueryTask.Query findUpdateTimeMicrosRangeClause(QueryTask.Query query) {
        if (query.term != null && query.term.propertyName != null && query.term.propertyName.equals("documentUpdateTimeMicros") && query.term.range != null) {
            return query;
        }
        if (query.booleanClauses == null) {
            return null;
        }
        for (QueryTask.Query q : query.booleanClauses) {
            QueryTask.Query match = this.findUpdateTimeMicrosRangeClause(q);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private void resolveNodeGroupReferences(State currentState) {
        this.logInfo("Resolving node group differences. [source=%s] [destination=%s]", currentState.sourceNodeGroupReference, currentState.destinationNodeGroupReference);
        DeferredResult<Object> sourceDeferred = new DeferredResult<Object>();
        if (currentState.sourceReferences.isEmpty()) {
            Operation.createGet(currentState.sourceNodeGroupReference).setCompletion((os, ex) -> {
                if (ex != null) {
                    sourceDeferred.fail(ex);
                    return;
                }
                NodeGroupService.NodeGroupState sourceGroup = os.getBody(NodeGroupService.NodeGroupState.class);
                currentState.sourceReferences = this.filterAvailableNodeUris(sourceGroup);
                this.waitUntilNodeGroupsAreStable(currentState, currentState.sourceNodeGroupReference, currentState.maximumConvergenceChecks, sourceDeferred);
            }).sendWith(this);
        } else {
            sourceDeferred.complete(DUMMY_OBJECT);
        }
        DeferredResult<Object> destDeferred = new DeferredResult<Object>();
        if (currentState.destinationReferences.isEmpty()) {
            Operation.createGet(currentState.destinationNodeGroupReference).setCompletion((os, ex) -> {
                if (ex != null) {
                    destDeferred.fail(ex);
                    return;
                }
                NodeGroupService.NodeGroupState sourceGroup = os.getBody(NodeGroupService.NodeGroupState.class);
                currentState.destinationReferences = this.filterAvailableNodeUris(sourceGroup);
                this.waitUntilNodeGroupsAreStable(currentState, currentState.destinationNodeGroupReference, currentState.maximumConvergenceChecks, destDeferred);
            }).sendWith(this);
        } else {
            destDeferred.complete(DUMMY_OBJECT);
        }
        DeferredResult.allOf(sourceDeferred, destDeferred).thenAccept(aVoid -> this.computeFirstCurrentPageLinks(currentState, currentState.sourceReferences, currentState.destinationReferences)).exceptionally(throwable -> {
            this.failTask((Throwable)throwable);
            return null;
        });
    }

    private List<URI> filterAvailableNodeUris(NodeGroupService.NodeGroupState destinationGroup) {
        return destinationGroup.nodes.values().stream().filter(ns -> !NodeState.isUnAvailable(ns)).map(this::extractBaseUri).collect(Collectors.toList());
    }

    private void waitUntilNodeGroupsAreStable(State currentState, URI nodeGroupReference, int allowedConvergenceChecks, DeferredResult<Object> deferredResult) {
        Operation callbackOp = new Operation().setCompletion((op, ex) -> {
            if (ex != null) {
                if (allowedConvergenceChecks <= 0) {
                    String msg = "Nodegroups did not converge after " + currentState.maximumConvergenceChecks + " retries.";
                    deferredResult.fail(new Exception(msg));
                    return;
                }
                this.logInfo("Nodegroups are not convereged scheduling retry.", new Object[0]);
                this.getHost().schedule(() -> this.waitUntilNodeGroupsAreStable(currentState, nodeGroupReference, allowedConvergenceChecks - 1, deferredResult), currentState.maintenanceIntervalMicros, TimeUnit.MICROSECONDS);
                return;
            }
            deferredResult.complete(null);
        }).setReferer(this.getUri());
        NodeGroupUtils.checkConvergence(this.getHost(), nodeGroupReference, callbackOp);
    }

    private void computeFirstCurrentPageLinks(State currentState, List<URI> sourceURIs, List<URI> destinationURIs) {
        this.logInfo("Node groups are stable. Computing pages to be migrated...", new Object[0]);
        long documentExpirationTimeMicros = currentState.documentExpirationTimeMicros;
        URI sourceHostUri = this.selectRandomUri(sourceURIs);
        URI factoryUri = UriUtils.buildUri(sourceHostUri, currentState.sourceFactoryLink);
        URI factoryConfigUri = UriUtils.buildConfigUri(factoryUri);
        Operation configGet = Operation.createGet(factoryConfigUri);
        this.sendWithDeferredResult(configGet).thenCompose(op -> {
            FactoryService.FactoryServiceConfiguration factoryConfig = op.getBody(FactoryService.FactoryServiceConfiguration.class);
            QueryTask countQuery = QueryTask.Builder.createDirectTask().addOption(QueryTask.QuerySpecification.QueryOption.COUNT).setQuery(this.buildFieldClause(currentState)).build();
            if (currentState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS) || factoryConfig.childOptions.contains((Object)Service.ServiceOption.IMMUTABLE)) {
                countQuery.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
            }
            if (currentState.migrationOptions.contains((Object)MigrationOption.ESTIMATE_COUNT)) {
                countQuery.documentExpirationTimeMicros = documentExpirationTimeMicros;
                Operation countOp = Operation.createPost(UriUtils.buildUri(sourceHostUri, ServiceUriPaths.CORE_QUERY_TASKS)).setBody(countQuery);
                return this.sendWithDeferredResult(countOp);
            }
            countQuery.results = new ServiceDocumentQueryResult();
            countQuery.results.documentCount = -1L;
            countQuery.results.queryTimeMicros = -1L;
            Operation dummyOp = Operation.createGet(null).setBody(countQuery);
            return DeferredResult.completed(dummyOp);
        }).thenAccept(countOp -> {
            QueryTask countQueryTask = countOp.getBody(QueryTask.class);
            Long estimatedTotalServiceCount = countQueryTask.results.documentCount;
            long queryTimeMicros = countQueryTask.results.queryTimeMicros;
            this.logInfo("[factory=%s] Estimated total service count =%,d calculation took %,d microsec ", currentState.sourceFactoryLink, estimatedTotalServiceCount, queryTimeMicros);
            this.setStat(STAT_NAME_COUNT_QUERY_TIME_DURATION_MICRO, (double)queryTimeMicros);
            this.adjustStat(STAT_NAME_ESTIMATED_TOTAL_SERVICE_COUNT, (double)estimatedTotalServiceCount.longValue());
            QueryTask queryTask = QueryTask.create(currentState.querySpec).setDirect(true);
            if (countQueryTask.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS)) {
                queryTask.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
            }
            queryTask.documentExpirationTimeMicros = documentExpirationTimeMicros;
            Set<Operation> queryOps = sourceURIs.stream().map(sourceUri -> {
                URI uri = UriUtils.buildUri(sourceUri, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS);
                return Operation.createPost(uri).setBody(queryTask);
            }).collect(Collectors.toSet());
            OperationJoin.create(queryOps).setCompletion((os, ts) -> {
                if (ts != null && !ts.isEmpty()) {
                    this.failTask(ts.values());
                    return;
                }
                Set<URI> currentPageLinks = os.values().stream().filter(operation -> operation.getBody(QueryTask.class).results.nextPageLink != null).map(this::getNextPageLinkUri).collect(Collectors.toSet());
                if (currentPageLinks.isEmpty()) {
                    this.patchToFinished(null);
                } else {
                    this.migrate(currentState, currentPageLinks, destinationURIs, new HashMap<String, Long>());
                }
            }).sendWith(this);
        }).exceptionally(throwable -> {
            this.failTask((Throwable)throwable);
            throw new CompletionException((Throwable)throwable);
        });
    }

    private void migrate(State currentState, Set<URI> currentPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        if (currentPageLinks.isEmpty()) {
            this.patchToFinished(lastUpdateTimesPerOwner);
            return;
        }
        Collection gets = currentPageLinks.stream().map(Operation::createGet).collect(Collectors.toSet());
        this.logFine("Migrating results using %d GET operations, which came from %d currentPageLinks", gets.size(), currentPageLinks.size());
        long start = Utils.getSystemNowMicrosUtc();
        OperationJoin.create(gets).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            ServiceStats.ServiceStat retrievalOpTimeStat = this.getSingleBinTimeSeriesStat(STAT_NAME_RETRIEVAL_OPERATIONS_DURATION_MICRO);
            this.setStat(retrievalOpTimeStat, (double)(Utils.getSystemNowMicrosUtc() - start));
            Set<URI> nextPages = os.values().stream().filter(operation -> operation.getBody(QueryTask.class).results.nextPageLink != null).map(operation -> this.getNextPageLinkUri((Operation)operation)).collect(Collectors.toSet());
            ArrayList<Object> results = new ArrayList<Object>();
            HashMap<Object, URI> hostUriByResult = new HashMap<Object, URI>();
            for (Operation op : os.values()) {
                QueryTask queryTask = op.getBody(QueryTask.class);
                String authority = op.getUri().getAuthority();
                String queryTimeStatKey = String.format(STAT_NAME_RETRIEVAL_QUERY_TIME_DURATION_MICRO_FORMAT, authority);
                this.setStat(this.getSingleBinTimeSeriesStat(queryTimeStatKey), (double)queryTask.results.queryTimeMicros.longValue());
                Collection<Object> docs = queryTask.results.documents.values();
                int totalFetched = docs.size();
                int ownerMissMatched = 0;
                for (Object doc : docs) {
                    ServiceDocument document = Utils.fromJson(doc, ServiceDocument.class);
                    String documentOwner = document.documentOwner;
                    if (documentOwner == null) {
                        documentOwner = queryTask.results.documentOwner;
                    }
                    if (documentOwner.equals(queryTask.results.documentOwner)) {
                        results.add(doc);
                        lastUpdateTimesPerOwner.compute(documentOwner, (key, val) -> {
                            if (val == null) {
                                return document.documentUpdateTimeMicros;
                            }
                            return Math.max(val, document.documentUpdateTimeMicros);
                        });
                        URI hostUri = this.getHostUri(op);
                        hostUriByResult.put(doc, hostUri);
                        continue;
                    }
                    ++ownerMissMatched;
                }
                this.adjustStat(STAT_NAME_FETCHED_DOCUMENT_COUNT, (double)totalFetched);
                this.adjustStat(STAT_NAME_OWNER_MISMATCH_COUNT, (double)ownerMissMatched);
            }
            if (results.isEmpty()) {
                this.migrate(currentState, nextPages, destinationURIs, lastUpdateTimesPerOwner);
                return;
            }
            if (currentState.migrationOptions.contains((Object)MigrationOption.ALL_VERSIONS)) {
                this.retrieveAllVersions(results, hostUriByResult, nextPages, currentState, destinationURIs, lastUpdateTimesPerOwner);
            } else {
                this.transformResults(currentState, results, nextPages, destinationURIs, lastUpdateTimesPerOwner);
            }
        }).sendWith(this);
    }

    private void retrieveAllVersions(Collection<Object> results, Map<Object, URI> hostUriByResult, Set<URI> nextPages, State currentState, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        ArrayList deferredResults = new ArrayList();
        for (Object doc : results) {
            URI hostUri = hostUriByResult.get(doc);
            ServiceDocument document = Utils.fromJson(doc, ServiceDocument.class);
            String selfLink = document.documentSelfLink;
            URI templateUri = UriUtils.buildUri(hostUri, selfLink, "/template");
            Operation o = Operation.createGet(templateUri);
            DeferredResult<List> deferredResult = this.sendWithDeferredResult(o).thenCompose(op -> {
                ServiceDocument template = op.getBody(ServiceDocument.class);
                int resultLimit = Long.valueOf(template.documentDescription.versionRetentionLimit).intValue();
                QueryTask.Query qs = QueryTask.Query.Builder.create().addFieldClause("documentSelfLink", selfLink).build();
                QueryTask q = QueryTask.Builder.createDirectTask().addOption(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS).addOption(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT).setQuery(qs).setResultLimit(resultLimit).orderAscending("documentVersion", ServiceDocumentDescription.TypeName.LONG).build();
                URI postUri = UriUtils.buildUri(hostUri, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS);
                Operation queryOp = Operation.createPost(postUri).setBody(q);
                return this.sendWithDeferredResult(queryOp);
            }).thenCompose(op -> {
                Operation getNextPageOp = Operation.createGet(this.getNextPageLinkUri((Operation)op));
                return this.sendWithDeferredResult(getNextPageOp);
            }).thenApply(op -> {
                QueryTask queryTask = op.getBody(QueryTask.class);
                List docs = queryTask.results.documentLinks.stream().map(link -> queryTask.results.documents.get(link)).collect(Collectors.toList());
                return docs;
            }).exceptionally(ex -> {
                this.failTask((Throwable)ex);
                return null;
            });
            deferredResults.add(deferredResult);
        }
        DeferredResult.allOf(deferredResults).thenAccept(docsList -> {
            List<Object> allVersions = docsList.stream().flatMap(Collection::stream).collect(Collectors.toList());
            this.transformResults(currentState, allVersions, nextPages, destinationURIs, lastUpdateTimesPerOwner);
        });
    }

    private void transformUsingMap(State state, Collection<Object> cleanJson, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        Collection transformations = cleanJson.stream().map(doc -> Operation.createPost(UriUtils.buildUri(this.selectRandomUri(destinationURIs), state.transformationServiceLink)).setBody(Collections.singletonMap(doc, state.destinationFactoryLink))).collect(Collectors.toList());
        this.adjustStat(STAT_NAME_BEFORE_TRANSFORM_COUNT, (double)transformations.size());
        OperationJoin.create(transformations).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            HashMap<Object, String> transformedJson = new HashMap<Object, String>();
            for (Operation o : os.values()) {
                Map m = o.getBody(Map.class);
                for (Map.Entry entry : m.entrySet()) {
                    transformedJson.put(entry.getKey(), Utils.fromJson(entry.getValue(), String.class));
                }
            }
            this.adjustStat(STAT_NAME_AFTER_TRANSFORM_COUNT, (double)transformedJson.size());
            this.migrateEntities(transformedJson, state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
        }).sendWith(this);
    }

    private void transformUsingObject(State state, Collection<Object> cleanJson, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        Collection transformations = cleanJson.stream().map(doc -> {
            TransformRequest transformRequest = new TransformRequest();
            transformRequest.originalDocument = Utils.toJson(doc);
            transformRequest.destinationLink = state.destinationFactoryLink;
            return Operation.createPost(UriUtils.buildUri(this.selectRandomUri(destinationURIs), state.transformationServiceLink)).setBody(transformRequest);
        }).collect(Collectors.toList());
        this.adjustStat(STAT_NAME_BEFORE_TRANSFORM_COUNT, (double)transformations.size());
        OperationJoin.create(transformations).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            HashMap<Object, String> transformedJson = new HashMap<Object, String>();
            for (Operation o : os.values()) {
                TransformResponse response = o.getBody(TransformResponse.class);
                transformedJson.putAll(response.destinationLinks);
            }
            this.adjustStat(STAT_NAME_AFTER_TRANSFORM_COUNT, (double)transformedJson.size());
            this.migrateEntities(transformedJson, state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
        }).sendWith(this);
    }

    private void transformResults(State state, Collection<Object> results, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        Collection cleanJson = results.stream().map(d -> this.removeFactoryPathFromSelfLink(d, state.sourceFactoryLink)).collect(Collectors.toList());
        if (state.transformationServiceLink != null) {
            this.logInfo("Transforming results using [migrationOptions=%s] [transformLink=%s]", state.migrationOptions, state.transformationServiceLink);
            if (state.migrationOptions.contains((Object)MigrationOption.USE_TRANSFORM_REQUEST)) {
                this.transformUsingObject(state, cleanJson, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
            } else {
                this.transformUsingMap(state, cleanJson, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
            }
        } else {
            Map<Object, String> jsonMap = cleanJson.stream().collect(Collectors.toMap(e -> e, e -> state.destinationFactoryLink));
            this.migrateEntities(jsonMap, state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
        }
    }

    private void migrateEntities(Map<Object, String> json, State state, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        if (json.isEmpty()) {
            this.migrate(state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
            return;
        }
        if (state.migrationOptions.contains((Object)MigrationOption.ALL_VERSIONS)) {
            this.migrateEntitiesForAllVersions(json, state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
        } else {
            this.migrateEntitiesForSingleVersion(json, state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
        }
    }

    private void migrateEntitiesForAllVersions(Map<Object, String> json, State state, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        SortedSet docs;
        String selfLink;
        boolean performRetry = state.migrationOptions.contains((Object)MigrationOption.DELETE_AFTER);
        HashMap<String, SortedSet> docsBySelfLink = new HashMap<String, SortedSet>();
        HashMap<String, String> factoryLinkBySelfLink = new HashMap<String, String>();
        block3: for (Object object : json.keySet()) {
            ServiceDocument doc = Utils.fromJson(object, ServiceDocument.class);
            Service.Action action = Service.Action.valueOf(doc.documentUpdateAction);
            switch (action) {
                case PUT: 
                case PATCH: 
                case DELETE: 
                case POST: {
                    continue block3;
                }
            }
            String format = "action=%s is not supported for ALL_VERSIONS migration. selfLink=%s, version=%s";
            String message = String.format(format, new Object[]{action, doc.documentSelfLink, doc.documentVersion});
            this.failTask(new RuntimeException(message));
            return;
        }
        for (Map.Entry entry : json.entrySet()) {
            Object docJson = entry.getKey();
            String string = (String)entry.getValue();
            selfLink = Utils.fromJson(docJson, ServiceDocument.class).documentSelfLink;
            factoryLinkBySelfLink.putIfAbsent(selfLink, string);
            docs = docsBySelfLink.computeIfAbsent(selfLink, key -> new TreeSet((left, right) -> {
                ServiceDocument leftDoc = Utils.fromJson(left, ServiceDocument.class);
                ServiceDocument rightDoc = Utils.fromJson(right, ServiceDocument.class);
                return Long.compare(leftDoc.documentVersion, rightDoc.documentVersion);
            }));
            docs.add(docJson);
        }
        ConcurrentHashMap failureBySelfLink = new ConcurrentHashMap();
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : docsBySelfLink.entrySet()) {
            selfLink = (String)entry.getKey();
            docs = (SortedSet)entry.getValue();
            String factoryLink = (String)factoryLinkBySelfLink.get(selfLink);
            URI destinationUri = this.selectRandomUri(destinationURIs);
            List<Operation> ops = this.createMigrateOpsWithAllVersions(destinationUri, factoryLink, selfLink, docs);
            DeferredResult<Operation> deferredResult = DeferredResult.completed(new Operation());
            for (Operation op : ops) {
                deferredResult = deferredResult.thenCompose(o -> {
                    this.logFine(() -> String.format("migrating history. link=%s%s action=%s dest=%s", new Object[]{factoryLink, selfLink, o.getAction(), destinationUri}));
                    return this.sendWithDeferredResult(op);
                });
            }
            deferredResult = deferredResult.exceptionally(throwable -> {
                this.logWarning("Migrating entity failed. link=%s, ex=%s", selfLink, throwable);
                failureBySelfLink.put(selfLink, throwable);
                return null;
            });
            arrayList.add(deferredResult);
        }
        int numOfProcessedDoc = json.size();
        DeferredResult.allOf(arrayList).whenComplete((operations, ignore) -> {
            if (failureBySelfLink.isEmpty()) {
                this.adjustStat(STAT_NAME_PROCESSED_DOCUMENTS, (double)numOfProcessedDoc);
                this.migrate(state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
            } else if (performRetry) {
                this.logInfo("Migration retry start. links=%s", failureBySelfLink.size());
                this.retryMigrateEntitiesForAllVersions(failureBySelfLink.keySet(), docsBySelfLink, factoryLinkBySelfLink, numOfProcessedDoc, state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
            } else {
                this.failTask(failureBySelfLink.values());
            }
        });
    }

    private void retryMigrateEntitiesForAllVersions(Set<String> failedSelfLinks, Map<String, SortedSet<Object>> docsBySelfLink, Map<String, String> factoryLinkBySelfLink, int numOfProcessedDoc, State state, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        ArrayList retryDeferredResults = new ArrayList();
        for (String failedSelfLink : failedSelfLinks) {
            SortedSet<Object> docs = docsBySelfLink.get(failedSelfLink);
            String factoryLink = factoryLinkBySelfLink.get(failedSelfLink);
            URI destinationUri = this.selectRandomUri(destinationURIs);
            List<Operation> ops = this.createRetryMigrateOpsWithAllVersions(destinationUri, factoryLink, failedSelfLink, docs);
            DeferredResult<Operation> deferredResult = DeferredResult.completed(new Operation());
            for (Operation op : ops) {
                deferredResult = deferredResult.thenCompose(ignore -> {
                    this.logFine(() -> String.format("migrating history. link=%s%s action=%s dest=%s", new Object[]{factoryLink, failedSelfLink, op.getAction(), destinationUri}));
                    return this.sendWithDeferredResult(op);
                });
            }
            retryDeferredResults.add(deferredResult);
        }
        DeferredResult.allOf(retryDeferredResults).whenComplete((retryOps, retryEx) -> {
            if (retryEx != null) {
                this.failTask((Throwable)retryEx);
                return;
            }
            this.adjustStat(STAT_NAME_PROCESSED_DOCUMENTS, (double)numOfProcessedDoc);
            this.migrate(state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
        });
    }

    private void migrateEntitiesForSingleVersion(Map<Object, String> json, State state, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        boolean performRetry = state.migrationOptions.contains((Object)MigrationOption.DELETE_AFTER);
        Map<Operation, Object> posts = json.entrySet().stream().map(d -> {
            Object docJson = d.getKey();
            String factoryLink = (String)d.getValue();
            URI uri = UriUtils.buildUri(this.selectRandomUri(destinationURIs), factoryLink);
            Operation op = Operation.createPost(uri).setBodyNoCloning(docJson);
            op.addPragmaDirective("xn-from-migration");
            return new AbstractMap.SimpleEntry(op, docJson);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        OperationJoin.create(posts.keySet()).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                if (performRetry) {
                    this.logWarning("Migrating entities failed with exception: %s; Retrying operation.", ts.values().iterator().next());
                    this.useFallBack(state, posts, ts, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
                    return;
                }
                this.failTask(ts.values());
                return;
            }
            this.logInfo("[source=%s][dest=%s] MigrationTask created %,d entries in destination.", state.sourceFactoryLink, state.destinationFactoryLink, posts.size());
            this.adjustStat(STAT_NAME_PROCESSED_DOCUMENTS, (double)posts.size());
            this.migrate(state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
        }).sendWith(this);
    }

    private List<Operation> createRetryMigrateOpsWithAllVersions(URI destinationUri, String factoryLink, String selfLink, SortedSet<Object> docs) {
        URI destinationFactoryUri = UriUtils.buildUri(destinationUri, factoryLink);
        URI destinationTargetUri = UriUtils.extendUri(destinationFactoryUri, selfLink);
        Operation delete = Operation.createDelete(destinationTargetUri).addRequestHeader("x-xenon-rpl-quorum", "x-xenon-all").addPragmaDirective("xn-from-migration");
        List<Operation> createOps = this.createMigrateOpsWithAllVersions(destinationUri, factoryLink, selfLink, docs);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add(delete);
        ops.addAll(createOps);
        return ops;
    }

    private List<Operation> createMigrateOpsWithAllVersions(URI destinationUri, String factoryLink, String selfLink, SortedSet<Object> sortedDocs) {
        ArrayList<Object> docs = new ArrayList<Object>(sortedDocs);
        Object firstDoc = docs.remove(0);
        URI destinationFactoryUri = UriUtils.buildUri(destinationUri, factoryLink);
        URI destinationTargetUri = UriUtils.extendUri(destinationFactoryUri, selfLink);
        ArrayList<Operation> ops = new ArrayList<Operation>();
        Operation post = Operation.createPost(destinationFactoryUri).addPragmaDirective("xn-force-index-update").addPragmaDirective("xn-from-migration").setBodyNoCloning(firstDoc);
        ops.add(post);
        for (Object e : docs) {
            Operation operation;
            Service.Action action = Service.Action.valueOf(Utils.fromJson(e, ServiceDocument.class).documentUpdateAction);
            switch (action) {
                case PUT: {
                    operation = Operation.createPut(destinationTargetUri).setBodyNoCloning(e);
                    break;
                }
                case PATCH: {
                    operation = Operation.createPatch(destinationTargetUri).setBodyNoCloning(e);
                    break;
                }
                case DELETE: {
                    operation = Operation.createDelete(destinationTargetUri).addRequestHeader("x-xenon-rpl-quorum", "x-xenon-all");
                    break;
                }
                case POST: {
                    operation = Operation.createPost(destinationFactoryUri).addPragmaDirective("xn-force-index-update").setBodyNoCloning(e);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported action type: " + (Object)((Object)action));
                }
            }
            operation.addPragmaDirective("xn-from-migration");
            ops.add(operation);
        }
        return ops;
    }

    private void patchToFinished(Map<String, Long> lastUpdateTimesPerOwner) {
        State patch = new State();
        patch.taskInfo = TaskState.createAsFinished();
        if (lastUpdateTimesPerOwner != null) {
            patch.latestSourceUpdateTimeMicros = lastUpdateTimesPerOwner.values().stream().min(Long::compare).orElse(0L);
        }
        Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
    }

    private void useFallBack(State state, Map<Operation, Object> posts, Map<Long, Throwable> operationFailures, Set<URI> nextPageLinks, List<URI> destinationURIs, Map<String, Long> lastUpdateTimesPerOwner) {
        Map<URI, Operation> entityDestinationUriTofailedOps = this.getFailedOperations(posts, operationFailures);
        Collection<Operation> deleteOperations = this.createDeleteOperations(entityDestinationUriTofailedOps.keySet());
        OperationJoin.create(deleteOperations).setCompletion((os, ts) -> {
            if (ts != null && !ts.isEmpty()) {
                this.failTask(ts.values());
                return;
            }
            Collection<Operation> postOperations = this.createPostOperations(entityDestinationUriTofailedOps, posts);
            OperationJoin.create(postOperations).setCompletion((oss, tss) -> {
                if (tss != null && !tss.isEmpty()) {
                    this.failTask(tss.values());
                    return;
                }
                this.adjustStat(STAT_NAME_PROCESSED_DOCUMENTS, (double)posts.size());
                this.migrate(state, nextPageLinks, destinationURIs, lastUpdateTimesPerOwner);
            }).sendWith(this);
        }).sendWith(this);
    }

    private Map<URI, Operation> getFailedOperations(Map<Operation, Object> posts, Map<Long, Throwable> operationFailures) {
        HashMap<URI, Operation> ops = new HashMap<URI, Operation>();
        for (Map.Entry<Operation, Object> entry : posts.entrySet()) {
            Operation op = entry.getKey();
            if (!operationFailures.containsKey(op.getId())) continue;
            Object jsonObject = entry.getValue();
            String selfLink = Utils.getJsonMapValue(jsonObject, "documentSelfLink", String.class);
            URI getUri = UriUtils.buildUri(op.getUri(), op.getUri().getPath(), selfLink);
            ops.put(getUri, op);
        }
        return ops;
    }

    private Collection<Operation> createDeleteOperations(Collection<URI> uris) {
        return uris.stream().map(u -> Operation.createDelete(u).addRequestHeader("x-xenon-rpl-quorum", "x-xenon-all").addPragmaDirective("xn-from-migration")).collect(Collectors.toList());
    }

    private Collection<Operation> createPostOperations(Map<URI, Operation> failedOps, Map<Operation, Object> posts) {
        return failedOps.values().stream().map(o -> {
            Object newBody = posts.get(o);
            return Operation.createPost(o.getUri()).setBodyNoCloning(newBody).addPragmaDirective("xn-from-migration").addPragmaDirective("xn-force-index-update");
        }).collect(Collectors.toList());
    }

    private boolean verifyPatchedState(State state, Operation operation) {
        ArrayList errMsgs = new ArrayList();
        if (!errMsgs.isEmpty()) {
            operation.fail(new IllegalArgumentException(String.join((CharSequence)"\n", errMsgs)));
        }
        return errMsgs.isEmpty();
    }

    private State applyPatch(State patchState, State currentState) {
        Utils.mergeWithState(this.getStateDescription(), currentState, patchState);
        currentState.latestSourceUpdateTimeMicros = Math.max(Optional.ofNullable(currentState.latestSourceUpdateTimeMicros).orElse(0L), Optional.ofNullable(patchState.latestSourceUpdateTimeMicros).orElse(0L));
        return currentState;
    }

    private Object removeFactoryPathFromSelfLink(Object jsonObject, String factoryPath) {
        String selfLink = this.extractId(jsonObject, factoryPath);
        return Utils.toJson(Utils.setJsonProperty(jsonObject, "documentSelfLink", selfLink));
    }

    private String extractId(Object jsonObject, String factoryPath) {
        String selfLink = Utils.getJsonMapValue(jsonObject, "documentSelfLink", String.class);
        if (selfLink.startsWith(factoryPath)) {
            selfLink = selfLink.replaceFirst(factoryPath, "");
        }
        return selfLink;
    }

    private URI selectRandomUri(Collection<URI> uris) {
        int num = (int)(Math.random() * (double)uris.size());
        for (URI uri : uris) {
            if (--num >= 0) continue;
            return uri;
        }
        return null;
    }

    private String addSlash(String string) {
        if (string.endsWith("/")) {
            return string;
        }
        return string + "/";
    }

    private URI getNextPageLinkUri(Operation operation) {
        URI queryUri = operation.getUri();
        return UriUtils.buildUri(queryUri.getScheme(), queryUri.getHost(), queryUri.getPort(), operation.getBody(QueryTask.class).results.nextPageLink, null);
    }

    private URI getHostUri(Operation operation) {
        URI uri = operation.getUri();
        return UriUtils.buildUri(uri.getScheme(), uri.getHost(), uri.getPort(), null, null);
    }

    private void failTask(Throwable t) {
        State patch = new State();
        patch.taskInfo = TaskState.createAsFailed();
        patch.taskInfo.failure = Utils.toServiceErrorResponse(t);
        Operation.createPatch(this.getUri()).setBody(patch).sendWith(this);
    }

    private void failTask(Collection<Throwable> ts) {
        for (Throwable t : ts) {
            this.logWarning("%s", t);
        }
        this.failTask(ts.iterator().next());
    }

    private ServiceStats.ServiceStat getSingleBinTimeSeriesStat(String statName) {
        return ServiceStatUtils.getOrCreateTimeSeriesStat(this, statName, () -> new ServiceStats.TimeSeriesStats(1, Long.MAX_VALUE, EnumSet.of(ServiceStats.TimeSeriesStats.AggregationType.AVG, ServiceStats.TimeSeriesStats.AggregationType.MAX, ServiceStats.TimeSeriesStats.AggregationType.MIN, ServiceStats.TimeSeriesStats.AggregationType.LATEST)));
    }

    public static class TransformResponse {
        public Map<String, String> destinationLinks;
    }

    public static class TransformRequest {
        public String originalDocument;
        public String destinationLink;
    }

    public static class State
    extends ServiceDocument {
        public URI sourceNodeGroupReference;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public List<URI> sourceReferences = new ArrayList<URI>();
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String sourceFactoryLink;
        public URI destinationNodeGroupReference;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public List<URI> destinationReferences = new ArrayList<URI>();
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String destinationFactoryLink;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public String transformationServiceLink;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public QueryTask.QuerySpecification querySpec;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public TaskState taskInfo;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Long maintenanceIntervalMicros;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Integer maximumConvergenceChecks;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Boolean continuousMigration;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public EnumSet<MigrationOption> migrationOptions;
        public Long latestSourceUpdateTimeMicros = 0L;

        public String toString() {
            String stage = this.taskInfo != null && this.taskInfo.stage != null ? this.taskInfo.stage.name() : "null";
            return String.format("MigrationTaskService: [documentSelfLink=%s] [stage=%s] [sourceFactoryLink=%s]", this.documentSelfLink, stage, this.sourceFactoryLink);
        }
    }

    public static enum MigrationOption {
        CONTINUOUS,
        DELETE_AFTER,
        USE_TRANSFORM_REQUEST,
        ALL_VERSIONS,
        ESTIMATE_COUNT;

    }
}

