/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.services.common.AuthorizationCacheClearRequest;
import com.vmware.xenon.services.common.ServiceUriPaths;

public class AuthorizationTokenCacheService
extends StatefulService {
    public static final String SELF_LINK = ServiceUriPaths.CORE_AUTHZ_TOKEN_CACHE;

    public AuthorizationTokenCacheService() {
        super(AuthorizationTokenCacheServiceState.class);
    }

    @Override
    public void handlePatch(Operation patch) {
        AuthorizationTokenCacheServiceState state = (AuthorizationTokenCacheServiceState)this.getBody(patch);
        Operation postClearCacheRequest = Operation.createPost(this.getHost().getAuthorizationServiceUri()).setBody(AuthorizationCacheClearRequest.create(state.serviceLink)).setCompletion((clearOp, clearEx) -> {
            if (clearEx != null) {
                this.logSevere(clearEx);
                patch.fail(clearEx);
                return;
            }
            patch.complete();
        });
        postClearCacheRequest.addPragmaDirective("xn-clear-auth-cache");
        this.setAuthorizationContext(postClearCacheRequest, this.getSystemAuthorizationContext());
        this.sendRequest(postClearCacheRequest);
    }

    public static class AuthorizationTokenCacheServiceState
    extends ServiceDocument {
        public String serviceLink;
    }
}

