/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.ServiceHostLogService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;

class AsyncLogFileReader {
    private static final int CHUNK_SIZE = 4096;
    private AsynchronousFileChannel channel;
    private long chunks;
    private int maxLines;
    private int bufferPosition;
    private boolean skippedFirst;
    private ByteBuffer buffer;
    private byte[] remaining;
    private LinkedList<String> lines = new LinkedList();
    private String parentSelfLink;

    AsyncLogFileReader() {
    }

    public static AsyncLogFileReader create(String parentSelfLink) {
        AsyncLogFileReader r = new AsyncLogFileReader();
        r.parentSelfLink = parentSelfLink;
        return r;
    }

    public void start(Operation op, String file, int maxLines) throws IOException {
        this.channel = AsynchronousFileChannel.open(Paths.get(file, new String[0]), StandardOpenOption.READ);
        long size = this.channel.size();
        this.chunks = size / 4096L;
        this.maxLines = maxLines;
        int firstChunkSize = (int)(size % 4096L);
        if (firstChunkSize > 0) {
            ++this.chunks;
        } else {
            firstChunkSize = 4096;
        }
        this.read(op, firstChunkSize);
    }

    private void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
                this.channel = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void fail(Throwable e, Operation op) {
        this.close();
        op.fail(e);
    }

    private void complete(Operation op) {
        this.close();
        ServiceHostLogService.LogServiceState state = new ServiceHostLogService.LogServiceState();
        state.documentKind = Utils.buildKind(ServiceHostLogService.LogServiceState.class);
        state.documentSelfLink = this.parentSelfLink;
        state.items = this.lines;
        op.setBody(state).complete();
    }

    private void handleReadCompletion(Operation op) {
        try {
            String line;
            this.buffer.limit(this.buffer.capacity());
            if (this.remaining != null) {
                this.buffer.put(this.remaining);
            }
            this.bufferPosition = this.buffer.capacity() - 1;
            while ((line = this.readLine()) != null) {
                this.lines.addFirst(line);
                if (--this.maxLines > 0) continue;
                this.complete(op);
                return;
            }
            this.read(op, 4096);
        }
        catch (Exception e) {
            this.fail(e, op);
        }
    }

    private void read(final Operation op, int length) {
        if (this.chunks-- > 0L) {
            int capacity = length + (this.remaining != null ? this.remaining.length : 0);
            long offset = this.chunks * 4096L;
            this.buffer = ByteBuffer.allocate(capacity);
            this.buffer.limit(length);
            try {
                this.channel.read(this.buffer, offset, null, new CompletionHandler<Integer, Void>(){

                    @Override
                    public void completed(Integer result, Void notUsed) {
                        AsyncLogFileReader.this.handleReadCompletion(op);
                    }

                    @Override
                    public void failed(Throwable exc, Void notUsed) {
                        AsyncLogFileReader.this.fail(exc, op);
                    }
                });
            }
            catch (Exception e) {
                this.fail(e, op);
            }
        } else {
            this.complete(op);
        }
    }

    private String readLine() throws UnsupportedEncodingException {
        String line = null;
        int i = this.bufferPosition;
        byte[] data = this.buffer.array();
        while (i > -1) {
            if (data[i] == 10) {
                int offset = i + 1;
                int len = this.bufferPosition - offset + 1;
                this.bufferPosition = i - 1;
                if (!this.skippedFirst) {
                    this.skippedFirst = true;
                } else {
                    line = new String(data, offset, len, "UTF-8");
                    break;
                }
            }
            if (--i >= 0) continue;
            int len = this.bufferPosition + 1;
            if (len > 0) {
                this.remaining = new byte[len];
                System.arraycopy(data, 0, this.remaining, 0, len);
            } else {
                this.remaining = null;
            }
            this.bufferPosition = -1;
            break;
        }
        if (this.chunks == 0L && this.remaining != null) {
            line = new String(this.remaining, "UTF-8");
            this.remaining = null;
        }
        return line;
    }
}

