/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.vmware.xenon.common.serialization.TypeTokens;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public enum ObjectMapTypeConverter implements JsonSerializer<Map<String, Object>>,
JsonDeserializer<Map<String, Object>>
{
    INSTANCE;

    public static final Type TYPE;

    public JsonElement serialize(Map<String, Object> map, Type type, JsonSerializationContext context) {
        JsonObject mapObject = new JsonObject();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Object v = e.getValue();
            if (v instanceof JsonObject) {
                mapObject.add(e.getKey(), (JsonElement)((JsonObject)v));
                continue;
            }
            if (v instanceof String) {
                mapObject.add(e.getKey(), new JsonParser().parse((String)v));
                continue;
            }
            mapObject.add(e.getKey(), context.serialize(v));
        }
        return mapObject;
    }

    public Map<String, Object> deserialize(JsonElement json, Type unused, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expecting a json Map object but found: " + json);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonObject()) {
                result.put(key, element.toString());
                continue;
            }
            if (element.isJsonNull()) {
                result.put(key, null);
                continue;
            }
            if (element.isJsonPrimitive()) {
                result.put(key, element.getAsString());
                continue;
            }
            if (element.isJsonArray()) {
                result.put(key, element.getAsJsonArray().toString());
                continue;
            }
            throw new JsonParseException("The json element is not valid for key:" + key + " value:" + element);
        }
        return result;
    }

    static {
        TYPE = TypeTokens.MAP_OF_OBJECTS_BY_STRING;
    }
}

