/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.stream.JsonWriter;
import com.vmware.xenon.common.FNVHash;
import java.io.IOException;
import java.io.Writer;

public final class HashingJsonWriter
extends JsonWriter {
    private static final int BEG_ARRAY = 1;
    private static final int END_ARRAY = -1;
    private static final int BEG_OBJ = 2;
    private static final int END_OBJ = -2;
    private static final int NAME = 3;
    private static final int STRING = 4;
    private static final int NULL = 5;
    private static final int NUMBER = 6;
    private static final int BOOL = 7;
    private long hash;
    private static final Writer UNWRITABLE_WRITER = new Writer(){

        @Override
        public void write(char[] buffer, int offset, int counter) {
            throw new AssertionError();
        }

        @Override
        public void flush() throws IOException {
            throw new AssertionError();
        }

        @Override
        public void close() throws IOException {
            throw new AssertionError();
        }
    };

    public HashingJsonWriter(long hash) {
        super(UNWRITABLE_WRITER);
        this.setLenient(true);
        this.setSerializeNulls(false);
        this.hash = hash;
    }

    public JsonWriter beginArray() throws IOException {
        this.hash = FNVHash.compute(1, this.hash);
        return this;
    }

    public JsonWriter endArray() throws IOException {
        this.hash = FNVHash.compute(-1, this.hash);
        return this;
    }

    public JsonWriter beginObject() throws IOException {
        this.hash = FNVHash.compute(2, this.hash);
        return this;
    }

    public JsonWriter endObject() throws IOException {
        this.hash = FNVHash.compute(-2, this.hash);
        return this;
    }

    public JsonWriter name(String name) throws IOException {
        long h = this.hash;
        h = FNVHash.compute(3, h);
        this.hash = h = FNVHash.compute(name, h);
        return this;
    }

    public JsonWriter value(String value) throws IOException {
        long h = this.hash;
        h = FNVHash.compute(4, h);
        h = value != null ? FNVHash.compute(value, h) : FNVHash.compute(5, h);
        this.hash = h;
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        this.hash = FNVHash.compute(5, this.hash);
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        long h = this.hash;
        h = FNVHash.compute(7, h);
        this.hash = h = FNVHash.compute(Boolean.hashCode(value), h);
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        long h = this.hash;
        h = FNVHash.compute(6, h);
        long bits = Double.doubleToLongBits(value);
        h = FNVHash.compute((int)bits, h);
        this.hash = h = FNVHash.compute((int)(bits >> 32), h);
        return this;
    }

    public JsonWriter value(Boolean value) throws IOException {
        long h = this.hash;
        h = FNVHash.compute(7, h);
        h = value != null ? FNVHash.compute(Boolean.hashCode(value), h) : FNVHash.compute(5, h);
        this.hash = h;
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        long h = this.hash;
        h = FNVHash.compute(6, h);
        h = FNVHash.compute((int)value, h);
        this.hash = h = FNVHash.compute((int)(value >> 32), h);
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        long h = this.hash;
        h = FNVHash.compute(6, h);
        h = value != null ? FNVHash.compute(value.toString(), h) : FNVHash.compute(5, h);
        this.hash = h;
        return this;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public long getHash() {
        return this.hash;
    }
}

