/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.vmware.xenon.common.FNVHash;
import com.vmware.xenon.common.serialization.JsonMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class GsonSerializers {
    private static final JsonMapper JSON = new JsonMapper();
    private static final ConcurrentMap<Class<?>, JsonMapper> CUSTOM_JSON = new ConcurrentSkipListMap<Class, JsonMapper>(Comparator.comparingInt(c -> c.hashCode()).thenComparing(Class::getName));

    private GsonSerializers() {
    }

    public static JsonMapper getJsonMapperFor(Object instance) {
        if (instance == null) {
            return JSON;
        }
        return GsonSerializers.getJsonMapperFor(instance.getClass());
    }

    public static JsonMapper getJsonMapperFor(Class<?> type) {
        if (type.isArray() && type != byte[].class) {
            type = type.getComponentType();
        }
        return CUSTOM_JSON.getOrDefault(type, JSON);
    }

    public static JsonMapper getJsonMapperFor(Type type) {
        if (type instanceof Class) {
            return GsonSerializers.getJsonMapperFor((Class)type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return GsonSerializers.getJsonMapperFor(rawType);
        }
        return JSON;
    }

    public static void registerCustomJsonMapper(Class<?> clazz, JsonMapper mapper) {
        CUSTOM_JSON.putIfAbsent(clazz, mapper);
    }

    public static long hashJson(Object body, long hash) {
        if (body instanceof String) {
            return FNVHash.compute((String)body, hash);
        }
        JsonMapper mapper = GsonSerializers.getJsonMapperFor(body);
        return mapper.hashJson(body, hash);
    }
}

