/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vmware.xenon.common.ByteBufferInputStream;
import com.vmware.xenon.common.FNVHash;
import com.vmware.xenon.common.LocalizableValidationException;
import com.vmware.xenon.common.LocalizationUtil;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceConfiguration;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStateCollectionUpdateRequest;
import com.vmware.xenon.common.ServiceStateMapUpdateRequest;
import com.vmware.xenon.common.StringBuilderThreadLocal;
import com.vmware.xenon.common.SystemHostInfo;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.logging.StackAwareLogRecord;
import com.vmware.xenon.common.serialization.GsonSerializers;
import com.vmware.xenon.common.serialization.JsonMapper;
import com.vmware.xenon.common.serialization.KryoSerializers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class Utils {
    public static final String PROPERTY_NAME_PREFIX = "xenon.";
    public static final Charset CHARSET_OBJECT = StandardCharsets.UTF_8;
    public static final String CHARSET = "UTF-8";
    public static final String UI_DIRECTORY_NAME = "ui";
    public static final String PROPERTY_NAME_TIME_COMPARISON = "timeComparisonEpsilonMicros";
    public static final int DEFAULT_IO_THREAD_COUNT = Math.min(2, Runtime.getRuntime().availableProcessors());
    public static final int DEFAULT_THREAD_COUNT = Math.max(4, Runtime.getRuntime().availableProcessors());
    public static final long DEFAULT_TIME_DRIFT_THRESHOLD_MICROS = TimeUnit.SECONDS.toMicros(1L);
    private static final long PING_LAUNCH_TOLERANCE_MS = 50L;
    private static final ThreadLocal<CharsetDecoder> decodersPerThread = new ThreadLocal<CharsetDecoder>(){

        @Override
        public CharsetDecoder initialValue() {
            return CHARSET_OBJECT.newDecoder();
        }
    };
    private static final AtomicLong previousTimeValue = new AtomicLong();
    private static long timeComparisonEpsilon = Utils.initializeTimeEpsilon();
    private static long timeDriftThresholdMicros = DEFAULT_TIME_DRIFT_THRESHOLD_MICROS;
    private static final ConcurrentMap<String, String> KINDS = new ConcurrentSkipListMap<String, String>();
    private static final ConcurrentMap<String, Class<?>> KIND_TO_TYPE = new ConcurrentSkipListMap();
    private static final StringBuilderThreadLocal builderPerThread = new StringBuilderThreadLocal();

    private Utils() {
    }

    public static void registerCustomJsonMapper(Class<?> clazz, JsonMapper mapper) {
        GsonSerializers.registerCustomJsonMapper(clazz, mapper);
    }

    public static void registerCustomKryoSerializer(ThreadLocal<Kryo> kryoThreadLocal, boolean isDocumentSerializer) {
        KryoSerializers.register(kryoThreadLocal, isDocumentSerializer);
    }

    public static <T> T clone(T t) {
        return KryoSerializers.clone(t);
    }

    public static <T> T cloneObject(T t) {
        return KryoSerializers.cloneObject(t);
    }

    public static String computeSignature(ServiceDocument s, ServiceDocumentDescription description) {
        if (description == null) {
            throw new IllegalArgumentException("description is required");
        }
        long hash = 4695981039346656037L;
        block3: for (ServiceDocumentDescription.PropertyDescription pd : description.propertyDescriptions.values()) {
            if (pd.indexingOptions != null && pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.EXCLUDE_FROM_SIGNATURE)) continue;
            Object fieldValue = ReflectionUtils.getPropertyValue(pd, s);
            if (fieldValue == null) {
                hash = FNVHash.compute(-1, hash);
                continue;
            }
            switch (pd.typeName) {
                case BYTES: {
                    byte[] bytes = (byte[])fieldValue;
                    hash = FNVHash.compute(bytes, 0, bytes.length, hash);
                    continue block3;
                }
            }
            hash = GsonSerializers.hashJson(fieldValue, hash);
        }
        return Long.toHexString(hash);
    }

    public static byte[] getBuffer(int capacity) {
        return KryoSerializers.getBuffer(capacity);
    }

    public static int toBytes(Object o, byte[] buffer, int position) {
        return KryoSerializers.serializeObject(o, buffer, position);
    }

    public static Object fromBytes(byte[] bytes) {
        return KryoSerializers.deserializeObject(bytes, 0, bytes.length);
    }

    public static Object fromBytes(byte[] bytes, int position, int length) {
        return KryoSerializers.deserializeObject(bytes, position, length);
    }

    public static ServiceDocument fromQueryBinaryDocument(String link, Object binaryData) {
        ServiceDocument serviceDocument = (ServiceDocument)KryoSerializers.deserializeDocument((ByteBuffer)binaryData);
        if (serviceDocument.documentSelfLink == null) {
            serviceDocument.documentSelfLink = link;
        }
        if (serviceDocument.documentKind == null) {
            serviceDocument.documentKind = Utils.buildKind(serviceDocument.getClass());
        }
        return serviceDocument;
    }

    public static void performMaintenance() {
    }

    public static String computeHash(CharSequence content) {
        return Long.toHexString(FNVHash.compute(content));
    }

    public static String toJson(Object body) {
        if (body instanceof String) {
            return (String)body;
        }
        StringBuilder content = Utils.getBuilder();
        JsonMapper mapper = GsonSerializers.getJsonMapperFor(body);
        mapper.toJson(body, content);
        return content.toString();
    }

    public static String toJsonHtml(Object body) {
        if (body instanceof String) {
            return (String)body;
        }
        StringBuilder content = Utils.getBuilder();
        JsonMapper mapper = GsonSerializers.getJsonMapperFor(body);
        mapper.toJsonHtml(body, content);
        return content.toString();
    }

    public static String toJson(boolean hideSensitiveFields, boolean useHtmlFormatting, Object body) throws IllegalArgumentException {
        if (body instanceof String) {
            if (hideSensitiveFields) {
                throw new IllegalArgumentException("Body is already a string, sensitive fields cannot be discovered");
            }
            return (String)body;
        }
        StringBuilder content = Utils.getBuilder();
        JsonMapper mapper = GsonSerializers.getJsonMapperFor(body);
        mapper.toJson(hideSensitiveFields, useHtmlFormatting, body, content);
        return content.toString();
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return GsonSerializers.getJsonMapperFor(clazz).fromJson((Object)json, clazz);
    }

    public static <T> T fromJson(Object json, Class<T> clazz) {
        return GsonSerializers.getJsonMapperFor(clazz).fromJson(json, clazz);
    }

    public static <T> T fromJson(Object json, Type type) {
        return GsonSerializers.getJsonMapperFor(type).fromJson(json, type);
    }

    public static <T> T getJsonMapValue(Object json, String key, Class<T> valueClazz) {
        JsonElement je = Utils.fromJson(json, JsonElement.class);
        if ((je = je.getAsJsonObject().get(key)) == null) {
            return null;
        }
        return Utils.fromJson((Object)je, valueClazz);
    }

    public static <T> T getJsonMapValue(Object json, String key, Type valueType) {
        JsonElement je = Utils.fromJson(json, JsonElement.class);
        if ((je = je.getAsJsonObject().get(key)) == null) {
            return null;
        }
        return Utils.fromJson((Object)je, valueType);
    }

    public static String toString(Throwable t) {
        StringWriter writer = new StringWriter();
        try (PrintWriter printer = new PrintWriter(writer);){
            t.printStackTrace(printer);
        }
        return writer.toString();
    }

    public static String toString(Map<?, Throwable> exceptions) {
        StringWriter writer = new StringWriter();
        try (PrintWriter printer = new PrintWriter(writer);){
            for (Throwable t : exceptions.values()) {
                t.printStackTrace(printer);
            }
        }
        return writer.toString();
    }

    public static void log(Class<?> type, String classOrUri, Level level, String fmt, Object ... args) {
        Logger lg = Logger.getLogger(type.getName());
        Utils.log(lg, 3, classOrUri, level, () -> String.format(fmt, args));
    }

    public static void log(Class<?> type, String classOrUri, Level level, Supplier<String> messageSupplier) {
        Logger lg = Logger.getLogger(type.getName());
        Utils.log(lg, 3, classOrUri, level, messageSupplier);
    }

    public static void log(Logger lg, Integer nestingLevel, String classOrUri, Level level, String fmt, Object ... args) {
        Utils.log(lg, nestingLevel, classOrUri, level, () -> String.format(fmt, args));
    }

    public static void log(Logger lg, Integer nestingLevel, String classOrUri, Level level, Supplier<String> messageSupplier) {
        if (!lg.isLoggable(level)) {
            return;
        }
        if (nestingLevel == null) {
            nestingLevel = 2;
        }
        String message = messageSupplier.get();
        StackAwareLogRecord lr = new StackAwareLogRecord(level, message);
        Exception e = new Exception();
        StackTraceElement[] stacks = e.getStackTrace();
        if (stacks.length > nestingLevel) {
            StackTraceElement stack = stacks[nestingLevel];
            lr.setStackElement(stack);
            lr.setSourceMethodName(stack.getMethodName());
        }
        lr.setSourceClassName(classOrUri);
        lr.setLoggerName(lg.getName());
        lg.log(lr);
    }

    public static void logWarning(String fmt, Object ... args) {
        Logger.getAnonymousLogger().warning(String.format(fmt, args));
    }

    public static String toDocumentKind(Class<?> type) {
        return type.getCanonicalName().replace('.', ':');
    }

    public static String fromDocumentKind(String kind) {
        return kind.replace(':', '.');
    }

    public static String registerKind(Class<?> type, String kind) {
        KIND_TO_TYPE.put(kind, type);
        return KINDS.put(type.getName(), kind);
    }

    public static Class<?> getTypeFromKind(String kind) {
        return (Class)KIND_TO_TYPE.get(kind);
    }

    public static String buildKind(Class<?> type) {
        return KINDS.computeIfAbsent(type.getName(), name -> Utils.toDocumentKind(type));
    }

    public static ServiceErrorResponse toServiceErrorResponse(Throwable e) {
        return ServiceErrorResponse.create(e, 400);
    }

    public static ServiceErrorResponse toValidationErrorResponse(Throwable t, Operation op) {
        String localizedMessage;
        ServiceErrorResponse rsp = new ServiceErrorResponse();
        rsp.message = t instanceof LocalizableValidationException ? (localizedMessage = LocalizationUtil.resolveMessage((LocalizableValidationException)t, op)) : t.getLocalizedMessage();
        return rsp;
    }

    public static boolean isValidationError(Throwable e) {
        return e instanceof IllegalArgumentException || e instanceof LocalizableValidationException;
    }

    public static String buildServicePath(Class<? extends Service> klass) {
        return klass.getName().replace('.', '/');
    }

    public static String buildUiResourceUriPrefixPath(Class<? extends Service> klass) {
        return UriUtils.buildUriPath("/user-interface/resources", Utils.buildServicePath(klass));
    }

    public static String buildUiResourceUriPrefixPath(Service service) {
        return Utils.buildUiResourceUriPrefixPath(service.getClass());
    }

    public static String buildCustomUiResourceUriPrefixPath(Service service) {
        return UriUtils.buildUriPath("/user-interface/resources", service.getDocumentTemplate().documentDescription.userInterfaceResourcePath);
    }

    public static Object setJsonProperty(Object body, String fieldName, String fieldValue) {
        JsonObject jo = body instanceof JsonObject ? (JsonObject)body : new JsonParser().parse((String)body).getAsJsonObject();
        jo.remove(fieldName);
        if (fieldValue != null) {
            jo.addProperty(fieldName, fieldValue);
        }
        return jo;
    }

    public static String validateServiceOption(EnumSet<Service.ServiceOption> options, Service.ServiceOption option) {
        Object error;
        if (!options.contains((Object)option)) {
            return null;
        }
        EnumSet<Service.ServiceOption> reqs = EnumSet.noneOf(Service.ServiceOption.class);
        EnumSet<Service.ServiceOption> antiReqs = EnumSet.noneOf(Service.ServiceOption.class);
        switch (option) {
            case CONCURRENT_UPDATE_HANDLING: {
                antiReqs = EnumSet.of(Service.ServiceOption.OWNER_SELECTION, Service.ServiceOption.STRICT_UPDATE_CHECKING);
                break;
            }
            case OWNER_SELECTION: {
                reqs = EnumSet.of(Service.ServiceOption.REPLICATION);
                antiReqs = EnumSet.of(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING);
                break;
            }
            case STRICT_UPDATE_CHECKING: {
                antiReqs = EnumSet.of(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING);
                break;
            }
            case URI_NAMESPACE_OWNER: {
                antiReqs = EnumSet.of(Service.ServiceOption.PERSISTENCE, Service.ServiceOption.REPLICATION);
                break;
            }
            case PERIODIC_MAINTENANCE: {
                antiReqs = EnumSet.of(Service.ServiceOption.ON_DEMAND_LOAD, Service.ServiceOption.IMMUTABLE);
                break;
            }
            case PERSISTENCE: {
                break;
            }
            case REPLICATION: {
                break;
            }
            case DOCUMENT_OWNER: {
                break;
            }
            case IDEMPOTENT_POST: {
                break;
            }
            case CORE: {
                break;
            }
            case FACTORY: {
                break;
            }
            case FACTORY_ITEM: {
                break;
            }
            case HTML_USER_INTERFACE: {
                break;
            }
            case INSTRUMENTATION: {
                antiReqs = EnumSet.of(Service.ServiceOption.IMMUTABLE);
                break;
            }
            case LIFO_QUEUE: {
                break;
            }
            case NONE: {
                break;
            }
            case UTILITY: {
                break;
            }
            case ON_DEMAND_LOAD: {
                if (!options.contains((Object)Service.ServiceOption.FACTORY)) {
                    reqs = EnumSet.of(Service.ServiceOption.PERSISTENCE);
                }
                antiReqs = EnumSet.of(Service.ServiceOption.PERIODIC_MAINTENANCE);
                break;
            }
            case IMMUTABLE: {
                reqs = EnumSet.of(Service.ServiceOption.ON_DEMAND_LOAD, Service.ServiceOption.PERSISTENCE);
                antiReqs = EnumSet.of(Service.ServiceOption.PERIODIC_MAINTENANCE, Service.ServiceOption.INSTRUMENTATION);
                break;
            }
            case TRANSACTION_PENDING: {
                break;
            }
            case STATELESS: {
                antiReqs = EnumSet.of(Service.ServiceOption.PERSISTENCE, Service.ServiceOption.REPLICATION, Service.ServiceOption.OWNER_SELECTION, Service.ServiceOption.STRICT_UPDATE_CHECKING);
                break;
            }
        }
        if (reqs.isEmpty() && antiReqs.isEmpty()) {
            return null;
        }
        if (!reqs.isEmpty()) {
            EnumSet<Service.ServiceOption> missingReqs = EnumSet.noneOf(Service.ServiceOption.class);
            for (Service.ServiceOption r : reqs) {
                if (options.contains((Object)r)) continue;
                missingReqs.add(r);
            }
            if (!missingReqs.isEmpty()) {
                error = String.format("%s missing required options: %s", new Object[]{option, missingReqs});
                return error;
            }
        }
        EnumSet<Service.ServiceOption> conflictReqs = EnumSet.noneOf(Service.ServiceOption.class);
        for (Service.ServiceOption r : antiReqs) {
            if (!options.contains((Object)r)) continue;
            conflictReqs.add(r);
        }
        if (!conflictReqs.isEmpty()) {
            error = String.format("%s conflicts with options: %s", new Object[]{option, conflictReqs});
            return error;
        }
        return null;
    }

    static boolean validateServiceOptions(ServiceHost host, Service service, Operation post) {
        for (Service.ServiceOption o : service.getOptions()) {
            String error = Utils.validateServiceOption(service.getOptions(), o);
            if (error == null) continue;
            host.log(Level.WARNING, "%s", error);
            post.fail(new IllegalArgumentException(error));
            return false;
        }
        if (service.getMaintenanceIntervalMicros() > 0L && service.getMaintenanceIntervalMicros() < host.getMaintenanceCheckIntervalMicros()) {
            host.setMaintenanceCheckIntervalMicros(service.getMaintenanceIntervalMicros());
        }
        return true;
    }

    public static boolean isReachable(SystemHostInfo systemInfo, InetAddress addr, long timeoutMs) throws IOException {
        if (systemInfo.osFamily == SystemHostInfo.OsFamily.WINDOWS) {
            return Utils.isReachableByPing(systemInfo, addr, timeoutMs);
        }
        return addr.isReachable((int)timeoutMs);
    }

    public static boolean isReachableByPing(SystemHostInfo systemInfo, InetAddress addr, long timeoutMs) throws IOException {
        try {
            Process process = new ProcessBuilder("ping", "-n", "1", "-w", Long.toString(timeoutMs), Utils.getNormalizedHostAddress(systemInfo, addr)).start();
            boolean completed = process.waitFor(50L + timeoutMs, TimeUnit.MILLISECONDS);
            return completed && process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static String getNormalizedHostAddress(SystemHostInfo systemInfo, InetAddress addr) {
        String addrStr = addr.getHostAddress();
        if (systemInfo.osFamily == SystemHostInfo.OsFamily.WINDOWS && addr instanceof Inet6Address && addr.isLinkLocalAddress()) {
            Inet6Address ip6Addr = (Inet6Address)addr;
            int pct = addrStr.lastIndexOf(37);
            if (pct > -1) {
                addrStr = addrStr.substring(0, pct) + '%' + ip6Addr.getScopeId();
            }
        }
        return addrStr;
    }

    public static void encodeAndTransferLinkedStateToBody(Operation source, Operation target, boolean useBinary) {
        if (useBinary && source.getAction() != Service.Action.POST) {
            try {
                byte[] encodedBody = Utils.encodeBody(source, source.getLinkedState(), "application/kryo-octet-stream", true);
                source.linkSerializedState(encodedBody);
            }
            catch (Exception e2) {
                Utils.logWarning("Failure binary serializing, will fallback to JSON: %s", Utils.toString(e2));
            }
        }
        if (!source.hasLinkedSerializedState()) {
            target.setContentType("application/json");
            target.setBodyNoCloning(Utils.toJson(source.getLinkedState()));
        } else {
            target.setContentType("application/kryo-octet-stream");
            target.setBodyNoCloning(source.getLinkedSerializedState());
        }
    }

    public static byte[] encodeBody(Operation op, boolean isRequest) throws Exception {
        return Utils.encodeBody(op, op.getBodyRaw(), op.getContentType(), isRequest);
    }

    public static byte[] encodeBody(Operation op, Object body, String contentType, boolean isRequest) throws Exception {
        String encodingHeader;
        String encoding;
        if (body == null) {
            op.setContentLength(0L);
            return null;
        }
        byte[] data = null;
        if (body instanceof String) {
            data = ((String)body).getBytes(CHARSET);
            op.setContentLength(data.length);
        } else if (body instanceof byte[]) {
            data = (byte[])body;
            if (contentType == null) {
                op.setContentType("application/octet-stream");
            }
            if (op.getContentLength() == 0L || op.getContentLength() > (long)data.length) {
                op.setContentLength(data.length);
            }
        } else if ("application/kryo-octet-stream".equals(contentType)) {
            Output o = KryoSerializers.serializeAsDocument(body, ServiceClient.MAX_BINARY_SERIALIZED_BODY_LIMIT);
            data = o.toBytes();
            op.setContentLength(data.length);
        }
        if (data == null) {
            String encodedBody = Utils.toJson(body);
            if (op.getAction() != Service.Action.GET && contentType == null) {
                op.setContentType("application/json");
            }
            data = encodedBody.getBytes(CHARSET);
            op.setContentLength(data.length);
        }
        if ("gzip".equals(encoding = op.getRequestHeaderAsIs(encodingHeader = isRequest ? "content-encoding" : "accept-encoding"))) {
            data = Utils.compressGZip(data);
            op.setContentLength(data.length);
            if (!isRequest) {
                op.addResponseHeader("content-encoding", "gzip");
            }
        }
        return data;
    }

    private static byte[] compressGZip(byte[] input) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream zos = new GZIPOutputStream(out);){
            zos.write(input, 0, input.length);
        }
        return out.toByteArray();
    }

    public static void decodeBody(Operation op, ByteBuffer buffer, boolean isRequest) throws Exception {
        String contentEncodingHeader = null;
        if (!isRequest) {
            contentEncodingHeader = op.getResponseHeaderAsIs("content-encoding");
        } else if (!op.isFromReplication()) {
            contentEncodingHeader = op.getRequestHeaderAsIs("content-encoding");
        }
        boolean compressed = false;
        if (contentEncodingHeader != null) {
            compressed = "gzip".equals(contentEncodingHeader);
        }
        Utils.decodeBody(op, buffer, isRequest, compressed);
    }

    public static void decodeBody(Operation op, ByteBuffer buffer, boolean isRequest, boolean compressed) throws Exception {
        String contentType;
        boolean isKryoBinary;
        if (op.getContentLength() == 0L) {
            op.setContentType("application/json");
            return;
        }
        if (compressed) {
            buffer = Utils.decompressGZip(buffer);
            if (isRequest) {
                op.getRequestHeaders().remove("content-encoding");
            } else {
                op.getResponseHeaders().remove("content-encoding");
            }
        }
        if (isKryoBinary = Utils.isContentTypeKryoBinary(contentType = op.getContentType())) {
            byte[] data = new byte[(int)op.getContentLength()];
            buffer.get(data);
            Object body = KryoSerializers.deserializeDocument(data, 0, data.length);
            if (op.isFromReplication()) {
                op.linkSerializedState(data);
            }
            op.setBodyNoCloning(body);
            return;
        }
        String body = Utils.decodeIfText(buffer, contentType);
        if (body != null) {
            op.setBodyNoCloning(body);
            return;
        }
        byte[] data = new byte[(int)op.getContentLength()];
        buffer.get(data);
        op.setBodyNoCloning(data);
    }

    public static String decodeIfText(ByteBuffer buffer, String contentType) throws CharacterCodingException {
        if (contentType == null) {
            return null;
        }
        String body = null;
        if (Utils.isContentTypeText(contentType)) {
            CharsetDecoder decoder = decodersPerThread.get().reset();
            body = decoder.decode(buffer).toString();
        } else if (contentType.contains("application/x-www-form-urlencoded")) {
            CharsetDecoder decoder = decodersPerThread.get().reset();
            body = decoder.decode(buffer).toString();
            try {
                body = URLDecoder.decode(body, CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer decompressGZip(ByteBuffer bb) throws Exception {
        GZIPInputStream zis = new GZIPInputStream(new ByteBufferInputStream(bb));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = Utils.getBuffer(1024);
            while ((len = zis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            zis.close();
            out.close();
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    public static ByteBuffer compressGZip(String text) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream zos = new GZIPOutputStream(out);){
            byte[] bytes = text.getBytes(CHARSET);
            zos.write(bytes, 0, bytes.length);
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    public static boolean isContentTypeKryoBinary(String contentType) {
        return contentType.length() == "application/kryo-octet-stream".length() && contentType.charAt(12) == 'k' && contentType.charAt(13) == 'r' && contentType.charAt(14) == 'y' && contentType.charAt(15) == 'o';
    }

    private static boolean isContentTypeText(String contentType) {
        return "application/json".equals(contentType) || contentType.contains("application/json") || contentType.contains("text") || contentType.contains("css") || contentType.contains("script") || contentType.contains("html") || contentType.contains("xml") || contentType.contains("yaml") || contentType.contains("yml");
    }

    public static Path getServiceUiResourcePath(Service s) {
        ServiceDocument sd = s.getDocumentTemplate();
        ServiceDocumentDescription sdd = sd.documentDescription;
        if (sdd != null && sdd.userInterfaceResourcePath != null) {
            String resourcePath = sdd.userInterfaceResourcePath;
            if (!resourcePath.isEmpty()) {
                return Paths.get(resourcePath, new String[0]);
            }
        } else {
            String servicePath = Utils.buildServicePath(s.getClass());
            return Paths.get(UI_DIRECTORY_NAME, servicePath);
        }
        Utils.log(Utils.class, Utils.class.getSimpleName(), Level.SEVERE, "UserInterface resource path field empty for service document %s", s.getClass().getSimpleName());
        return null;
    }

    public static <T extends ServiceDocument> boolean mergeWithState(ServiceDocumentDescription desc, T source, T patch) {
        Class<?> clazz = source.getClass();
        if (!patch.getClass().equals(clazz)) {
            throw new IllegalArgumentException("Source object and patch object types mismatch");
        }
        boolean modified = false;
        for (ServiceDocumentDescription.PropertyDescription prop : desc.propertyDescriptions.values()) {
            Object o;
            if (prop.usageOptions == null || !prop.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL) || (o = ReflectionUtils.getPropertyValue(prop, patch)) == null || "documentExpirationTimeMicros".equals(prop.accessor.getName()) && Long.valueOf(0L).equals(o)) continue;
            if (prop.typeName == ServiceDocumentDescription.TypeName.COLLECTION && !o.getClass().isArray() || prop.typeName == ServiceDocumentDescription.TypeName.MAP) {
                modified |= ReflectionUtils.setOrUpdatePropertyValue(prop, source, o);
                continue;
            }
            if (o.equals(ReflectionUtils.getPropertyValue(prop, source))) continue;
            ReflectionUtils.setPropertyValue(prop, source, o);
            modified = true;
        }
        return modified;
    }

    public static <T extends ServiceDocument> boolean mergeWithState(T currentState, Operation op) throws NoSuchFieldException, IllegalAccessException {
        ServiceStateCollectionUpdateRequest collectionUpdateRequest = op.getBody(ServiceStateCollectionUpdateRequest.class);
        if (ServiceStateCollectionUpdateRequest.KIND.equals(collectionUpdateRequest.kind)) {
            Utils.updateCollections(currentState, collectionUpdateRequest);
            return true;
        }
        ServiceStateMapUpdateRequest mapUpdateRequest = op.getBody(ServiceStateMapUpdateRequest.class);
        if (ServiceStateMapUpdateRequest.KIND.equals(mapUpdateRequest.kind)) {
            Utils.updateMaps(currentState, mapUpdateRequest);
            return true;
        }
        return false;
    }

    public static <T extends ServiceDocument> EnumSet<MergeResult> mergeWithStateAdvanced(ServiceDocumentDescription desc, T currentState, Class<T> type, Operation op) throws NoSuchFieldException, IllegalAccessException {
        EnumSet<MergeResult> result = EnumSet.noneOf(MergeResult.class);
        ServiceStateCollectionUpdateRequest requestBody = op.getBody(ServiceStateCollectionUpdateRequest.class);
        if (ServiceStateCollectionUpdateRequest.KIND.equals(requestBody.kind)) {
            result.add(MergeResult.SPECIAL_MERGE);
            if (Utils.updateCollections(currentState, requestBody)) {
                result.add(MergeResult.STATE_CHANGED);
            }
            return result;
        }
        ServiceStateMapUpdateRequest mapUpdateRequest = op.getBody(ServiceStateMapUpdateRequest.class);
        if (ServiceStateMapUpdateRequest.KIND.equals(mapUpdateRequest.kind)) {
            result.add(MergeResult.SPECIAL_MERGE);
            if (Utils.updateMaps(currentState, mapUpdateRequest)) {
                result.add(MergeResult.STATE_CHANGED);
            }
            return result;
        }
        ServiceDocument patchState = (ServiceDocument)op.getBody(type);
        if (Utils.mergeWithState(desc, currentState, patchState)) {
            result.add(MergeResult.STATE_CHANGED);
        }
        return result;
    }

    public static <T extends ServiceDocument> void validateState(ServiceDocumentDescription desc, T state) {
        for (ServiceDocumentDescription.PropertyDescription prop : desc.propertyDescriptions.values()) {
            Object o;
            if (prop.usageOptions == null || !prop.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.REQUIRED) || (o = ReflectionUtils.getPropertyValue(prop, state)) != null) continue;
            if (prop.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.ID)) {
                ReflectionUtils.setPropertyValue(prop, state, UUID.randomUUID().toString());
                continue;
            }
            throw new IllegalArgumentException(prop.accessor.getName() + " is a required field.");
        }
    }

    private static long initializeTimeEpsilon() {
        return Long.getLong("xenon.timeComparisonEpsilonMicros", ServiceHost.ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS);
    }

    public static long fromNowMicrosUtc(long deltaMicros) {
        return Utils.getSystemNowMicrosUtc() + deltaMicros;
    }

    public static boolean beforeNow(long microsUtc) {
        return Utils.getSystemNowMicrosUtc() >= microsUtc;
    }

    public static long getSystemNowMicrosUtc() {
        return System.currentTimeMillis() * 1000L;
    }

    public static long getNowMicrosUtc() {
        long time;
        long now = System.currentTimeMillis() * 1000L;
        if (now > (time = previousTimeValue.getAndIncrement())) {
            previousTimeValue.compareAndSet(time + 1L, now);
            return previousTimeValue.getAndIncrement();
        }
        if (time - now > timeDriftThresholdMicros) {
            throw new IllegalStateException("Time drift is " + (time - now));
        }
        return time;
    }

    public static void setTimeDriftThreshold(long micros) {
        timeDriftThresholdMicros = micros;
        previousTimeValue.set(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()));
    }

    public static void resetTimeComparisonEpsilonMicros() {
        timeComparisonEpsilon = Utils.initializeTimeEpsilon();
    }

    public static void setTimeComparisonEpsilonMicros(long micros) {
        timeComparisonEpsilon = micros;
    }

    public static long getTimeComparisonEpsilonMicros() {
        return timeComparisonEpsilon;
    }

    public static boolean isWithinTimeComparisonEpsilon(long timeMicros) {
        return Math.abs(timeMicros - Utils.getSystemNowMicrosUtc()) < timeComparisonEpsilon;
    }

    static StringBuilder getBuilder() {
        return builderPerThread.get();
    }

    public static <T extends ServiceDocument> boolean updateCollections(T currentState, ServiceStateCollectionUpdateRequest patchBody) throws NoSuchFieldException, IllegalAccessException {
        boolean hasChanged = false;
        if (patchBody.itemsToRemove != null) {
            for (Map.Entry<String, Collection<Object>> collectionItem : patchBody.itemsToRemove.entrySet()) {
                hasChanged |= Utils.processCollection(collectionItem.getValue(), collectionItem.getKey(), currentState, CollectionOperation.REMOVE);
            }
        }
        if (patchBody.itemsToAdd != null) {
            for (Map.Entry<String, Collection<Object>> collectionItem : patchBody.itemsToAdd.entrySet()) {
                hasChanged |= Utils.processCollection(collectionItem.getValue(), collectionItem.getKey(), currentState, CollectionOperation.ADD);
            }
        }
        return hasChanged;
    }

    public static <T extends ServiceDocument> boolean updateMaps(T currentState, ServiceStateMapUpdateRequest patchBody) throws NoSuchFieldException, IllegalAccessException {
        boolean hasChanged = false;
        if (patchBody.keysToRemove != null) {
            for (Map.Entry<String, Object> entry : patchBody.keysToRemove.entrySet()) {
                hasChanged |= Utils.processMapKeyRemoval((Collection)entry.getValue(), entry.getKey(), currentState);
            }
        }
        if (patchBody.entriesToAdd != null) {
            for (Map.Entry<String, Object> entry : patchBody.entriesToAdd.entrySet()) {
                hasChanged |= Utils.processMapEntryAddition((Map)entry.getValue(), entry.getKey(), currentState);
            }
        }
        return hasChanged;
    }

    private static <T extends ServiceDocument> boolean processCollection(Collection<Object> inputCollection, String collectionName, T currentState, CollectionOperation operation) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz;
        Field field;
        boolean hasChanged = false;
        if (inputCollection != null && !inputCollection.isEmpty() && (field = (clazz = currentState.getClass()).getField(collectionName)) != null && Collection.class.isAssignableFrom(field.getType())) {
            Collection collObj = (Collection)field.get(currentState);
            switch (operation) {
                case ADD: {
                    if (collObj == null) {
                        hasChanged = ReflectionUtils.setOrInstantiateCollectionField(currentState, field, inputCollection);
                        break;
                    }
                    hasChanged = collObj.addAll(inputCollection);
                    break;
                }
                case REMOVE: {
                    if (collObj == null) break;
                    hasChanged = collObj.removeAll(inputCollection);
                    break;
                }
            }
        }
        return hasChanged;
    }

    private static <T extends ServiceDocument> boolean processMapKeyRemoval(Collection<Object> keysToRemove, String mapName, T currentState) throws NoSuchFieldException, IllegalAccessException {
        Map mapObj;
        Class<?> clazz;
        Field field;
        boolean hasChanged = false;
        if (keysToRemove != null && !keysToRemove.isEmpty() && (field = (clazz = currentState.getClass()).getField(mapName)) != null && Map.class.isAssignableFrom(field.getType()) && (mapObj = (Map)field.get(currentState)) != null) {
            for (Object key : keysToRemove) {
                hasChanged |= mapObj.remove(key) != null;
            }
        }
        return hasChanged;
    }

    private static <T extends ServiceDocument> boolean processMapEntryAddition(Map<Object, Object> entriesToAdd, String mapName, T currentState) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz;
        Field field;
        boolean hasChanged = false;
        if (entriesToAdd != null && !entriesToAdd.isEmpty() && (field = (clazz = currentState.getClass()).getField(mapName)) != null && Map.class.isAssignableFrom(field.getType())) {
            Map mapObj = (Map)field.get(currentState);
            if (mapObj == null) {
                field.set(currentState, entriesToAdd);
                hasChanged = true;
            } else {
                for (Map.Entry<Object, Object> entry : entriesToAdd.entrySet()) {
                    Object oldValue = mapObj.put(entry.getKey(), entry.getValue());
                    if (oldValue == null) {
                        hasChanged |= entry.getValue() != null;
                        continue;
                    }
                    hasChanged |= !oldValue.equals(entry.getValue());
                }
            }
        }
        return hasChanged;
    }

    public static String buildUUID(String id) {
        return Utils.getBuilder().append(id).append(Long.toHexString(Utils.getNowMicrosUtc())).toString();
    }

    public static <T extends ServiceConfiguration> T buildServiceConfig(T config, Service service) {
        ServiceDocumentDescription desc = service.getHost().buildDocumentDescription(service);
        config.options = service.getOptions();
        config.maintenanceIntervalMicros = service.getMaintenanceIntervalMicros();
        config.versionRetentionLimit = desc.versionRetentionLimit;
        config.versionRetentionFloor = desc.versionRetentionFloor;
        config.peerNodeSelectorPath = service.getPeerNodeSelectorPath();
        config.documentIndexPath = service.getDocumentIndexPath();
        return config;
    }

    private static enum CollectionOperation {
        ADD,
        REMOVE;

    }

    public static enum MergeResult {
        SPECIAL_MERGE,
        STATE_CHANGED;

    }
}

