/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceStats;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class ServiceStatUtils {
    private ServiceStatUtils() {
    }

    public static ServiceStats.ServiceStat getOrCreateHistogramStat(Service service, String name) {
        return ServiceStatUtils.getOrCreateStat(service, name, true, null);
    }

    public static ServiceStats.TimeSeriesStats createHourlyTimeSeriesStat(EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        return new ServiceStats.TimeSeriesStats((int)TimeUnit.HOURS.toMinutes(1L), TimeUnit.MINUTES.toMillis(1L), aggregationTypes);
    }

    public static ServiceStats.TimeSeriesStats createDailyTimeSeriesStat(EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        return new ServiceStats.TimeSeriesStats((int)TimeUnit.DAYS.toHours(1L), TimeUnit.HOURS.toMillis(1L), aggregationTypes);
    }

    public static ServiceStats.ServiceStat getOrCreateHourlyTimeSeriesStat(Service service, String prefix, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        String statName = prefix + "PerHour";
        return ServiceStatUtils.getOrCreateStat(service, statName, false, () -> ServiceStatUtils.createHourlyTimeSeriesStat(aggregationTypes));
    }

    public static ServiceStats.ServiceStat getOrCreateDailyTimeSeriesStat(Service service, String prefix, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        String statName = prefix + "PerDay";
        return ServiceStatUtils.getOrCreateStat(service, statName, false, () -> ServiceStatUtils.createDailyTimeSeriesStat(aggregationTypes));
    }

    public static ServiceStats.ServiceStat getOrCreateHourlyTimeSeriesHistogramStat(Service service, String prefix, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        String statName = prefix + "PerHour";
        return ServiceStatUtils.getOrCreateStat(service, statName, true, () -> ServiceStatUtils.createHourlyTimeSeriesStat(aggregationTypes));
    }

    public static ServiceStats.ServiceStat getOrCreateDailyTimeSeriesHistogramStat(Service service, String prefix, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationTypes) {
        String statName = prefix + "PerDay";
        return ServiceStatUtils.getOrCreateStat(service, statName, true, () -> ServiceStatUtils.createDailyTimeSeriesStat(aggregationTypes));
    }

    public static ServiceStats.ServiceStat getOrCreateTimeSeriesStat(Service service, String name, Supplier<ServiceStats.TimeSeriesStats> timeSeriesStatsSupplier) {
        return ServiceStatUtils.getOrCreateStat(service, name, false, timeSeriesStatsSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceStats.ServiceStat getOrCreateStat(Service service, String name, boolean createHistogram, Supplier<ServiceStats.TimeSeriesStats> timeSeriesStatsSupplier) {
        ServiceStats.ServiceStat stat;
        if (!service.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return null;
        }
        ServiceStats.ServiceStat serviceStat = stat = service.getStat(name);
        synchronized (serviceStat) {
            if (stat.logHistogram == null && createHistogram) {
                stat.logHistogram = new ServiceStats.ServiceStatLogHistogram();
            }
            if (stat.timeSeriesStats == null && timeSeriesStatsSupplier != null) {
                stat.timeSeriesStats = timeSeriesStatsSupplier.get();
            }
        }
        return stat;
    }
}

