/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ODataToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ODataTokenList
implements Iterator<ODataToken> {
    private ArrayList<ODataToken> tokens = new ArrayList();
    private int currentODataToken = 0;

    public void appendODataToken(int position, ODataToken.ODataTokenKind kind, String uriLiteral) {
        ODataToken token = new ODataToken(kind, position, uriLiteral);
        this.tokens.add(token);
    }

    public void appendODataToken(int position, ODataToken.ODataTokenKind kind, char charValue) {
        ODataToken token = new ODataToken(kind, position, Character.toString(charValue));
        this.tokens.add(token);
    }

    public ODataToken lookToken() {
        if (this.currentODataToken >= this.tokens.size()) {
            throw new NoSuchElementException();
        }
        return this.tokens.get(this.currentODataToken);
    }

    @Override
    public ODataToken next() {
        if (this.currentODataToken >= this.tokens.size()) {
            throw new NoSuchElementException();
        }
        ODataToken ret = this.tokens.get(this.currentODataToken);
        ++this.currentODataToken;
        return ret;
    }

    public ODataToken lookPrevToken() {
        if (this.currentODataToken - 1 < 0) {
            return null;
        }
        return this.tokens.get(this.currentODataToken - 1);
    }

    public void skip() {
        ++this.currentODataToken;
    }

    @Override
    public boolean hasNext() {
        return this.currentODataToken < this.tokens.size();
    }

    @Override
    public void remove() {
        throw new IllegalArgumentException("Method not allowed");
    }

    public ODataToken elementAt(int index) {
        return this.tokens.get(index);
    }

    public boolean hasTokens() {
        return this.tokens.size() > 0;
    }

    public int tokenCount() {
        int i = this.tokens.size();
        return i;
    }
}

