/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FileUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.LuceneDocumentIndexService;
import com.vmware.xenon.services.common.ServiceHostManagementService;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class LuceneDocumentIndexBackupService
extends StatelessService {
    public static final String SELF_LINK = "/core/document-index-backup";
    private LuceneDocumentIndexService indexService;

    public LuceneDocumentIndexBackupService(LuceneDocumentIndexService indexService) {
        this.indexService = indexService;
    }

    @Override
    public void handlePatch(Operation patch) {
        if (patch.isRemote()) {
            Operation.failActionNotSupported(patch);
            return;
        }
        Object request = patch.getBodyRaw();
        if (request instanceof ServiceHostManagementService.BackupRequest) {
            this.handleBackup(patch);
            return;
        }
        if (request instanceof ServiceHostManagementService.RestoreRequest) {
            try {
                this.handleRestore(patch);
            }
            catch (IOException e) {
                patch.fail(e);
            }
            return;
        }
        Operation.failActionNotSupported(patch);
    }

    private void handleBackup(Operation op) {
        ServiceHostManagementService.BackupRequest backupRequest = op.getBody(ServiceHostManagementService.BackupRequest.class);
        Exception validationError = this.validateBackupRequest(backupRequest);
        if (validationError != null) {
            op.fail(validationError);
            return;
        }
        if (this.indexService.writer == null) {
            op.fail(new CancellationException("writer is null"));
            return;
        }
        LuceneDocumentIndexService.MaintenanceRequest maintenanceRequest = new LuceneDocumentIndexService.MaintenanceRequest();
        Operation post = Operation.createPost(this, this.indexService.getSelfLink()).setBody(maintenanceRequest);
        this.sendWithDeferredResult(post).whenComplete((o, x) -> {
            if (x != null) {
                op.fail((Throwable)x);
                return;
            }
            try {
                this.handleBackupInternal(op, backupRequest);
            }
            catch (IOException e) {
                op.fail(e);
                return;
            }
        });
    }

    private void handleBackupInternal(Operation originalOp, ServiceHostManagementService.BackupRequest backupRequest) throws IOException {
        Path localDestinationPath;
        boolean isStreamBackup;
        String indexDirectoryName = this.indexService.indexDirectory;
        boolean bl = isStreamBackup = ServiceHostManagementService.BackupType.STREAM == backupRequest.backupType;
        if (isStreamBackup) {
            String outFileName = indexDirectoryName + "-" + Utils.getNowMicrosUtc();
            localDestinationPath = Files.createTempFile(outFileName, ".zip", new FileAttribute[0]);
        } else {
            localDestinationPath = Paths.get(backupRequest.destination);
        }
        boolean isZipBackup = EnumSet.of(ServiceHostManagementService.BackupType.ZIP, ServiceHostManagementService.BackupType.STREAM).contains((Object)backupRequest.backupType);
        try {
            this.takeSnapshot(localDestinationPath, isZipBackup);
        }
        catch (IOException e) {
            this.logSevere(e);
            Files.deleteIfExists(localDestinationPath);
            throw e;
        }
        if (isStreamBackup) {
            Operation uploadOp = Operation.createPost(backupRequest.destination).transferRequestHeadersFrom(originalOp).transferRefererFrom(originalOp).setCompletion((oop, oox) -> {
                try {
                    Files.deleteIfExists(localDestinationPath);
                }
                catch (IOException e) {
                    this.logWarning("Failed to delete temporary backup file %s: %s", localDestinationPath, Utils.toString(e));
                }
                if (oox != null) {
                    originalOp.fail(oox);
                    return;
                }
                originalOp.complete();
            });
            FileUtils.putFile(this.getHost().getClient(), uploadOp, localDestinationPath.toFile());
        } else {
            originalOp.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSnapshot(Path destinationPath, boolean isZipBackup) throws IOException {
        block20: {
            IndexWriter writer = this.indexService.writer;
            boolean isInMemoryIndex = this.isInMemoryIndex();
            SnapshotDeletionPolicy snapshotter = null;
            IndexCommit commit = null;
            try {
                snapshotter = (SnapshotDeletionPolicy)writer.getConfig().getIndexDeletionPolicy();
                commit = snapshotter.snapshot();
                if (isZipBackup) {
                    Path tempDir = null;
                    try {
                        ArrayList<URI> fileList = new ArrayList<URI>();
                        if (isInMemoryIndex) {
                            tempDir = Files.createTempDirectory("lucene-in-memory-backup", new FileAttribute[0]);
                            this.copyInMemoryLuceneIndexToDirectory(commit, tempDir);
                            List files = Files.list(tempDir).map(Path::toUri).collect(Collectors.toList());
                            fileList.addAll(files);
                        } else {
                            Path indexDirectoryPath = this.getIndexDirectoryPath();
                            List files = commit.getFileNames().stream().map(indexDirectoryPath::resolve).map(Path::toUri).collect(Collectors.toList());
                            fileList.addAll(files);
                        }
                        FileUtils.zipFiles(fileList, destinationPath.toFile());
                        break block20;
                    }
                    finally {
                        if (tempDir != null) {
                            FileUtils.deleteFiles(tempDir.toFile());
                        }
                    }
                }
                if (!Files.exists(destinationPath, new LinkOption[0])) {
                    Files.createDirectory(destinationPath, new FileAttribute[0]);
                }
                HashSet sourceFileNames = new HashSet(commit.getFileNames());
                Set destFileNames = Files.list(destinationPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).collect(Collectors.toSet());
                Path tempDir = null;
                try {
                    Path indexDirectoryPath;
                    if (isInMemoryIndex) {
                        tempDir = Files.createTempDirectory("lucene-in-memory-backup", new FileAttribute[0]);
                        this.copyInMemoryLuceneIndexToDirectory(commit, tempDir);
                        indexDirectoryPath = tempDir;
                    } else {
                        indexDirectoryPath = this.getIndexDirectoryPath();
                    }
                    HashSet toAdd = new HashSet(sourceFileNames);
                    toAdd.removeAll(destFileNames);
                    for (String filename : toAdd) {
                        Path source = indexDirectoryPath.resolve(filename);
                        Path target = destinationPath.resolve(filename);
                        Files.copy(source, target, new CopyOption[0]);
                    }
                    HashSet toDelete = new HashSet(destFileNames);
                    toDelete.removeAll(sourceFileNames);
                    for (String filename : toDelete) {
                        Path path2 = destinationPath.resolve(filename);
                        Files.delete(path2);
                    }
                    this.logInfo("Incremental backup performed. dir=%s, added=%d, deleted=%d", destinationPath, toAdd.size(), toDelete.size());
                }
                finally {
                    if (tempDir != null) {
                        FileUtils.deleteFiles(tempDir.toFile());
                    }
                }
            }
            finally {
                if (snapshotter != null && commit != null) {
                    snapshotter.release(commit);
                }
                writer.deleteUnusedFiles();
            }
        }
    }

    private Path getIndexDirectoryPath() {
        String indexDirectoryName = this.indexService.indexDirectory;
        URI storageSandbox = this.getHost().getStorageSandbox();
        return Paths.get(storageSandbox).resolve(indexDirectoryName);
    }

    private void copyInMemoryLuceneIndexToDirectory(IndexCommit commit, Path directoryPath) throws IOException {
        Directory from = commit.getDirectory();
        NIOFSDirectory to = new NIOFSDirectory(directoryPath);
        for (String filename : commit.getFileNames()) {
            to.copyFrom(from, filename, filename, IOContext.DEFAULT);
        }
    }

    private Exception validateBackupRequest(ServiceHostManagementService.BackupRequest backupRequest) {
        Path destinationPath;
        URI destinationUri = backupRequest.destination;
        if (destinationUri == null) {
            return new IllegalStateException("backup destination must be specified.");
        }
        if (backupRequest.backupType == ServiceHostManagementService.BackupType.ZIP) {
            Path destinationPath2 = Paths.get(destinationUri);
            if (Files.isDirectory(destinationPath2, new LinkOption[0])) {
                String message = String.format("destination %s must be a local file for zip backup.", destinationPath2);
                return new IllegalStateException(message);
            }
        } else if (backupRequest.backupType == ServiceHostManagementService.BackupType.DIRECTORY && Files.isRegularFile(destinationPath = Paths.get(destinationUri), new LinkOption[0])) {
            String message = String.format("destination %s must be a local directory for incremental backup.", destinationPath);
            return new IllegalStateException(message);
        }
        return null;
    }

    private void handleRestore(Operation op) throws IOException {
        ServiceHostManagementService.RestoreRequest restoreRequest = op.getBody(ServiceHostManagementService.RestoreRequest.class);
        if (restoreRequest.destination == null) {
            op.fail(new IllegalStateException("destination is required."));
            return;
        }
        String scheme = restoreRequest.destination.getScheme();
        boolean isFromRemote = "http".equals(scheme) || "https".equals(scheme);
        Path backupFilePath = isFromRemote ? Files.createTempFile("restore-" + Utils.getNowMicrosUtc(), ".zip", new FileAttribute[0]) : Paths.get(restoreRequest.destination);
        Operation downloadFileOp = Operation.createGet(restoreRequest.destination).transferRefererFrom(op).setCompletion((o, x) -> {
            if (x != null) {
                op.fail(x);
            }
            this.restoreFromLocal(op, backupFilePath, restoreRequest.timeSnapshotBoundaryMicros);
            if (isFromRemote) {
                try {
                    Files.deleteIfExists(backupFilePath);
                }
                catch (IOException e) {
                    this.logWarning("Failed to delete temporary backup file %s: %s", backupFilePath, Utils.toString(e));
                }
            }
        });
        if (isFromRemote) {
            FileUtils.getFile(this.getHost().getClient(), downloadFileOp, backupFilePath.toFile());
        } else {
            downloadFileOp.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreFromLocal(Operation op, Path restoreFrom, Long timeSnapshotBoundaryMicros) {
        IndexWriter w = this.indexService.writer;
        if (w == null) {
            op.fail(new CancellationException("writer is null"));
            return;
        }
        boolean isInMemoryIndex = this.isInMemoryIndex();
        boolean restoreFromZipFile = Files.isRegularFile(restoreFrom, new LinkOption[0]);
        Path restoreTo = null;
        if (!isInMemoryIndex) {
            restoreTo = this.getIndexDirectoryPath();
        }
        HashSet<Path> pathToDeleteAtFinally = new HashSet<Path>();
        int semaphoreCount = LuceneDocumentIndexService.QUERY_THREAD_COUNT + LuceneDocumentIndexService.UPDATE_THREAD_COUNT - 1;
        try {
            Object newWriter;
            this.indexService.writerSync.acquire(semaphoreCount);
            this.indexService.close(w);
            if (restoreFromZipFile && isInMemoryIndex) {
                Path tempDir = Files.createTempDirectory("restore-" + Utils.getSystemNowMicrosUtc(), new FileAttribute[0]);
                pathToDeleteAtFinally.add(tempDir);
                this.logInfo("extracting zip file to temporal directory %s", tempDir);
                FileUtils.extractZipArchive(restoreFrom.toFile(), tempDir);
                restoreFromZipFile = false;
                restoreFrom = tempDir;
            }
            if (restoreFromZipFile) {
                this.logInfo("restoring index %s from %s md5sum(%s)", restoreTo, restoreFrom, FileUtils.md5sum(restoreFrom.toFile()));
                FileUtils.extractZipArchive(restoreFrom.toFile(), restoreTo);
                newWriter = this.indexService.createWriter(restoreTo.toFile(), true);
            } else if (isInMemoryIndex) {
                this.logInfo("restoring in-memory index from directory %s", restoreFrom);
                FSDirectory from = MMapDirectory.open((Path)restoreFrom);
                RAMDirectory to = new RAMDirectory();
                for (String filename : from.listAll()) {
                    to.copyFrom((Directory)from, filename, filename, IOContext.DEFAULT);
                }
                newWriter = this.indexService.createWriterWithLuceneDirectory((Directory)to, true);
            } else {
                this.logInfo("restoring index %s from directory %s", restoreTo, restoreFrom);
                if (Files.list(restoreTo).count() > 0L) {
                    this.logInfo("archiving existing index %s", restoreTo);
                    this.indexService.archiveCorruptIndexFiles(restoreTo.toFile());
                }
                FileUtils.copyFiles(restoreFrom.toFile(), restoreTo.toFile());
                newWriter = this.indexService.createWriter(restoreTo.toFile(), true);
            }
            if (timeSnapshotBoundaryMicros != null) {
                Query luceneQuery = LongPoint.newRangeQuery((String)"documentUpdateTimeMicros", (long)(timeSnapshotBoundaryMicros + 1L), (long)Long.MAX_VALUE);
                newWriter.deleteDocuments(new Query[]{luceneQuery});
            }
            this.indexService.setWriterUpdateTimeMicros(Utils.getNowMicrosUtc());
            op.complete();
            this.logInfo("restore complete", new Object[0]);
        }
        catch (Throwable e) {
            this.logSevere(e);
            op.fail(e);
        }
        finally {
            this.indexService.writerSync.release(semaphoreCount);
            for (Path path : pathToDeleteAtFinally) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean isInMemoryIndex() {
        return this.indexService.indexDirectory == null;
    }
}

