/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.RequestRouter;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExampleService
extends StatefulService {
    public static final String FACTORY_LINK = "/core/examples";

    public static FactoryService createFactory() {
        return FactoryService.create(ExampleService.class, new Service.ServiceOption[0]);
    }

    public ExampleService() {
        super(ExampleServiceState.class);
        this.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        this.toggleOption(Service.ServiceOption.REPLICATION, true);
        this.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        this.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation startPost) {
        if (!startPost.hasBody()) {
            startPost.fail(new IllegalArgumentException("initial state is required"));
            return;
        }
        ExampleServiceState s = startPost.getBody(ExampleServiceState.class);
        if (s.name == null) {
            startPost.fail(new IllegalArgumentException("name is required"));
            return;
        }
        startPost.complete();
    }

    @Override
    public void handlePut(Operation put) {
        ExampleServiceState newState = (ExampleServiceState)this.getBody(put);
        ExampleServiceState currentState = (ExampleServiceState)this.getState(put);
        if (currentState.name != null && newState.name == null) {
            put.fail(new IllegalArgumentException("name must be set"));
            return;
        }
        this.updateCounter(newState, currentState, false);
        this.setState(put, newState);
        put.complete();
    }

    @Override
    public void handlePatch(Operation patch) {
        this.updateState(patch);
        patch.complete();
    }

    @Override
    public OperationProcessingChain getOperationProcessingChain() {
        if (super.getOperationProcessingChain() != null) {
            return super.getOperationProcessingChain();
        }
        RequestRouter myRouter = new RequestRouter();
        myRouter.register(Service.Action.PATCH, new RequestRouter.RequestBodyMatcher<StrictUpdateRequest>(StrictUpdateRequest.class, "kind", StrictUpdateRequest.KIND), this::handlePatchForStrictUpdate, "Strict update version check");
        OperationProcessingChain opProcessingChain = new OperationProcessingChain(this);
        opProcessingChain.add(myRouter);
        this.setOperationProcessingChain(opProcessingChain);
        return opProcessingChain;
    }

    private void handlePatchForStrictUpdate(Operation patch) {
        ExampleServiceState currentState = (ExampleServiceState)this.getState(patch);
        StrictUpdateRequest body = patch.getBody(StrictUpdateRequest.class);
        if (body.kind == null || !body.kind.equals(Utils.buildKind(StrictUpdateRequest.class))) {
            patch.fail(new IllegalArgumentException("invalid kind: %s" + body.kind));
            return;
        }
        if (body.name == null) {
            patch.fail(new IllegalArgumentException("name is required"));
            return;
        }
        if (body.documentVersion != currentState.documentVersion) {
            String errorString = String.format("Current version %d. Request version %d", currentState.documentVersion, body.documentVersion);
            patch.fail(new IllegalArgumentException(errorString));
            return;
        }
        currentState.name = body.name;
        patch.setBody(currentState);
        patch.complete();
    }

    private ExampleServiceState updateState(Operation update) {
        ExampleServiceState body = (ExampleServiceState)this.getBody(update);
        ExampleServiceState currentState = (ExampleServiceState)this.getState(update);
        boolean hasStateChanged = Utils.mergeWithState(this.getStateDescription(), currentState, body);
        this.updateCounter(body, currentState, hasStateChanged);
        if (body.documentExpirationTimeMicros != currentState.documentExpirationTimeMicros) {
            currentState.documentExpirationTimeMicros = body.documentExpirationTimeMicros;
        }
        update.setBody(currentState);
        return currentState;
    }

    private boolean updateCounter(ExampleServiceState body, ExampleServiceState currentState, boolean hasStateChanged) {
        if (body.counter != null) {
            if (currentState.counter == null) {
                currentState.counter = body.counter;
            }
            body.counter = currentState.counter = Long.valueOf(Math.max(body.counter, currentState.counter));
            hasStateChanged = true;
        }
        return hasStateChanged;
    }

    @Override
    public void handleDelete(Operation delete) {
        if (!delete.hasBody()) {
            delete.complete();
            return;
        }
        ExampleServiceState currentState = (ExampleServiceState)this.getState(delete);
        ExampleServiceState st = delete.getBody(ExampleServiceState.class);
        if (st.documentExpirationTimeMicros > 0L) {
            currentState.documentExpirationTimeMicros = st.documentExpirationTimeMicros;
        }
        delete.complete();
    }

    @Override
    public ServiceDocument getDocumentTemplate() {
        ServiceDocument template = super.getDocumentTemplate();
        ServiceDocumentDescription.PropertyDescription pd = template.documentDescription.propertyDescriptions.get("keyValues");
        pd.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.EXPAND);
        ServiceDocumentDescription.PropertyDescription pdTags = template.documentDescription.propertyDescriptions.get("tags");
        pdTags.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.EXPAND);
        ServiceDocumentDescription.PropertyDescription pdName = template.documentDescription.propertyDescriptions.get("name");
        pdName.indexingOptions.add(ServiceDocumentDescription.PropertyIndexingOption.SORT);
        template.documentDescription.versionRetentionLimit = 100L;
        template.documentDescription.versionRetentionFloor = 20L;
        return template;
    }

    public static class ExampleServiceState
    extends ServiceDocument {
        public static final String FIELD_NAME_KEY_VALUES = "keyValues";
        public static final String FIELD_NAME_COUNTER = "counter";
        public static final String FIELD_NAME_SORTED_COUNTER = "sortedCounter";
        public static final String FIELD_NAME_NAME = "name";
        public static final String FIELD_NAME_TAGS = "tags";
        public static final String FIELD_NAME_ID = "id";
        public static final String FIELD_NAME_REQUIRED = "required";
        public static final long VERSION_RETENTION_LIMIT = 100L;
        public static final long VERSION_RETENTION_FLOOR = 20L;
        @ServiceDocument.UsageOptions(value={@ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.OPTIONAL), @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)})
        @ServiceDocument.PropertyOptions(indexing={ServiceDocumentDescription.PropertyIndexingOption.EXPAND, ServiceDocumentDescription.PropertyIndexingOption.FIXED_ITEM_NAME})
        public Map<String, String> keyValues = new HashMap<String, String>();
        public Long counter;
        @ServiceDocument.PropertyOptions(indexing={ServiceDocumentDescription.PropertyIndexingOption.SORT})
        public Long sortedCounter;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        @ServiceDocument.PropertyOptions(indexing={ServiceDocumentDescription.PropertyIndexingOption.SORT})
        public String name;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Set<String> tags = new HashSet<String>();
        @ServiceDocument.UsageOptions(value={@ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.ID), @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.REQUIRED)})
        public String id;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.REQUIRED)
        public String required;
    }

    public static class StrictUpdateRequest {
        public static final String KIND = Utils.buildKind(StrictUpdateRequest.class);
        public String kind;
        public String name;
        public long documentVersion;
    }
}

