/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.fsm;

import com.vmware.xenon.common.fsm.FSM;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FSMTracker<T, R>
implements FSM<T, R> {
    private Map<T, Map<R, T>> config;
    private T currentState;

    @Override
    public void configure(Map<T, Map<R, T>> fsmConfig, T initialState) {
        this.config = fsmConfig;
        this.currentState = initialState;
        this.validate();
    }

    @Override
    public R getTransition(T target) {
        this.validate();
        Map<R, T> transitions = this.config.get(this.currentState);
        for (Map.Entry<R, T> e : transitions.entrySet()) {
            if (e.getValue() != target) continue;
            return e.getKey();
        }
        throw new IllegalArgumentException(String.format("State %s cannot be reached from state %s", target, this.currentState));
    }

    @Override
    public boolean isNextState(T target) {
        this.validate();
        try {
            this.getTransition(target);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    @Override
    public boolean isTransitionValid(R transition) {
        this.validate();
        Map<R, T> transitions = this.config.get(this.currentState);
        return transitions.containsKey(transition);
    }

    @Override
    public T getNextState(R transition) {
        this.validate();
        Map<R, T> transitions = this.config.get(this.currentState);
        T nextState = transitions.get(transition);
        if (nextState == null) {
            throw new IllegalArgumentException(String.format("Transition %s is not found", transition));
        }
        return nextState;
    }

    @Override
    public Set<R> getTransitions() {
        this.validate();
        Map<R, T> transitions = this.config.get(this.currentState);
        return transitions.keySet();
    }

    @Override
    public Collection<T> getNextStates() {
        this.validate();
        Map<R, T> transitions = this.config.get(this.currentState);
        return transitions.values();
    }

    @Override
    public T getCurrentState() {
        this.validate();
        return this.currentState;
    }

    @Override
    public void adjustState(R transition) {
        this.validate();
        this.currentState = this.getNextState(transition);
    }

    private void validate() {
        if (this.config == null) {
            throw new IllegalStateException("state machine config is null");
        }
        if (this.currentState == null) {
            throw new IllegalStateException("state machine current state is null");
        }
        if (!this.config.containsKey(this.currentState)) {
            throw new IllegalStateException(String.format("state machine config does not contain current state %s", this.currentState));
        }
    }
}

