/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common.authn;

import com.vmware.xenon.common.AuthUtils;
import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.jwt.Verifier;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.authn.AuthenticationRequest;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class BasicAuthenticationUtils {
    public static final String WWW_AUTHENTICATE_HEADER_NAME = "WWW-Authenticate";
    public static final String WWW_AUTHENTICATE_HEADER_VALUE = "Basic realm=\"xenon\"";
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String BASIC_AUTH_NAME = "Basic";
    private static final String BASIC_AUTH_SEPERATOR = " ";
    private static final String BASIC_AUTH_USER_SEPERATOR = ":";
    private static final long AUTH_TOKEN_EXPIRATION_MICROS = Long.getLong("xenon.BasicAuthenticationService.AUTH_TOKEN_EXPIRATION_MICROS", TimeUnit.HOURS.toMicros(1L));

    private BasicAuthenticationUtils() {
    }

    public static void handleLogout(StatelessService service, Operation op) {
        if (op.getAuthorizationContext() == null) {
            op.complete();
            return;
        }
        String userLink = op.getAuthorizationContext().getClaims().getSubject();
        if (!BasicAuthenticationUtils.associateAuthorizationContext(service, op, userLink, 0L)) {
            op.setStatusCode(500).complete();
            return;
        }
        op.complete();
    }

    public static void handleLogin(StatelessService service, Operation op, BasicAuthenticationContext authContext) {
        BasicAuthenticationUtils.queryUserService(service, op, authContext);
    }

    public static String[] parseRequest(StatelessService service, Operation op) {
        String authString;
        String authHeader = op.getRequestHeader(AUTHORIZATION_HEADER_NAME);
        String userInfo = op.getUri().getUserInfo();
        if (authHeader != null) {
            String[] authHeaderParts = authHeader.split(BASIC_AUTH_SEPERATOR);
            if (authHeaderParts.length != 2 || !authHeaderParts[0].equalsIgnoreCase(BASIC_AUTH_NAME)) {
                op.fail(400);
                return null;
            }
            try {
                authString = new String(Base64.getDecoder().decode(authHeaderParts[1]), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                service.logWarning("Exception decoding auth header: %s", Utils.toString(e));
                op.setStatusCode(400).complete();
                return null;
            }
        } else if (userInfo != null) {
            authString = userInfo;
        } else {
            op.addResponseHeader(WWW_AUTHENTICATE_HEADER_NAME, WWW_AUTHENTICATE_HEADER_VALUE);
            op.fail(401);
            return null;
        }
        String[] userNameAndPassword = authString.split(BASIC_AUTH_USER_SEPERATOR);
        if (userNameAndPassword.length != 2) {
            op.fail(400);
            return null;
        }
        return userNameAndPassword;
    }

    public static String constructBasicAuth(String name, String password) {
        String userPass = String.format("%s:%s", name, password);
        byte[] bytes = Base64.getEncoder().encode(userPass.getBytes(StandardCharsets.UTF_8));
        String encodedUserPass = new String(bytes, StandardCharsets.UTF_8);
        String basicAuth = "Basic " + encodedUserPass;
        return basicAuth;
    }

    private static void queryUserService(StatelessService service, Operation parentOp, BasicAuthenticationContext authContext) {
        QueryTask q = new QueryTask();
        q.querySpec = new QueryTask.QuerySpecification();
        q.querySpec.query = authContext.userQuery;
        q.taskInfo.isDirect = true;
        Operation.CompletionHandler userServiceCompletion = (o, ex) -> {
            if (ex != null) {
                service.logWarning("Exception validating user: %s", Utils.toString(ex));
                parentOp.setBodyNoCloning(o.getBodyRaw()).fail(o.getStatusCode());
                return;
            }
            QueryTask rsp = o.getBody(QueryTask.class);
            if (rsp.results.documentLinks.isEmpty()) {
                parentOp.fail(403);
                return;
            }
            String userLink = rsp.results.documentLinks.get(0);
            BasicAuthenticationUtils.queryAuthStore(service, parentOp, userLink, authContext);
        };
        Operation queryOp = Operation.createPost(AuthUtils.buildAuthProviderHostUri(service.getHost(), ServiceUriPaths.CORE_QUERY_TASKS)).setBody(q).setCompletion(userServiceCompletion);
        service.setAuthorizationContext(queryOp, service.getSystemAuthorizationContext());
        service.sendRequest(queryOp);
    }

    private static void queryAuthStore(StatelessService service, Operation parentOp, String userLink, BasicAuthenticationContext authContext) {
        QueryTask authQuery = new QueryTask();
        authQuery.querySpec = new QueryTask.QuerySpecification();
        authQuery.querySpec.query = authContext.authQuery;
        authQuery.taskInfo.isDirect = true;
        Operation.CompletionHandler authCompletionHandler = (authOp, authEx) -> {
            if (authEx != null) {
                service.logWarning("Exception validating user credentials: %s", Utils.toString(authEx));
                parentOp.setBodyNoCloning(authOp.getBodyRaw()).fail(500);
                return;
            }
            QueryTask authRsp = authOp.getBody(QueryTask.class);
            if (authRsp.results.documentLinks.isEmpty()) {
                parentOp.fail(403);
                return;
            }
            AuthenticationRequest authRequest = parentOp.getBody(AuthenticationRequest.class);
            long expirationTime = authRequest.sessionExpirationSeconds != null ? Utils.fromNowMicrosUtc(TimeUnit.SECONDS.toMicros(authRequest.sessionExpirationSeconds)) : Utils.fromNowMicrosUtc(AUTH_TOKEN_EXPIRATION_MICROS);
            if (!BasicAuthenticationUtils.associateAuthorizationContext(service, parentOp, userLink, expirationTime)) {
                parentOp.fail(500);
                return;
            }
            parentOp.complete();
        };
        Operation queryAuth = Operation.createPost(AuthUtils.buildAuthProviderHostUri(service.getHost(), ServiceUriPaths.CORE_QUERY_TASKS)).setBody(authQuery).setCompletion(authCompletionHandler);
        service.setAuthorizationContext(queryAuth, service.getSystemAuthorizationContext());
        service.sendRequest(queryAuth);
    }

    private static boolean associateAuthorizationContext(StatelessService service, Operation op, String userLink, long expirationTimeMicros) {
        String token;
        Claims.Builder builder = new Claims.Builder();
        builder.setIssuer("xn");
        builder.setSubject(userLink);
        builder.setExpirationTime(TimeUnit.MICROSECONDS.toSeconds(expirationTimeMicros));
        Claims claims = (Claims)builder.getResult();
        try {
            token = service.getTokenSigner().sign(claims);
        }
        catch (Exception e) {
            service.logSevere(e);
            return false;
        }
        Operation.AuthorizationContext.Builder ab = Operation.AuthorizationContext.Builder.create();
        ab.setClaims(claims);
        ab.setToken(token);
        ab.setPropagateToClient(true);
        service.setAuthorizationContext(op, ab.getResult());
        return true;
    }

    public static void handleTokenVerify(StatelessService service, Operation op) {
        String token = BasicAuthenticationUtils.getAuthToken(op);
        if (token == null) {
            IllegalArgumentException e = new IllegalArgumentException("Token is empty");
            service.logWarning("Error verifying token: %s", e.getMessage());
            op.fail(e);
            return;
        }
        try {
            Verifier verifier = service.getTokenVerifier();
            Claims claims = verifier.verify(token, Claims.class);
            op.setBody(claims);
            op.complete();
        }
        catch (Verifier.TokenException | GeneralSecurityException e) {
            service.logWarning("Error verifying token: %s", e.getMessage());
            op.fail(e);
        }
    }

    public static String getAuthToken(Operation op) {
        String token = op.getRequestHeader("x-xenon-auth-token");
        if (token == null) {
            Map<String, String> cookies = op.getCookies();
            if (cookies == null) {
                return null;
            }
            token = cookies.get("xenon-auth-cookie");
        }
        return token;
    }

    public static class BasicAuthenticationContext {
        public QueryTask.Query userQuery;
        public QueryTask.Query authQuery;
    }
}

