/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.esotericsoftware.kryo.serializers.VersionFieldSerializer;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class QueryTask
extends ServiceDocument {
    public static final String KIND = Utils.buildKind(QueryTask.class);
    public static final int DEFAULT_PRECISION_STEP = 16;
    public List<String> tenantLinks;
    public TaskState taskInfo = new TaskState();
    public QuerySpecification querySpec;
    public ServiceDocumentQueryResult results;
    public String indexLink = "/core/document-index";
    public String nodeSelectorLink = "/core/node-selectors/default";

    public static QueryTask create(QuerySpecification q) {
        QueryTask qt = new QueryTask();
        qt.querySpec = q;
        return qt;
    }

    public QueryTask setDirect(boolean enable) {
        this.taskInfo.isDirect = enable;
        return this;
    }

    public static class Builder {
        private final QueryTask queryTask = new QueryTask();
        private final QuerySpecification querySpec;

        private Builder(boolean isDirect) {
            this.queryTask.querySpec = this.querySpec = new QuerySpecification();
            this.queryTask.taskInfo.isDirect = isDirect;
        }

        public static Builder create() {
            return new Builder(false);
        }

        public static Builder createDirectTask() {
            return new Builder(true);
        }

        public Builder setResultLimit(int resultLimit) {
            this.querySpec.resultLimit = resultLimit;
            return this;
        }

        public Builder setGroupResultLimit(int resultLimit) {
            this.querySpec.groupResultLimit = resultLimit;
            return this;
        }

        public Builder setExpectedResultCount(long expectedResultCount) {
            this.querySpec.expectedResultCount = expectedResultCount;
            return this;
        }

        public Builder orderAscending(String fieldName, ServiceDocumentDescription.TypeName fieldType) {
            return this.order(fieldName, fieldType, QuerySpecification.SortOrder.ASC);
        }

        public Builder orderDescending(String fieldName, ServiceDocumentDescription.TypeName fieldType) {
            return this.order(fieldName, fieldType, QuerySpecification.SortOrder.DESC);
        }

        private Builder order(String fieldName, ServiceDocumentDescription.TypeName fieldType, QuerySpecification.SortOrder sortOrder) {
            QueryTerm sortTerm = new QueryTerm();
            sortTerm.propertyName = fieldName;
            sortTerm.propertyType = fieldType;
            if (this.querySpec.sortTerm == null) {
                this.querySpec.sortTerm = sortTerm;
                this.querySpec.sortOrder = sortOrder;
            } else {
                sortTerm.sortOrder = sortOrder;
                if (this.querySpec.additionalSortTerms == null) {
                    this.querySpec.additionalSortTerms = new ArrayList<QueryTerm>();
                }
                this.querySpec.additionalSortTerms.add(sortTerm);
            }
            this.addOption(QuerySpecification.QueryOption.SORT);
            return this;
        }

        public Builder groupOrder(String fieldName, ServiceDocumentDescription.TypeName fieldType, QuerySpecification.SortOrder sortOrder) {
            QueryTerm sortTerm = new QueryTerm();
            this.setGroupByTerm(fieldName, fieldType);
            sortTerm.propertyName = fieldName;
            sortTerm.propertyType = fieldType;
            this.querySpec.groupSortTerm = sortTerm;
            this.querySpec.groupSortOrder = sortOrder;
            return this;
        }

        public Builder addOption(QuerySpecification.QueryOption queryOption) {
            this.querySpec.options.add(queryOption);
            return this;
        }

        public Builder addOptions(EnumSet<QuerySpecification.QueryOption> queryOptions) {
            this.querySpec.options.addAll(queryOptions);
            return this;
        }

        public Builder addLinkTerm(String linkFieldName) {
            QueryTerm linkTerm = new QueryTerm();
            linkTerm.propertyName = linkFieldName;
            linkTerm.propertyType = ServiceDocumentDescription.TypeName.STRING;
            if (this.querySpec.linkTerms == null) {
                this.querySpec.linkTerms = new ArrayList<QueryTerm>();
            }
            this.querySpec.linkTerms.add(linkTerm);
            return this;
        }

        public Builder setGroupByTerm(String fieldName) {
            return this.setGroupByTerm(fieldName, ServiceDocumentDescription.TypeName.STRING);
        }

        public Builder setGroupByTerm(String fieldName, ServiceDocumentDescription.TypeName fieldType) {
            QueryTerm term = new QueryTerm();
            term.propertyName = fieldName;
            term.propertyType = fieldType;
            this.querySpec.groupByTerm = term;
            return this;
        }

        public Builder setQuery(Query query) {
            this.querySpec.query = query;
            return this;
        }

        public Builder setIndexLink(String indexLink) {
            this.queryTask.indexLink = indexLink;
            return this;
        }

        public Builder setQueryTimeStamp(Long documentsUpdatedBeforeInMicros) {
            this.querySpec.timeSnapshotBoundaryMicros = documentsUpdatedBeforeInMicros;
            return this;
        }

        public QueryTask build() {
            return this.queryTask;
        }
    }

    public static class Query {
        public Occurance occurance = Occurance.MUST_OCCUR;
        public QueryTerm term;
        public List<Query> booleanClauses;

        public Query setTermPropertyName(String name) {
            this.allocateTerm();
            this.term.propertyName = name;
            return this;
        }

        public Query setCaseInsensitiveTermMatchValue(String matchValue) {
            return this.setTermMatchValue(matchValue.toLowerCase());
        }

        public Query setTermMatchValue(String matchValue) {
            this.allocateTerm();
            if (this.term.matchType == null) {
                this.term.matchType = QueryTerm.MatchType.TERM;
            }
            this.term.matchValue = matchValue;
            return this;
        }

        public Query setTermMatchType(QueryTerm.MatchType matchType) {
            this.allocateTerm();
            this.term.matchType = matchType;
            return this;
        }

        public Query setOccurance(Occurance occur) {
            this.occurance = occur;
            return this;
        }

        public Query setNumericRange(NumericRange<?> range) {
            this.allocateTerm();
            this.term.range = range;
            return this;
        }

        private void allocateTerm() {
            if (this.term != null) {
                return;
            }
            this.term = new QueryTerm();
        }

        public Query addBooleanClause(Query clause) {
            if (this.booleanClauses == null) {
                this.booleanClauses = new ArrayList<Query>();
                this.term = null;
            }
            this.booleanClauses.add(clause);
            return this;
        }

        public static final class Builder {
            private final Query query = new Query();

            private Builder(Occurance occurance) {
                this.query.occurance = occurance;
            }

            public static Builder create() {
                return new Builder(Occurance.MUST_OCCUR);
            }

            public static Builder create(Occurance occurance) {
                return new Builder(occurance);
            }

            public Builder addKindFieldClause(Class<? extends ServiceDocument> documentClass) {
                return this.addFieldClause("documentKind", Utils.buildKind(documentClass));
            }

            public Builder addKindFieldClause(Class<? extends ServiceDocument> documentClass, Occurance occurance) {
                return this.addFieldClause("documentKind", Utils.buildKind(documentClass), occurance);
            }

            public Builder addCollectionItemClause(String collectionFieldName, String itemName) {
                return this.addFieldClause(QuerySpecification.buildCollectionItemName(collectionFieldName), itemName);
            }

            public Builder addCollectionItemClause(String collectionFieldName, String itemName, Occurance occurance) {
                return this.addFieldClause(QuerySpecification.buildCollectionItemName(collectionFieldName), itemName, occurance);
            }

            public Builder addInClause(String fieldName, Collection<String> itemNames) {
                return this.addInClause(fieldName, itemNames, Occurance.MUST_OCCUR);
            }

            public Builder addInClause(String fieldName, Collection<String> itemNames, Occurance occurance) {
                if (itemNames.size() == 1) {
                    return this.addFieldClause(fieldName, itemNames.iterator().next(), occurance);
                }
                Builder inClause = Builder.create(occurance);
                for (String itemName : itemNames) {
                    inClause.addFieldClause(fieldName, itemName, Occurance.SHOULD_OCCUR);
                }
                return this.addClause(inClause.build());
            }

            public Builder addInCollectionItemClause(String collectionFieldName, Collection<String> itemNames) {
                String collectionItemFieldName = QuerySpecification.buildCollectionItemName(collectionFieldName);
                return this.addInClause(collectionItemFieldName, itemNames);
            }

            public Builder addInCollectionItemClause(String collectionFieldName, Collection<String> itemNames, Occurance occurance) {
                String collectionItemFieldName = QuerySpecification.buildCollectionItemName(collectionFieldName);
                return this.addInClause(collectionItemFieldName, itemNames, occurance);
            }

            public Builder addCompositeFieldClause(String parentFieldName, String nestedFieldName, String nestedFieldValue) {
                return this.addFieldClause(QuerySpecification.buildCompositeFieldName(parentFieldName, nestedFieldName), nestedFieldValue);
            }

            public Builder addCompositeFieldClause(String parentFieldName, String nestedFieldName, String nestedFieldValue, Occurance occurance) {
                return this.addFieldClause(QuerySpecification.buildCompositeFieldName(parentFieldName, nestedFieldName), nestedFieldValue, occurance);
            }

            public Builder addFieldClause(String fieldName, String fieldValue) {
                return this.addFieldClause(fieldName, fieldValue, QueryTerm.MatchType.TERM, Occurance.MUST_OCCUR);
            }

            public Builder addFieldClause(String fieldName, Object fieldValue) {
                return this.addFieldClause(fieldName, QuerySpecification.toMatchValue(fieldValue), QueryTerm.MatchType.TERM, Occurance.MUST_OCCUR);
            }

            public Builder addFieldClause(String fieldName, String fieldValue, QueryTerm.MatchType matchType) {
                return this.addFieldClause(fieldName, fieldValue, matchType, Occurance.MUST_OCCUR);
            }

            public Builder addFieldClause(String fieldName, String fieldValue, Occurance occurance) {
                return this.addFieldClause(fieldName, fieldValue, QueryTerm.MatchType.TERM, occurance);
            }

            public Builder addFieldClause(String fieldName, String fieldValue, QueryTerm.MatchType matchType, Occurance occurance) {
                Query clause = new Query().setTermPropertyName(fieldName).setTermMatchValue(fieldValue).setTermMatchType(matchType);
                clause.occurance = occurance;
                this.query.addBooleanClause(clause);
                return this;
            }

            public Builder addCaseInsensitiveFieldClause(String fieldName, String fieldValue, QueryTerm.MatchType matchType, Occurance occurance) {
                Query clause = new Query().setTermPropertyName(fieldName).setCaseInsensitiveTermMatchValue(fieldValue).setTermMatchType(matchType);
                clause.occurance = occurance;
                this.query.addBooleanClause(clause);
                return this;
            }

            public Builder setTerm(String fieldName, String fieldValue) {
                return this.setTerm(fieldName, fieldValue, QueryTerm.MatchType.TERM);
            }

            public Builder setTerm(String fieldName, String fieldValue, QueryTerm.MatchType matchType) {
                this.query.term = new QueryTerm();
                this.query.term.propertyName = fieldName;
                this.query.term.matchValue = fieldValue;
                this.query.term.matchType = matchType;
                return this;
            }

            public Builder addRangeClause(String fieldName, NumericRange<?> range) {
                return this.addRangeClause(fieldName, range, Occurance.MUST_OCCUR);
            }

            public Builder addRangeClause(String fieldName, NumericRange<?> range, Occurance occurance) {
                Query clause = new Query().setTermPropertyName(fieldName).setNumericRange(range);
                clause.occurance = occurance;
                this.query.addBooleanClause(clause);
                return this;
            }

            public Builder addClause(Query clause) {
                this.query.addBooleanClause(clause);
                return this;
            }

            public Builder addClauses(Query clause1, Query clause2) {
                this.query.addBooleanClause(clause1).addBooleanClause(clause2);
                return this;
            }

            public Builder addClauses(Query clause1, Query clause2, Query clause3) {
                this.query.addBooleanClause(clause1).addBooleanClause(clause2).addBooleanClause(clause3);
                return this;
            }

            public Builder addClauses(Query firstClause, Query ... otherClauses) {
                this.query.addBooleanClause(firstClause);
                for (Query clause : otherClauses) {
                    this.query.addBooleanClause(clause);
                }
                return this;
            }

            public Query build() {
                return this.query;
            }
        }

        public static enum Occurance {
            MUST_OCCUR,
            MUST_NOT_OCCUR,
            SHOULD_OCCUR;

        }
    }

    public static class QueryTerm {
        public String propertyName;
        public ServiceDocumentDescription.TypeName propertyType;
        public String matchValue;
        public MatchType matchType;
        public NumericRange<?> range;
        @VersionFieldSerializer.Since(value=131)
        public QuerySpecification.SortOrder sortOrder;

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof QueryTerm) {
                QueryTerm qObj = (QueryTerm)obj;
                if (Objects.equals(this.propertyName, qObj.propertyName) && Objects.equals((Object)this.propertyType, (Object)qObj.propertyType) && Objects.equals((Object)this.matchType, (Object)qObj.matchType) && Objects.equals(this.matchValue, qObj.matchValue) && Objects.equals(this.range, qObj.range)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.propertyName, this.propertyType, this.matchType, this.matchValue, this.range});
        }

        public static enum MatchType {
            WILDCARD,
            TERM,
            PHRASE,
            PREFIX;

        }
    }

    public static class NumericRange<T extends Number> {
        public ServiceDocumentDescription.TypeName type;
        public T min;
        public T max;
        public boolean isMinInclusive;
        public boolean isMaxInclusive;
        public int precisionStep = 16;

        public static NumericRange<Long> createLongRange(Long min, Long max, boolean isMinInclusive, boolean isMaxInclusive) {
            NumericRange<Long> nr = new NumericRange<Long>();
            nr.type = ServiceDocumentDescription.TypeName.LONG;
            nr.isMaxInclusive = isMaxInclusive;
            nr.isMinInclusive = isMinInclusive;
            nr.max = max;
            nr.min = min;
            return nr;
        }

        public static NumericRange<Double> createDoubleRange(Double min, Double max, boolean isMinInclusive, boolean isMaxInclusive) {
            NumericRange<Double> nr = new NumericRange<Double>();
            nr.type = ServiceDocumentDescription.TypeName.DOUBLE;
            nr.isMaxInclusive = isMaxInclusive;
            nr.isMinInclusive = isMinInclusive;
            nr.max = max;
            nr.min = min;
            return nr;
        }

        public void validate() throws IllegalArgumentException {
            if (this.max == null && this.min == null) {
                throw new IllegalArgumentException("max and min can not both be null");
            }
            if (this.max != null && this.min != null && ((Comparable)this.max).compareTo(this.min) < 0) {
                throw new IllegalArgumentException("max must be greater than min");
            }
            if (this.min != null && this.max != null && ((Comparable)this.min).compareTo(this.max) > 0) {
                throw new IllegalArgumentException("max must be greater than min");
            }
            if (this.type == null) {
                throw new IllegalArgumentException("type must be specified");
            }
        }

        public static NumericRange<?> createLessThanRange(Number max) {
            if (max instanceof Double) {
                return NumericRange.createDoubleRange(Double.MIN_VALUE, (Double)max, true, false);
            }
            return NumericRange.createLongRange(Long.MIN_VALUE, (Long)max, true, false);
        }

        public static NumericRange<?> createLessThanOrEqualRange(Number max) {
            if (max instanceof Double) {
                return NumericRange.createDoubleRange(Double.MIN_VALUE, (Double)max, true, true);
            }
            return NumericRange.createLongRange(Long.MIN_VALUE, (Long)max, true, true);
        }

        public static NumericRange<?> createGreaterThanRange(Number min) {
            if (min instanceof Double) {
                return NumericRange.createDoubleRange((Double)min, Double.MAX_VALUE, false, true);
            }
            return NumericRange.createLongRange((Long)min, Long.MAX_VALUE, false, true);
        }

        public static NumericRange<?> createGreaterThanOrEqualRange(Number min) {
            if (min instanceof Double) {
                return NumericRange.createDoubleRange((Double)min, Double.MAX_VALUE, true, true);
            }
            return NumericRange.createLongRange((Long)min, Long.MAX_VALUE, true, true);
        }

        public static NumericRange<?> createEqualRange(Number num) {
            if (num instanceof Double) {
                return NumericRange.createDoubleRange((Double)num, (Double)num, true, true);
            }
            return NumericRange.createLongRange((Long)num, (Long)num, true, true);
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof NumericRange) {
                NumericRange nObj = (NumericRange)obj;
                if (this.isMaxInclusive == nObj.isMaxInclusive && this.isMinInclusive == nObj.isMinInclusive && Objects.equals(this.max, nObj.max) && Objects.equals(this.min, nObj.min) && Objects.equals(this.precisionStep, nObj.precisionStep) && Objects.equals((Object)this.type, (Object)nObj.type)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.max, this.min, this.precisionStep, this.type});
        }
    }

    public static class QuerySpecification {
        public static final String FIELD_NAME_CHARACTER = ".";
        public static final String FIELD_NAME_REGEXP = "\\.";
        public static final String COLLECTION_FIELD_SUFFIX = "item";
        public Query query = new Query();
        public List<QueryTerm> linkTerms;
        public QueryTerm sortTerm;
        public QueryTerm groupSortTerm;
        @VersionFieldSerializer.Since(value=131)
        public List<QueryTerm> additionalSortTerms;
        @VersionFieldSerializer.Since(value=131)
        public List<QueryTerm> additionalGroupSortTerms;
        public QueryTerm groupByTerm;
        public SortOrder sortOrder;
        public SortOrder groupSortOrder;
        public Integer resultLimit;
        public Integer groupResultLimit;
        public Long expectedResultCount;
        public EnumSet<QueryOption> options = EnumSet.noneOf(QueryOption.class);
        public transient QueryRuntimeContext context = new QueryRuntimeContext();
        @VersionFieldSerializer.Since(value=136)
        public Long timeSnapshotBoundaryMicros;

        public static String buildCompositeFieldName(String ... fieldNames) {
            StringBuilder sb = new StringBuilder();
            for (String s : fieldNames) {
                if (s == null) continue;
                sb.append(s).append(FIELD_NAME_CHARACTER);
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        public static String buildCollectionItemName(String fieldName) {
            return fieldName + FIELD_NAME_CHARACTER + COLLECTION_FIELD_SUFFIX;
        }

        public static String buildLinkCollectionItemName(String fieldName, int ordinal) {
            return fieldName + FIELD_NAME_CHARACTER + COLLECTION_FIELD_SUFFIX + FIELD_NAME_CHARACTER + ordinal;
        }

        public static String toMatchValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Boolean) {
                return QuerySpecification.toMatchValue((Boolean)value);
            }
            if (value instanceof URI) {
                return QuerySpecification.toMatchValue((URI)value);
            }
            if (value instanceof Enum) {
                return QuerySpecification.toMatchValue((Enum)value);
            }
            return value.toString();
        }

        public static String toMatchValue(boolean value) {
            return value ? "true" : "false";
        }

        public static String toMatchValue(URI value) {
            return value == null ? null : value.toString();
        }

        public static String toMatchValue(Enum<?> value) {
            return value == null ? null : value.name();
        }

        public static QueryTask addExpandOption(QueryTask queryTask) {
            queryTask.querySpec.options = EnumSet.of(QueryOption.EXPAND_CONTENT);
            return queryTask;
        }

        public void copyTo(QuerySpecification clonedSpec) {
            clonedSpec.context.documentLinkWhiteList = this.context.documentLinkWhiteList;
            clonedSpec.context.filter = this.context.filter;
            clonedSpec.context.nativePage = this.context.nativePage;
            clonedSpec.context.nativeQuery = this.context.nativeQuery;
            clonedSpec.context.nativeSearcher = this.context.nativeSearcher;
            clonedSpec.context.nativeSort = this.context.nativeSort;
            clonedSpec.expectedResultCount = this.expectedResultCount;
            clonedSpec.linkTerms = this.linkTerms;
            clonedSpec.groupByTerm = this.groupByTerm;
            clonedSpec.options = EnumSet.copyOf(this.options);
            clonedSpec.query = this.query;
            clonedSpec.resultLimit = this.resultLimit;
            clonedSpec.sortOrder = this.sortOrder;
            clonedSpec.sortTerm = this.sortTerm;
            clonedSpec.groupSortTerm = this.groupSortTerm;
            clonedSpec.groupSortOrder = this.groupSortOrder;
            clonedSpec.timeSnapshotBoundaryMicros = this.timeSnapshotBoundaryMicros;
        }

        public static enum SortOrder {
            ASC,
            DESC;

        }

        public static enum QueryOption {
            CONTINUOUS,
            COUNT,
            DO_NOT_REFRESH,
            TOP_RESULTS,
            EXPAND_CONTENT,
            EXPAND_BUILTIN_CONTENT_ONLY,
            EXPAND_LINKS,
            INCLUDE_ALL_VERSIONS,
            INCLUDE_DELETED,
            SORT,
            TASK,
            BROADCAST,
            OWNER_SELECTION,
            SELECT_LINKS,
            GROUP_BY,
            TIME_SNAPSHOT;

        }

        public static class QueryRuntimeContext {
            public transient Object nativeQuery;
            public transient Object nativePage;
            public transient Object nativeSearcher;
            public transient Object nativeSort;
            public transient QueryFilter filter;
            public transient Set<String> documentLinkWhiteList;
            public transient String subjectLink;
        }
    }
}

