/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.vmware.xenon.common.RequestRouter;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import io.netty.util.internal.StringUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public enum RequestRouteConverter implements JsonSerializer<RequestRouter.Route>,
JsonDeserializer<RequestRouter.Route>
{
    INSTANCE;

    public static final Type TYPE;
    private static final String BODY_MATCHER_CLASS_NAME_SPLITTER = "#";
    private static final String FIELD_ACTION = "action";
    private static final String FIELD_CONDITION = "condition";
    private static final String FIELD_REQUEST_TYPE = "requestType";
    private static final String FIELD_RESPONSE_TYPE = "responseType";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_REQUIRED = "required";
    private static final String FIELD_VALUE = "value";
    private static final String FIELD_PARAM_DEF = "paramDef";
    private static final String FIELD_PARAMETERS = "parameters";

    public JsonElement serialize(RequestRouter.Route src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject ob = new JsonObject();
        ob.addProperty(FIELD_ACTION, src.action.toString());
        if (src.matcher != null) {
            ob.addProperty(FIELD_CONDITION, src.matcher.toString());
        }
        ob.addProperty(FIELD_DESCRIPTION, src.description);
        if (src.requestType != null) {
            ob.addProperty(FIELD_REQUEST_TYPE, src.requestType.getName());
        }
        if (src.responseType != null) {
            ob.addProperty(FIELD_RESPONSE_TYPE, src.responseType.getName());
        }
        if (src.parameters != null && !src.parameters.isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            src.parameters.stream().forEach(p -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty(FIELD_NAME, p.name);
                jsonObject.addProperty(FIELD_DESCRIPTION, p.description);
                jsonObject.addProperty(FIELD_TYPE, p.type);
                jsonObject.addProperty(FIELD_REQUIRED, Boolean.valueOf(p.required));
                jsonObject.addProperty(FIELD_VALUE, p.value);
                jsonObject.addProperty(FIELD_PARAM_DEF, p.paramDef.name());
                jsonArray.add((JsonElement)jsonObject);
            });
            ob.add(FIELD_PARAMETERS, (JsonElement)jsonArray);
        }
        return ob;
    }

    public RequestRouter.Route deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("The json element is not valid");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        RequestRouter.Route route = new RequestRouter.Route();
        String action = this.checkAndGetFromJson(jsonObject, FIELD_ACTION);
        route.action = action == null ? null : Service.Action.valueOf(action);
        route.description = this.checkAndGetFromJson(jsonObject, FIELD_DESCRIPTION);
        try {
            String requestType = this.checkAndGetFromJson(jsonObject, FIELD_REQUEST_TYPE);
            route.requestType = requestType == null ? null : Class.forName(requestType);
            String condition = this.checkAndGetFromJson(jsonObject, FIELD_CONDITION);
            if (!StringUtil.isNullOrEmpty((String)condition)) {
                if (condition.startsWith("?")) {
                    Map<String, String> queryParams = UriUtils.parseUriQueryParams(UriUtils.buildUri(condition));
                    route.parameters = new ArrayList<RequestRouter.Parameter>(queryParams.size());
                    for (Map.Entry<String, String> paramPair : queryParams.entrySet()) {
                        route.parameters.add(new RequestRouter.Parameter(paramPair.getKey(), "", ServiceDocumentDescription.TypeName.STRING.name(), true, paramPair.getValue(), RequestRouter.ParamDef.QUERY));
                    }
                } else {
                    String[] conditionParts = condition.split(BODY_MATCHER_CLASS_NAME_SPLITTER);
                    if (route.requestType == null) {
                        route.requestType = Class.forName(conditionParts[0]);
                    }
                    String[] bodyParts = conditionParts[1].split(String.valueOf("="));
                    RequestRouter.Parameter parameter = new RequestRouter.Parameter(bodyParts[0], "", ServiceDocumentDescription.TypeName.STRING.name(), true, bodyParts[1], RequestRouter.ParamDef.BODY);
                    route.parameters = Arrays.asList(parameter);
                }
            } else if (jsonObject.has(FIELD_PARAMETERS)) {
                JsonArray parameters = jsonObject.getAsJsonArray(FIELD_PARAMETERS);
                Type gsonType = new TypeToken<List<RequestRouter.Parameter>>(){}.getType();
                route.parameters = (List)Utils.fromJson((Object)parameters, gsonType);
            }
            String responseType = this.checkAndGetFromJson(jsonObject, FIELD_RESPONSE_TYPE);
            route.responseType = responseType == null ? null : Class.forName(responseType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return route;
    }

    private String checkAndGetFromJson(JsonObject jsonObject, String memberName) {
        if (jsonObject.has(memberName)) {
            return jsonObject.get(memberName).getAsString();
        }
        return null;
    }

    static {
        TYPE = new TypeToken<RequestRouter.Route>(){}.getType();
    }
}

