/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.ServiceStatUtils;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

class ServiceMaintenanceTracker {
    public static final long SCHEDULING_EPSILON_MICROS = TimeUnit.MILLISECONDS.toMicros(10L);
    private ServiceHost host;
    private ConcurrentHashMap<String, Long> trackedServices = new ConcurrentHashMap();
    private ConcurrentSkipListMap<Long, Set<String>> nextExpiration = new ConcurrentSkipListMap();

    ServiceMaintenanceTracker() {
    }

    public static ServiceMaintenanceTracker create(ServiceHost host) {
        ServiceMaintenanceTracker smt = new ServiceMaintenanceTracker();
        smt.host = host;
        return smt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Service s, long now) {
        long interval = s.getMaintenanceIntervalMicros();
        if (interval == 0L) {
            interval = this.host.getMaintenanceIntervalMicros();
        }
        long nextExpirationMicros = Math.max(now, now + interval - SCHEDULING_EPSILON_MICROS);
        String selfLink = s.getSelfLink();
        ServiceMaintenanceTracker serviceMaintenanceTracker = this;
        synchronized (serviceMaintenanceTracker) {
            Set<String> services;
            Long expiration = this.trackedServices.get(selfLink);
            if (expiration != null && (services = this.nextExpiration.get(expiration)) != null) {
                services.remove(selfLink);
            }
            this.trackedServices.put(selfLink, nextExpirationMicros);
            services = this.nextExpiration.get(nextExpirationMicros);
            if (services == null) {
                services = new HashSet<String>();
                this.nextExpiration.put(nextExpirationMicros, services);
            }
            services.add(selfLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMaintenance(Operation op, long deadline) {
        long now;
        while ((now = Utils.getSystemNowMicrosUtc()) < deadline) {
            Map.Entry<Long, Set<String>> e;
            if (this.host.isStopping()) {
                op.fail(new CancellationException("Host is stopping"));
                return;
            }
            ServiceMaintenanceTracker serviceMaintenanceTracker = this;
            synchronized (serviceMaintenanceTracker) {
                e = this.nextExpiration.firstEntry();
                if (e == null || e.getKey() >= now) {
                    return;
                }
                this.nextExpiration.pollFirstEntry();
            }
            Long expiration = e.getKey();
            Set<String> services = e.getValue();
            for (String servicePath : services) {
                boolean skipMaintenance;
                Service s = this.host.findService(servicePath);
                boolean bl = skipMaintenance = s == null || s.getProcessingStage() != Service.ProcessingStage.AVAILABLE || !s.hasOption(Service.ServiceOption.PERIODIC_MAINTENANCE) || s.hasOption(Service.ServiceOption.OWNER_SELECTION) && !s.hasOption(Service.ServiceOption.DOCUMENT_OWNER);
                if (skipMaintenance) {
                    ServiceMaintenanceTracker serviceMaintenanceTracker2 = this;
                    synchronized (serviceMaintenanceTracker2) {
                        Long serviceExpiration = this.trackedServices.get(servicePath);
                        if (serviceExpiration.equals(expiration)) {
                            this.trackedServices.remove(servicePath);
                        }
                        continue;
                    }
                }
                this.performServiceMaintenance(servicePath, s);
            }
        }
    }

    private void performServiceMaintenance(String servicePath, Service s) {
        long[] start = new long[1];
        ServiceMaintenanceRequest body = ServiceMaintenanceRequest.create();
        body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.PERIODIC_SCHEDULE);
        Operation servicePost = Operation.createPost(UriUtils.buildUri(this.host, servicePath)).setReferer(this.host.getUri()).setBodyNoCloning(body).setCompletion((o, ex) -> {
            long now = Utils.getSystemNowMicrosUtc();
            long actual = now - start[0];
            long limit = Math.max(this.host.getMaintenanceIntervalMicros(), s.getMaintenanceIntervalMicros());
            if (s.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                this.updateStats(s, actual, limit, servicePath);
            }
            this.schedule(s, now);
            if (ex != null) {
                this.host.log(Level.WARNING, "Service %s failed maintenance: %s", servicePath, Utils.toString(ex));
            }
        });
        this.host.schedule(() -> {
            try {
                OperationContext.setAuthorizationContext(this.host.getSystemAuthorizationContext());
                if (s.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
                    s.adjustStat("maintenanceCount", 1.0);
                }
                start[0] = Utils.getSystemNowMicrosUtc();
                s.handleMaintenance(servicePost);
            }
            catch (Throwable ex) {
                this.host.log(Level.WARNING, "Service %s failed to perform maintenance: %s", servicePath, Utils.toString(ex));
                servicePost.fail(ex);
            }
        }, SCHEDULING_EPSILON_MICROS, TimeUnit.MICROSECONDS);
    }

    public synchronized void close() {
        this.trackedServices.clear();
        this.nextExpiration.clear();
    }

    private void updateStats(Service s, long actual, long limit, String servicePath) {
        ServiceStats.ServiceStat durationStat = ServiceStatUtils.getHistogramStat(s, "maintenanceDuration");
        s.setStat(durationStat, (double)actual);
        if (limit * 2L < actual) {
            this.host.log(Level.WARNING, "Service %s exceeded maintenance interval %d. Actual: %d", servicePath, limit, actual);
            s.adjustStat("maintenanceCompletionDelayedCount", 1.0);
        }
    }
}

