/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common.authn;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.services.common.AuthCredentialsService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.UserService;
import com.vmware.xenon.services.common.authn.AuthenticationRequest;
import com.vmware.xenon.services.common.authn.BasicAuthenticationUtils;

public class BasicAuthenticationService
extends StatelessService {
    public static String SELF_LINK = ServiceUriPaths.CORE_AUTHN_BASIC;
    public static final String WWW_AUTHENTICATE_HEADER_NAME = "WWW-Authenticate";
    public static final String WWW_AUTHENTICATE_HEADER_VALUE = "Basic realm=\"xenon\"";
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String BASIC_AUTH_NAME = "Basic";

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public boolean queueRequest(Operation op) {
        if (this.getSelfLink().equals(op.getUri().getPath())) {
            return false;
        }
        op.complete();
        return true;
    }

    @Override
    public void handlePost(Operation op) {
        if (op.hasPragmaDirective("xn-verify-token")) {
            BasicAuthenticationUtils.handleTokenVerify(this, op);
            op.removePragmaDirective("xn-verify-token");
            return;
        }
        AuthenticationRequest.AuthenticationRequestType requestType = op.getBody(AuthenticationRequest.class).requestType;
        if (requestType == null) {
            requestType = AuthenticationRequest.AuthenticationRequestType.LOGIN;
        }
        switch (requestType) {
            case LOGIN: {
                String[] userNameAndPassword = BasicAuthenticationUtils.parseRequest(this, op);
                if (userNameAndPassword == null) {
                    return;
                }
                BasicAuthenticationUtils.BasicAuthenticationContext authContext = new BasicAuthenticationUtils.BasicAuthenticationContext();
                authContext.userQuery = QueryTask.Query.Builder.create().addKindFieldClause(UserService.UserState.class).addFieldClause("email", userNameAndPassword[0]).build();
                authContext.authQuery = QueryTask.Query.Builder.create().addKindFieldClause(AuthCredentialsService.AuthCredentialsServiceState.class).addFieldClause("userEmail", userNameAndPassword[0]).addFieldClause("privateKey", userNameAndPassword[1]).build();
                BasicAuthenticationUtils.handleLogin(this, op, authContext);
                break;
            }
            case LOGOUT: {
                BasicAuthenticationUtils.handleLogout(this, op);
                break;
            }
        }
    }
}

