/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.TransactionService;

public class TransactionResolutionService {
    StatefulService parent;

    public TransactionResolutionService(StatefulService parent) {
        this.parent = parent;
    }

    public void handleResolutionRequest(Operation op) {
        TransactionService.ResolutionRequest resolutionRequest = op.getBody(TransactionService.ResolutionRequest.class);
        Operation subscribeToCoordinator = Operation.createPost(UriUtils.buildSubscriptionUri(this.parent.getUri())).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            Operation operation = Operation.createPatch(this.parent.getUri()).setBody(resolutionRequest).setCompletion((o2, e2) -> {
                if (e2 != null) {
                    op.fail(e2);
                    return;
                }
                this.parent.logInfo("Transaction resolution request has been accepted by %s", this.parent.getSelfLink());
            });
            this.parent.logInfo("Sending transaction resolution request to %s with kind %s", new Object[]{this.parent.getSelfLink(), resolutionRequest.resolutionKind});
            this.parent.sendRequest(operation);
        }).setReferer(this.parent.getUri());
        this.parent.logInfo("Subscribing to transaction resolution on %s", this.parent.getSelfLink());
        this.parent.getHost().startSubscriptionService(subscribeToCoordinator, notifyOp -> {
            TransactionService.ResolutionRequest resolve = notifyOp.getBody(TransactionService.ResolutionRequest.class);
            notifyOp.complete();
            this.parent.logInfo("Received notification: action=%s, resolution=%s", new Object[]{notifyOp.getAction(), resolve.resolutionKind});
            if (this.isNotComplete(resolve.resolutionKind)) {
                return;
            }
            if (resolve.resolutionKind == TransactionService.ResolutionKind.COMMITTED && resolutionRequest.resolutionKind == TransactionService.ResolutionKind.COMMIT || resolve.resolutionKind == TransactionService.ResolutionKind.ABORTED && resolutionRequest.resolutionKind == TransactionService.ResolutionKind.ABORT) {
                this.parent.logInfo("Resolution of transaction %s is complete", this.parent.getSelfLink());
                op.setBodyNoCloning(notifyOp.getBodyRaw());
                op.setStatusCode(notifyOp.getStatusCode());
                op.complete();
            } else {
                String errorMsg = String.format("Resolution %s of transaction %s is different than requested", new Object[]{resolve.resolutionKind, this.parent.getSelfLink()});
                this.parent.logWarning(errorMsg, new Object[0]);
                op.fail(new IllegalStateException(errorMsg));
            }
            Operation.createDelete(this.parent.getUri()).addPragmaDirective("xn-no-index-update").sendWith(this.parent);
        });
    }

    private boolean isNotComplete(TransactionService.ResolutionKind kind) {
        return kind != TransactionService.ResolutionKind.COMMITTED && kind != TransactionService.ResolutionKind.ABORTED;
    }
}

