/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.LuceneDocumentIndexService;
import com.vmware.xenon.services.common.UpdateIndexRequest;
import java.util.concurrent.TimeUnit;

public class OperationIndexService
extends LuceneDocumentIndexService {
    public static final String SELF_LINK = "/core/operation-index";
    public static final String FILE_PATH = "lucene-operation-index";
    public static final long DEFAULT_EXPIRATION_INTERVAL_MICROS = TimeUnit.DAYS.toMicros(1L);

    public OperationIndexService() {
        super(FILE_PATH);
    }

    @Override
    public void handleRequest(Operation op) {
        if (op.getAction() == Service.Action.DELETE) {
            try {
                super.handleDeleteImpl(op);
            }
            catch (Throwable e) {
                op.fail(e);
            }
            return;
        }
        if (!op.hasBody() || !op.getAction().equals((Object)Service.Action.POST)) {
            super.handleRequest(op);
            return;
        }
        Operation.SerializedOperation state = op.getBody(Operation.SerializedOperation.class);
        if (state.documentKind != null && !state.documentKind.equals(Operation.SerializedOperation.KIND)) {
            op.fail(new IllegalArgumentException("documentKind is not SerializedOperation"));
            return;
        }
        state.documentExpirationTimeMicros = Utils.fromNowMicrosUtc(DEFAULT_EXPIRATION_INTERVAL_MICROS);
        state.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        if (state.documentSelfLink == null) {
            state.documentSelfLink = state.documentUpdateTimeMicros + "";
        }
        state.documentUpdateAction = op.getAction().toString();
        UpdateIndexRequest req = new UpdateIndexRequest();
        req.description = Operation.SerializedOperation.DESCRIPTION;
        req.document = state;
        op.setBodyNoCloning(req);
        super.handleRequest(op);
    }
}

