/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.nio.ByteBuffer;

final class ByteBufferSerializer
extends Serializer<ByteBuffer> {
    public static final Serializer<ByteBuffer> INSTANCE = new ByteBufferSerializer();

    ByteBufferSerializer() {
    }

    public void write(Kryo kryo, Output output, ByteBuffer object) {
        int count = object.limit();
        byte[] array = object.array();
        output.writeInt(count);
        output.writeBytes(array, 0, count);
    }

    public ByteBuffer read(Kryo kryo, Input input, Class<ByteBuffer> type) {
        int length = input.readInt();
        return ByteBuffer.wrap(input.readBytes(length));
    }
}

