/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.CookieJar;
import com.vmware.xenon.common.http.netty.MaintenanceProxyService;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import com.vmware.xenon.common.http.netty.NettyFullHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.AsciiString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public class NettyHttpServiceClient
implements ServiceClient {
    public static final int DEFAULT_CONNECTIONS_PER_HOST = ServiceClient.DEFAULT_CONNECTION_LIMIT_PER_HOST;
    public static final Logger LOGGER = Logger.getLogger(ServiceClient.class.getName());
    private static final String ENV_VAR_NAME_HTTP_PROXY = "http_proxy";
    static final AsciiString TRANSACTION_ID_HEADER_ASCII = new AsciiString((CharSequence)"x-xenon-tx-id");
    static final AsciiString CONTEXT_ID_HEADER_ASCII = new AsciiString((CharSequence)"x-xenon-ctx-id");
    static final AsciiString AUTH_TOKEN_HEADER_ASCII = new AsciiString((CharSequence)"x-xenon-auth-token");
    static final AsciiString DEFAULT_MEDIA_TYPE_ASCII = new AsciiString((CharSequence)"*/*");
    static final AsciiString PRAGMA_DIRECTIVE_REPLICATED_ASCII = new AsciiString((CharSequence)"xn-rpl");
    static final AsciiString MEDIA_TYPE_JSON_ASCII = new AsciiString((CharSequence)"application/json");
    static final AsciiString MEDIA_TYPE_KRYO_OCTET_STREAM_ASCII = new AsciiString((CharSequence)"application/kryo-octet-stream");
    private static final int MEDIA_TYPE_APPLICATION_PREFIX_LENGTH = 12;
    private URI httpProxy;
    private AsciiString userAgentAscii;
    private NettyChannelPool sslChannelPool;
    private NettyChannelPool channelPool;
    private NettyChannelPool http2ChannelPool;
    private SortedMap<Long, Operation> pendingRequests = new ConcurrentSkipListMap<Long, Operation>();
    private ScheduledExecutorService scheduledExecutor;
    private ExecutorService executor;
    private SSLContext sslContext;
    private ServiceHost host;
    private CookieJar cookieJar = new CookieJar();
    private boolean isStarted;
    private boolean warnHttp2DisablingConnectionSharing = false;
    private final Object startSync = new Object();

    public static ServiceClient create(String userAgent, ExecutorService executor, ScheduledExecutorService scheduledExecutor) throws URISyntaxException {
        return NettyHttpServiceClient.create(userAgent, executor, scheduledExecutor, null);
    }

    public static ServiceClient create(String userAgent, ExecutorService executor, ScheduledExecutorService scheduledExecutor, ServiceHost host) throws URISyntaxException {
        NettyHttpServiceClient sc = new NettyHttpServiceClient();
        sc.userAgentAscii = new AsciiString((CharSequence)userAgent);
        sc.scheduledExecutor = scheduledExecutor;
        sc.executor = executor;
        sc.host = host;
        sc.channelPool = new NettyChannelPool();
        sc.http2ChannelPool = new NettyChannelPool();
        sc.sslChannelPool = new NettyChannelPool();
        String proxy = System.getenv(ENV_VAR_NAME_HTTP_PROXY);
        if (proxy != null) {
            sc.setHttpProxy(new URI(proxy));
        }
        sc.setConnectionLimitPerHost(DEFAULT_CONNECTION_LIMIT_PER_HOST);
        sc.setConnectionLimitPerTag("xn-cnx-tag-default", DEFAULT_CONNECTIONS_PER_HOST);
        sc.setConnectionLimitPerTag("xn-cnx-tag-http2-default", DEFAULT_CONNECTION_LIMIT_PER_TAG);
        sc.setRequestPayloadSizeLimit(ServiceClient.REQUEST_PAYLOAD_SIZE_LIMIT);
        return sc;
    }

    private String buildThreadTag() {
        if (this.host != null) {
            return UriUtils.extendUri(this.host.getUri(), "netty-client").toString();
        }
        return this.getClass().getSimpleName() + ":" + Utils.getSystemNowMicrosUtc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.startSync;
        synchronized (object) {
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
        }
        this.channelPool.setThreadTag(this.buildThreadTag());
        this.channelPool.setThreadCount(Utils.DEFAULT_IO_THREAD_COUNT);
        this.channelPool.setExecutor(this.executor);
        this.channelPool.start();
        this.http2ChannelPool.setThreadTag(this.buildThreadTag());
        this.http2ChannelPool.setThreadCount(Utils.DEFAULT_IO_THREAD_COUNT);
        this.http2ChannelPool.setExecutor(this.executor);
        this.http2ChannelPool.setHttp2Only();
        this.http2ChannelPool.start();
        if (this.sslContext != null) {
            this.sslChannelPool.setThreadTag(this.buildThreadTag());
            this.sslChannelPool.setThreadCount(Utils.DEFAULT_IO_THREAD_COUNT);
            this.sslChannelPool.setExecutor(this.executor);
            this.sslChannelPool.setSSLContext(this.sslContext);
            this.sslChannelPool.start();
        }
        if (this.host != null) {
            MaintenanceProxyService.start(this.host, this::handleMaintenance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.startSync;
        synchronized (object) {
            if (!this.isStarted) {
                return;
            }
            this.isStarted = false;
        }
        this.channelPool.stop();
        this.sslChannelPool.stop();
        this.http2ChannelPool.stop();
        this.pendingRequests.clear();
    }

    public ServiceClient setHttpProxy(URI proxy) {
        this.httpProxy = proxy;
        return this;
    }

    @Override
    public void send(Operation op) {
        this.sendRequest(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(Operation op) {
        if (!NettyHttpServiceClient.validateOperation(op)) {
            return;
        }
        Operation clone = op.clone();
        this.setExpiration(clone);
        this.setCookies(clone);
        OperationContext ctx = OperationContext.getOperationContext();
        try {
            if (!op.isRemote() && this.host != null && this.host.handleRequest(clone)) {
                return;
            }
            this.sendRemote(clone);
        }
        finally {
            OperationContext.restoreOperationContext(ctx);
        }
    }

    private void setExpiration(Operation op) {
        if (op.getExpirationMicrosUtc() != 0L) {
            return;
        }
        long expMicros = this.host != null ? this.host.getOperationTimeoutMicros() : ServiceHost.ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS;
        op.setExpiration(Utils.fromNowMicrosUtc(expMicros));
    }

    private void setCookies(Operation clone) {
        if (this.cookieJar.isEmpty()) {
            return;
        }
        clone.setCookies(this.cookieJar.list(clone.getUri()));
    }

    private void startTracking(Operation op) {
        this.pendingRequests.put(op.getId(), op);
    }

    void stopTracking(Operation op) {
        this.pendingRequests.remove(op.getId());
    }

    private void updateCookieJarFromResponseHeaders(Operation op) {
        String value = op.getResponseHeaderAsIs("set-cookie");
        if (value == null) {
            return;
        }
        Cookie cookie = ClientCookieDecoder.LAX.decode(value);
        if (cookie == null) {
            return;
        }
        this.cookieJar.add(op.getUri(), cookie);
    }

    private void sendRemote(Operation op) {
        this.startTracking(op);
        String remoteHost = op.getUri().getHost();
        String scheme = op.getUri().getScheme();
        int port = op.getUri().getPort();
        if (this.httpProxy != null && !"127.0.0.1".equals(remoteHost)) {
            remoteHost = this.httpProxy.getHost();
            port = this.httpProxy.getPort();
            scheme = this.httpProxy.getScheme();
        }
        boolean isHttpScheme = false;
        boolean isHttpsScheme = scheme.equals("https");
        if (!isHttpsScheme) {
            isHttpScheme = scheme.equals("http");
        }
        if (!isHttpScheme && !isHttpsScheme) {
            op.setRetryCount(0);
            this.fail(new IllegalArgumentException("Scheme is not supported: " + op.getUri().getScheme()), op, op.getBodyRaw());
            return;
        }
        if (isHttpsScheme && this.getSSLContext() == null) {
            op.setRetryCount(0);
            this.fail(new IllegalArgumentException("HTTPS not enabled, set SSL context before starting client:" + op.getUri()), op, op.getBodyRaw());
            return;
        }
        if (port == -1) {
            int n = port = isHttpScheme ? 80 : 443;
        }
        if (op.isConnectionSharing() && isHttpsScheme) {
            op.setConnectionSharing(false);
            if (!this.warnHttp2DisablingConnectionSharing) {
                this.warnHttp2DisablingConnectionSharing = true;
                LOGGER.warning("HTTP/2 requests are not supported on HTTPS. Falling back to HTTP1.1");
            }
        }
        NettyChannelPool pool = this.channelPool;
        if (op.isConnectionSharing()) {
            pool = this.http2ChannelPool;
        }
        if (isHttpsScheme) {
            pool = this.sslChannelPool;
            op.setConnectionSharing(false);
        }
        this.connectChannel(pool, op, remoteHost, port);
    }

    private void connectChannel(NettyChannelPool pool, Operation op, String remoteHost, int port) {
        op.nestCompletion((o, e) -> {
            if (o.getStatusCode() == 408) {
                this.failWithTimeout(op, op.getBodyRaw());
                return;
            }
            if (e != null) {
                op.setBody(ServiceErrorResponse.create(e, 400, EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)));
                this.fail(e, op, op.getBodyRaw());
                return;
            }
            op.toggleOption(Operation.OperationOption.SOCKET_ACTIVE, true);
            this.sendHttpRequest(op);
        });
        NettyChannelPool.NettyChannelGroupKey key = NettyChannelPool.buildLookupKey(op.getConnectionTag(), remoteHost, port, pool.isHttp2Only());
        pool.connectOrReuse(key, op);
    }

    private void sendHttpRequest(Operation op) {
        Object originalBody = op.getBodyRaw();
        try {
            boolean isXenonToXenon;
            byte[] body = Utils.encodeBody(op);
            if (op.getContentLength() > (long)this.getRequestPayloadSizeLimit()) {
                String error = String.format("Content length %d, limit is %d", op.getContentLength(), this.getRequestPayloadSizeLimit());
                IllegalArgumentException e2 = new IllegalArgumentException(error);
                op.setBody(ServiceErrorResponse.create(e2, 400));
                this.fail(e2, op, originalBody);
                return;
            }
            String path = op.getUri().getPath();
            String query = op.getUri().getRawQuery();
            String userInfo = op.getUri().getRawUserInfo();
            path = path == null || path.isEmpty() ? "/" : path;
            String pathAndQuery = query != null ? path + "?" + query : path;
            boolean useHttp2 = op.isConnectionSharing();
            if (this.httpProxy != null || useHttp2 || userInfo != null) {
                pathAndQuery = op.getUri().toString();
            }
            NettyFullHttpRequest request = null;
            HttpMethod method = NettyHttpServiceClient.toHttpMethod(op.getAction());
            if (body == null || body.length == 0) {
                request = new NettyFullHttpRequest(HttpVersion.HTTP_1_1, method, pathAndQuery, Unpooled.buffer((int)0), false);
            } else {
                ByteBuf content = Unpooled.wrappedBuffer((byte[])body, (int)0, (int)((int)op.getContentLength()));
                request = new NettyFullHttpRequest(HttpVersion.HTTP_1_1, method, pathAndQuery, content, false);
            }
            HttpHeaders httpHeaders = request.headers();
            boolean hasRequestHeaders = op.hasRequestHeaders();
            if (useHttp2) {
                if (hasRequestHeaders) {
                    op.getAndRemoveRequestHeaderAsIs("x-http2-stream-id");
                }
                request.setOperation(op);
            }
            String pragmaValue = op.getAndRemoveRequestHeaderAsIs("pragma");
            String acceptValue = op.getAndRemoveRequestHeaderAsIs("accept");
            String authTokenValue = op.getAndRemoveRequestHeaderAsIs("x-xenon-auth-token");
            if (op.isFromReplication() && pragmaValue == null) {
                httpHeaders.add((CharSequence)HttpHeaderNames.PRAGMA, (Object)PRAGMA_DIRECTIVE_REPLICATED_ASCII);
            } else if (pragmaValue != null) {
                httpHeaders.add((CharSequence)HttpHeaderNames.PRAGMA, (Object)pragmaValue);
            }
            if (op.getTransactionId() != null) {
                httpHeaders.add((CharSequence)TRANSACTION_ID_HEADER_ASCII, (Object)op.getTransactionId());
            }
            if (op.getContextId() != null) {
                httpHeaders.add((CharSequence)CONTEXT_ID_HEADER_ASCII, (Object)op.getContextId());
            }
            hasRequestHeaders = op.hasRequestHeaders();
            boolean bl = isXenonToXenon = op.isFromReplication() || op.isForwarded();
            if (hasRequestHeaders) {
                op.getAndRemoveRequestHeaderAsIs("content-length");
                op.getAndRemoveRequestHeaderAsIs("content-type");
                op.getAndRemoveRequestHeaderAsIs("connection");
                op.getAndRemoveRequestHeaderAsIs("referer");
                op.getAndRemoveRequestHeaderAsIs("host");
                op.getAndRemoveRequestHeaderAsIs("user-agent");
                hasRequestHeaders = op.hasRequestHeaders();
            }
            if (hasRequestHeaders) {
                for (Map.Entry<String, String> nameValue : op.getRequestHeaders().entrySet()) {
                    httpHeaders.add(nameValue.getKey(), (Object)nameValue.getValue());
                }
            }
            if (authTokenValue != null) {
                httpHeaders.add((CharSequence)AUTH_TOKEN_HEADER_ASCII, (Object)authTokenValue);
            } else {
                Operation.AuthorizationContext ctx = op.getAuthorizationContext();
                if (ctx != null && ctx.getToken() != null) {
                    httpHeaders.add((CharSequence)AUTH_TOKEN_HEADER_ASCII, (Object)ctx.getToken());
                }
            }
            this.setAsciiContentType(op, httpHeaders);
            httpHeaders.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Long.toString(op.getContentLength()));
            if (op.isKeepAlive()) {
                httpHeaders.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            if (op.hasReferer() && !op.isFromReplication()) {
                httpHeaders.add((CharSequence)HttpHeaderNames.REFERER, (Object)op.getRefererAsString());
            }
            if (!isXenonToXenon) {
                if (op.getCookies() != null) {
                    String header = CookieJar.encodeCookies(op.getCookies());
                    httpHeaders.set((CharSequence)HttpHeaderNames.COOKIE, (Object)header);
                }
                request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.userAgentAscii);
                if (acceptValue == null) {
                    httpHeaders.add((CharSequence)HttpHeaderNames.ACCEPT, (Object)DEFAULT_MEDIA_TYPE_ASCII);
                } else {
                    httpHeaders.add((CharSequence)HttpHeaderNames.ACCEPT, (Object)acceptValue);
                }
                httpHeaders.add((CharSequence)HttpHeaderNames.HOST, (Object)op.getUri().getHost());
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                this.logRequestFraming(op, request);
            }
            boolean doCookieJarUpdate = !isXenonToXenon;
            op.nestCompletion((o, e) -> {
                if (e != null) {
                    this.fail(e, op, originalBody);
                    return;
                }
                this.stopTracking(op);
                if (doCookieJarUpdate) {
                    this.updateCookieJarFromResponseHeaders(o);
                }
                op.complete();
            });
            op.getSocketContext().writeHttpRequest((Object)request);
        }
        catch (Throwable e3) {
            op.setBody(ServiceErrorResponse.create(e3, 400, EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY)));
            this.fail(e3, op, originalBody);
        }
    }

    private void setAsciiContentType(Operation op, HttpHeaders httpHeaders) {
        String contentType = op.getContentType();
        if (contentType.length() >= 12 && contentType.charAt(12) == 'k' && "application/kryo-octet-stream".hashCode() == contentType.hashCode()) {
            httpHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)MEDIA_TYPE_KRYO_OCTET_STREAM_ASCII);
        } else if (contentType.length() >= 12 && contentType.charAt(12) == 'j' && "application/json".hashCode() == contentType.hashCode()) {
            httpHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)MEDIA_TYPE_JSON_ASCII);
        } else {
            httpHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)op.getContentType());
        }
    }

    private void logRequestFraming(Operation op, NettyFullHttpRequest request) {
        StringBuilder s = new StringBuilder();
        s.append(op.getAction().toString()).append(" ").append(op.getUri().toString()).append("\n");
        request.headers().forEach(e -> s.append(e.toString()).append("\n"));
        LOGGER.info(s.toString());
    }

    private static HttpMethod toHttpMethod(Service.Action a) {
        switch (a) {
            case DELETE: {
                return HttpMethod.DELETE;
            }
            case GET: {
                return HttpMethod.GET;
            }
            case OPTIONS: {
                return HttpMethod.OPTIONS;
            }
            case PATCH: {
                return HttpMethod.PATCH;
            }
            case POST: {
                return HttpMethod.POST;
            }
            case PUT: {
                return HttpMethod.PUT;
            }
        }
        throw new IllegalArgumentException("unknown method " + (Object)((Object)a));
    }

    private void failWithTimeout(Operation op, Object originalBody) {
        TimeoutException e = new TimeoutException(op.getUri() + ":" + op.getExpirationMicrosUtc());
        op.setStatusCode(408);
        this.fail(e, op, originalBody);
    }

    private void fail(Throwable e, Operation op, Object originalBody) {
        boolean isRetryRequested;
        this.stopTracking(op);
        Operation.SocketContext ctx = op.getSocketContext();
        if (ctx != null && ctx instanceof NettyChannelContext) {
            ExecutorService exec;
            NettyChannelContext nettyCtx = (NettyChannelContext)op.getSocketContext();
            NettyChannelPool pool = this.channelPool;
            if (this.sslChannelPool != null && this.sslChannelPool.isContextInUse(nettyCtx)) {
                pool = this.sslChannelPool;
            }
            Runnable r = null;
            if (nettyCtx.getProtocol() == NettyChannelContext.Protocol.HTTP2) {
                r = () -> this.http2ChannelPool.returnOrClose(nettyCtx, false);
            } else {
                op.setSocketContext(null);
                NettyChannelPool finalPool = pool;
                r = () -> finalPool.returnOrClose(nettyCtx, !op.isKeepAlive());
            }
            ExecutorService executorService = exec = this.host != null ? this.host.getExecutor() : this.executor;
            if (exec != null) {
                exec.execute(r);
            } else {
                r.run();
            }
        }
        if (this.scheduledExecutor.isShutdown()) {
            op.fail(new CancellationException());
            return;
        }
        boolean bl = isRetryRequested = op.getRetryCount() > 0 && op.decrementRetriesRemaining() >= 0;
        if (isRetryRequested) {
            if (op.getStatusCode() >= 500) {
                isRetryRequested = false;
            } else if (op.getStatusCode() == 409) {
                isRetryRequested = false;
            } else if (op.getStatusCode() == 401) {
                isRetryRequested = false;
            } else if (op.getStatusCode() == 404) {
                isRetryRequested = false;
            } else if (op.getStatusCode() == 403) {
                isRetryRequested = false;
            }
        }
        if (!isRetryRequested) {
            LOGGER.fine(() -> String.format("Send of %d, from %s to %s failed with %s", op.getId(), op.getRefererAsString(), op.getUri(), e));
            op.fail(e);
            return;
        }
        LOGGER.info(String.format("Retry %d of request %d from %s to %s due to %s", op.getRetryCount() - op.getRetriesRemaining(), op.getId(), op.getRefererAsString(), op.getUri(), e));
        int delaySeconds = op.getRetryCount() - op.getRetriesRemaining();
        op.setStatusCode(200).setBodyNoCloning(originalBody);
        this.scheduledExecutor.schedule(() -> {
            this.startTracking(op);
            this.sendRemote(op);
        }, (long)delaySeconds, TimeUnit.SECONDS);
    }

    private static boolean validateOperation(Operation op) {
        if (op == null) {
            throw new IllegalArgumentException("Operation is required");
        }
        IllegalArgumentException e = null;
        if (op.getUri() == null) {
            e = new IllegalArgumentException("Uri is required");
        } else if (op.getUri().getHost() == null) {
            e = new IllegalArgumentException("Missing host in URI");
        } else if (op.getAction() == null) {
            e = new IllegalArgumentException("Action is required");
        } else if (!op.hasReferer()) {
            e = new IllegalArgumentException("Referer is required");
        } else {
            boolean needsBody;
            boolean bl = needsBody = op.getAction() != Service.Action.GET && op.getAction() != Service.Action.DELETE && op.getAction() != Service.Action.POST && op.getAction() != Service.Action.OPTIONS;
            if (!op.hasBody() && needsBody) {
                e = new IllegalArgumentException("Body is required");
            }
        }
        if (e == null) {
            return true;
        }
        Operation.CompletionHandler c = op.getCompletion();
        if (c != null) {
            c.handle(op, e);
            return false;
        }
        throw new RuntimeException(e);
    }

    @Override
    public void handleMaintenance(Operation op) {
        long now = Utils.getSystemNowMicrosUtc();
        if (this.sslChannelPool != null) {
            this.sslChannelPool.handleMaintenance(Operation.createPost(op.getUri()));
        }
        if (this.http2ChannelPool != null) {
            this.http2ChannelPool.handleMaintenance(Operation.createPost(op.getUri()));
        }
        this.channelPool.handleMaintenance(Operation.createPost(op.getUri()));
        this.failExpiredRequests(now);
        op.complete();
    }

    private void failExpiredRequests(long now) {
        if (this.pendingRequests.isEmpty()) {
            return;
        }
        int searchLimit = 1000;
        long epsilonMicros = TimeUnit.SECONDS.toMicros(1L);
        int expiredCount = 0;
        int forcedExpiredCount = 0;
        int i = 0;
        for (Operation o : this.pendingRequests.values()) {
            boolean forceExpiration;
            if (i++ >= 1000) break;
            long exp = o.getExpirationMicrosUtc();
            if (exp > now) continue;
            boolean bl = forceExpiration = o.hasOption(Operation.OperationOption.CONNECTION_SHARING) && now - exp > epsilonMicros;
            if (!forceExpiration && !o.hasOption(Operation.OperationOption.SOCKET_ACTIVE)) continue;
            o.fail(408);
            ++expiredCount;
            if (!forceExpiration) continue;
            ++forcedExpiredCount;
        }
        if (expiredCount == 0) {
            return;
        }
        LOGGER.info("Failed expired operations, count: " + expiredCount + " forced count: " + forcedExpiredCount);
    }

    @Override
    public ServiceClient setConnectionLimitPerHost(int limit) {
        this.channelPool.setConnectionLimitPerHost(limit);
        if (this.sslChannelPool != null) {
            this.sslChannelPool.setConnectionLimitPerHost(limit);
        }
        if (this.http2ChannelPool != null) {
            this.http2ChannelPool.setConnectionLimitPerHost(limit);
        }
        return this;
    }

    @Override
    public int getConnectionLimitPerHost() {
        return this.channelPool.getConnectionLimitPerHost();
    }

    @Override
    public ServiceClient setConnectionLimitPerTag(String tag, int limit) {
        this.channelPool.setConnectionLimitPerTag(tag, limit);
        if (this.sslChannelPool != null) {
            this.sslChannelPool.setConnectionLimitPerTag(tag, limit);
        }
        if (this.http2ChannelPool != null) {
            this.http2ChannelPool.setConnectionLimitPerTag(tag, limit);
        }
        return this;
    }

    @Override
    public int getConnectionLimitPerTag(String tag) {
        return this.channelPool.getConnectionLimitPerTag(tag);
    }

    @Override
    public ServiceClient setSSLContext(SSLContext context) {
        this.sslContext = context;
        return this;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public NettyChannelPool getChannelPool() {
        return this.channelPool;
    }

    public NettyChannelPool getHttp2ChannelPool() {
        return this.http2ChannelPool;
    }

    public NettyChannelPool getSslChannelPool() {
        return this.sslChannelPool;
    }

    public NettyChannelContext getInUseHttp2Context(String tag, String host, int port) {
        if (this.http2ChannelPool == null) {
            throw new IllegalStateException("Internal error: no HTTP/2 channel pool");
        }
        return this.http2ChannelPool.getFirstValidHttp2Context(tag, host, port);
    }

    @Override
    public ServiceClient.ConnectionPoolMetrics getConnectionPoolMetrics(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is required");
        }
        ServiceClient.ConnectionPoolMetrics tagInfo = null;
        if (this.http2ChannelPool != null) {
            tagInfo = this.http2ChannelPool.getConnectionTagInfo(tag);
        }
        if (tagInfo != null) {
            return tagInfo;
        }
        if (this.channelPool != null) {
            tagInfo = this.channelPool.getConnectionTagInfo(tag);
        }
        ServiceClient.ConnectionPoolMetrics secureTagInfo = null;
        if (this.sslChannelPool != null) {
            secureTagInfo = this.sslChannelPool.getConnectionTagInfo(tag);
        }
        if (tagInfo == null) {
            tagInfo = secureTagInfo;
        } else if (secureTagInfo != null) {
            tagInfo.inUseConnectionCount += secureTagInfo.inUseConnectionCount;
            tagInfo.pendingRequestCount += secureTagInfo.pendingRequestCount;
            tagInfo.availableConnectionCount += secureTagInfo.availableConnectionCount;
        }
        return tagInfo;
    }

    public int getInUseContextCount(String tag, String host, int port) {
        if (this.http2ChannelPool == null) {
            throw new IllegalStateException("Internal error: no HTTP/2 channel pool");
        }
        return this.http2ChannelPool.getHttp2ActiveContextCount(tag, host, port);
    }

    public void clearCookieJar() {
        this.cookieJar = new CookieJar();
    }

    @Override
    public int getRequestPayloadSizeLimit() {
        return this.channelPool.getRequestPayloadSizeLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceClient setRequestPayloadSizeLimit(int limit) {
        Object object = this.startSync;
        synchronized (object) {
            if (this.isStarted) {
                throw new IllegalStateException("Already started");
            }
            this.channelPool.setRequestPayloadSizeLimit(limit);
            if (this.sslChannelPool != null) {
                this.sslChannelPool.setRequestPayloadSizeLimit(limit);
            }
            if (this.http2ChannelPool != null) {
                this.http2ChannelPool.setRequestPayloadSizeLimit(limit);
            }
        }
        return this;
    }
}

