/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.CookieJar;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyHttpListener;
import com.vmware.xenon.common.http.netty.NettyHttpServiceClient;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLSession;

public class NettyHttpClientRequestHandler
extends SimpleChannelInboundHandler<Object> {
    private static final String ERROR_MSG_DECODING_FAILURE = "Failure decoding HTTP request";
    private final ServiceHost host;
    private final SslHandler sslHandler;
    private int responsePayloadSizeLimit;
    private NettyHttpListener listener;

    public NettyHttpClientRequestHandler(ServiceHost host, NettyHttpListener listener, SslHandler sslHandler, int responsePayloadSizeLimit) {
        this.host = host;
        this.listener = listener;
        this.sslHandler = sslHandler;
        this.responsePayloadSizeLimit = responsePayloadSizeLimit;
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof FullHttpRequest;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.listener.addChannel(ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.listener.removeChannel(ctx.channel());
        super.channelInactive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Operation request = null;
        Integer streamId = null;
        try {
            FullHttpRequest nettyRequest = (FullHttpRequest)msg;
            long expMicros = Utils.fromNowMicrosUtc(this.host.getOperationTimeoutMicros());
            request = Operation.createGet(null);
            request.setAction(Service.Action.valueOf(nettyRequest.method().toString())).setExpiration(expMicros).forceRemote();
            streamId = nettyRequest.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            if (streamId == null) {
                ctx.channel().attr(NettyChannelContext.OPERATION_KEY).set((Object)request);
            }
            if (nettyRequest.decoderResult().isFailure()) {
                request.setStatusCode(400).setKeepAlive(false);
                request.setBody(ServiceErrorResponse.create(new IllegalArgumentException(ERROR_MSG_DECODING_FAILURE), request.getStatusCode()));
                this.sendResponse(ctx, request, streamId);
                return;
            }
            this.parseRequestHeaders(ctx, request, (HttpRequest)nettyRequest);
            this.parseRequestUri(request, nettyRequest);
            this.decodeRequestBody(ctx, request, nettyRequest.content(), streamId);
        }
        catch (Throwable e) {
            this.host.log(Level.SEVERE, "Uncaught exception: %s", Utils.toString(e));
            if (request == null) {
                request = Operation.createGet(this.host.getUri());
            }
            int sc = 400;
            if (e instanceof URISyntaxException) {
                request.setUri(this.host.getUri());
            }
            request.setKeepAlive(false).setStatusCode(sc).setBodyNoCloning(ServiceErrorResponse.create(e, sc));
            this.sendResponse(ctx, request, streamId);
        }
    }

    private void parseRequestUri(Operation request, FullHttpRequest nettyRequest) throws URISyntaxException {
        URI targetUri = new URI(nettyRequest.uri());
        String decodedQuery = null;
        if (!(request.isForwarded() || request.isFromReplication() || (decodedQuery = (targetUri = targetUri.normalize()).getQuery()) == null || decodedQuery.isEmpty())) {
            decodedQuery = QueryStringDecoder.decodeComponent((String)targetUri.getQuery());
        }
        String query = decodedQuery == null ? targetUri.getRawQuery() : decodedQuery;
        URI uri = new URI("http", targetUri.getUserInfo(), "127.0.0.1", this.host.getPort(), targetUri.getPath(), query, targetUri.getFragment());
        request.setUri(uri);
        if (!request.hasReferer() && request.isFromReplication()) {
            request.setReferer(request.getUri());
        }
    }

    private void decodeRequestBody(ChannelHandlerContext ctx, Operation request, ByteBuf content, Integer streamId) throws Exception {
        if (!content.isReadable()) {
            request.setContentLength(0L);
            this.submitRequest(ctx, request, streamId);
            return;
        }
        Utils.decodeBody(request, content.nioBuffer(), true);
        this.submitRequest(ctx, request, streamId);
    }

    private void parseRequestHeaders(ChannelHandlerContext ctx, Operation request, HttpRequest nettyRequest) {
        String cookie;
        String pragma;
        HttpHeaders headers = nettyRequest.headers();
        boolean hasHeaders = !headers.isEmpty();
        String referer = this.getAndRemove(headers, HttpHeaderNames.REFERER);
        if (referer != null) {
            request.setReferer(referer);
        }
        if (!hasHeaders) {
            return;
        }
        request.setKeepAlive(HttpUtil.isKeepAlive((HttpMessage)nettyRequest));
        if (HttpUtil.isContentLengthSet((HttpMessage)nettyRequest)) {
            request.setContentLength(HttpUtil.getContentLength((HttpMessage)nettyRequest));
            this.getAndRemove(headers, HttpHeaderNames.CONTENT_LENGTH);
        }
        if ("xn-rpl".equals(pragma = this.getAndRemove(headers, HttpHeaderNames.PRAGMA))) {
            request.setFromReplication(true).setTargetReplicated(true);
        } else if (pragma != null) {
            request.addRequestHeader("pragma", pragma);
            if (pragma.contains("xn-fwd")) {
                request.toggleOption(Operation.OperationOption.FORWARDED, true);
            }
        }
        if (pragma != null && pragma.contains("xn-rpl")) {
            request.setFromReplication(true).setTargetReplicated(true);
        }
        request.setContextId(this.getAndRemove(headers, NettyHttpServiceClient.CONTEXT_ID_HEADER_ASCII));
        request.setTransactionId(this.getAndRemove(headers, NettyHttpServiceClient.TRANSACTION_ID_HEADER_ASCII));
        String contentType = this.getAndRemove(headers, HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null) {
            request.setContentType(contentType);
        }
        if ((cookie = this.getAndRemove(headers, HttpHeaderNames.COOKIE)) != null) {
            request.setCookies(CookieJar.decodeCookies(cookie));
        }
        String host = this.getAndRemove(headers, HttpHeaderNames.HOST);
        for (Map.Entry h : headers) {
            String key = (String)h.getKey();
            String value = (String)h.getValue();
            if ("x-http2-stream-id".equals(key) || "x-http2-scheme".equals(key)) continue;
            request.addRequestHeader(key, value);
        }
        if (host != null) {
            request.addRequestHeader("host", host);
        }
        if (this.sslHandler == null) {
            return;
        }
        try {
            if (this.sslHandler.engine().getWantClientAuth() || this.sslHandler.engine().getNeedClientAuth()) {
                SSLSession session = this.sslHandler.engine().getSession();
                request.setPeerCertificates(session.getPeerPrincipal(), session.getPeerCertificateChain());
            }
        }
        catch (Exception e) {
            this.host.log(Level.WARNING, "Failed to get peer principal " + Utils.toString(e), new Object[0]);
        }
    }

    private String getAndRemove(HttpHeaders headers, AsciiString headerName) {
        String headerValue = headers.get((CharSequence)headerName);
        headers.remove((CharSequence)headerName);
        return headerValue;
    }

    private void submitRequest(ChannelHandlerContext ctx, Operation request, Integer streamId) {
        request.nestCompletion((o, e) -> {
            request.setBodyNoCloning(o.getBodyRaw());
            this.sendResponse(ctx, request, streamId);
        });
        request.toggleOption(Operation.OperationOption.CLONING_DISABLED, true);
        if (!request.hasReferer()) {
            this.setRefererFromSocketContext(ctx, request);
        }
        this.host.handleRequest(null, request);
    }

    private void sendResponse(ChannelHandlerContext ctx, Operation request, Integer streamId) {
        try {
            this.applyRateLimit(ctx, request);
            this.writeResponseUnsafe(ctx, request, streamId);
        }
        catch (Throwable e1) {
            this.host.log(Level.SEVERE, "%s", Utils.toString(e1));
        }
    }

    private void applyRateLimit(ChannelHandlerContext ctx, Operation request) {
        if (!request.hasOption(Operation.OperationOption.RATE_LIMITED)) {
            return;
        }
        this.listener.pauseChannel(ctx.channel());
    }

    private void writeResponseUnsafe(ChannelHandlerContext ctx, Operation request, Integer streamId) {
        Operation.AuthorizationContext authorizationContext;
        ByteBuf bodyBuffer = null;
        try {
            byte[] data = Utils.encodeBody(request);
            if (request.getContentLength() > (long)this.responsePayloadSizeLimit) {
                String errorMessage = "Content-Length " + request.getContentLength() + " is greater than max size allowed " + this.responsePayloadSizeLimit;
                this.host.log(Level.SEVERE, errorMessage, new Object[0]);
                this.writeInternalServerError(ctx, request, streamId, errorMessage);
                return;
            }
            if (data != null) {
                bodyBuffer = Unpooled.wrappedBuffer((byte[])data);
            }
        }
        catch (Throwable e1) {
            this.host.log(Level.SEVERE, "Error encoding body: %s", Utils.toString(e1));
            this.writeInternalServerError(ctx, request, streamId, "Error encoding body: " + e1.getMessage());
            return;
        }
        DefaultFullHttpResponse response = bodyBuffer == null || request.getStatusCode() == 304 ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)request.getStatusCode()), false, false) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)request.getStatusCode()), bodyBuffer, false, false);
        if (streamId != null) {
            response.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), streamId.intValue());
        }
        request.getAndRemoveResponseHeaderAsIs("x-http2-stream-weight");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)request.getContentType());
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
        if (request.hasResponseHeaders()) {
            for (Map.Entry<String, String> nameValue : request.getResponseHeaders().entrySet()) {
                response.headers().set(nameValue.getKey(), (Object)nameValue.getValue());
            }
        }
        if ((authorizationContext = request.getAuthorizationContext()) != null && authorizationContext.shouldPropagateToClient()) {
            String token = authorizationContext.getToken();
            response.headers().add("x-xenon-auth-token", (Object)token);
            StringBuilder buf = new StringBuilder().append("xenon-auth-cookie").append('=').append(token);
            buf.append("; Path=/");
            if (authorizationContext.getClaims().getExpirationTime() != null) {
                buf.append("; Max-Age=");
                long maxAge = authorizationContext.getClaims().getExpirationTime() - Utils.getSystemNowMicrosUtc();
                buf.append(maxAge > 0L ? TimeUnit.MICROSECONDS.toSeconds(maxAge) : 0L);
            }
            response.headers().add("set-cookie", (Object)buf.toString());
        }
        this.writeResponse(ctx, request, (FullHttpResponse)response);
    }

    private void writeInternalServerError(ChannelHandlerContext ctx, Operation request, Integer streamId, String err) {
        byte[] data;
        try {
            data = err.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            this.exceptionCaught(ctx, ueex);
            return;
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])data), false, false);
        if (streamId != null) {
            response.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), streamId.intValue());
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
        this.writeResponse(ctx, request, (FullHttpResponse)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Operation op = (Operation)ctx.channel().attr(NettyChannelContext.OPERATION_KEY).get();
        if (op != null) {
            this.host.log(Level.SEVERE, "HTTP/1.1 listener channel exception: %s, in progress op: %s", cause.getMessage(), op.toString());
        } else {
            this.host.log(Level.SEVERE, "Listener channel exception: %s", cause.getMessage());
        }
        ctx.channel().attr(NettyChannelContext.OPERATION_KEY).set(null);
        ctx.close();
    }

    private void setRefererFromSocketContext(ChannelHandlerContext ctx, Operation request) {
        try {
            InetSocketAddress remote = (InetSocketAddress)ctx.channel().remoteAddress();
            String path = "unknown-client";
            request.setReferer(UriUtils.buildUri(this.sslHandler != null ? "https" : "http", remote.getHostString(), remote.getPort(), path, null));
        }
        catch (Throwable e) {
            this.host.log(Level.SEVERE, "%s", Utils.toString(e));
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, Operation request, FullHttpResponse response) {
        boolean isClose = !request.isKeepAlive() || response == null;
        ByteBuf rsp = Unpooled.EMPTY_BUFFER;
        if (response != null) {
            AsciiString v = isClose ? HttpHeaderValues.CLOSE : HttpHeaderValues.KEEP_ALIVE;
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)v);
            rsp = response;
        }
        ctx.channel().attr(NettyChannelContext.OPERATION_KEY).set(null);
        ChannelFuture future = ctx.writeAndFlush((Object)rsp);
        if (isClose) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

