/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import java.util.function.Consumer;

public class MaintenanceProxyService
extends StatelessService {
    private Consumer<Operation> parentHandler;

    public static void start(ServiceHost host, Consumer<Operation> parentHandler) {
        MaintenanceProxyService s = new MaintenanceProxyService(parentHandler);
        String path = UriUtils.buildUriPath("/core", "netty-maint-proxies", host.nextUUID());
        host.startService(Operation.createPost(UriUtils.buildUri(host, path)), s);
    }

    public MaintenanceProxyService(Consumer<Operation> parentHandler) {
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        this.parentHandler = parentHandler;
    }

    @Override
    public void handleMaintenance(Operation post) {
        this.parentHandler.accept(post);
    }
}

