/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.ODataFactoryQueryResult;
import com.vmware.xenon.common.ODataUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.SynchronizationTaskService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.TransactionServiceHelper;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupBroadcastResponse;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.QueryTaskUtils;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class FactoryService
extends StatelessService {
    public static final Integer SELF_QUERY_RESULT_LIMIT = Integer.getInteger("xenon.FactoryService.SELF_QUERY_RESULT_LIMIT", 1000);
    private EnumSet<Service.ServiceOption> childOptions;
    private String nodeSelectorLink = "/core/node-selectors/default";
    private int selfQueryResultLimit = SELF_QUERY_RESULT_LIMIT;
    private ServiceDocument childTemplate;
    private URI uri;

    public static FactoryService create(Class<? extends Service> childServiceType, Service.ServiceOption ... options) {
        try {
            Service s = childServiceType.newInstance();
            Class<? extends ServiceDocument> childServiceDocumentType = s.getStateType();
            FactoryService fs = FactoryService.create(childServiceType, childServiceDocumentType, options);
            return fs;
        }
        catch (Throwable e) {
            Utils.logWarning("Failure creating factory for %s: %s", childServiceType, Utils.toString(e));
            return null;
        }
    }

    public static FactoryService create(final Class<? extends Service> childServiceType, Class<? extends ServiceDocument> childServiceDocumentType, Service.ServiceOption ... options) {
        FactoryService fs = new FactoryService(childServiceDocumentType){

            @Override
            public Service createServiceInstance() throws Throwable {
                return (Service)childServiceType.newInstance();
            }
        };
        Arrays.stream(options).forEach(option -> fs.toggleOption((Service.ServiceOption)((Object)option), true));
        return fs;
    }

    public static FactoryService createIdempotent(Class<? extends Service> childServiceType) {
        return FactoryService.create(childServiceType, Service.ServiceOption.IDEMPOTENT_POST);
    }

    public static FactoryService createIdempotent(Class<? extends Service> childServiceType, Class<? extends ServiceDocument> childServiceDocumentType) {
        return FactoryService.create(childServiceType, childServiceDocumentType, Service.ServiceOption.IDEMPOTENT_POST);
    }

    public FactoryService(Class<? extends ServiceDocument> childServiceDocumentType) {
        super(childServiceDocumentType);
        super.toggleOption(Service.ServiceOption.STATELESS, false);
        super.toggleOption(Service.ServiceOption.FACTORY, true);
        this.setSelfLink("");
        Service s = this.createChildServiceSafe();
        if (s == null) {
            throw new IllegalStateException("Could not create service of type " + childServiceDocumentType.toString());
        }
        this.setSelfLink(null);
        this.childOptions = s.getOptions();
    }

    public void setSelfQueryResultLimit(int limit) {
        this.selfQueryResultLimit = limit;
    }

    public int getSelfQueryResultLimit() {
        return this.selfQueryResultLimit;
    }

    public boolean hasChildOption(Service.ServiceOption option) {
        return this.childOptions.contains((Object)option);
    }

    @Override
    public final void handleStart(Operation startPost) {
        try {
            this.setAvailable(false);
            Service s = this.createChildService();
            s.setHost(this.getHost());
            this.getHost().buildDocumentDescription(s);
            if (this.childOptions.contains((Object)Service.ServiceOption.PERSISTENCE)) {
                this.toggleOption(Service.ServiceOption.PERSISTENCE, true);
            }
            Class<? extends ServiceDocument> childStateTypeDeclaredInChild = s.getStateType();
            if (!this.getStateType().equals(childStateTypeDeclaredInChild)) {
                throw new IllegalArgumentException(String.format("Child service state type %s does not match state type declared in child service class (%s)", this.getStateType(), childStateTypeDeclaredInChild));
            }
            if (s.hasOption(Service.ServiceOption.PERSISTENCE)) {
                byte[] buffer = new byte[65536];
                Utils.toBytes(s, buffer, 0);
            }
        }
        catch (Throwable e2) {
            this.logSevere(e2);
            startPost.fail(e2);
            return;
        }
        String path = UriUtils.buildUriPath("/core/synch-tasks", UriUtils.convertPathCharsFromLink(this.getSelfLink()));
        Operation post = Operation.createPost(UriUtils.buildUri(this.getHost(), path)).setBody(this.createSynchronizationTaskState(null)).setCompletion((o, e) -> {
            if (e != null) {
                this.logSevere(e);
                startPost.fail(e);
                return;
            }
            if (!ServiceHost.isServiceIndexed(this)) {
                this.setAvailable(true);
                startPost.complete();
                return;
            }
            Operation clonedOp = startPost.clone();
            startPost.complete();
            if (!this.childOptions.contains((Object)Service.ServiceOption.REPLICATION)) {
                clonedOp.setCompletion((op, t) -> {
                    if (t != null && !this.getHost().isStopping()) {
                        this.logWarning("Failure in kicking-off synchronization-task: %s", t.getMessage());
                        return;
                    }
                });
                this.startFactorySynchronizationTask(clonedOp, null);
                return;
            }
        });
        SynchronizationTaskService service = SynchronizationTaskService.create(() -> this.createChildServiceSafe());
        this.getHost().startService(post, service);
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op) {
        this.handleRequest(op, Service.OperationProcessingStage.PROCESSING_FILTERS);
    }

    @Override
    public void handleRequest(Operation op, Service.OperationProcessingStage opProcessingStage) {
        if (op.getAction() == Service.Action.POST) {
            if (opProcessingStage == Service.OperationProcessingStage.PROCESSING_FILTERS) {
                OperationProcessingChain opProcessingChain = this.getOperationProcessingChain();
                if (opProcessingChain != null && !opProcessingChain.processRequest(op)) {
                    return;
                }
                opProcessingStage = Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER;
            }
            if (opProcessingStage == Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER) {
                op.nestCompletion((o, e) -> {
                    if (e != null) {
                        this.logWarning("Service start failed: %s", Utils.toString(e));
                        op.fail(e);
                        return;
                    }
                    this.handlePostCompletion(op);
                });
                this.handlePost(op);
            }
        } else if (op.getAction() == Service.Action.GET) {
            if (this.getProcessingStage() != Service.ProcessingStage.AVAILABLE) {
                op.setBody(new ServiceDocumentQueryResult()).complete();
                return;
            }
            op.nestCompletion(this::handleGetCompletion);
            this.handleGet(op);
        } else if (op.getAction() == Service.Action.DELETE) {
            if (ServiceHost.isServiceStop(op)) {
                op.nestCompletion(o -> this.handleStopCompletion(op));
                this.handleStop(op);
            } else {
                op.nestCompletion(o -> this.handleDeleteCompletion(op));
                this.handleDelete(op);
            }
        } else if (op.getAction() == Service.Action.OPTIONS) {
            op.nestCompletion(this::handleOptionsCompletion);
            this.handleOptions(op);
        } else {
            op.fail(new IllegalArgumentException("Action not supported"));
        }
    }

    private void handlePostCompletion(Operation o) {
        Service childService;
        if (o.getStatusCode() == 202) {
            o.complete();
            return;
        }
        if (!o.isSynchronize()) {
            o.addPragmaDirective("xn-created");
        }
        ServiceDocument initialState = null;
        try {
            String suffix;
            childService = this.createChildService();
            if (o.hasBody()) {
                initialState = (ServiceDocument)o.getBody(this.stateType);
                initialState = Utils.clone(initialState);
            }
            if (initialState == null) {
                suffix = this.buildDefaultChildSelfLink();
                initialState = new ServiceDocument();
            } else {
                suffix = initialState.documentSelfLink == null ? this.buildDefaultChildSelfLink() : initialState.documentSelfLink;
            }
            URI serviceUri = UriUtils.isChildPath(suffix, this.getSelfLink()) ? UriUtils.buildUri(this.getHost(), suffix) : UriUtils.extendUri(this.getUri(), suffix);
            o.setUri(serviceUri);
        }
        catch (Throwable e) {
            this.logSevere(e);
            o.fail(e);
            return;
        }
        initialState.documentSelfLink = o.getUri().getPath();
        initialState.documentKind = Utils.buildKind(this.stateType);
        initialState.documentTransactionId = o.getTransactionId();
        if (this.hasChildOption(Service.ServiceOption.IMMUTABLE)) {
            o.setBodyNoCloning(initialState);
        } else {
            o.setBody(initialState);
        }
        if (this.childOptions.contains((Object)Service.ServiceOption.REPLICATION) && !o.isFromReplication() && !o.isForwardingDisabled()) {
            this.forwardRequest(o, childService);
            return;
        }
        this.completePostRequest(o, childService);
    }

    protected String buildDefaultChildSelfLink() {
        return this.getHost().nextUUID();
    }

    @Override
    public void handleStop(Operation op) {
        if (!ServiceHost.isServiceStop(op)) {
            this.logWarning("Abrupt stop of factory %s", this.getSelfLink());
        }
        super.handleStop(op);
    }

    private void completePostRequest(Operation o, Service childService) {
        if (o.isSynchronizeOwner()) {
            o.setBody(null);
        }
        if (!o.isFromReplication() && !o.isReplicationDisabled()) {
            o.nestCompletion(startOp -> {
                this.publish(o);
                if (o.getAction() == Service.Action.PUT || !this.hasOption(Service.ServiceOption.REPLICATION)) {
                    o.complete();
                    return;
                }
                o.linkState(null);
                o.complete();
            });
            if (o.isWithinTransaction() && this.getHost().getTransactionServiceUri() != null) {
                childService.sendRequest(TransactionServiceHelper.notifyTransactionCoordinatorOfNewServiceOp(this, childService, o).setCompletion((notifyOp, notifyFailure) -> {
                    if (notifyFailure != null) {
                        o.fail(notifyFailure);
                        return;
                    }
                    this.startChildService(o, childService);
                }));
                return;
            }
        }
        this.startChildService(o, childService);
    }

    private void startChildService(Operation o, Service childService) {
        o.addPragmaDirective("xn-check-version");
        this.getHost().startService(o, childService);
    }

    private void forwardRequest(Operation o, Service childService) {
        Operation selectOp = Operation.createPost(null).setExpiration(o.getExpirationMicrosUtc()).setCompletion((so, se) -> {
            if (se != null) {
                o.fail(se);
                return;
            }
            if (!so.hasBody()) {
                throw new IllegalStateException();
            }
            NodeSelectorService.SelectOwnerResponse rsp = so.getBody(NodeSelectorService.SelectOwnerResponse.class);
            ServiceDocument initialState = (ServiceDocument)o.getBodyRaw();
            initialState.documentOwner = rsp.ownerNodeId;
            if (initialState.documentEpoch == null) {
                initialState.documentEpoch = 0L;
            }
            if (rsp.isLocalHostOwner) {
                o.addRequestHeader("x-xenon-rpl-parent", this.getSelfLink());
                this.completePostRequest(o, childService);
                return;
            }
            URI remotePeerService = NodeSelectorService.SelectOwnerResponse.buildUriToOwner(rsp, this.getSelfLink(), null);
            Operation.CompletionHandler fc = (fo, fe) -> {
                o.setBodyNoCloning(fo.getBodyRaw());
                o.setStatusCode(fo.getStatusCode());
                o.transferResponseHeadersFrom(fo);
                if (fe != null) {
                    o.fail(fe);
                    return;
                }
                o.complete();
            };
            Operation forwardOp = o.clone().setUri(remotePeerService).setCompletion(fc);
            this.getHost().prepareForwardRequest(forwardOp);
            if (initialState.documentSelfLink.startsWith(this.getSelfLink())) {
                initialState.documentSelfLink = initialState.documentSelfLink.substring(this.getSelfLink().length());
            }
            this.getHost().sendRequest(forwardOp);
        });
        this.getHost().selectOwner(this.getPeerNodeSelectorPath(), o.getUri().getPath(), selectOp);
    }

    @Override
    public void handleGet(Operation get) {
        get.complete();
    }

    private void handleGetCompletion(Operation op) {
        String query = op.getUri().getQuery();
        boolean isODataQuery = UriUtils.hasODataQueryParams(op.getUri());
        boolean expand = UriUtils.hasODataExpandParamValue(op.getUri());
        if (query == null || !isODataQuery && expand) {
            this.completeGetWithQuery(op, this.childOptions);
        } else {
            this.handleGetOdataCompletion(op);
        }
    }

    private void handleGetOdataCompletion(Operation op) {
        String path = UriUtils.getPathParamValue(op.getUri());
        String peer = UriUtils.getPeerParamValue(op.getUri());
        if (path != null && peer != null) {
            this.handleNavigationRequest(op);
            return;
        }
        Set<String> expandedQueryPropertyNames = QueryTaskUtils.getExpandedQueryPropertyNames(this.getChildTemplate().documentDescription);
        QueryTask task = ODataUtils.toQuery(op, false, expandedQueryPropertyNames);
        if (task == null) {
            return;
        }
        task.setDirect(true);
        String kind = Utils.buildKind(this.getStateType());
        QueryTask.Query kindClause = new QueryTask.Query().setTermPropertyName("documentKind").setTermMatchValue(kind);
        task.querySpec.query.addBooleanClause(kindClause);
        QueryTask.Query selfLinkPrefixClause = new QueryTask.Query().setTermPropertyName("documentSelfLink").setTermMatchType(QueryTask.QueryTerm.MatchType.PREFIX).setTermMatchValue(this.getSelfLink());
        task.querySpec.query.addBooleanClause(selfLinkPrefixClause);
        if (task.querySpec.sortTerm != null) {
            String propertyName = task.querySpec.sortTerm.propertyName;
            ServiceDocumentDescription.PropertyDescription propertyDescription = this.getChildTemplate().documentDescription.propertyDescriptions.get(propertyName);
            if (propertyDescription == null) {
                op.fail(new IllegalArgumentException("Sort term is not a valid property: " + propertyName));
                return;
            }
            task.querySpec.sortTerm.propertyType = propertyDescription.typeName;
        }
        if (this.hasOption(Service.ServiceOption.IMMUTABLE)) {
            task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        }
        if (task.querySpec.resultLimit != null) {
            this.handleODataLimitRequest(op, task);
            return;
        }
        this.sendRequest(Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(task).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ServiceDocumentQueryResult result = o.getBody(QueryTask.class).results;
            ODataFactoryQueryResult odataResult = new ODataFactoryQueryResult();
            odataResult.totalCount = result.documentCount;
            result.copyTo(odataResult);
            op.setBodyNoCloning(odataResult).complete();
        }));
    }

    private void handleNavigationRequest(Operation op) {
        String path = UriUtils.buildUriPath("/core/node-selectors/default", "forwarding");
        String query = UriUtils.buildUriQuery("path", UriUtils.getPathParamValue(op.getUri()), "peer", UriUtils.getPeerParamValue(op.getUri()), "target", UriUtils.ForwardingTarget.PEER_ID.toString());
        this.sendRequest(Operation.createGet(UriUtils.buildUri(this.getHost(), path, query)).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ServiceDocumentQueryResult result = o.getBody(QueryTask.class).results;
            this.prepareNavigationResult(result);
            op.setBodyNoCloning(result).complete();
        }));
    }

    private void handleODataLimitRequest(Operation op, QueryTask task) {
        if (task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
            task.querySpec.options.remove((Object)QueryTask.QuerySpecification.QueryOption.COUNT);
            task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
            Operation query = Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(task);
            this.prepareRequest(query);
            QueryTask countTask = new QueryTask();
            countTask.setDirect(true);
            countTask.querySpec = new QueryTask.QuerySpecification();
            countTask.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.COUNT);
            countTask.querySpec.query = task.querySpec.query;
            if (this.hasOption(Service.ServiceOption.IMMUTABLE)) {
                countTask.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
            }
            Operation count = Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(countTask);
            this.prepareRequest(count);
            OperationJoin.create(count, query).setCompletion((os, es) -> {
                if (es != null && !es.isEmpty()) {
                    op.fail((Throwable)es.values().iterator().next());
                    return;
                }
                ServiceDocumentQueryResult countResult = ((Operation)os.get((Object)Long.valueOf((long)count.getId()))).getBody(QueryTask.class).results;
                ServiceDocumentQueryResult queryResult = ((Operation)os.get((Object)Long.valueOf((long)query.getId()))).getBody(QueryTask.class).results;
                if (queryResult.nextPageLink == null) {
                    ODataFactoryQueryResult odataResult = new ODataFactoryQueryResult();
                    queryResult.copyTo(odataResult);
                    odataResult.totalCount = countResult.documentCount;
                    op.setBodyNoCloning(odataResult).complete();
                    return;
                }
                this.sendNextRequest(op, queryResult.nextPageLink, countResult.documentCount);
            }).sendWith(this.getHost());
            return;
        }
        this.sendRequest(Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(task).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ServiceDocumentQueryResult result = o.getBody(QueryTask.class).results;
            if (result.nextPageLink == null) {
                ODataFactoryQueryResult odataResult = new ODataFactoryQueryResult();
                result.copyTo(odataResult);
                odataResult.totalCount = result.documentCount;
                op.setBodyNoCloning(odataResult).complete();
                return;
            }
            this.sendNextRequest(op, result.nextPageLink, null);
        }));
    }

    private void sendNextRequest(Operation op, String nextPageLink, Long totalCount) {
        this.sendRequest(Operation.createGet(this, nextPageLink).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ODataFactoryQueryResult odataResult = new ODataFactoryQueryResult();
            ServiceDocumentQueryResult result = o.getBody(QueryTask.class).results;
            result.copyTo(odataResult);
            odataResult.totalCount = totalCount == null ? result.documentCount : totalCount;
            this.prepareNavigationResult(odataResult);
            op.setBodyNoCloning(odataResult).complete();
        }));
    }

    private void prepareNavigationResult(ServiceDocumentQueryResult result) {
        if (result.nextPageLink != null) {
            result.nextPageLink = this.convertNavigationLink(result.nextPageLink);
        }
        if (result.prevPageLink != null) {
            result.prevPageLink = this.convertNavigationLink(result.prevPageLink);
        }
    }

    private String convertNavigationLink(String navigationLink) {
        URI uri = URI.create(navigationLink);
        return this.getSelfLink() + "?" + UriUtils.buildUriQuery("path", UriUtils.getPathParamValue(uri), "peer", UriUtils.getPeerParamValue(uri));
    }

    public void completeGetWithQuery(Operation op, EnumSet<Service.ServiceOption> caps) {
        boolean doExpand = false;
        if (op.getUri().getQuery() != null) {
            doExpand = UriUtils.hasODataExpandParamValue(op.getUri());
        }
        URI u = UriUtils.buildDocumentQueryUri(this.getHost(), UriUtils.buildUriPath(this.getSelfLink(), "*"), doExpand, false, caps != null ? caps : EnumSet.of(Service.ServiceOption.NONE));
        Operation query = Operation.createGet(u).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.setBodyNoCloning(o.getBodyRaw()).complete();
        });
        this.sendRequest(query);
    }

    @Override
    public void handleOptions(Operation op) {
        op.setBody(null).complete();
    }

    @Override
    public void handlePost(Operation op) {
        if (op.hasBody()) {
            ServiceDocument body = (ServiceDocument)op.getBody(this.stateType);
            if (body == null) {
                op.fail(new IllegalArgumentException("structured body is required"));
                return;
            }
            if (body.documentSourceLink != null) {
                op.fail(new IllegalArgumentException("clone request not supported"));
                return;
            }
        }
        op.complete();
    }

    private Service createChildService() throws Throwable {
        Service childService = this.createServiceInstance();
        this.childOptions = childService.getOptions();
        if (childService.hasOption(Service.ServiceOption.REPLICATION)) {
            this.toggleOption(Service.ServiceOption.REPLICATION, true);
            if (!"/core/node-selectors/default".equals(childService.getPeerNodeSelectorPath())) {
                this.nodeSelectorLink = childService.getPeerNodeSelectorPath();
            } else if (!"/core/node-selectors/default".equals(this.nodeSelectorLink)) {
                childService.setPeerNodeSelectorPath(this.nodeSelectorLink);
            }
        }
        if (childService.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            this.toggleOption(Service.ServiceOption.ON_DEMAND_LOAD, true);
        }
        if (childService.hasOption(Service.ServiceOption.HTML_USER_INTERFACE)) {
            this.toggleOption(Service.ServiceOption.HTML_USER_INTERFACE, true);
        }
        if (childService.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            this.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        }
        if (this.hasOption(Service.ServiceOption.IDEMPOTENT_POST)) {
            childService.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
        }
        childService.toggleOption(Service.ServiceOption.FACTORY_ITEM, true);
        return childService;
    }

    private Service createChildServiceSafe() {
        try {
            return this.createChildService();
        }
        catch (Throwable e) {
            this.logSevere(e);
            return null;
        }
    }

    @Override
    public void toggleOption(Service.ServiceOption option, boolean enable) {
        if (enable) {
            this.options.add(option);
        } else {
            this.options.remove((Object)option);
        }
    }

    @Override
    public String getPeerNodeSelectorPath() {
        return this.nodeSelectorLink;
    }

    @Override
    public void setPeerNodeSelectorPath(String link) {
        this.nodeSelectorLink = link;
    }

    @Override
    public URI getUri() {
        if (this.uri == null) {
            this.uri = super.getUri();
        }
        return this.uri;
    }

    @Override
    public ServiceDocument getDocumentTemplate() {
        ServiceDocumentQueryResult r = new ServiceDocumentQueryResult();
        ServiceDocument childTemplate = this.getChildTemplate();
        r.documents = new HashMap<String, Object>();
        childTemplate.documentSelfLink = UriUtils.buildUriPath(this.getSelfLink(), "child-template");
        r.documentLinks.add(childTemplate.documentSelfLink);
        r.documents.put(childTemplate.documentSelfLink, childTemplate);
        return r;
    }

    private ServiceDocument getChildTemplate() {
        if (this.childTemplate == null) {
            try {
                Service s = this.createServiceInstance();
                s.setHost(this.getHost());
                s.toggleOption(Service.ServiceOption.FACTORY_ITEM, true);
                this.childTemplate = s.getDocumentTemplate();
            }
            catch (Throwable e) {
                this.logSevere(e);
                return null;
            }
        }
        return this.childTemplate;
    }

    @Override
    public void handleNodeGroupMaintenance(Operation maintOp) {
        if (this.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            this.setAvailable(true);
            maintOp.complete();
            return;
        }
        this.setAvailable(false);
        OperationContext opContext = OperationContext.getOperationContext();
        Operation selectOwnerOp = maintOp.clone().setExpiration(Utils.fromNowMicrosUtc(this.getHost().getOperationTimeoutMicros()));
        selectOwnerOp.setCompletion((o, e) -> {
            OperationContext.restoreOperationContext(opContext);
            if (e != null) {
                this.logWarning("owner selection failed: %s", e.toString());
                maintOp.fail(e);
                return;
            }
            NodeSelectorService.SelectOwnerResponse rsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            if (!rsp.isLocalHostOwner) {
                maintOp.complete();
                return;
            }
            if (rsp.availableNodeCount > 1) {
                this.verifyFactoryOwnership(maintOp, rsp);
                return;
            }
            this.synchronizeChildServicesAsOwner(maintOp, rsp.membershipUpdateTimeMicros);
        });
        this.getHost().selectOwner(this.nodeSelectorLink, this.getSelfLink(), selectOwnerOp);
    }

    private void synchronizeChildServicesAsOwner(Operation maintOp, long membershipUpdateTimeMicros) {
        maintOp.nestCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("synch failed: %s", e.toString());
            }
            maintOp.complete();
        });
        this.startFactorySynchronizationTask(maintOp, membershipUpdateTimeMicros);
    }

    private void startFactorySynchronizationTask(Operation parentOp, Long membershipUpdateTimeMicros) {
        if (this.childOptions.contains((Object)Service.ServiceOption.ON_DEMAND_LOAD)) {
            this.setAvailable(true);
            parentOp.complete();
            return;
        }
        SynchronizationTaskService.State task = this.createSynchronizationTaskState(membershipUpdateTimeMicros);
        Operation post = Operation.createPost(this, "/core/synch-tasks").setBody(task).setCompletion((o, e) -> {
            if (o.getStatusCode() == 400) {
                ServiceErrorResponse rsp = o.getBody(ServiceErrorResponse.class);
                this.logInfo("Failure on POST to synch task: %s", Utils.toJsonHtml(rsp));
                if (rsp.getErrorCode() == -2147483647) {
                    parentOp.complete();
                    return;
                }
            }
            if (e != null) {
                this.logInfo("Failure on POST to synch task: %s", e.getMessage());
                parentOp.fail(e);
                return;
            }
            parentOp.complete();
        });
        this.sendRequest(post);
    }

    private SynchronizationTaskService.State createSynchronizationTaskState(Long membershipUpdateTimeMicros) {
        SynchronizationTaskService.State task = new SynchronizationTaskService.State();
        task.documentSelfLink = UriUtils.convertPathCharsFromLink(this.getSelfLink());
        task.factorySelfLink = this.getSelfLink();
        task.factoryStateKind = Utils.buildKind(this.getStateType());
        task.membershipUpdateTimeMicros = membershipUpdateTimeMicros;
        task.nodeSelectorLink = this.nodeSelectorLink;
        task.queryResultLimit = SELF_QUERY_RESULT_LIMIT;
        task.taskInfo = TaskState.create();
        task.taskInfo.isDirect = true;
        return task;
    }

    private void verifyFactoryOwnership(Operation maintOp, NodeSelectorService.SelectOwnerResponse ownerResponse) {
        NodeSelectorService.SelectAndForwardRequest request = new NodeSelectorService.SelectAndForwardRequest();
        request.key = this.getSelfLink();
        Operation broadcastSelectOp = Operation.createPost(UriUtils.buildUri(this.getHost(), this.nodeSelectorLink)).setReferer(this.getHost().getUri()).setBody(request).setCompletion((op, t) -> {
            if (t != null) {
                this.logWarning("owner selection failed: %s", t.toString());
                maintOp.fail(t);
                return;
            }
            NodeGroupBroadcastResponse response = op.getBody(NodeGroupBroadcastResponse.class);
            for (Map.Entry<URI, String> r : response.jsonResponses.entrySet()) {
                NodeSelectorService.SelectOwnerResponse rsp = null;
                try {
                    rsp = Utils.fromJson(r.getValue(), NodeSelectorService.SelectOwnerResponse.class);
                }
                catch (Throwable e) {
                    this.logWarning("Exception thrown in de-serializing json response. %s", e.toString());
                    continue;
                }
                if (rsp.ownerNodeId.equals(this.getHost().getId())) continue;
                this.logWarning("SelectOwner response from %s does not indicate that local node %s is the owner for factory %s. JsonResponse: %s", r.getKey().toString(), this.getHost().getId(), this.getSelfLink(), r.getValue());
                maintOp.complete();
                return;
            }
            this.logInfo("%s elected as owner for factory %s. Starting synch ...", this.getHost().getId(), this.getSelfLink());
            this.synchronizeChildServicesAsOwner(maintOp, ownerResponse.membershipUpdateTimeMicros);
        });
        this.getHost().broadcastRequest(this.nodeSelectorLink, this.getSelfLink(), true, broadcastSelectOp);
    }

    public abstract Service createServiceInstance() throws Throwable;
}

