/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.TransactionResolutionService;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class TransactionService
extends StatefulService {
    private TransactionResolutionService resolutionHelper;

    public TransactionService() {
        super(TransactionServiceState.class);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation start) {
        TransactionServiceState s = start.getBody(TransactionServiceState.class);
        s.taskSubStage = s.taskSubStage == null ? SubStage.COLLECTING : s.taskSubStage;
        s.options = s.options == null ? new Options() : s.options;
        s.servicesToCoordinators = s.servicesToCoordinators == null ? new LinkedHashMap<String, Set<String>>() : s.servicesToCoordinators;
        s.readLinks = s.readLinks == null ? new HashSet() : s.readLinks;
        s.modifiedLinks = s.modifiedLinks == null ? new HashSet() : s.modifiedLinks;
        s.createdLinks = s.createdLinks == null ? new HashSet() : s.createdLinks;
        s.deletedLinks = s.deletedLinks == null ? new HashSet() : s.deletedLinks;
        s.failedLinks = new HashSet<String>();
        this.setState(start, s);
        this.allocateResolutionService(start);
    }

    private void allocateResolutionService(Operation op) {
        Operation startResolutionService = Operation.createPost(UriUtils.extendUri(this.getUri(), "/resolve")).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.complete();
        });
        this.resolutionHelper = new TransactionResolutionService(this);
        this.getHost().startService(startResolutionService, this.resolutionHelper);
    }

    @Override
    public void handlePut(Operation put) {
        if (!put.hasBody()) {
            put.fail(new IllegalArgumentException("Body is required"));
            return;
        }
        Operation.TransactionContext record = put.getBody(Operation.TransactionContext.class);
        TransactionServiceState existing = (TransactionServiceState)this.getState(put);
        String serviceLink = put.getRequestHeader("x-xenon-tx-reflink");
        if (record.action == Service.Action.GET) {
            existing.readLinks.add(serviceLink);
        } else {
            existing.modifiedLinks.add(serviceLink);
        }
        if (record.action == Service.Action.POST) {
            existing.createdLinks.add(serviceLink);
        }
        if (record.action == Service.Action.DELETE) {
            existing.deletedLinks.add(serviceLink);
        }
        if (record.coordinatorLinks != null) {
            existing.servicesToCoordinators.put(serviceLink, record.coordinatorLinks);
        }
        if (!record.isSuccessful) {
            existing.failedLinks.add(serviceLink);
        }
        this.setState(put, existing);
        put.complete();
    }

    @Override
    public void handleConfigurationRequest(Operation request) {
        this.resolutionHelper.handleResolutionRequest(request);
    }

    @Override
    public void handlePatch(Operation patch) {
        if (!patch.hasBody()) {
            patch.fail(new IllegalArgumentException("Body is required"));
            return;
        }
        if ("ensure-commit".equals(patch.getRequestHeaderAsIs("x-xenon-tx-phase"))) {
            this.handleCheckConflicts(patch);
            return;
        }
        ResolutionRequest resolution = patch.getBody(ResolutionRequest.class);
        if (!resolution.kind.equals(ResolutionRequest.KIND)) {
            patch.fail(new IllegalArgumentException("Unrecognized request kind: " + resolution.kind));
            return;
        }
        TransactionServiceState currentState = (TransactionServiceState)this.getState(patch);
        if (resolution.resolutionKind == ResolutionKind.ABORT) {
            if (currentState.taskSubStage == SubStage.COMMITTED || currentState.taskSubStage == SubStage.COMMITTING) {
                patch.fail(new IllegalStateException(String.format("Already %s", new Object[]{currentState.taskSubStage})));
                return;
            }
            if (currentState.taskSubStage == SubStage.ABORTING || currentState.taskSubStage == SubStage.ABORTED) {
                this.logInfo("Alreading in sub-stage %s. Completing request.", new Object[]{currentState.taskSubStage});
                patch.complete();
                return;
            }
            this.updateStage(patch, SubStage.ABORTING);
            patch.complete();
            this.handleAbort(currentState);
        } else if (resolution.resolutionKind == ResolutionKind.COMMIT) {
            if (currentState.taskSubStage == SubStage.ABORTED || currentState.taskSubStage == SubStage.ABORTING) {
                patch.fail(new IllegalStateException("Already aborted"));
                return;
            }
            if (currentState.taskSubStage == SubStage.COMMITTED || currentState.taskSubStage == SubStage.COMMITTING) {
                this.logInfo("Alreading in sub-stage %s. Completing request.", new Object[]{currentState.taskSubStage});
                patch.complete();
                return;
            }
            this.updateStage(patch, SubStage.RESOLVING);
            patch.complete();
            this.handleCommit(currentState);
        } else if (resolution.resolutionKind == ResolutionKind.COMMITTING) {
            if (currentState.taskSubStage == SubStage.ABORTED || currentState.taskSubStage == SubStage.ABORTING) {
                patch.fail(new IllegalStateException("Already aborted"));
                return;
            }
            this.updateStage(patch, SubStage.COMMITTING);
            patch.complete();
            this.notifyServicesToCommit(currentState);
        } else if (resolution.resolutionKind == ResolutionKind.COMMITTED) {
            this.updateStage(patch, SubStage.COMMITTED);
            patch.complete();
        } else if (resolution.resolutionKind == ResolutionKind.ABORTED) {
            this.updateStage(patch, SubStage.ABORTED);
            patch.complete();
        } else {
            patch.fail(new IllegalArgumentException("Unrecognized resolution kind: " + (Object)((Object)resolution.resolutionKind)));
        }
    }

    private void handleCommit(TransactionServiceState existing) {
        if (existing.options.allowErrorsCauseAbort && !existing.failedLinks.isEmpty()) {
            this.logWarning("Failed to commit: some transactional operations have failed. Aborting.", new Object[0]);
            this.selfPatch(ResolutionKind.ABORT);
            return;
        }
        this.checkPotentialConflicts(existing);
    }

    private void updateStage(Operation op, SubStage stage) {
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        existing.taskSubStage = stage;
        this.setState(op, existing);
    }

    private void selfPatch(ResolutionKind resolution) {
        ResolutionRequest resolve = new ResolutionRequest();
        resolve.resolutionKind = resolution;
        Operation operation = Operation.createPatch(this.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Failure self patching: %s", e.getMessage());
            }
        }).setBody(resolve);
        this.sendRequest(operation);
    }

    private void handleAbort(TransactionServiceState existing) {
        Collection<Operation> ops = this.createNotifyServicesToAbort(existing);
        if (ops.isEmpty()) {
            this.selfPatch(ResolutionKind.ABORTED);
            return;
        }
        OperationJoin.create(ops).setCompletion((operations, failures) -> {
            if (failures != null) {
                this.logWarning("Transaction failed to notify some services to abort: %s", failures.toString());
            }
            this.selfPatch(ResolutionKind.ABORTED);
        }).sendWith(this);
    }

    private void handleCheckConflicts(Operation op) {
        String txLink;
        TransactionServiceState existing = (TransactionServiceState)this.getState(op);
        ConflictCheckRequest req = op.getBody(ConflictCheckRequest.class);
        ConflictCheckResponse res = new ConflictCheckResponse();
        res.subStage = existing.taskSubStage;
        res.serviceIsInWriteSet = existing.modifiedLinks.contains(req.serviceLink);
        boolean abort = false;
        if (!(existing.taskSubStage != SubStage.COLLECTING && existing.taskSubStage != SubStage.RESOLVING || this.compareTo(txLink = op.getRequestHeader("x-xenon-tx-reflink")))) {
            this.logInfo("Conflicting transaction %s is trying to commit, aborting this transaction...", txLink);
            abort = true;
            this.updateStage(op, SubStage.ABORTING);
        }
        op.setBodyNoCloning(res);
        op.complete();
        if (abort) {
            this.handleAbort(existing);
        }
    }

    private void checkPotentialConflicts(TransactionServiceState state) {
        HashSet<Operation> operations = new HashSet<Operation>();
        boolean[] continueWithCommit = new boolean[]{true};
        for (String serviceLink : state.modifiedLinks) {
            if (!state.servicesToCoordinators.containsKey(serviceLink)) continue;
            for (String coordinator : state.servicesToCoordinators.get(serviceLink)) {
                if (coordinator.equals(this.getSelfLink())) continue;
                operations.add(this.createNotifyOp(coordinator, serviceLink, "ensure-commit", (o, e) -> {
                    if (e != null) {
                        continueWithCommit[0] = false;
                        this.logWarning("Failed to receive response from transaction %s, aborting this transaction...", coordinator);
                        this.selfPatch(ResolutionKind.ABORT);
                        return;
                    }
                    ConflictCheckResponse res = o.getBody(ConflictCheckResponse.class);
                    if (!res.serviceIsInWriteSet || res.subStage == SubStage.ABORTED || res.subStage == SubStage.ABORTING) {
                        return;
                    }
                    if (res.subStage == SubStage.COMMITTED || res.subStage == SubStage.COMMITTING || !this.compareTo(coordinator)) {
                        continueWithCommit[0] = false;
                        this.logInfo("Conflicting transaction %s is committing, aborting this transaction...", coordinator);
                        this.selfPatch(ResolutionKind.ABORT);
                    }
                }));
            }
        }
        if (operations.isEmpty()) {
            this.selfPatch(ResolutionKind.COMMITTING);
            return;
        }
        OperationJoin.create(operations).setCompletion((ops, failures) -> {
            if (failures != null) {
                this.logWarning("Failed to commit: %s. Aborting.", failures);
                this.selfPatch(ResolutionKind.ABORT);
                return;
            }
            if (continueWithCommit[0]) {
                this.selfPatch(ResolutionKind.COMMITTING);
            }
        }).sendWith(this.getHost());
    }

    private boolean compareTo(String remote) {
        return this.getSelfLink().compareTo(remote) < 0;
    }

    private Collection<Operation> createNotifyServicesToAbort(TransactionServiceState state) {
        HashSet<Operation> operations = new HashSet<Operation>();
        for (String service : state.createdLinks) {
            operations.add(this.createDeleteOp(service));
            state.readLinks.remove(service);
            state.modifiedLinks.remove(service);
        }
        for (String service : state.readLinks) {
            state.modifiedLinks.remove(service);
            operations.add(this.createNotifyOp(service, "abort"));
        }
        for (String service : state.modifiedLinks) {
            operations.add(this.createNotifyOp(service, "abort"));
        }
        return operations;
    }

    private void notifyServicesToCommit(TransactionServiceState state) {
        HashSet<Operation> operations = new HashSet<Operation>();
        for (String service2 : state.deletedLinks) {
            operations.add(this.createDeleteOp(service2));
            state.readLinks.remove(service2);
            state.modifiedLinks.remove(service2);
        }
        operations.addAll(state.readLinks.stream().peek(service -> state.modifiedLinks.remove(service)).map(service -> this.createNotifyOp((String)service, "commit")).collect(Collectors.toSet()));
        operations.addAll(state.modifiedLinks.stream().map(service -> this.createNotifyOp((String)service, "commit")).collect(Collectors.toSet()));
        if (operations.isEmpty()) {
            this.selfPatch(ResolutionKind.COMMITTED);
            return;
        }
        OperationJoin.create(operations).setCompletion((ops, failures) -> {
            if (failures != null) {
                this.logWarning("Failed to commit: %s. Aborting.", failures);
                this.selfPatch(ResolutionKind.ABORT);
                return;
            }
            this.selfPatch(ResolutionKind.COMMITTED);
        }).sendWith(this.getHost());
    }

    private Operation createNotifyOp(String service, String header) {
        return Operation.createPatch(this, service).addRequestHeader("x-xenon-tx-phase", header).setBody(new TransactionServiceState()).setReferer(this.getUri()).addRequestHeader("x-xenon-tx-reflink", this.getSelfLink()).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Notification of service %s failed: %s", service, e);
            } else {
                this.logInfo("Notification of service %s succeeded", service);
            }
        });
    }

    private Operation createDeleteOp(String service) {
        return Operation.createDelete(this, service).setReferer(this.getUri()).addRequestHeader("x-xenon-tx-reflink", this.getSelfLink()).setCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("Deletion of service %s failed: %s", service, e);
            } else {
                this.logInfo("Deletion of service %s succeeded", service);
            }
        });
    }

    private Operation createNotifyOp(String coordinator, String serviceLink, String header, Operation.CompletionHandler callback) {
        ConflictCheckRequest body = new ConflictCheckRequest();
        body.serviceLink = serviceLink;
        return Operation.createPatch(this, coordinator).addRequestHeader("x-xenon-tx-phase", header).setBody(body).setReferer(this.getUri()).addRequestHeader("x-xenon-tx-reflink", this.getSelfLink()).setCompletion(callback);
    }

    public static class TransactionServiceState
    extends ServiceDocument {
        public Set<String> readLinks;
        public Set<String> modifiedLinks;
        public Set<String> createdLinks;
        public Set<String> deletedLinks;
        public LinkedHashMap<String, Set<String>> servicesToCoordinators;
        public TaskState taskInfo = new TaskState();
        public SubStage taskSubStage;
        public Options options;
        public Set<String> failedLinks;
    }

    public static class ConflictCheckResponse {
        public SubStage subStage;
        public boolean serviceIsInWriteSet;
    }

    public static class ConflictCheckRequest {
        public String serviceLink;
    }

    public static class ResolutionRequest {
        public static final String KIND = Utils.buildKind(ResolutionRequest.class);
        public String kind = KIND;
        public ResolutionKind resolutionKind;
    }

    public static class Options {
        public boolean allowErrorsCauseAbort = true;
    }

    public static enum ResolutionKind {
        COMMIT,
        ABORT,
        COMMITTING,
        COMMITTED,
        ABORTED;

    }

    public static enum SubStage {
        COLLECTING,
        RESOLVING,
        COMMITTING,
        ABORTING,
        COMMITTED,
        ABORTED;

    }
}

