/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FNVHash;
import com.vmware.xenon.common.ServiceDocument;
import java.net.URI;
import java.util.EnumSet;
import java.util.Map;

public class NodeState
extends ServiceDocument {
    public static final String PROPERTY_NAME_MEMBERSHIP_QUORUM = "xenon.NodeState.membershipQuorum";
    public static final String PROPERTY_NAME_LOCATION = "xenon.NodeState.location";
    private transient long nodeIdHash;
    public static final EnumSet<NodeOption> DEFAULT_OPTIONS = EnumSet.of(NodeOption.PEER);
    public URI groupReference;
    public NodeStatus status = NodeStatus.UNKNOWN;
    public EnumSet<NodeOption> options = DEFAULT_OPTIONS;
    public String id;
    public int membershipQuorum;
    public Map<String, String> customProperties;

    public static boolean isUnAvailable(NodeState ns) {
        return NodeState.isUnAvailable(ns, NodeOption.OBSERVER);
    }

    public static boolean isUnAvailable(NodeState ns, NodeOption excludeNodeOption) {
        boolean unAvailable;
        boolean bl = unAvailable = ns.status == NodeStatus.UNAVAILABLE || ns.status == NodeStatus.REPLACED;
        if (excludeNodeOption != null) {
            unAvailable |= ns.options.contains((Object)excludeNodeOption);
        }
        return unAvailable;
    }

    public static boolean isAvailable(NodeState m, String hostId, boolean excludeThisHost) {
        if (m.status != NodeStatus.AVAILABLE) {
            return false;
        }
        return !excludeThisHost || !m.id.equals(hostId);
    }

    long getNodeIdHash() {
        long h = this.nodeIdHash;
        if (h == 0L) {
            this.nodeIdHash = h = FNVHash.compute(this.id);
        }
        return h;
    }

    public static enum NodeOption {
        PEER,
        OBSERVER;

    }

    public static enum NodeStatus {
        UNKNOWN,
        UNAVAILABLE,
        AVAILABLE,
        SYNCHRONIZING,
        REPLACED;

    }
}

