/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupBroadcastResponse;
import com.vmware.xenon.services.common.NodeGroupService;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NodeSelectorSynchronizationService
extends StatelessService {
    public static final String PROPERTY_NAME_SYNCHRONIZATION_LOGGING = "xenon.NodeSelectorSynchronizationService.isDetailedLoggingEnabled";
    private Service parent;
    private boolean isDetailedLoggingEnabled = Boolean.getBoolean("xenon.NodeSelectorSynchronizationService.isDetailedLoggingEnabled");

    public NodeSelectorSynchronizationService(Service parent) {
        super(NodeGroupSynchronizationState.class);
        super.toggleOption(Service.ServiceOption.UTILITY, true);
        this.parent = parent;
    }

    @Override
    public void handleStart(Operation startPost) {
        startPost.complete();
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation post) {
        if (post.getAction() != Service.Action.POST) {
            post.fail(new IllegalArgumentException("Action not supported"));
            return;
        }
        if (!post.hasBody()) {
            post.fail(new IllegalArgumentException("Body is required"));
            return;
        }
        SynchronizePeersRequest body = post.getBody(SynchronizePeersRequest.class);
        if (body.kind == null) {
            post.fail(new IllegalArgumentException("kind is required"));
            return;
        }
        if (body.kind.equals(SynchronizePeersRequest.KIND)) {
            this.handleSynchronizeRequest(post, body);
            return;
        }
        post.fail(new IllegalArgumentException("kind is not supported: " + body.kind));
    }

    private void handleSynchronizeRequest(Operation post, SynchronizePeersRequest body) {
        if (body.state == null) {
            post.fail(new IllegalArgumentException("state is required"));
            return;
        }
        if (body.state.documentSelfLink == null) {
            post.fail(new IllegalArgumentException("state.documentSelfLink is required"));
            return;
        }
        if (body.options == null || body.options.isEmpty()) {
            post.fail(new IllegalArgumentException("options is required"));
            return;
        }
        if (body.factoryLink == null || body.factoryLink.isEmpty()) {
            post.fail(new IllegalArgumentException("factoryLink is required"));
            return;
        }
        URI localQueryUri = UriUtils.buildDocumentQueryUri(this.getHost(), body.state.documentSelfLink, false, true, body.options);
        Operation remoteGet = Operation.createGet(localQueryUri).setReferer(this.getUri()).setExpiration(Utils.fromNowMicrosUtc(NodeGroupService.PEER_REQUEST_TIMEOUT_MICROS)).setCompletion((o, e) -> {
            if (e != null) {
                post.fail(e);
                return;
            }
            NodeGroupBroadcastResponse rsp = o.getBody(NodeGroupBroadcastResponse.class);
            this.handleBroadcastGetCompletion(rsp, post, body);
        });
        this.getHost().broadcastRequest(this.parent.getSelfLink(), body.state.documentSelfLink, true, remoteGet);
    }

    private void handleBroadcastGetCompletion(NodeGroupBroadcastResponse rsp, Operation post, SynchronizePeersRequest request) {
        if (rsp.failures.size() > 0 && rsp.jsonResponses.isEmpty()) {
            post.fail(new IllegalStateException("Failures received: " + Utils.toJsonHtml(rsp)));
            return;
        }
        ServiceDocument bestPeerRsp = null;
        TreeMap<Long, ArrayList<ServiceDocument>> syncRspsPerEpoch = new TreeMap<Long, ArrayList<ServiceDocument>>();
        HashMap<URI, ServiceDocument> peerStates = new HashMap<URI, ServiceDocument>();
        for (Map.Entry<URI, String> e : rsp.jsonResponses.entrySet()) {
            ArrayList<ServiceDocument> statesForEpoch;
            ServiceDocument peerState = (ServiceDocument)Utils.fromJson(e.getValue(), request.state.getClass());
            if (peerState.documentSelfLink == null || !peerState.documentSelfLink.equals(request.state.documentSelfLink)) {
                this.logWarning("Invalid state from peer %s: %s", e.getKey(), e.getValue());
                peerStates.put(e.getKey(), new ServiceDocument());
                continue;
            }
            peerStates.put(e.getKey(), peerState);
            if (peerState.documentEpoch == null) {
                peerState.documentEpoch = 0L;
            }
            if ((statesForEpoch = (ArrayList<ServiceDocument>)syncRspsPerEpoch.get(peerState.documentEpoch)) == null) {
                statesForEpoch = new ArrayList<ServiceDocument>();
                syncRspsPerEpoch.put(peerState.documentEpoch, statesForEpoch);
            }
            statesForEpoch.add(peerState);
        }
        for (URI remotePeerService : rsp.receivers) {
            if (peerStates.containsKey(remotePeerService)) continue;
            if (this.isDetailedLoggingEnabled) {
                this.logInfo("No peer response for %s from %s", request.state.documentSelfLink, remotePeerService);
            }
            peerStates.put(remotePeerService, new ServiceDocument());
        }
        if (!syncRspsPerEpoch.isEmpty()) {
            List statesForHighestEpoch = (List)syncRspsPerEpoch.get(syncRspsPerEpoch.lastKey());
            long maxVersion = Long.MIN_VALUE;
            for (ServiceDocument peerState : statesForHighestEpoch) {
                if (peerState.documentVersion <= maxVersion) continue;
                bestPeerRsp = peerState;
                maxVersion = peerState.documentVersion;
            }
        }
        if (bestPeerRsp != null && bestPeerRsp.documentEpoch == null) {
            bestPeerRsp.documentEpoch = 0L;
        }
        if (request.state.documentEpoch == null) {
            request.state.documentEpoch = 0L;
        }
        EnumSet<ServiceDocument.DocumentRelationship> results = EnumSet.noneOf(ServiceDocument.DocumentRelationship.class);
        if (bestPeerRsp == null) {
            results.add(ServiceDocument.DocumentRelationship.PREFERRED);
        } else if (request.state.documentEpoch.compareTo(bestPeerRsp.documentEpoch) > 0) {
            results.add(ServiceDocument.DocumentRelationship.PREFERRED);
        } else if (request.state.documentEpoch.equals(bestPeerRsp.documentEpoch)) {
            results = ServiceDocument.compare(request.state, bestPeerRsp, request.stateDescription, Utils.getTimeComparisonEpsilonMicros());
        }
        if (bestPeerRsp == null && request.options.contains((Object)Service.ServiceOption.ON_DEMAND_LOAD)) {
            post.setStatusCode(404);
            post.setBody(null);
            post.complete();
            return;
        }
        if (results.contains((Object)ServiceDocument.DocumentRelationship.IN_CONFLICT)) {
            this.markServiceInConflict(request.state, bestPeerRsp);
        } else if (results.contains((Object)ServiceDocument.DocumentRelationship.PREFERRED)) {
            bestPeerRsp = request.state;
        }
        if (bestPeerRsp == null) {
            bestPeerRsp = request.state;
        }
        if (bestPeerRsp.documentSelfLink == null || bestPeerRsp.documentVersion < 0L || bestPeerRsp.documentEpoch == null || bestPeerRsp.documentEpoch < 0L) {
            post.fail(new IllegalStateException("Chosen state has invalid epoch or version: " + Utils.toJson(bestPeerRsp)));
            return;
        }
        if (this.isDetailedLoggingEnabled) {
            this.logInfo("Using best peer state %s", Utils.toJson(bestPeerRsp));
        }
        boolean incrementEpoch = bestPeerRsp.documentOwner != null && !bestPeerRsp.documentOwner.equals(this.getHost().getId());
        bestPeerRsp.documentOwner = this.getHost().getId();
        this.broadcastBestState(rsp.selectedNodes, peerStates, post, request, bestPeerRsp, incrementEpoch);
    }

    private void broadcastBestState(Map<String, URI> selectedNodes, Map<URI, ServiceDocument> peerStates, Operation post, SynchronizePeersRequest request, ServiceDocument bestPeerRsp, boolean incrementEpoch) {
        try {
            post.setBodyNoCloning(null);
            if (peerStates.isEmpty()) {
                if (this.isDetailedLoggingEnabled) {
                    this.logInfo(") No peers available for %s", bestPeerRsp.documentSelfLink);
                }
                post.complete();
                return;
            }
            ServiceDocument bestState = bestPeerRsp;
            boolean isServiceDeleted = Service.Action.DELETE.toString().equals(bestPeerRsp.documentUpdateAction);
            if (isServiceDeleted) {
                post.setBodyNoCloning(bestPeerRsp);
            }
            if (peerStates.isEmpty()) {
                post.complete();
                return;
            }
            AtomicInteger remaining = new AtomicInteger(peerStates.size());
            Operation.CompletionHandler c = (o, e) -> {
                int r = remaining.decrementAndGet();
                if (e != null) {
                    this.logWarning("Peer update to %s:%d for %s failed with %s, remaining %d", o.getUri().getHost(), o.getUri().getPort(), bestPeerRsp.documentSelfLink, e.toString(), r);
                }
                if (r != 0) {
                    return;
                }
                post.complete();
            };
            if (incrementEpoch) {
                this.logInfo("Incrementing epoch from %d to %d for %s", bestPeerRsp.documentEpoch, bestPeerRsp.documentEpoch + 1L, bestPeerRsp.documentSelfLink);
                ServiceDocument serviceDocument = bestPeerRsp;
                serviceDocument.documentEpoch = serviceDocument.documentEpoch + 1L;
                ++bestPeerRsp.documentVersion;
            }
            post.setBody(bestPeerRsp);
            ServiceDocument clonedState = Utils.clone(bestPeerRsp);
            for (Map.Entry<URI, ServiceDocument> entry : peerStates.entrySet()) {
                URI peer = entry.getKey();
                ServiceDocument peerState = entry.getValue();
                Operation peerOp = this.prepareSynchPostRequest(post, request, bestState, isServiceDeleted, c, clonedState, peer);
                if (!incrementEpoch && bestPeerRsp.getClass().equals(peerState.getClass()) && ServiceDocument.equals(request.stateDescription, bestPeerRsp, peerState)) {
                    this.skipSynchOrStartServiceOnPeer(peerOp, peerState.documentSelfLink, request);
                    continue;
                }
                if (this.isDetailedLoggingEnabled) {
                    this.logInfo("(remaining: %d) (last action: %s) Sending %s with best state for %s to %s (e:%d, v:%d)", new Object[]{remaining.get(), clonedState.documentUpdateAction, peerOp.getAction(), clonedState.documentSelfLink, peerOp.getUri(), clonedState.documentEpoch, clonedState.documentVersion});
                }
                this.sendRequest(peerOp);
            }
        }
        catch (Throwable e2) {
            this.logSevere(e2);
            post.fail(e2);
        }
    }

    private void skipSynchOrStartServiceOnPeer(Operation peerOp, String link, SynchronizePeersRequest request) {
        if (request.options.contains((Object)Service.ServiceOption.ON_DEMAND_LOAD)) {
            peerOp.complete();
            return;
        }
        Operation checkGet = Operation.createGet(UriUtils.buildUri(peerOp.getUri(), link)).addPragmaDirective("xn-no-fwd").setConnectionSharing(true).setExpiration(Utils.fromNowMicrosUtc(TimeUnit.SECONDS.toMicros(2L))).setCompletion((o, e) -> {
            if (e == null) {
                this.logInfo("Skipping %s , state identical with best state", o.getUri());
                peerOp.complete();
                return;
            }
            this.sendRequest(peerOp);
        });
        this.sendRequest(checkGet);
    }

    private Operation prepareSynchPostRequest(Operation post, SynchronizePeersRequest request, ServiceDocument bestState, boolean isServiceDeleted, Operation.CompletionHandler c, ServiceDocument clonedState, URI peer) {
        URI targetFactoryUri = UriUtils.buildUri(peer, request.factoryLink);
        Operation peerOp = Operation.createPost(targetFactoryUri).transferRefererFrom(post).setCompletion(c);
        peerOp.setRetryCount(0);
        peerOp.setExpiration(Utils.fromNowMicrosUtc(NodeGroupService.PEER_REQUEST_TIMEOUT_MICROS));
        peerOp.toggleOption(Operation.OperationOption.CONNECTION_SHARING, true);
        peerOp.addPragmaDirective("xn-rpl");
        peerOp.addPragmaDirective("xn-check-version");
        peerOp.addPragmaDirective("xn-synch-peer");
        peerOp.addRequestHeader("x-xenon-rpl-phase", "commit");
        clonedState.documentSelfLink = UriUtils.getLastPathSegment(bestState.documentSelfLink);
        if (isServiceDeleted) {
            peerOp.setAction(Service.Action.DELETE);
            peerOp.setUri(UriUtils.buildUri(peer, bestState.documentSelfLink));
            clonedState.documentSelfLink = bestState.documentSelfLink;
        }
        peerOp.setBody(clonedState);
        return peerOp;
    }

    private void markServiceInConflict(ServiceDocument state, ServiceDocument bestPeerRsp) {
        this.logWarning("State in conflict. Local: %s, Among peers: %s", Utils.toJsonHtml(state), Utils.toJsonHtml(bestPeerRsp));
    }

    public static class SynchronizePeersRequest {
        public static final String KIND = Utils.buildKind(SynchronizePeersRequest.class);
        public ServiceDocument state;
        public ServiceDocumentDescription stateDescription;
        public EnumSet<Service.ServiceOption> options;
        public String factoryLink;
        public String kind;

        public static SynchronizePeersRequest create() {
            SynchronizePeersRequest r = new SynchronizePeersRequest();
            r.kind = KIND;
            return r;
        }
    }

    public static class NodeGroupSynchronizationState
    extends ServiceDocument {
        public Set<String> inConflictLinks = new HashSet<String>();
    }
}

